<?php
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ExtensionCustomerAttributes
 *
 * @property AController baseObject
 * @property  ModelSaleCustomerAttributes $model_sale_customer_attributes
 */
class ExtensionCustomerAttributes extends Extension
{

    public $errors = array();
    public $data = array();
    protected $registry;

    public function __construct()
    {
        $this->registry = Registry::getInstance();
    }

    private function isEnabled()
    {
        return $this->baseObject->config->get('customer_attributes_status') ? true : false;
    }

    public function onControllerPagesCatalogAttribute_InitData()
    {
        if (!$this->isEnabled()) {
            return null;
        }
        $that =& $this->baseObject;
        // purge regexp pattern and error text when attribute type is "file"
        if ($that->request->is_POST() && $that->request->post['element_type'] == 'U') {
            $that->request->post['regexp_pattern'] = $that->request->post['error_text'] = '';
        }
    }

    public function onControllerPagesCatalogAttribute_UpdateData()
    {
        if (!$this->isEnabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $am = new AAttribute_Manager('customer_attribute');
        $type_id = $am->getAttributeTypeID('customer_attribute');
        if ((int)$that->request->get['attribute_type_id']
            && $that->request->get['attribute_type_id'] != $type_id
        ) {
            return null;
        } elseif ((int)$that->request->get['attribute_id']) {
            $attr_info = $am->getAttribute((int)$that->request->get['attribute_id']);
            if ($attr_info['attribute_type_id'] != $type_id) {
                return null;
            }
        } elseif (!(int)$that->request->get['attribute_id'] && !(int)$that->request->get['attribute_type_id']) {
            return null;
        }

        $viewData = $that->view->getData();
        if (has_value($viewData['success'])) {
            $that->view->append('success',
                ' '.$that->html->convertLinks($that->language->get('success_saved_attribute')));
        }
        $form = $that->data['form'];
        unset($form['fields']['attribute_parent']);
        $that->view->assign('form', $form);
    }

    public function onControllerPagesAccountCreate_InitData()
    {
        if (!$this->isEnabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->loadLanguage('account/customer_attributes');

        if ($that->request->is_POST()) {
            $that->loadModel('sale/customer_attributes');

            $errors = $that->model_sale_customer_attributes->validateAttributesForCreate(
                $that->config->get('config_customer_group_id'),
                $that->language->getLanguageID(),
                $that->request->post['attributes']
            );

            foreach ($this->errors as $id => $err) {
                $errors[$id] = $err;
            }

            if (!empty($errors)) {
                $that->loadModel('account/customer');
                $that->session->data['base_post'] = $that->request->post;
                $base_errors = $that->model_account_customer->validateRegistrationData($that->request->post);
                $that->session->data['base_errors'] = $base_errors;
                $that->session->data['attr_errors'] = $errors;
                //redirect for case when base form data is valid but customer attribute value does not
                header('Location: '.$that->html->getSecureURL('account/create'));
            }

        }

        if (isset($that->session->data['base_post'])) {
            $that->request->post = $that->session->data['base_post'];
            unset($that->session->data['base_post']);
        }
    }

    public function onControllerPagesAccountCreate_UpdateData()
    {
        if (!$this->isEnabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $data = array();
        $form = new AForm();
        $form->setForm(array('form_name' => 'AccountFrm'));

        $that->loadModel('sale/customer_attributes');

        if ($that->request->is_POST() && !$this->errors) {

            if ($that->session->data['customer_id']) {
                $customerID = $that->session->data['customer_id'];
            } elseif ($that->session->data['activation']['customer_id']) {
                $customerID = (int)$that->session->data['activation']['customer_id'];
            } else {
                $customerID = $that->data['customer_id'];
            }

            if ($customerID > 0) {
                $that->model_sale_customer_attributes->addAttributesToCustomer($customerID,
                    $that->request->post['attributes']);
            }
            if (has_value($that->request->files['attributes']['name'])) {
                $this->processFileUpload($customerID);
            }
        }

        $base_errors = $that->session->data['base_errors'];
        if ($base_errors) {
            $new_data['error_warning'] = $base_errors['warning'];
            $new_data['error_firstname'] = $base_errors['firstname'];
            $new_data['error_lastname'] = $base_errors['lastname'];
            $new_data['error_email'] = $base_errors['email'];
            $new_data['error_telephone'] = $base_errors['telephone'];
            $new_data['error_password'] = $base_errors['password'];
            $new_data['error_confirm'] = $base_errors['confirm'];
            $new_data['error_address_1'] = $base_errors['address_1'];
            $new_data['error_city'] = $base_errors['city'];
            $new_data['error_country'] = $base_errors['country'];
            $new_data['error_zone'] = $base_errors['zone'];
            $that->view->batchAssign($new_data);
            unset($that->session->data['base_errors']);
        }

        $attr_errors = $that->session->data['attr_errors'];
        if ($attr_errors) {
            foreach ($attr_errors as $key => $attr_error) {
                $data['errors']['attribute_'.$key] = $attr_error;
            }
            unset($that->session->data['attr_errors']);
        }

        $elements = HtmlElementFactory::getAvailableElements();
        $attributes = $that->model_sale_customer_attributes->getAttributesForGroup(
            $that->config->get('config_customer_group_id'),
            $that->language->getLanguageID()
        );

        $html_multivalue_elements = HtmlElementFactory::getMultivalueElements();
        $html_elements_with_options = HtmlElementFactory::getElementsWithOptions();
        foreach ($attributes as $attribute) {
            $html_type = $elements[$attribute['element_type']]['type'];
            if (!$html_type) {
                continue;
            }
            $values = $value = array();
            //values that was set
            if (in_array($attribute['element_type'], $html_elements_with_options)) {
                if (isset($that->request->post['attributes'][$attribute['customer_attribute_id']])) {
                    $value = $that->request->post['attributes'][$attribute['customer_attribute_id']];
                    $value = $html_type == 'radio' ? current($value) : $value;
                } else {
                    foreach ($attribute['selected_values'] as $val) {
                        $value[$val['customer_attribute_value_id']] = $val['customer_attribute_value'];
                    }
                }
            } else {
                if (isset($that->request->post['attributes'][$attribute['customer_attribute_id']])) {
                    $value = $that->request->post['attributes'][$attribute['customer_attribute_id']];
                } else {
                    $value = $attribute['values'][0]['value'];
                }
            }
            // possible values
            foreach ($attribute['values'] as $val) {
                $values[$val['customer_attribute_value_id']] = $val['value'];
            }

            if (!in_array($attribute['element_type'], $html_multivalue_elements)) {
                $option_name = 'attributes['.$attribute['customer_attribute_id'].']';
            } else {
                $option_name =
                    'attributes['.$attribute['customer_attribute_id'].']['.$attribute['customer_attribute_value_id'].']';
            }

            $disabled = '';
            $required = $attribute['required'];

            $option_data = array(
                'type'     => $html_type,
                'name'     => $option_name,
                'value'    => $value,
                'options'  => $values,
                'required' => $required,
                'attr'     => $disabled,
            );

            if ($html_type == 'checkbox') {
                $option_data['label_text'] = !in_array($value, array('0', '1')) ? $value : '';
                if ($value == '') {
                    $option_data['value'] = 1;
                }
            } elseif ($html_type == 'checkboxgroup') {
                $option_data['scrollbox'] = true;
            }

            $data['entry_attribute_'.$attribute['customer_attribute_id']] = $attribute['name'];
            $data['attributes']['attribute_'.$attribute['customer_attribute_id']] =
                $that->html->buildElement($option_data);
        }

        $data['text_your_attributes'] = $that->language->get('text_your_attributes');

        $view = new AView($this->registry, 0);
        $view->batchAssign($data);
        $that->view->addHookVar('customer_attributes', $view->fetch('pages/account/attributes_create.tpl'));

    }

    public function onControllerPagesAccountSubscriber_InitData()
    {
        if (!$this->isEnabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->loadLanguage('account/create');
        $that->loadLanguage('account/customer_attributes');

        if ($that->request->is_POST()) {
            $that->loadModel('sale/customer_attributes');

            $that->loadModel('account/customer');

            $errors = $that->model_sale_customer_attributes->validateAttributesForCreate(
                $that->model_account_customer->getSubscribersCustomerGroupId(),
                $that->session->data['content_language_id'],
                $that->request->post['attributes']
            );

            foreach ($this->errors as $id => $err) {
                $errors[$id] = $err;
            }

            if (!empty($errors)) {

                $that->session->data['base_post'] = $that->request->post;
                $that->session->data['base_errors'] =
                    $that->model_account_customer->validateSubscribeData($that->request->post);
                $that->session->data['attr_errors'] = $errors;

                header('Location: '.str_replace('&amp;', '&', $that->html->getSecureURL('account/subscriber')));
                exit();
            }

        }

        if (isset($that->session->data['base_post'])) {
            $that->request->post = $that->session->data['base_post'];
            unset($that->session->data['base_post']);
        }
    }

    public function onControllerPagesAccountSubscriber_UpdateData()
    {
        if (!$this->isEnabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $data = array();
        $form = new AForm();
        $form->setForm(array('form_name' => 'SubscriberFrm'));
        $that->loadModel('sale/customer_attributes');
        $that->loadModel('account/customer');

        if ($that->request->is_POST()) {
            //save posted data.. note that validation was in initData method!
            $res = $that->db->query('SELECT MAX(customer_id) as id FROM '.$that->db->table('customers'));
            $customerID = $res->row['id'];
            if ($customerID > 0) {
                $that->model_sale_customer_attributes->addAttributesToCustomer($customerID,
                    $that->request->post['attributes']);
                $that->model_sale_customer_attributes->updateCustomerAttributeValues(
                    $customerID,
                    $that->request->post['attributes']
                );

                if (has_value($that->request->files['attributes']['name'])) {
                    $this->processFileUpload($customerID);
                }
            }
        }

        $base_errors = $that->session->data['base_errors'];
        if ($base_errors) {
            $new_data['error_warning'] = $base_errors['warning'];
            $new_data['error_firstname'] = $base_errors['firstname'];
            $new_data['error_lastname'] = $base_errors['lastname'];
            $new_data['error_email'] = $base_errors['email'];
            $new_data['error_confirm'] = $base_errors['confirm'];

            $that->view->batchAssign($new_data);
            unset($that->session->data['base_errors']);
        }

        $attr_errors = $that->session->data['attr_errors'];

        if ($attr_errors) {
            foreach ($attr_errors as $key => $attr_error) {
                $data['errors']['attribute_'.$key] = $attr_error;
            }
            if ($that->request->is_GET()) {
                unset($that->session->data['attr_errors']);
            }
        }

        $elements = HtmlElementFactory::getAvailableElements();
        $attributes = $that->model_sale_customer_attributes->getAttributesForGroup(
            $that->model_account_customer->getSubscribersCustomerGroupId(),
            $that->language->getLanguageID()
        );

        $html_multivalue_elements = HtmlElementFactory::getMultivalueElements();
        $html_elements_with_options = HtmlElementFactory::getElementsWithOptions();
        foreach ($attributes as $attribute) {
            $html_type = $elements[$attribute['element_type']]['type'];
            if (!$html_type) {
                continue;
            }
            $values = $value = array();
            //values that was set
            if (in_array($attribute['element_type'], $html_elements_with_options)) {
                if (isset($that->request->post['attributes'][$attribute['customer_attribute_id']])) {
                    $value = $that->request->post['attributes'][$attribute['customer_attribute_id']];
                    $value = $html_type == 'radio' ? current($value) : $value;
                } else {
                    foreach ($attribute['selected_values'] as $val) {
                        $value[$val['customer_attribute_value_id']] = $val['customer_attribute_value'];
                    }
                }
            } else {
                if (isset($that->request->post['attributes'][$attribute['customer_attribute_id']])) {
                    $value = $that->request->post['attributes'][$attribute['customer_attribute_id']];
                } else {
                    $value = $attribute['values'][0]['value'];
                }
            }
            // possible values
            foreach ($attribute['values'] as $val) {
                $values[$val['customer_attribute_value_id']] = $val['value'];
            }

            if (!in_array($attribute['element_type'], $html_multivalue_elements)) {
                $option_name = 'attributes['.$attribute['customer_attribute_id'].']';
            } else {
                $option_name =
                    'attributes['.$attribute['customer_attribute_id'].']['.$attribute['customer_attribute_value_id']
                    .']';

            }

            $disabled = '';
            $required = $attribute['required'];

            $option_data = array(
                'type'     => $html_type,
                'name'     => $option_name,
                'value'    => $value,
                'options'  => $values,
                'required' => $required,
                'attr'     => $disabled,
            );

            if ($html_type == 'checkbox') {
                $option_data['label_text'] = $value;
            } elseif ($html_type == 'checkboxgroup') {
                $option_data['scrollbox'] = true;
            }

            $data['entry_attribute_'.$attribute['customer_attribute_id']] = $attribute['name'];

            $data['attributes']['attribute_'.$attribute['customer_attribute_id']] =
                $that->html->buildElement($option_data);

        }
        $data['text_your_attributes'] = $that->language->get('text_your_attributes');

        $view = new AView($this->registry, 0);
        $view->batchAssign($data);
        $that->view->addHookVar('subscriber_hookvar', $view->fetch('pages/account/attributes_create.tpl'));

    }

    public function onControllerPagesAccountEdit_InitData()
    {
        if (!$this->isEnabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->loadLanguage('account/customer_attributes');
        if ($that->request->is_POST()) {
            $that->loadModel('sale/customer_attributes');

            if (has_value($that->request->files['attributes']['name'])) {
                $this->processFileUpload(0);
            }

            $errors = $that->model_sale_customer_attributes->validateAttributesForEdit(
                $that->customer->getCustomerGroupId(),
                $that->request->post['attributes']
            );
            //append file upload errors
            foreach ($this->errors as $id => $err) {
                $errors[$id] = $err;
            }

            if (!empty($errors)) {
                $that->loadModel('account/customer');
                $that->session->data['base_post'] = $that->request->post;

                $that->session->data['attr_errors'] = $errors;
                $that->session->data['file_errors'] = $this->errors;

                header('Location: '.$that->html->getSecureURL('account/edit'));
                die();
            } else {
                $that->model_sale_customer_attributes->updateCustomerAttributeValues(
                    $that->session->data['customer_id'],
                    $that->request->post['attributes']
                );
            }
        }

        if (isset($that->session->data['base_post'])) {

            $that->request->post = $that->session->data['base_post'];
            unset($that->session->data['base_post']);
        }

    }

    public function onControllerPagesAccountEdit_UpdateData()
    {
        if (!$this->isEnabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $data = array();
        $that->loadModel('sale/customer_attributes');
        $data['text_your_attributes'] = $that->language->get('text_your_attributes');
        $attr_errors = $that->session->data['attr_errors'];
        if ($attr_errors) {
            foreach ($attr_errors as $key => $attr_error) {
                $data['errors']['attribute_'.$key] = $attr_error;
            }
            unset($that->session->data['attr_errors']);
        }

        $attributes =
            $that->model_sale_customer_attributes->getCustomerVisibleAttributes($that->customer->getCustomerGroupId());

        $elements = HtmlElementFactory::getAvailableElements();
        $html_multivalue_elements = HtmlElementFactory::getMultivalueElements();
        $html_elements_with_options = HtmlElementFactory::getElementsWithOptions();

        foreach ($attributes as $attribute) {
            $html_type = $elements[$attribute['element_type']]['type'];
            if (!$html_type) {
                continue;
            }
            $values = $value = array();
            //values that was set
            if (in_array($attribute['element_type'], $html_elements_with_options)) {
                if ($html_type == 'radio') {
                    $value = current($attribute['selected_values']);
                    $value = $value['customer_attribute_value'];
                } else {

                    foreach ($attribute['selected_values'] as $val) {
                        $value[] = $val['customer_attribute_value'];
                    }
                }
            } else {
                $value = current($attribute['selected_values']);
                $value = $value['customer_attribute_value'];
            }

            // possible values
            foreach ($attribute['values'] as $val) {
                $values[$val['customer_attribute_value_id']] = $val['value'];
            }

            if (!in_array($attribute['element_type'], $html_multivalue_elements)) {
                $option_name = 'attributes['.$attribute['customer_attribute_id'].']';
            } else {
                $option_name =
                    'attributes['.$attribute['customer_attribute_id'].']['.$attribute['customer_attribute_value_id']
                    .']';
            }

            if (isset($attribute['editable_by_customer']) && $attribute['editable_by_customer'] > 0) {
                $disabled = '';
                $required = $attribute['required'];
            } else {
                $disabled = 'disabled="disabled"';
                $required = '';
            }

            $option_data = array(
                'type'     => $html_type,
                'name'     => $option_name,
                'value'    => $value,
                'options'  => $values,
                'required' => $required,
                'attr'     => $disabled,
            );

            if ($html_type == 'checkbox') {
                $option_data['value'] = $option_data['label_text'] = current($values);
                if ($value) {
                    $option_data['checked'] = true;
                }
            } elseif ($html_type == 'checkboxgroup') {
                $option_data['scrollbox'] = true;
            }

            $data['entry_attribute_'.$attribute['customer_attribute_id']] = $attribute['name'];
            $data['attributes']['attribute_'.$attribute['customer_attribute_id']] =
                $that->html->buildElement($option_data);
        }

        $view = new AView($this->registry, 0);
        $view->batchAssign($data);
        $that->view->addHookVar('customer_attributes', $view->fetch('pages/account/attributes_edit.tpl'));
    }

    public function onControllerResponsesCommonTabs_InitData()
    {
        if (!$this->isEnabled()) {
            return null;
        }
        if ($this->baseObject->parent_controller != 'sale/customer_group') {
            return null;
        }

        $that =& $this->baseObject;
        $that->loadLanguage('sale/customer_attributes');

        $that->data['tabs']['customer_attributes'] = array(
            'name'       => 'customer_attributes',
            'text'       => $that->language->get('text_customer_attributes'),
            'href'       => $that->html->getSecureURL('sale/customer_attributes/update',
                '&customer_group_id='.$that->request->get['customer_group_id']),
            'active'     => $that->request->get['rt'] == 'sale/customer_attributes/update' ? true : false,
            'sort_order' => 1,
        );

    }

    public function onControllerPagesSaleCustomer_InitData()
    {
        if (!$this->isEnabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->loadLanguage('sale/customer_attributes');
        if (($that->request->is_POST())) {
            $that->loadModel('sale/customer_attributes');
            $that->model_sale_customer_attributes->updateCustomerAttributeValues(
                $that->request->get['customer_id'],
                $that->request->post['attributes']
            );
        }
    }

    public function onControllerPagesSaleCustomer_UpdateData()
    {
        if (!$this->isEnabled()) {
            return null;
        }
        if (!isset($this->baseObject->request->get['customer_id'])) {
            return null;
        }
        $that =& $this->baseObject;
        $this->data = $that->view->getData();
        $form = new AForm('HS');
        $form->setForm(array(
            'form_name' => 'cgFrm',
            'update'    => $this->data['update'],
        ));
        $that->loadModel('sale/customer_attributes');
        $customer_id = $that->request->get['customer_id'];
        $attributes = $that->model_sale_customer_attributes->getCustomerAttributes($customer_id);
        $customer_info = $that->model_sale_customer->getCustomer($customer_id);

        $elements = HtmlElementFactory::getAvailableElements();
        $html_multivalue_elements = HtmlElementFactory::getMultivalueElements();
        $html_elements_with_options = HtmlElementFactory::getElementsWithOptions();

        foreach ($attributes as $attribute) {
            $html_type = $elements[$attribute['element_type']]['type'];
            if (!$html_type) {
                continue;
            }
            $values = $value = array();

            //values that was set
            if (in_array($attribute['element_type'], $html_elements_with_options)) {
                if ($html_type == 'radio') {
                    $value = current($attribute['selected_values']);
                    $value = $value['customer_attribute_value'];
                } else {
                    foreach ($attribute['selected_values'] as $val) {
                        $value[] = $val['customer_attribute_value'];
                    }
                }
            } else {
                $value = current($attribute['selected_values']);
                $value = $value['customer_attribute_value'];
            }
            // possible values
            foreach ($attribute['values'] as $val) {
                $values[$val['customer_attribute_value_id']] = $val['value'];
            }

            if (!in_array($attribute['element_type'], $html_multivalue_elements)) {
                $option_name = 'attributes['.$attribute['customer_attribute_id'].']';
            } else {
                $option_name =
                    'attributes['.$attribute['customer_attribute_id'].']['.$attribute['customer_attribute_value_id']
                    .']';
            }

            $option_data = array(
                'type'     => $html_type,
                'name'     => $option_name,
                'value'    => $value,
                'options'  => $values,
                'required' => $attribute['required'],
            );

            if ($html_type == 'checkbox') {
                $option_data['value'] = $option_data['label_text'] = current($values);
                if ($value) {
                    $option_data['checked'] = true;
                }
            } elseif ($html_type == 'checkboxgroup') {
                $option_data['scrollbox'] = true;
            }

            $this->data['entry_attribute_'.$attribute['customer_attribute_id']] = $attribute['name'];

            if ($html_type == 'file') {
                $dir = DIR_APP_SECTION.'system/uploads/'.$attribute['settings']['directory'];
                $dir = rtrim($dir, '/');
                if (is_file($dir.'/'.$value) && is_readable($dir.'/'.$value)) {
                    $field_value = '<a style="display:block; padding-top: 7px;" href="'.$that->html->getSecureURL(
                            'sale/customer_attributes/download',
                            '&filename='.urlencode($value).
                            '&customer_attribute_id='.(int)$attribute['customer_attribute_id'].
                            '&customer_group_id='.$customer_info['customer_group_id'])
                        .'" title=" to download file" target="_blank">'.$value.'</a>';

                } else {
                    $field_value = $that->html->buildElement(
                        array(
                            'type'  => 'input',
                            'value' => $value,
                            'attr'  => 'disabled',
                        ));

                }
            } elseif ($html_type == 'hidden') {
                $field_value = $value;
            } else {
                $field_value = $that->html->buildElement($option_data);
            }
            $this->data['form']['fields']['attributes']['attribute_'.$attribute['customer_attribute_id']] =
                $field_value;
        }

        $this->data['tab_customer_attributes'] = $that->language->get('text_customer_attributes');

        $that->view->batchAssign($this->data);
    }

    public function onControllerResponsesListingGridCustomer_InitData()
    {
        if (!$this->isEnabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if (isset($that->request->get['id']) && isset($that->request->post['attributes'])) {
            $that->loadModel('sale/customer_attributes');
            $that->model_sale_customer_attributes->updateCustomerAttributeValues(
                $that->request->get['id'],
                $that->request->post['attributes']
            );
            unset($that->request->post['attributes']);

        }
        return null;
    }

    private function processFileUpload($customer_id)
    {
        $that =& $this->baseObject;
        $fm = new AFile();

        $customer_id = !$customer_id ? $that->customer->getId() : $customer_id;

        foreach ($that->request->files['attributes']['name'] as $id => $name) {

            $attribute_data = $that->model_sale_customer_attributes->getAttributeInfo($id);
            if ($attribute_data['required'] && !has_value($name)) {
                $this->errors[$id] = $that->language->get('error_required');
            } else {
                if (!has_value($name)) {
                    continue;
                }

                $name = $customer_id.'_'.$name; //adds customer_id to set filename unique per customer

                $file_path_info = $fm->getUploadFilePath($attribute_data['settings']['directory'], $name);
                $that->model_sale_customer_attributes->addAttributesToCustomer($customer_id, array($id => $name));

                $file_data = array(
                    'option_id' => $id,
                    'name'      => $file_path_info['name'],
                    'path'      => $file_path_info['path'],
                    'type'      => $that->request->files['attributes']['type'][$id],
                    'tmp_name'  => $that->request->files['attributes']['tmp_name'][$id],
                    'error'     => $that->request->files['attributes']['error'][$id],
                    'size'      => $that->request->files['attributes']['size'][$id],
                );

                $file_errors = $fm->validateFileOption($attribute_data['settings'], $file_data);
                if (has_value($file_errors)) {
                    $this->errors[$id] = $file_errors[0];
                }

                if (!has_value($this->errors)) {
                    move_uploaded_file($file_data['tmp_name'], $file_path_info['path']);

                    $dataset = new ADataset('file_uploads', 'admin');
                    $dataset->addRows(
                        array(
                            'date_added' => date("Y-m-d H:i:s", time()),
                            'name'       => $file_path_info['name'],
                            'type'       => $file_data['type'],
                            'section'    => 'customer_attribute',
                            'section_id' => $attribute_data['attribute_id'],
                            'path'       => $file_path_info['path'],
                        )
                    );
                }

            }

        }

    }

}