<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelExtensionBulkSpecialsGenerator extends Model
{
    public function __construct()
    {
        $this->registry = Registry::getInstance();
    }

    /*START SERCH PRODUCTS native model mod*/

    /**
     * @param array  $data
     * @param string $mode
     *
     * @return array|int
     */
    public function getProductsSearch($data = array(), $mode = 'default')
    {
        if (!empty($data['content_language_id'])) {
            $language_id = (int) $data['content_language_id'];
        } else {
            $language_id = (int) $this->config->get('storefront_language_id');
        }

        if ($data['store_id']) {
            $store_id = (int) $data['store_id'];
        } else {
            $store_id = (int) $this->config->get('config_store_id');
        }

        //$mode = 'total_only';

        if ($data || 'total_only' == $mode) {
            $match = '';
            $filter = (isset($data['filter']) ? $data['filter'] : array());

            if ('total_only' == $mode) {
                $sql = 'SELECT COUNT(*) as total ';
            } else {
                $sql = 'SELECT *, p.product_id ';
                $sql .= ', (SELECT
                                CASE WHEN SUM(COALESCE(ppov.subtract,0))>0
                                 THEN SUM( CASE WHEN ppov.quantity > 0 THEN ppov.quantity ELSE 0 END)
                                ELSE pp.quantity END as quantity
                            FROM '.$this->db->table('products').' pp
                            LEFT JOIN '.$this->db->table('product_options').' ppo
                                ON ppo.product_id = pp.product_id
                            LEFT JOIN  '.$this->db->table('product_option_values').' ppov
                                ON (ppo.product_option_id = ppov.product_option_id AND ppov.subtract>0)
                            WHERE pp.product_id = p.product_id
                            GROUP BY pp.product_id) as quantity ';
            }
            $sql .= ' FROM '.$this->db->table('products').' p
                        LEFT JOIN '.$this->db->table('product_descriptions')." pd
                            ON (p.product_id = pd.product_id AND pd.language_id = '".$language_id."')
                        INNER JOIN ".$this->db->table('products_to_stores')." ps
                            ON (p.product_id = ps.product_id AND ps.store_id = '".$store_id."') ";

            if (isset($filter['category']) && $filter['category'] > 0) {
                $sql .= ' LEFT JOIN '.$this->db->table('products_to_categories')
                    .' p2c ON (p.product_id = p2c.product_id) ';
            }

            $sql .= ' WHERE 1=1 ';

            if (!empty($data['subsql_filter'])) {
                $sql .= ' AND '.$data['subsql_filter'];
            }

            if (isset($filter['match']) && !is_null($filter['match'])) {
                $match = $filter['match'];
            }

            if (isset($filter['exclude']['product_id'])) {
                $exclude = $filter['exclude']['product_id'];
                $excludes = array();
                if (is_array($exclude)) {
                    foreach ($exclude as $ex) {
                        $excludes[] = (int) $ex;
                    }
                } elseif ((int) $exclude) {
                    $excludes = array((int) $exclude);
                }

                if ($excludes) {
                    $sql .= ' AND p.product_id NOT IN ('.implode(',', $excludes).') ';
                }
            }

            if (isset($filter['keyword']) && !is_null($filter['keyword'])) {
                $keywords = explode(' ', $filter['keyword']);
                //$match = 'any';
                if ('any' == $match) {
                    $sql .= ' AND (';
                    foreach ($keywords as $k => $keyword) {
                        $sql .= $k > 0 ? ' OR' : '';
                        $sql .= " (LCASE(pd.name) LIKE '%".$this->db->escape(mb_strtolower($keyword), true)."%'";
                        $sql .= " OR LCASE(p.model) LIKE '%".$this->db->escape(mb_strtolower($keyword), true)."%'";
                        $sql .= " OR LCASE(p.sku) LIKE '%".$this->db->escape(mb_strtolower($keyword), true)."%')";
                    }
                    $sql .= ' )';
                } else {
                    if ('all' == $match) {
                        $sql .= ' AND (';
                        foreach ($keywords as $k => $keyword) {
                            $sql .= $k > 0 ? ' AND' : '';
                            $sql .= " (LCASE(pd.name) LIKE '%".$this->db->escape(mb_strtolower($keyword), true)."%'";
                            $sql .= " OR LCASE(p.model) LIKE '%".$this->db->escape(mb_strtolower($keyword), true)."%'";
                            $sql .= " OR LCASE(p.sku) LIKE '%".$this->db->escape(mb_strtolower($keyword), true)."%')";
                        }
                        $sql .= ' )';
                    } else {
                        if ('exact' == $match) {
                            /*$sql .= " AND (LCASE(pd.name) LIKE '%".$this->db->escape(mb_strtolower($filter['keyword']),
                                    true)."%'";
                            $sql .= " OR LCASE(p.model) LIKE '%".$this->db->escape(mb_strtolower($filter['keyword']),
                                    true)."%'";
                            $sql .= " OR LCASE(p.sku) LIKE '%".$this->db->escape(mb_strtolower($filter['keyword']),
                                    true)."%')";*/
                        } else {
                            if ('begin' == $match) {
                                $sql .= " AND (LCASE(pd.name) LIKE '"
                                    .$this->db->escape(
                                        mb_strtolower($filter['keyword']), true)."%'";
                                $sql .= " OR LCASE(p.model) LIKE '".$this->db->escape(
                                        mb_strtolower($filter['keyword']),
                                        true)."%'";
                                $sql .= " OR LCASE(p.sku) LIKE '".$this->db->escape(
                                        mb_strtolower($filter['keyword']),
                                        true)."%')";
                            }
                        }
                    }
                }
            }

            if (isset($filter['pfrom']) && !is_null($filter['pfrom'])) {
                $sql .= " AND p.price >= '".(float) $filter['pfrom']."'";
            }
            if (isset($filter['pto']) && !is_null($filter['pto'])) {
                $sql .= " AND p.price <= '".(float) $filter['pto']."'";
            }
            if ($filter['category']) {
                $sql .= " AND p2c.category_id = '".(int) $filter['category']."'";
            }
            if (isset($filter['status']) && !is_null($filter['status'])) {
                $sql .= " AND p.status = '".(int) $filter['status']."'";
            }

            //If for total, we done building the query
            if ('total_only' == $mode) {
                $query = $this->db->query($sql);

                return $query->row['total'];
            }

            $sort_data = array(
                'product_id' => 'p.product_id',
                'name' => 'pd.name'.' '.'p.model',
                'model' => 'p.model',
                'quantity' => 'quantity',
                'price' => 'p.price',
                'status' => 'p.status',
                'sort_order' => 'p.sort_order',
                'date_modified' => 'p.date_modified',
            );

            if (isset($data['sort']) && array_key_exists($data['sort'], $sort_data)) {
                $sql .= ' ORDER BY '.$sort_data[$data['sort']];
            } else {
                //for faster SQL default to ID based order
                $sql .= ' ORDER BY p.product_id';
            }

            if (isset($data['order']) && ('DESC' == $data['order'])) {
                $sql .= ' DESC';
            } else {
                $sql .= ' ASC';
            }

            if (isset($data['start']) || isset($data['limit'])) {
                if ($data['start'] < 0) {
                    $data['start'] = 0;
                }

                if ($data['limit'] < 1) {
                    $data['limit'] = 20;
                }
                $sql .= ' LIMIT '.(int) $data['start'].','.(int) $data['limit'];
            }
            $query = $this->db->query($sql);

            return $query->rows;
        } else {
            $cache_key = 'product.lang_'.$language_id;
            $product_data = $this->cache->pull($cache_key);
            if (false === $product_data) {
                $query = $this->db->query('SELECT p.product_id, p.model, p.sku,
                  CONCAT(p.sku, " ", p.model, " ", pd.name) AS name, pd.product_id
                                            FROM '.$this->db->table('products').' p
                                            LEFT JOIN '.$this->db->table('product_descriptions')." pd
                                                ON (p.product_id = pd.product_id AND pd.language_id = '".$language_id."')
                                            ORDER BY pd.name ASC");
                $product_data = $query->rows;
                $this->cache->push($cache_key, $product_data);
            }

            return $product_data;
        }
    }

    /*END SEARCH*/

    public function getproducts($category, $brand, $products)
    {
        $products = trim($products,","); // to fix ,13839
        $category = trim($category,",");
        $brand = trim($brand,",");
        //$this->log->write(print_r( $products, true).' BULKGENERATOR MODEL debug 0: products	'); //
        //$this->log->write(print_r( $brand, true).' BULKGENERATOR MODEL debug 0: brands	'); //
        //$this->log->write(print_r( $category, true).' BULKGENERATOR MODEL debug 0: category	'); //
        if (0 == $category and $brand > 0 and 0 == $products) {
            $sql = 'SELECT DISTINCT p.product_id FROM '.DB_PREFIX.'products_to_stores p
							INNER JOIN '.DB_PREFIX.'products d ON d.product_id = p.product_id
							WHERE
							manufacturer_id IN ('.$brand.")
							AND store_id = '".(int) $this->config->get('config_store_id')."'";
        } elseif ($category > 0 and 0 == $brand and 0 == $products) {
            $sql = 'SELECT DISTINCT p.product_id FROM '.DB_PREFIX.'products_to_stores p
							INNER JOIN '.DB_PREFIX.'products_to_categories c ON c.product_id = p.product_id
							INNER JOIN '.DB_PREFIX.'products d ON d.product_id = p.product_id
							WHERE
							category_id IN ('.$category.")
							AND store_id = '".(int) $this->config->get('config_store_id')."'";
        } elseif ($category > 0 and $brand > 0 and 0 == $products) {
            $sql = 'SELECT DISTINCT p.product_id FROM '.DB_PREFIX.'products_to_stores p
							INNER JOIN '.DB_PREFIX.'products_to_categories c ON c.product_id = p.product_id
							INNER JOIN '.DB_PREFIX.'products d ON d.product_id = p.product_id
							WHERE
							manufacturer_id IN ('.$brand.')
							AND category_id IN ('.$category.")
							AND store_id = '".(int) $this->config->get('config_store_id')."'";
        } elseif (strlen($products) > 1) {
            //$this->log->write(print_r( $products, true).' BULKGENERATOR MODEL debug 1	');
            $sql = 'SELECT DISTINCT p.product_id FROM '.DB_PREFIX.'products_to_stores p
						INNER JOIN '.DB_PREFIX.'products d ON d.product_id = p.product_id
						WHERE
						d.product_id IN ('.$products.")
						AND store_id = '".(int) $this->config->get('config_store_id')."'";

        }

        //$this->log->write($sql);
        //$this->log->write(' BULKGENERATOR MODEL debug 2	');
        $sqlr = $this->db->query($sql);

        $product_data = $sqlr->rows;

        return $product_data;
    }

    public function getCategories($parent_id = null, $store_id = null)
    {
        if (null === $parent_id) {
            $parent_id = 0;
        }

        $language_id = (int) $this->language->getContentLanguageID();

        $store_id = $this->config->get('config_store_id');
        $cache_key = 'category.'.$parent_id.'.store_'.$store_id.'_lang_'.$language_id;
        $category_data = $this->cache->pull($cache_key);

        if (false == $category_data) {
            $category_data = array();
            $sql = 'SELECT *
					FROM '.$this->db->table('categories').' c
					LEFT JOIN '.$this->db->table('category_descriptions').' cd
					ON (c.category_id = cd.category_id) ';
            if (!is_null($store_id)) {
                ////$this->log->write(' getCategories2A');
                $sql .= 'RIGHT JOIN '.$this->db->table('categories_to_stores')." cs ON (c.category_id = cs.category_id AND cs.store_id = '".(int) $store_id."')";
            }

            ////$this->log->write(' getCategories2B');
            $sql .= "WHERE c.parent_id = '".(int) $parent_id."'
						AND cd.language_id = '".(int) $language_id."'
					ORDER BY c.sort_order, cd.name ASC";
            $query = $this->db->query($sql);
            ////$this->log->write('$sql= '.print_r($sql, true));
            ////$this->log->write('$query= '.print_r($query, true));
            ////$this->log->write(' getCategories2C');

            foreach ($query->rows as $ckey => $result) {
                $category_data[] = array(
                    'category_id' => $result['category_id'],
                    'parent_id' => $result['parent_id'],
                    'name' => $this->getPath($result['category_id'], $language_id),
                    'status' => $result['status'],
                    'sort_order' => $result['sort_order'],
                );
                ////$this->log->write(' getCategories2D-'.$ckey);
                $category_data = array_merge($category_data, $this->getCategories($result['category_id'], $store_id));
            }

            $this->cache->push($cache_key, $category_data);
        }
        ////$this->log->write(' getCategories4');
        return $category_data;
    }

    /**
     * @param int $category_id
     * @param int $language_id
     *
     * @return string
     */
    public function getPath($category_id, $language_id = 0)
    {
        $category_id = (int) $category_id;
        $language_id = (int) $language_id;
        if (!$language_id) {
            $language_id = (int) $this->language->getContentLanguageID();
        }
        $query = $this->db->query('SELECT name, parent_id
		                            FROM '.$this->db->table('categories').' c
		                            LEFT JOIN '.$this->db->table('category_descriptions')." cd
		                                ON (c.category_id = cd.category_id)
		                            WHERE c.category_id = '".(int) $category_id."' AND cd.language_id = '".$language_id."'
		                            ORDER BY c.sort_order, cd.name ASC");

        $category_info = $query->row;

        if ($category_info['parent_id']) {
            return $this->getPath($category_info['parent_id'], $language_id).$this->language->get('text_separator').$category_info['name'];
        } else {
            return $category_info['name'];
        }
    }
}
