<?php

/* Hooks */
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ExtensionAvailabilityListing extends Extension
{
    public $data = array();

    public function __construct()
    {
        $this->registry = Registry::getInstance();
    }

    public function __get($key)
    {
        return $this->registry->get($key);
    }

    public function pageclass()
    {
        $request = $this->request->get;
        $pagedata = array();

        $url = '';
        if (isset($request['page'])) {
            $url .= '&page='.$request['page'];
        }

        if (isset($request['page'])) {
            $page = $request['page'];
        } else {
            $page = 1;
        }

        if (isset($request['limit'])) {
            $limit = (int) $request['limit'];
            $limit = $limit > 50 ? 50 : $limit;
        } else {
            $limit = $this->baseObject->config->get('config_catalog_limit');
        }

        if (isset($request['sort'])) {
            $sorting_href = $request['sort'];
        } else {
            $sorting_href = $this->baseObject->config->get('config_product_default_sort_order');
        }

        list($sort, $order) = explode('-', $sorting_href);
        if ('name' == $sort) {
            $sort = 'pd.'.$sort;
        } elseif (in_array($sort, array('sort_order', 'price'))) {
            $sort = 'p.'.$sort;
        }

        //for search
        if (isset($request['model'])) {
            $model = $request['model'];
            $pagedata['model'] = $model;
        }

        if (isset($request['description'])) {
            $description = $request['description'];
            $pagedata['description'] = $description;
        }

        if (isset($request['keyword'])) {
            $keyword = $request['keyword'];
            $pagedata['keyword'] = $keyword;
        }

        $pagedata['order'] = $order;
        $pagedata['page'] = $page;
        $pagedata['limit'] = $limit;
        $pagedata['sorting_href'] = $sorting_href;
        $pagedata['sort'] = $sort;

        return $pagedata;
    }

    public function processingclass($products_result) // only for specials TODO all
    {
        $this->baseObject->loadLanguage('availability_listing/availability_listing');
        $this->baseObject->loadLanguage('product/product');
        $this->baseObject->loadModel('catalog/product');
        $product_ids = $products = array();
        $data['language_id'] = $this->baseObject->config->get('storefront_language_id');
        $data['availability_tab'] = $this->baseObject->language->get('availability_listing_name');
        $data['availability_listing_nastock_text'] = $this->baseObject->language->get('text_instock');
        $data['availability_text'] = $this->baseObject->config->get('availability_text');
        if ('1' == $this->baseObject->config->get('availability_listing_nastock')) {
            $data['availability_listing_nastock'] = 1;
        } elseif ('0' == $this->baseObject->config->get('availability_listing_nastock')) {
            $data['availability_listing_nastock'] = 0;
        }

        /*display data selector*/
        if ('0' == $this->baseObject->config->get('display_type')) {
            $data['data_to_display'] = 0;
        } elseif ('1' == $this->baseObject->config->get('display_type')) {
            $data['data_to_display'] = 1;
        } elseif ('2' == $this->baseObject->config->get('display_type')) {
            $data['data_to_display'] = 2;
        }

        /*end data selector*/
        $view = new AView($this->registry, 0);
        if (isset($products_result) and count($products_result)) {
            foreach ($products_result as $result) {
                $product_id = (int) $result['product_id'];
                $data['tplvar']['stock'] = $this->GetStock($product_id);
                //$this->baseObject->log->write(print_r($data, true).' $data before inject');
                $view->batchAssign($data);
                $hooks = (string) ('product_listing_details0_'.(int) $product_id);
                // $this->baseObject->view->addHookVar($hooks, $product_wl_data['weight_class']);
                $this->baseObject->view->addHookVar($hooks, $view->fetch('pages/availability_listing/availability_listing_list.tpl'));
            }
        }
    }

    public function GetStock($product_id)
    {
        //if (107 == $product_id) {
        $this->baseObject->loadLanguage('availability_listing/availability_listing');
        $this->baseObject->loadLanguage('product/product');
        $this->baseObject->loadModel('catalog/product');
        //handle stock messages
            // if track stock is off. no messages needed.
            //$this->baseObject->log->write(print_r($this->baseObject->model_catalog_product->isStockTrackable($product_id), true).' isStockTrackable');
            $product_info = $this->baseObject->model_catalog_product->getProduct($product_id); //getProductDataForCart($product_id);
            //$this->baseObject->log->write(print_r($product_info, true).' $product_info data');
            if (!has_value($product_info['stock_checkout'])) {
                $product_info['stock_checkout'] = $this->baseObject->config->get('config_stock_checkout');
            }
        if ($this->baseObject->model_catalog_product->isStockTrackable($product_id)) {
            $total_quantity = $this->baseObject->model_catalog_product->hasAnyStock($product_id);
            //$this->baseObject->log->write(print_r($total_quantity, true).' $total_quantity value for prID'.$product_id);
            $this->data['track_stock'] = true;
            $this->data['can_buy'] = true;
            //out of stock if no quantity and no stock checkout is disabled
            if ($total_quantity <= 0 && !$product_info['stock_checkout']) {
                $this->data['can_buy'] = false;
                $this->data['in_stock'] = false;
                //show out of stock message
                $this->data['stock'] = $this->baseObject->language->get('text_out_of_stock');
            } else {
                $this->data['can_buy'] = true;
                $this->data['in_stock'] = true;
                $this->data['stock'] = '';
                //$this->baseObject->log->write(print_r($product_info['quantity'], true).' $product_info[quantity] value');
                if ($this->baseObject->config->get('config_stock_display') && $product_info['quantity'] > 0 && $product_info['subtract']) {
                    if ($total_quantity < 999999) {
                        $this->data['stock'] = $total_quantity.' '; //$product_info['quantity'].' ';
                    } else {
                        $this->data['stock'] = $product_info['quantity'].' ';
                    }
                }
                if ($product_info['quantity'] <= 0) {
                    $this->data['stock'] = $product_info['stock_status'];
                } else {
                    $this->data['stock'] .= $this->baseObject->language->get('text_instock');
                }
            }

            //check if we need to disable product for no stock
            if ($this->baseObject->config->get('config_nostock_autodisable') && $total_quantity <= 0) {
                //set available data
            }
        } else {
            $this->data['can_buy'] = true;
            if ($product_info['quantity'] <= 0) {
                $this->data['stock'] = $product_info['stock_status'];
            } else {
                $this->data['stock'] = $this->baseObject->language->get('text_instock');
            }
        }

        return $this->data['stock'];
        //}
    }

    public function processingclassinblocks($products_result) // only for specials TODO all
    {
        $this->baseObject->loadLanguage('availability_listing/availability_listing');
        $this->baseObject->loadLanguage('product/product');
        $this->baseObject->loadModel('catalog/product');
        $product_ids = $products = array();
        $data['language_id'] = $this->baseObject->config->get('storefront_language_id');
        $data['availability_tab'] = $this->baseObject->language->get('availability_listing_name');
        $data['availability_listing_nastock_text'] = $this->baseObject->language->get('text_instock');
        $data['availability_text'] = $this->baseObject->config->get('availability_text');
        if ('1' == $this->baseObject->config->get('availability_listing_nastock')) {
            $data['availability_listing_nastock'] = 1;
        } elseif ('0' == $this->baseObject->config->get('availability_listing_nastock')) {
            $data['availability_listing_nastock'] = 0;
        }

        /*display data selector*/
        if ('0' == $this->baseObject->config->get('display_type')) {
            $data['data_to_display'] = 0;
        } elseif ('1' == $this->baseObject->config->get('display_type')) {
            $data['data_to_display'] = 1;
        } elseif ('2' == $this->baseObject->config->get('display_type')) {
            $data['data_to_display'] = 2;
        }

        /*end data selector*/
        $view = new AView($this->registry, 0);
        foreach ($products_result as $result) {
            $product_id = (int) $result['product_id'];
            $data['tplvar'] = $product_info = $this->baseObject->model_catalog_product->getProductDataForCart($product_id);
            $data['quantity'] = $data['tplvar']['quantity'];
            $data['stock_checkout'] = $data['tplvar']['stock_checkout'];
            $data['subtract'] = $data['tplvar']['subtract'];
            $data['tplvar']['stock'] = $this->GetStock($product_id);

            $view->batchAssign($data);
            //$hooks = (string) ('product_price_hook_var_'.(int) $result['product_id']);
            $hooks = (string) ('product_listing_details0_'.(int) $product_id);
            //$this->baseObject->view->addHookVar('product_price_hook_var_'.$result['product_id'], $result['badges']);
            // $this->baseObject->view->addHookVar($hooks, $data['tplvar']['weight_class']);
            $this->baseObject->view->addHookVar($hooks, $view->fetch('pages/availability_listing/availability_listing_list.tpl'));
        }
    }

    //remove default
    public function onControllerPagesProductProduct_UpdateData()
    {
        if (('1' == $this->baseObject->config->get('availability_listing_status')) and ('2' != $this->baseObject->config->get('availability_listing_product_page'))) {
            $view = new AView($this->registry, 0);
            // get all data from the Controller
            $data = $this->baseObject->view->getData();
            $data = $this->superclass($data);
            //put in controller new $data['products'] array
            $this->baseObject->view->assign('stock', '');
        }
    }

    public function onControllerPagesProductProduct_InitData()
    {
        $this->baseObject->loadLanguage('availability_listing/availability_listing');
        $this->baseObject->loadLanguage('product/product');
        $this->baseObject->load->model('catalog/product');
        $product_id = $this->baseObject->request->get['product_id'];
        if (empty($product_id)) {//cart revert
            $product_id = $this->baseObject->request->get['key'];
        }

        $data['language_id'] = $this->baseObject->config->get('storefront_language_id');
        $data['availability_tab'] = $this->baseObject->language->get('availability_listing_name');
        $data['availability_listing_nastock_text'] = $this->baseObject->language->get('text_instock');
        $data['availability_text'] = $this->baseObject->config->get('availability_text');
        if ('1' == $this->baseObject->config->get('availability_listing_nastock')) {
            $data['availability_listing_nastock'] = 1;
        } elseif ('0' == $this->baseObject->config->get('availability_listing_nastock')) {
            $data['availability_listing_nastock'] = 0;
        }
        /*display data selector*/
        if ('0' == $this->baseObject->config->get('display_type')) {
            $data['data_to_display'] = 0;
        } elseif ('1' == $this->baseObject->config->get('display_type')) {
            $data['data_to_display'] = 1;
        } elseif ('2' == $this->baseObject->config->get('display_type')) {
            $data['data_to_display'] = 2;
        }
        /*end data selector*/
        $data['tplvar'] = $product_info = $this->baseObject->model_catalog_product->getProductDataForCart($product_id);
        $data['quantity'] = $data['tplvar']['quantity'];
        $data['stock_checkout'] = $data['tplvar']['stock_checkout'];
        $data['subtract'] = $data['tplvar']['subtract'];
        $data['tplvar']['stock'] = $this->GetStock($product_id);

        if ('1' == $this->baseObject->config->get('availability_listing_product_page')) {/*show in Tab*/
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $this->baseObject->view->addHookVar('product_features_tab', $view->fetch('pages/availability_listing/availability_listing_tab.tpl'));
            $this->baseObject->view->addHookVar('product_features', $view->fetch('pages/availability_listing/availability_listing_content.tpl'));
        } elseif ('0' == $this->baseObject->config->get('availability_listing_product_page')) {/*show in buttons*/
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $this->baseObject->view->addHookVar('buttons', $view->fetch('pages/availability_listing/availability_listing_outside.tpl'));
        }
    }

    public function onControllerPagesProductManufacturer_InitData()   //Brands
    {
        if ('1' == $this->baseObject->config->get('availability_listing_listing_status_manufacturer')) {
            //$this->baseObject->loadLanguage('availability_listing/availability_listing');
            //$this->baseObject->loadModel('availability_listing/availability_listing');
            //$data = array();
            $pagedata = $this->pageclass();
            $manufacturer_id = $this->baseObject->request->get['manufacturer_id'];
            $this->baseObject->load->model('catalog/product');
            $products_result = $this->baseObject->model_catalog_product->getProductsByManufacturerId((int) $manufacturer_id, $pagedata['sort'], $pagedata['order'], ($pagedata['page'] - 1) * $pagedata['limit'], $pagedata['limit']);
            $this->processingclass($products_result);
        }
    }

    public function onControllerPagesProductCategory_InitData()   //     category
    {
        if ('1' == $this->baseObject->config->get('availability_listing_listing_status_category')) {
            $pagedata = $this->pageclass();
            $this->processingclass($products_result);

            if (isset($this->baseObject->request->get['path'])) {
                $path = explode('_', $this->baseObject->request->get['path']);
                $category_id = end($path);
            }

            if (empty($category_id)) {
                $category_id = $this->baseObject->request->get['category_id'];
            }

            $this->baseObject->load->model('catalog/product');
            $products_result = $this->baseObject->model_catalog_product->getProductsByCategoryId($category_id, $pagedata['sort'], $pagedata['order'], ($pagedata['page'] - 1) * $pagedata['limit'], $pagedata['limit']);
            $this->processingclass($products_result);
        }
    }

    public function onControllerPagesProductSearch_InitData()   //search
    {
        if ('1' == $this->baseObject->config->get('availability_listing_listing_status_search')) {
            $this->baseObject->loadLanguage('availability_listing/availability_listing');
            //$this->baseObject->loadModel('availability_listing/availability_listing');
            //$data = array();
            ///index.php?rt=product/search&keyword=a&category_id=0,49&description=1&model=1&sort=rating-DESC&limit=3&page=3
            /*if (isset($this->baseObject->request->get['category_id'])) {
            $path = explode(',', rawurlencode($this->baseObject->request->get['category_id']));   //    0%2C36   vs 0,36   //
            $category_id = end($path);
            }
            if(empty($category_id)){
            $category_id = $this->baseObject->request->get['category_id']; }
            */
            $request = $this->request->get;
            if (isset($request['category_id'])) {
                $category_id = explode(',', $request['category_id']);
                end($category_id);
                $category_id = current($category_id);
            } else {
                $category_id = '';
            }

            $pagedata = $this->pageclass();
            $limit = $pagedata['limit'];
            //$this->baseObject->config->get('config_catalog_limit');    cache or sql bug
            $this->baseObject->load->model('catalog/product');
            //($keyword, $category_id = 0, $description = false, $model = false, $sort = 'p.sort_order', $order = 'ASC', $start = 0, $limit = 20)
            $products_result = $this->baseObject->model_catalog_product->getProductsByKeyword(
              $pagedata['keyword'],
              $category_id,
              isset($pagedata['description']) ? $pagedata['description'] : '',
              isset($pagedata['model']) ? $pagedata['model'] : '',
              $pagedata['sort'],
              $pagedata['order'],
              ($pagedata['page'] - 1) * $limit,
              $limit
            );
            //$this->baseObject->log->write(serialize($products_result));
            $this->processingclass($products_result);
        }
    }

    public function onControllerPagesProductSpecial_InitData()   //special
    {
        if ('1' == $this->baseObject->config->get('availability_listing_listing_status_special')) {
            $pagedata = $this->pageclass();
            $this->baseObject->load->model('catalog/product');
            $products_result = $this->baseObject->model_catalog_product->getProductSpecials($pagedata['sort'], $pagedata['order'], ($pagedata['page'] - 1) * $pagedata['limit'], $pagedata['limit']);
            //$this->baseObject->log->write(print_r($products_result, true).' products');
            $this->processingclass($products_result);
        }
    }

    /*public function onControllerBlocksListingBlock_UpdateData() {
      if ($this->baseObject->config->get('availability_listing_listing_status_special') == '1') {
          $view = new AView($this->registry, 0);
          $data = $this->baseObject->view->getData();
          $this->baseObject->log->write(print_r($data['content'], true).' products data block');
          $this->processingclass($data['content']);
      }
    }*/
    /*public function onControllerBlocksListingBlock_InitData() {
      if ($this->baseObject->config->get('availability_listing_listing_status_special') == '1') {
          //$view = new AView($this->registry, 0);
          //$data = $this->baseObject->view->getData();
          $instance_id = func_get_arg(0);
      		$block_data = $this->_getBlockContent($instance_id);
          $this->baseObject->log->write(print_r($instance_id, true).' $instance_id'); //getListing main
          $this->baseObject->log->write(print_r($block_data, true).'  $block_data');

      		$block_details = $this->baseObject->layout->getBlockDetails($instance_id);
          $this->baseObject->log->write(print_r($block_details, true).' products data details');
          $this->processingclass($data['content']);
      }
    }
    */

    public function onControllerBlocksfeatured_UpdateData()
    {
        if ('1' == $this->baseObject->config->get('availability_listing_block_status_featured')) {
            $this->baseObject->load->model('catalog/product');
            $products_result = $this->baseObject->model_catalog_product->getfeaturedProducts($this->baseObject->config->get('config_featured_limit'));
            //$this->baseObject->log->write(print_r($results, true).' products sp block');
            $this->processingclassinblocks($products_result);
        }
    }

    public function onControllerBlocksBestSeller_UpdateData()
    {
        if ('1' == $this->baseObject->config->get('availability_listing_block_status_bestsellers')) {
            $this->baseObject->load->model('catalog/product');
            $products_result = $this->baseObject->model_catalog_product->getBestSellerProducts($this->baseObject->config->get('config_bestseller_limit'));
            //$this->baseObject->log->write(print_r($results, true).' products sp block');
            $this->processingclassinblocks($products_result);
        }
    }

    /*public function onControllerBlocksSpecial_UpdateData() {
      if ($this->baseObject->config->get('availability_listing_listing_status_special') == '1') {
          $view = new AView($this->registry, 0);
          $data = $this->baseObject->view->getData();
          $this->baseObject->log->write(print_r($data['products'], true).' products');
          $this->processingclass($data['products']);
      }
    }*/

    public function onControllerBlocksSpecial_InitData()
    { //specials block
        if ('1' == $this->baseObject->config->get('availability_listing_block_status_special')) {
            $promotion = new APromotion();
            $results = $promotion->getSpecialProducts(
                      array(
                              'sort' => 'pd.name',
                              'order' => 'ASC',
                              'start' => 0,
                              'limit' => $this->config->get('config_special_limit'),
                              'avg_rating' => $this->config->get('enable_reviews'),
                      )
              );
            //$this->baseObject->log->write(print_r($results, true).' products sp block');
            $this->processingclassinblocks($results);
        }
    }

    public function onControllerBlocksLatest_UpdateData()
    {
        if ('1' == $this->baseObject->config->get('availability_listing_block_status_latest')) {
            $this->baseObject->load->model('catalog/product');
            $products_result = $this->baseObject->model_catalog_product->getLatestProducts($this->baseObject->config->get('config_latest_limit'));
            //$this->baseObject->log->write(print_r($results, true).' products sp block');
            $this->processingclassinblocks($products_result);
        }
    }

    // themes support
    public function onControllerHomeTripleFeaturedHomeTripleFeatured_UpdateData()
    {
    }

    // extensions support
    public function onControllerAlsoPurchasedAlsoPurchased_UpdateData()
    {
    }

    public function onControllerTopSellingTopSelling_UpdateData()
    {
    }
}
