<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ControllerAlsoPurchasedAlsoPurchased extends AController
{
    public function getPurchased($product_id)
    {
        $limit = $this->config->get('also_purchased_quantity');
        if ($limit > 150) {
            $limit = 150;
        }
        $query_limit = $limit + 20;
        $language_id = (int)$this->config->get('storefront_language_id');
        $store_id = (int)$this->config->get('config_store_id');

        /*$sql = "SELECT DISTINCT tag
                        FROM " . $this->db->table("product_tags") . "
                        WHERE language_id = '" . (int)$this->config->get('storefront_language_id') . "'
                        ORDER BY tag ASC
                        LIMIT " . $limit . "";
                        */

        //select all orders with current product id
        //SELECT `order_id` FROM `abc129_order_products` WHERE `product_id`=51 GROUP BY `order_id` LIMIT 33
        $order_limit = 10000;
        $sql1 = "SELECT order_id
					FROM " . $this->db->table("order_products") . "
					WHERE product_id = '" . (int)$product_id . "'
					GROUP BY order_id
					LIMIT " . (int)$order_limit . "";

        $query = $this->db->query($sql1);
        $orderitems = array();
        $orderitems = $query->rows;
        //$this->log->write(print_r(array_column($orderitems, 'order_id'), true).'$orderitems'); // print array
        $data = array();
        //php <5.5 fix
        if (! function_exists('array_column')) {
            function array_column(array $input, $columnKey, $indexKey = null)
            {
                $array = array();
                foreach ($input as $value) {
                    if (!array_key_exists($columnKey, $value)) {
                        trigger_error("Key \"$columnKey\" does not exist in array");
                        return false;
                    }
                    if (is_null($indexKey)) {
                        $array[] = $value[$columnKey];
                    } else {
                        if (!array_key_exists($indexKey, $value)) {
                            trigger_error("Key \"$indexKey\" does not exist in array");
                            return false;
                        }
                        if (! is_scalar($value[$indexKey])) {
                            trigger_error("Key \"$indexKey\" does not contain scalar value");
                            return false;
                        }
                        $array[$value[$indexKey]] = $value[$columnKey];
                    }
                }
                return $array;
            }
        }
        //end fix
        if (count($orderitems) > 0) {
            $sql2 = "SELECT op.product_id
										FROM " . $this->db->table("order_products") . " op
                    LEFT JOIN " . $this->db->table("products") . " p ON p.product_id = op.product_id
                    LEFT JOIN " . $this->db->table("products_to_stores") . " p2s
                      ON (p.product_id = p2s.product_id)
										WHERE op.order_id IN (" . implode(',', (array_column($orderitems, 'order_id'))) . ") AND p.status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . $store_id . "'
										LIMIT " . (int)$query_limit . "";
            $query = $this->db->query($sql2);
            $items = array();
            $items = $query->rows;
            //$this->log->write(print_r($items, true).'$items'); //print array

            $all_ids = implode(',', (array_column($items, 'product_id')));
            $array_view = array_unique(explode(',', $all_ids));
            //remove product
            foreach ($array_view as $k => $result) {
                if ($result == (int)$product_id || empty($result)) {
                    unset($array_view[$k]);
                }
            }
            shuffle($array_view);
            //$this->log->write(print_r($array_view, true).'$array_view');
        }

        $this->loadModel('catalog/product');
        $this->loadModel('catalog/review');
        $this->loadModel('tool/seo_url');

        if (count($array_view)) {
            foreach ($array_view as $k => $v) {
                $product_status = $this->model_catalog_product->getProduct($v);

                if ($product_status['status'] > 0) {
                    //$this->log->write(print_r($product_status, true).' --$product_status');
                    // get discounts and options
                    $product_allinfo = $this->model_catalog_product->getProductsAllInfo(array($v));
                    //$this->log->write(print_r($product_allinfo, true).' --$product_allinfo');
                    if (count($product_allinfo[$v]['options'])) {
                        $add_to_cart = $this->html->getSEOURL('product/product', '&product_id=' . $v, '&encode');
                    } else {
                        if ($this->config->get('config_cart_ajax')) {
                            $add_to_cart = '#';
                        } else {
                            $add_to_cart = $this->html->getSecureURL('checkout/cart', '&product_id=' . $v, '&encode');
                        }
                    }
                    $product_status['add'] = $add_to_cart; //be ignored skip to check in line 200
                    $product_info[$k] = $product_status;
                }
            }
            $product_info = array_slice($product_info, 0, $limit);
        }
        //$this->log->write(print_r($product_info, true).' --$product_info');
        return $product_info;
        //return $array_view;
    }









    public function main()
    {
        /*    $code = html_entity_decode( $this->config->get('also_purchased_code') );
        if(!$code){
            return;
        }*/
        //init controller data
        //$this->log->write(' run');
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $product_id = $this->request->get['product_id'];
        if (empty($product_id)) {//cart revert
            $product_id = $this->request->get['key'];
        }
        if ($product_id) {
            $this->loadLanguage('also_purchased/also_purchased');
            $this->loadModel('catalog/category');
            $this->loadModel('catalog/product');
            $this->loadModel('catalog/review');
            $this->loadModel('tool/image');

            if ($this->config->get('config_customer_price')) {
                $display_price = true;
            } elseif ($this->customer->isLogged()) {
                $display_price = true;
            } else {
                $display_price = false;
            }

            $products = array();
            $resource = new AResource('image');
            $promoton = new APromotion();
            $results = $this->getPurchased((int)$product_id);

            //$this->log->write(print_r($results, true).' $results'); //print array


            $sizes = array('main' => array('width' => $this->config->get('also_purchased_width'),
                                          'height' => $this->config->get('also_purchased_height'), ),
                                          'thumb' => array('width' => $this->config->get('also_purchased_width'),
                                          'height' => $this->config->get('also_purchased_height'), ), );
            $limit = $this->config->get('also_purchased_quantity');
            if ($limit > 150) {
                $limit = 150;
            }
            if (!count($results) and $this->config->get('also_purchased_fillgap_status')) {
                $results = $this->model_catalog_product->getPopularProducts($limit);
                //$results = $this->model_catalog_product->getProductRelated((int)$product_id);
                //$this->log->write(print_r($results, true).' $results related'); //print array
            }
            if (count($results)) {
                foreach ($results as $result) {
                    //  product image

                    $image = $resource->getResourceAllObjects('products', (int)$result['product_id'], $sizes, 1);

                    if ($this->config->get('enable_reviews')) {
                        $rating = $this->model_catalog_review->getAverageRating($result['product_id']);
                    } else {
                        $rating = false;
                    }

                    $special = false;
                    $discount = $promoton->getProductDiscount($result['product_id']);
                    if ($discount) {
                        $price = $this->currency->format($this->tax->calculate($discount, $result['tax_class_id'], (bool) $this->config->get('config_tax')));
                    } else {
                        $price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], (bool) $this->config->get('config_tax')));
                        $special = $promoton->getProductSpecial($result['product_id']);
                        if ($special) {
                            $special = $this->currency->format($this->tax->calculate($special, $result['tax_class_id'], (bool) $this->config->get('config_tax')));
                        }
                    }
                    //$price = $result['price'];

                    $options = $this->model_catalog_product->getProductOptions($result['product_id']);

                    if ($options) {
                        $add = $this->html->getSEOURL('product/product', '&product_id='.$result['product_id'], '&encode');
                    } else {
                        if ($this->config->get('config_cart_ajax')) {
                            $add = '#';
                        } else {
                            $add = $this->html->getSecureURL($this->routes['cart_rt'], '&product_id='.$result['product_id'], '&encode');
                        }
                    }

                    $products[] = array(
                                                    'product_id' => $result['product_id'],
                                                    'name' => $result['name'],
                                                    'model' => $result['model'],
                                                    'rating' => $rating,
                                                    'stars' => sprintf($this->language->get('text_stars'), $rating),
                                                    'price' => $price,
                                                    'call_to_order' => $result['call_to_order'],
                                                    'options' => $options,
                                                    'special' => $special,
                                                    'image' => $image,
                                                    'thumb'        => $image,
                                                    'href' => $this->html->getSEOURL('product/product', '&product_id='.$result['product_id'], '&encode'),
                                                    'add' => $add,
                                                    //to do
                                                    'track_stock' => $track_stock,
                                                    'in_stock'        => $in_stock,
                                                    'no_stock_text' => $no_stock_text,
                                                    'total_quantity'=> $total_quantity,
                                                    'date_added'    => $result['date_added']

                                    );
                }
                /*foreach ($array_view as $k => $v) {
                //$product_info[$k] = $this->model_catalog_product->getProductDataForCart($v);
                $product_info[$v] = $this->model_catalog_product->getProductDataForCart($v);
                }
                */
            } else {
                //fill no products case
            }
            //$this->log->write(print_r($products, true).' $products finit'); //print array

            $this->view->assign('heading_title', $this->language->get('heading_title'));
            //$this->view->assign( 'code', $code);
            $this->view->assign('products', $products);
            $this->view->assign('block_framed', true);
            $this->view->assign('display_price', $display_price);

            if (count($products)) {
                $this->processTemplate();
            }
        }

        //init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }
}
