<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2018 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

class ExtensionAddthis extends Extension {

    public $data=array();

    private function _is_enabled() {
        return $this->baseObject->config->get('addthis_status') ? true : false;
    }

    public function onControllerCommonHead_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if (IS_ADMIN===false) {
            $that = $this->baseObject;
            $resource = new AResource('image');
            $request = $that->request->get;
            $key = array(); //key of product from cart
            $product_page='0';
            if(has_value($request['key'])){
                $key = explode(':', $request['key']);
                $product_id = (int)$key[0];
                $product_page='1';
            } elseif(has_value($request['product_id'])){
                $product_id = (int)$request['product_id'];
                $product_page='1';
            } else {
                $product_id=0;
            }

            $desc='';
            $that->load->model('catalog/product');
            $product_info = $that->model_catalog_product->getProduct($product_id);
            if ($product_info) {
                $desc=strip_tags(htmlspecialchars_decode($product_info['description']));
            }
            $sizes = array(
                'thumb' => array('width' => $that->config->get('config_image_thumb_width'),
                    'height' => $that->config->get('config_image_thumb_height')));
            $array[] = $resource->getResourceAllObjects('products', $product_id, $sizes, 1, false);
            $version=str_replace('.','',VERSION);
            if ($version < '128') {
                $thumb_url = $array[0]['thumb_url'];
            } else {
                if (HTTPS === true) {
                    $thumb_url = 'https:' . $array[0]['thumb_url'];
                } else {
                    $thumb_url = 'http:' . $array[0]['thumb_url'];
                }
            }
            $this->data['ogImg']= $thumb_url;
            $this->data['ogWidth']= $array[0]['thumb_width'];
            $this->data['ogHeight']= $array[0]['thumb_height'];
            $this->data['ogDesc']=$desc;
            if (HTTPS === true) {
                $url = 'https://';
            } else {
                $url = 'http://';
            }
            $headCode=$that->config->get('addthis_headJSCode');
            $headJS = str_replace(PHP_EOL, '', nl2br($headCode));
            $head = str_replace("<br />", "<br />\\", $headJS);
            $this->data['headJSCode']= $head;
            $this->data['product_page']=$product_page;
            $this->data['ogUrl']= $url . $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"];
            $divCode=$that->config->get('addthis_divTag');
            $divTag = str_replace(PHP_EOL, '', nl2br($divCode));
            $div = str_replace("<br />", "<br />\\", $divTag);
            $this->data['spans']=$div;
            $that->loadLanguage('addthis/addthis');
            $this->data['addthis_text']=$that->language->get('addthis_text');
            $that->view->batchAssign($this->data);
            $that->processTemplate('common/head.post.tpl');
        }
    }

    public function onControllerResponsesEmbedHead_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $resource = new AResource('image');
        $request = $that->request->get;
        $key = array(); //key of product from cart

        $product_page='0';
        if(has_value($request['key'])){
            $key = explode(':', $request['key']);
            $product_id = (int)$key[0];
            $product_page='1';
        } elseif(has_value($request['product_id'])){
            $product_id = (int)$request['product_id'];
            $product_page='1';
        } else {
            $product_id=0;
        }

        $desc='';
        $that->load->model('catalog/product');
        $product_info = $that->model_catalog_product->getProduct($product_id);
        if ($product_info) {
            $desc=strip_tags(htmlspecialchars_decode($product_info['description']));
        }

        $sizes = array(
            'thumb' => array('width' => $that->config->get('config_image_thumb_width'),
                'height' => $that->config->get('config_image_thumb_height')));
        $array[] = $resource->getResourceAllObjects('products', $product_id, $sizes, 1, false);

        $version=str_replace('.','',VERSION);
        if ($version < '128') {
            $thumb_url = $array[0]['thumb_url'];
        } else {
            if (HTTPS === true) {
                $thumb_url = 'https:' . $array[0]['thumb_url'];
            } else {
                $thumb_url = 'http:' . $array[0]['thumb_url'];
            }
        }
        $this->data['ogImg']= $thumb_url;
        $this->data['ogWidth']= $array[0]['thumb_width'];
        $this->data['ogHeight']= $array[0]['thumb_height'];
        $this->data['ogDesc']=$desc;
        if (HTTPS === true) {
            $url = 'https://';
        } else {
            $url = 'http://';
        }
        $headCode=$that->config->get('addthis_headJSCode');
        $headJS = str_replace(PHP_EOL, '', nl2br($headCode));
        $head = str_replace("<br />", "<br />\\", $headJS);
        $this->data['headJSCode']= $head;
        $this->data['product_page']=$product_page;
        $this->data['ogUrl']= $url . $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"];
        $divCode=$that->config->get('addthis_divTag');
        $divTag = str_replace(PHP_EOL, '', nl2br($divCode));
        $div = str_replace("<br />", "<br />\\", $divTag);
        $this->data['spans']=$div;
        $that->loadLanguage('addthis/addthis');
        $this->data['addthis_text']=$that->language->get('addthis_text');
        $that->view->batchAssign($this->data);
        $that->processTemplate('embed/head.post.tpl');
    }
}