<?php
/* SQL */
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelSeoPackGoogleSitemapXmlSeoPackGoogleSitemapXml extends Model
{
    public function getProductData($path)
    {
        $sql =  "SELECT p.product_id AS product_id,  p.date_modified AS date_modified FROM " . DB_PREFIX . "products p
				LEFT JOIN " . DB_PREFIX . "products_to_stores p2s ON (p.product_id = p2s.product_id)";
        $sql .= " WHERE p.status = '1'
									AND p.date_available <= NOW()
									AND p2s.store_id = '" . (int)$this->config->get('config_store_id') . "'";


        $sql .= " ORDER BY p.date_modified DESC";

    /*if ((int)$limit > 0){
    $sql .= " LIMIT 0," . (int)$limit;}*/

    $query = $this->db->query($sql);
        $product_data = $query->rows;
        return $product_data;
    }




    public function getCategories($parent_id = 0, $limit=0)
    {
        $language_id = (int)$this->config->get('storefront_language_id');
        $cache_name = 'category.list.'. $parent_id.'.'.$limit;
        //$cache = $this->cache->get($cache_name, $language_id, (int)$this->config->get('config_store_id'));
        if (is_null($cache)) {
            $query = $this->db->query("SELECT c.category_id AS category_id, c.parent_id AS parent_id
										FROM " . DB_PREFIX . "categories c
										LEFT JOIN " . DB_PREFIX . "categories_to_stores c2s ON (c.category_id = c2s.category_id)
										WHERE ".($parent_id<0 ? "" : "c.parent_id = '" . (int)$parent_id . "' AND ")."
										     c2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND c.status = '1'
										ORDER BY c.sort_order
										".((int)$limit ? "LIMIT ".(int)$limit : '')."										");
            $cache =  $query->rows;
            //$this->cache->set($cache_name, $cache, $language_id, (int)$this->config->get('config_store_id'));
        }
        return $cache;
    }



    public function getCollections()
    {
        $language_id = (int)$this->config->get('storefront_language_id');
        $cache_name = 'collections.list.'.$limit;
        $cache = $this->cache->get($cache_name, $language_id, (int)$this->config->get('config_store_id'));
        if (!$cache) {
            $col = $this->db->query("show tables like '".DB_PREFIX."collections'");
            if (empty($col->num_rows)) {// not exist
                $collections = [];
            } else {
                $sql = "SELECT * FROM " . DB_PREFIX . "collections";
                $sql .= " WHERE ";
                            $sql .= " store_id = '" . (int)$this->config->get('config_store_id') . "'
                                            AND status = 1
                        ORDER BY LCASE(name) ASC";

                $query = $this->db->query($sql);
                $collections = $query->rows;
            }
            
            $this->cache->set($cache_name, $cache, $language_id, (int)$this->config->get('config_store_id'));
        }
        return $collections;
    }


    public function getManufacturers()
    {
        $manufacturer = $this->cache->get('manufacturer', '', (int)$this->config->get('config_store_id'));
        if (!$manufacturer) {
            $query = $this->db->query("SELECT *
										FROM " . DB_PREFIX . "manufacturers m
										LEFT JOIN " . DB_PREFIX . "manufacturers_to_stores m2s ON (m.manufacturer_id = m2s.manufacturer_id)
										WHERE m2s.store_id = '" . (int)$this->config->get('config_store_id') . "'
										ORDER BY sort_order, LCASE(m.name) ASC");
            $manufacturer = $query->rows;
            //$this->cache->set('manufacturer', $manufacturer, '', (int)$this->config->get('config_store_id'));
        }
        return $manufacturer;
    }


    public function getContents()
    {
        $output = $this->cache->get('contents', $this->config->get('storefront_language_id'), $this->config->get('config_store_id'));
        if (is_null($output)) {
            $sql = "SELECT i.*, id.*
					FROM " . DB_PREFIX . "contents i
					LEFT JOIN " . DB_PREFIX . "content_descriptions id
							ON (i.content_id = id.content_id
									AND id.language_id = '" . (int)$this->config->get('storefront_language_id') . "')";

            if ((int)$this->config->get('config_store_id')) {
                $sql .=    "LEFT JOIN " . DB_PREFIX . "contents_to_stores i2s ON (i.content_id = i2s.content_id)";
            }

            $sql .=    "WHERE i.status = '1' ";

            if ((int)$this->config->get('config_store_id')) {
                $sql .= " AND i2s.store_id = '" . (int)$this->config->get('config_store_id') . "'";
            }

            $sql .= "ORDER BY i.parent_content_id, i.sort_order, LCASE(id.title) ASC";
            $query = $this->db->query($sql);

            if ($query->num_rows) {
                foreach ($query->rows as $row) {
                    $output[] = $row;
                }
            }
            //$this->cache->set('contents',$output, $this->config->get('storefront_language_id'), $this->config->get('config_store_id') );
        }
        return (array)$output;
    }
}
