<?php

/* Hooks */
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ExtensionSeoPack extends Extension
{
    public $data = array();

    public function __construct()
    {
        $this->registry = Registry::getInstance();
    }

    public function getIcon_twitter($iconUri)
    {
        //$this->baseObject->log->write(print_r($iconUri, true).' $iconUri');
        if (is_numeric($iconUri)) {
            $resource = new AResource('image');
            $image_data = $resource->getResource($iconUri);
            $img_sub_path = $image_data['type_name'].'/'.$image_data['resource_path'];
            $r = [];
            //$this->baseObject->log->write(print_r($image_data, true).' $image_data');
            if (is_file(DIR_RESOURCE.$img_sub_path)) {
                $r['image'] = $img_sub_path;
                $logo_path = DIR_RESOURCE.$img_sub_path;
                //get logo image dimensions
                $info = get_image_size($logo_path);
                $r['image_width'] = $info['width'];
                $r['image_height'] = $info['height'];
            } else {
                //html
                $r['image'] = $image_data['resource_code'];
            }
            return $r['image'];
        } else {
            return $iconUri;
        }
    }

    public function onControllerCommonListingGrid_InitData()
    {
        $this->baseObject->loadLanguage('seo_pack/seo_pack');

        $data = &$this->baseObject->data;
        if (version_compare(VERSION, '1.2.16') >= 0) {
            if ('product_grid' == $data['table_id']) {
                $data['actions']['dropdown']['children']['seo'] = array(
                  'text' => $this->baseObject->language->get('entry_admin_seo_tab_name'),
                  'href' => $this->baseObject->html->getSecureURL('catalog/product_seo_pack', '&product_id=%ID%'), );
            }
            if ('category_grid' == $data['table_id']) {
                $data['actions']['dropdown']['children']['seo'] = array(
                  'text' => $this->baseObject->language->get('entry_admin_seo_tab_name'),
                  'href' => $this->baseObject->html->getSecureURL('catalog/category_seo_pack', '&category_id=%ID%'), );
            }
        } else {
            if ('product_grid' == $data['table_id']) {
                $data['actions']['edit']['children']['seo'] = array(
                  'text' => $this->baseObject->language->get('entry_admin_seo_tab_name'),
                  'href' => $this->baseObject->html->getSecureURL('catalog/product_seo_pack', '&product_id=%ID%'), );
            }
            if ('category_grid' == $data['table_id']) {
                $data['actions']['edit']['children']['seo'] = array(
                  'text' => $this->baseObject->language->get('entry_admin_seo_tab_name'),
                  'href' => $this->baseObject->html->getSecureURL('catalog/category_seo_pack', '&category_id=%ID%'), );
            }
        }
    }

    public function onControllerPagesCatalogProductTabs_InitData()
    {
        $this->baseObject->loadLanguage('seo_pack/seo_pack');

        $view = new AView(Registry::getInstance(), 0);
        $view->batchAssign($data);
        $this->baseObject->view->addHookVar('extension_tabs', $view->fetch('pages/extension/tabs_seo.tpl'));
        //$this->baseObject->view->assign('seo_text', html_entity_decode($this->baseObject->language->get('entry_required_extra')));
    }

    public function onControllerPagesCatalogCategoryTabs_InitData()
    {
        $this->baseObject->loadLanguage('seo_pack/seo_pack');
        $this->baseObject->data['category_id'] = $this->baseObject->request->get['category_id'];
        $view = new AView(Registry::getInstance(), 0);
        $view->batchAssign($data);
        $this->baseObject->view->addHookVar('extension_tabs', $view->fetch('pages/extension/tabs_seo_category.tpl'));
        //$this->baseObject->view->assign('seo_text', html_entity_decode($this->baseObject->language->get('entry_required_extra')));
    }

    public function onControllerPagesCatalogCollectionTabs_InitData()
    {
        $this->baseObject->loadLanguage('seo_pack/seo_pack');
        $this->baseObject->data['id'] = $this->baseObject->request->get['id'];
        $view = new AView(Registry::getInstance(), 0);
        $view->batchAssign($data);
        $this->baseObject->view->addHookVar('extension_tabs', $view->fetch('pages/extension/tabs_seo_collection.tpl'));
        //$this->baseObject->view->assign('seo_text', html_entity_decode($this->baseObject->language->get('entry_required_extra')));
    }

    public function onControllerPagesCatalogProductTabs_UpdateData()
    {
        $that = &$this->baseObject;
        $active = $that->data['tabs_seo'] ? true : false;
        $tabs = array(
                array(
                    'href' => $that->html->getSecureURL(
                        'catalog/product_seo_pack',
                        '&product_id='.$that->request->get['product_id'].
                        ''
                    ),
                    'text' => $that->language->get('entry_admin_seo_tab_name'),
                    'active' => $active,
                ),
        );
        $view = new AView($this->registry, 0);
        $view->batchAssign(array('tabs' => $tabs));
        //$that->view->addHookVar('extension_tabs', $view->fetch('pages/extension/tabs_seo.tpl'));
    }

    public function onControllerPagesCatalogCategoryTabs_UpdateData()
    {
        $that = &$this->baseObject;
        $active = $that->data['tabs_seo'] ? true : false;
        $tabs = array(
                array(
                    'href' => $that->html->getSecureURL(
                        'catalog/category_seo_pack',
                        '&category_id='.$that->request->get['category_id'].
                        ''
                    ),
                    'text' => $that->language->get('entry_admin_seo_tab_name'),
                    'active' => $active,
                ),
        );
        $view = new AView($this->registry, 0);
        $view->batchAssign(array('tabs' => $tabs));
        //$that->view->addHookVar('extension_tabs', $view->fetch('pages/extension/tabs_seo.tpl'));
    }

    public function onControllerPagesCatalogCollectionTabs_UpdateData()
    {
        $that = &$this->baseObject;
        $active = $that->data['tabs_seo'] ? true : false;
        $tabs = array(
                array(
                    'href' => $that->html->getSecureURL(
                        'catalog/collection_seo_pack',
                        '&id='.$that->request->get['id'].
                        ''
                    ),
                    'text' => $that->language->get('entry_admin_seo_tab_name'),
                    'active' => $active,
                ),
        );
        $view = new AView($this->registry, 0);
        $view->batchAssign(array('tabs' => $tabs));
        //$that->view->addHookVar('extension_tabs', $view->fetch('pages/extension/tabs_seo.tpl'));
    }

    public function Lmodel($product_id)
    {
        $this->baseObject->load->model('seo_pack/product');
        $seo_meta = $this->baseObject->model_seo_pack_product->getProductSeo($product_id);

        return $seo_meta;
    }

    public function Lcategory($category_id)
    {
        $this->baseObject->load->model('seo_pack/category');
        $category_seo = $this->baseObject->model_seo_pack_category->getCategorySeo($category_id);

        return $category_seo;
    }

    public function Lcollection($collection_id)
    {
        $this->baseObject->load->model('seo_pack/collection');
        $collection_seo = $this->baseObject->model_seo_pack_collection->getCollectionSeo($collection_id);
        //$this->baseObject->log->write(print_r($collection_seo, true).' Lcollection');
        return $collection_seo;
    }

    /*  public function onControllerCommonHead_UpdateData()
      {

          $product_id = $this->baseObject->request->get['product_id'];
          if(empty($product_id)){//cart revert
          $product_id = $this->baseObject->request->get['key'];}
          if ($product_id > 0){

              $seo_meta =	$this->Lmodel($product_id);
                  if(strlen($seo_meta['seo_title'])>1){
                  $this->baseObject->view->assign('title', html_entity_decode($seo_meta['seo_title']));
                      }


              }

          else {
              if (isset($this->baseObject->request->get['path'])) {
              $path = explode('_', $this->baseObject->request->get['path']);
              $category_id = end($path);	}

              if(empty($category_id)){
              $category_id = $this->baseObject->request->get['category_id']; }

              if ($category_id > 0)
                  {

                  $category_seo = $this->Lcategory($category_id);
                  if(strlen($category_seo['seo_title'])>1){$this->baseObject->view->assign('title', html_entity_decode ($category_seo['seo_title'])); }
                  }
           }




      }*/

    public function onControllerPagesProductProduct_UpdateData()
    {
        $product_id = $this->baseObject->request->get['product_id'];
        if (empty($product_id)) {//cart revert
            $product_id = $this->baseObject->request->get['key'];
        }
        if ($product_id > 0) {
            $seo_meta = $this->Lmodel($product_id);
            if (strlen($seo_meta['seo_h1']) > 1) {
                $this->baseObject->view->assign('heading_title', html_entity_decode($seo_meta['seo_h1']));
            }
        }

        //breadcrumb

        //$this->baseObject->log->write('product catched');
        if ('1' == $this->baseObject->config->get('product_breadcrumb_status') and ('1' == $this->baseObject->config->get('product_breadcrumb_mode') or '2' == $this->baseObject->config->get('product_breadcrumb_mode')) or '0' == $this->baseObject->config->get('product_breadcrumb_mode')) {
            $view = new AView($this->registry, 0);
            // get all data from the Controller
            $data = $this->baseObject->view->getData();
            //$data = $this->superclass($data);
            $product_id = (int) $data['product_id'];
            //reset breadcrumb and add initial
            $depth = 0;
            $this->baseObject->document->resetBreadcrumbs();
            //'separator' => $this->baseObject->language->get('text_separator')
            if ('1' == $this->baseObject->config->get('product_breadcrumb_home')) {
                if ('1' == $this->baseObject->config->get('product_breadcrumb_sitename')) {
                    $this->baseObject->document->addBreadcrumb(array(
                                'href' => $this->baseObject->html->getHomeURL(),
                                'text' => $this->baseObject->config->get('store_name'),
                                'separator' => false,
                        ));
                } else {
                    $this->baseObject->document->addBreadcrumb(array(
                              'href' => $this->baseObject->html->getHomeURL(),
                              'text' => $this->baseObject->language->get('text_home'),
                              'separator' => false,
                      ));
                    ++$depth;
                }
            }
            //get brand
            if ('1' == $this->baseObject->config->get('product_breadcrumb_brand') and (int) $data['product_info']['manufacturer_id'] > 0) {
                //if brand exist and enabled
                //$this->loadModel('catalog/manufacturer');
                $this->baseObject->document->addBreadcrumb(array(
                                'href' => $this->baseObject->html->getSEOURL('product/manufacturer', '&manufacturer_id='.(int) $data['product_info']['manufacturer_id'], '&encode'),
                                'text' => $data['product_info']['manufacturer'],
                                'separator' => $this->baseObject->language->get('text_separator'),
                        ));
                ++$depth;
            }

            //get all category trails for product
            $cats = $this->getclass((int) $product_id);
            //$this->baseObject->log->write(print_r($cats, true).' get all category trails');

            //if product_breadcrumb_mode 1 find one largest path
            if (('1' == $this->baseObject->config->get('product_breadcrumb_mode') or '2' == $this->baseObject->config->get('product_breadcrumb_mode')) and is_array($cats)) {
                if (count($cats) > 1) {
                    if ('1' == $this->baseObject->config->get('product_breadcrumb_mode')) {
                        $needlecount = 0;
                        foreach ($cats as $result) {
                            //$product_category_data[] = $result['category_id'];
                            $newneedle = substr_count($result['fulltrail'], '>');
                            if ($newneedle > $needlecount) {
                                $needlecount = $newneedle;
                                $searched_id = $result['id'];
                            }
                        }
                        //$this->baseObject->log->write(print_r($searched_id, true).' $searched_id');
                        //pase id fulltrail
                        $cats_ids_list = explode('>', $cats[$searched_id]['fulltrail']);
                    //$this->baseObject->log->write(print_r($cats_ids_list, true).' $cats_ids_list');
                    } else {
                        foreach ($cats as $result) {
                            $cats_ids_list[$result['id']] = explode('>', $result['fulltrail']);
                        }
                        //$this->baseObject->log->write(print_r($cats_ids_list, true).' $cats_ids_list arrays');
                    }

                    if ('1' == $this->baseObject->config->get('product_breadcrumb_mode')) {
                        $limic = 0;
                        foreach ($cats_ids_list as $breadcrumbsitem) {
                            if ($limic == (int) $this->baseObject->config->get('product_breadcrumb_depth')) {
                                break;
                            }
                            $category_info = $this->baseObject->model_catalog_category->getCategory((int) $breadcrumbsitem);
                            $this->baseObject->document->addBreadcrumb(array(
                              'href' => $this->baseObject->html->getSEOURL('product/category', '&path='.(int) $breadcrumbsitem, '&encode'),
                              'text' => $category_info['name'],
                              'separator' => $this->baseObject->language->get('text_separator')
                          ));
                            ++$limic;
                        }
                    } else { //show all trails //if product_breadcrumb_mode 21 display all paths
                        if ('2' == $this->baseObject->config->get('product_breadcrumb_mode')) {
                            foreach ($cats_ids_list as $breadcrumbkey => $arrayvalue) { //separate one by one
                                //$this->baseObject->log->write(print_r($breadcrumbkey, true).' $breadcrumb arrays');
                                //$this->baseObject->log->write(print_r($arrayvalue, true).' new breadcrumb start');

                                foreach ($arrayvalue as $breadcrumbsitem) {
                                    //$this->baseObject->log->write(print_r($breadcrumbsitem, true).' $breadcrumbsitem ');
                                    $newbreadcrumb[] = $breadcrumbsitem;

                                    //$idsdone = array('0' => 0); //conslidation to one breadcrumb and remove duplicates!

                                    $idsdone['empty'] = array('0' => '0');
                                    if (!array_key_exists((int) $breadcrumbsitem, $idsdone)) {
                                        //if(!array_key_exists((int)$breadcrumbsitem, $cats_ids_list)) {
                                        $category_info = $this->baseObject->model_catalog_category->getCategory((int) $breadcrumbsitem);
                                        $this->baseObject->document->addBreadcrumb(array(
                                        'href' => $this->baseObject->html->getSEOURL('product/category', '&path='.(int) $breadcrumbsitem, '&encode'),
                                        'text' => $category_info['name'],
                                        'separator' => $this->baseObject->language->get('text_separator')
                                    ));

                                        $idsdone[(int) $breadcrumbsitem] = (int) $breadcrumbsitem;
                                    }

                                    //}
                                  //$this->baseObject->log->write(print_r($idsdone, true).' $idsdone ');
                                  //$this->baseObject->log->write(print_r(count($idsdone), true).' count$idsdone ');
                                }
                                if ((count($idsdone)) == (int) $this->baseObject->config->get('product_breadcrumb_depth')) {
                                    break;
                                }
                            }
                            //$this->baseObject->log->write(print_r(count($newbreadcrumb), true).' $newbreadcrumb ');
                            //put in controller new $data['products'] array
                            $this->baseObject->view->assign('newbreadcrumb', $newbreadcrumb);
                        }
                    }
                } else {
                    reset($cats);
                    $first_key = key($cats);
                    $cats_ids_list = explode('>', $cats[$first_key]['fulltrail']);
                    foreach ($cats_ids_list as $breadcrumbsitem) {
                        $category_info = $this->baseObject->model_catalog_category->getCategory((int) $breadcrumbsitem);
                        $this->baseObject->document->addBreadcrumb(array(
                              'href' => $this->baseObject->html->getSEOURL('product/category', '&path='.(int) $breadcrumbsitem, '&encode'),
                              'text' => $category_info['name'],
                              'separator' => $this->baseObject->language->get('text_separator')
                          ));
                    }
                }
            }

            // add last breadcrumb item
            if ('1' == $this->baseObject->config->get('product_breadcrumb_product')) {
                $this->baseObject->document->addBreadcrumb(array(
                  'href' => $this->baseObject->html->getSEOURL('product/product', $url.'&product_id='.$product_id, '&encode'),
                  'text' => $data['product_info']['name'],
                  'separator' => $this->baseObject->language->get('text_separator')
              ));
            }
        }
        //breadcrumb end
    }

    public function onControllerPagesProductCategory_UpdateData()
    {
        if (isset($this->baseObject->request->get['path'])) {
            $path = explode('_', $this->baseObject->request->get['path']);
            $category_id = end($path);
        }

        if (empty($category_id)) {
            $category_id = $this->baseObject->request->get['category_id'];
        }

        if ($category_id > 0) {
            $category_seo = $this->Lcategory($category_id);
            if (strlen($category_seo['seo_h1']) > 1) {
                $this->baseObject->view->assign('heading_title', html_entity_decode($category_seo['seo_h1']));
            }
        }
    }


    public function onControllerPagesProductCollection_UpdateData()
    {
        if (empty($collection_id)) {
            $collection_id = $this->baseObject->request->get['collection_id'];
        }

        if ($collection_id > 0) {
            $collection_seo = $this->Lcollection($collection_id);
            if (strlen($collection_seo['seo_h1']) > 1) {
                //$this->baseObject->log->write(print_r($collection_seo, true).' $collection_seo');
                $this->baseObject->view->assign('heading_title', html_entity_decode($collection_seo['seo_h1']));
            }
            if (strlen($collection_seo['seo_title']) > 1) {
                $this->baseObject->view->assign('title', html_entity_decode($collection_seo['seo_title']));
            }
        }
    }

    //TWITTER FUNCTIONS
    //////////start strip tags
    //To remove all the hidden text not displayed on a webpage
    public function strip_html_tagstwit($str)
    {
        $str = preg_replace('/(<|>)\1{2}/is', '', $str);
        $str = preg_replace(
            array(// Remove invisible content
                              '@<head[^>]*?>.*?</head>@siu',
                              '@<style[^>]*?>.*?</style>@siu',
                              '@<script[^>]*?.*?</script>@siu',
                              '@<noscript[^>]*?.*?</noscript>@siu',
                              ),
            '', //replace above with nothing
                          $str
        );
        $str = $this->replaceWhitespaceTwit($str);
        $str = strip_tags($str);

        return $str;
    }

    //function strip_html_tagstwit ENDS

    //To replace all types of whitespace with a single space
    public function replaceWhitespaceTwit($str)
    {
        $result = $str;
        foreach (array(
                      '  ', " \t",  " \r",  " \n",
                      "\t\t", "\t ", "\t\r", "\t\n",
                      "\r\r", "\r ", "\r\t", "\r\n",
                      "\n\n", "\n ", "\n\t", "\n\r",
                      ) as $replacement) {
            $result = str_replace($replacement, $replacement[0], $result);
        }

        return $str !== $result ? $this->replaceWhitespaceTwit($result) : $result;
    }

    //TWITTER END

    //facebook
    //////////start strip tags
    //To remove all the hidden text not displayed on a webpage
    public function strip_html_tags($str)
    {
        $str = preg_replace('/(<|>)\1{2}/is', '', $str);
        $str = preg_replace(
            array(// Remove invisible content
                          '@<head[^>]*?>.*?</head>@siu',
                          '@<style[^>]*?>.*?</style>@siu',
                          '@<script[^>]*?.*?</script>@siu',
                          '@<noscript[^>]*?.*?</noscript>@siu',
                          ),
            '', //replace above with nothing
                      $str
        );
        $str = $this->replaceWhitespace($str);
        $str = strip_tags($str);

        return $str;
    }

    //function strip_html_tags ENDS

    //To replace all types of whitespace with a single space
    public function replaceWhitespace($str)
    {
        $result = $str;
        foreach (array(
                  '  ', " \t",  " \r",  " \n",
                  "\t\t", "\t ", "\t\r", "\t\n",
                  "\r\r", "\r ", "\r\t", "\r\n",
                  "\n\n", "\n ", "\n\t", "\n\r",
                  ) as $replacement) {
            $result = str_replace($replacement, $replacement[0], $result);
        }

        return $str !== $result ? $this->replaceWhitespace($result) : $result;
    }

    ///////////////end

    public function rewriteseo($link)
    { // clon
        if ($this->baseObject->config->get('enable_seo_url')) {
            $url_data = parse_url(str_replace('&amp;', '&', $link));

            $url = '';
            $data = array();
            parse_str($url_data['query'], $data);

            foreach ($data as $key => $value) {
                if (('product_id' == $key) || ('manufacturer_id' == $key) || ('content_id' == $key)) {
                    $query = $this->baseObject->db->query('SELECT *
      											   FROM '.DB_PREFIX."url_aliases
      											   WHERE `query` = '".$this->baseObject->db->escape($key.'='.(int) $value)."'
      											   	AND language_id='".(int) $this->baseObject->config->get('storefront_language_id')."'");

                    if ($query->num_rows) {
                        $url .= '/'.$query->row['keyword'];
                        unset($data[$key]);
                    }
                } elseif ('path' == $key || 'category_id' == $key) {
                    if ('path' == $key) {
                        $value = explode('_', $value);
                        end($value);
                        $value = current($value);
                    }

                    $sql = 'SELECT *
      								FROM '.DB_PREFIX."url_aliases
      								WHERE `query` = 'category_id=".$this->baseObject->db->escape($value)."'
      									AND language_id='".(int) $this->baseObject->config->get('storefront_language_id')."'";

                    $query = $this->baseObject->db->query($sql);
                    if ($query->num_rows) {
                        $url .= '/'.$query->row['keyword'];
                    }

                    unset($data[$key]);
                }
            }

            if ($url) {
                unset($data['rt']);

                $query = '';

                if ($data) {
                    foreach ($data as $key => $value) {
                        $query .= '&'.$key.'='.$value;
                    }

                    if ($query) {
                        $query = '?'.trim($query, '&');
                    }
                }

                return $url_data['scheme'].'://'.$url_data['host'].(isset($url_data['port']) ? ':'.$url_data['port'] : '').str_replace('/index.php', '', $url_data['path']).$url.$query;
            } else {
                return $link;
            }
        } else {
            return $link;
        }
    }

    public function onControllerCommonHead_UpdateData()
    {
        $request = $this->baseObject->request->get;
        //init controller data
        $this->baseObject->extensions->hk_InitData($this, __FUNCTION__);

        if (version_compare(VERSION, '1.3.0') >= 0) {
            $twitter_meta_tags_image = $this->getIcon_twitter($this->baseObject->config->get('twitter_meta_tags_image'));
            $fb_image_common = $this->getIcon_twitter($this->baseObject->config->get('facebook_meta_image'));
        } else {// 1216
            $twitter_meta_tags_image = $this->baseObject->config->get('twitter_meta_tags_image');
            $fb_image_common = $this->baseObject->config->get('facebook_meta_image');
        }

        $this->baseObject->view->assign('twitter_meta_tags_image', $twitter_meta_tags_image);
        $this->baseObject->view->assign('fb_image_common', $fb_image_common);


        if ($_SERVER['HTTPS']) {
            $protocol = 'https:';
        } else {
            $protocol = 'http:';
        } //1.2.8 fix
        $product_id = $request['product_id'];
        if (empty($product_id)) {//cart revert
            $product_id = $request['key'];
        }
        $collection_id = (int)$request['collection_id'];
        if ($product_id > 0) {
            $seo_meta = $this->Lmodel($product_id);
            if (strlen($seo_meta['seo_title']) > 1) {
                $this->baseObject->view->assign('title', html_entity_decode($seo_meta['seo_title']));
            }
        } elseif ($collection_id > 0) {
            $collection_seo = $this->Lcollection($collection_id);
            if (strlen($collection_seo['seo_title']) > 1) {
                $this->baseObject->view->assign('title', html_entity_decode($collection_seo['seo_title']));
            }
        } else {
            if (isset($request['path'])) {
                $path = explode('_', $request['path']);
                $category_id = end($path);
            }

            if (empty($category_id)) {
                $category_id = $request['category_id'];
            }

            if ($category_id > 0) {
                $category_seo = $this->Lcategory($category_id);
                if (strlen($category_seo['seo_title']) > 1) {
                    $this->baseObject->view->assign('title', html_entity_decode($category_seo['seo_title']));
                }
            }
        }
        if (isset($request['content_id'])) {
            $content_id = $request['content_id'];
        }
        /////

        if ($content_id > 0) {
            $this->baseObject->load->model('catalog/content');
            $content_info = $this->baseObject->model_catalog_content->getContent($content_id);
            if ($content_info) {
                if (mb_strlen($content_info['meta_description']) > 3) {
                    $fb_content_metadesc = $content_info['meta_description'];
                } else {
                    $fb_content_metadesc = $content_info['content'];
                }
            }
            $this->baseObject->view->assign('fb_content_metadesc', $fb_content_metadesc);
        }

        ////////////facebook
        //	$product_id = $this->baseObject->request->get['product_id'];
        //	if(empty($product_id)){//cart revert
        //$product_id = $this->baseObject->request->get['key'];}

        //  $category_id = $this->baseObject->request->get['category_id'];

        if (isset($this->baseObject->request->get['path'])) {
            $path = explode('_', $this->baseObject->request->get['path']);
            $category_id = end($path);
        }
        if (empty($category_id)) {
            $category_id = $this->baseObject->request->get['category_id'];
        }
        if (($category_id > 0) and $this->baseObject->config->get('facebook_meta_cat_image')) {
            $this->baseObject->load->model('catalog/category');
            $resource = new AResource('image');
            $cat_image = $resource->getMainThumb(
                'categories',
                $category_id,
                $this->baseObject->config->get('config_image_thumb_width'),
                $this->baseObject->config->get('config_image_thumb_height'),
                true
            );
            // echo $root_image['thumb_url'];
            if (false !== strpos($cat_image['thumb_url'], 'http://')) {
                $image_url = $cat_image['thumb_url'];
            } else {
                $image_url = $protocol.$cat_image['thumb_url'];
            }
            $fb_image_cat = $image_url;
            $fb_image_width_cat = $this->baseObject->config->get('config_image_thumb_width');
            $fb_image_height_cat = $this->baseObject->config->get('config_image_thumb_height');
            $category_info = $this->baseObject->model_catalog_category->getCategory($category_id);
            if (mb_strlen($category_info['meta_description']) > 3) {
                $fb_cat_metadesc = $category_info['meta_description'];
            } else {
                $fb_cat_metadesc = $category_info['description']; //html_entity_decode($category_info['description'], ENT_QUOTES, 'UTF-8');
            }

            $this->baseObject->view->assign('fb_image_cat', $fb_image_cat);
            $this->baseObject->view->assign('fb_image_width_cat', $fb_image_width_cat);
            $this->baseObject->view->assign('fb_image_height_cat', $fb_image_height_cat);
            $this->baseObject->view->assign('fb_cat_metadesc', $fb_cat_metadesc);
        }

        if ('1' == $this->baseObject->config->get('facebook_meta_tags_locale')) {
            //$fb_locale = $this->baseObject->language->getLanguageCode(); // en
            //$fb_locale = $this->baseObject->language->getLanguageID(); // 2
            $fb_locale = $this->baseObject->language->getLanguageDetailsByID($this->baseObject->language->getLanguageID());
            // [locale] [locale] => es_ES.UTF-8,es_ES,spanish   https://regex101.com/r/kO6jL4/1
            $re = '/[a-z]*_[A-Z]*/u';
            $str = $fb_locale['locale'];
            preg_match($re, $str, $matches);
            //echo $matches[0];
            $this->baseObject->view->assign('fb_locale', strip_tags($matches[0]));
        }

        if ((int) $product_id > 0) {
            //https://developers.facebook.com/docs/reference/opengraph/object-type/product.item/
            $this->baseObject->load->model('catalog/product');
            $resource = new AResource('image');
            ////////
            // main product image
            $sizes = array(
                'main' => array(
                    'width' => $this->baseObject->config->get('config_image_popup_width'),
                    'height' => $this->baseObject->config->get('config_image_popup_height'),
                ),
                'thumb' => array(
                    'width' => $this->baseObject->config->get('config_image_thumb_width'),
                    'height' => $this->baseObject->config->get('config_image_thumb_height'),
                ),
            );
            $data['image_main'] = $resource->getResourceAllObjects('products', $product_id, $sizes, 1, false);
            if ($data['image_main']) {
                $data['image_main']['sizes'] = $sizes;
                $image_url = $data['image_main']['main_url'];
                $thumb_url = $data['image_main']['thumb_url'];
                //$this->baseObject->log->write(print_r($data, true).' $data');
            }
            ////////

            // echo $image_url;
            if (false !== strpos($image_url, 'http')) {
                $image_url_product = $image_url;
            } else {
                $image_url_product = $protocol.$image_url;
            }
            if ($this->baseObject->config->get('config_retina_enable')) {
                $fb_image = pathinfo($image_url_product)['dirname'].DIRECTORY_SEPARATOR.pathinfo($image_url_product)['filename'].'@2x.'.pathinfo($image_url_product)['extension'];
                $fb_image_width = (int) $this->baseObject->config->get('config_image_popup_width') * 2;
                $fb_image_height = (int) $this->baseObject->config->get('config_image_popup_width') * 2;
            } else {
                $fb_image = $image_url_product;
                $fb_image_width = $this->baseObject->config->get('config_image_popup_width');
                $fb_image_height = $this->baseObject->config->get('config_image_popup_width');
            }

            ///
            //$fb_image = $image_url;
            $product_info = $this->baseObject->model_catalog_product->getProduct($product_id);
            $fb_desc = html_entity_decode($product_info['description'], ENT_QUOTES, 'UTF-8');
            $fb_desc = str_replace('"', '', $fb_desc);
            $fb_title = html_entity_decode($product_info['name'], ENT_QUOTES, 'UTF-8');
            $fb_title = str_replace('"', '', $fb_title);
            //$fb_price = $product_info['price'];
            if (mb_strlen($data['title']) > 1) {
                $fb_image_alt = strip_tags($data['title']);
            } else {
                $fb_image_alt = $fb_title;
            }

            if ('1' == $this->baseObject->config->get('facebook_meta_tags_price_status') or '1' == $this->baseObject->config->get('facebook_meta_tags_pricecodesale')) {
                $product_info_all = $this->baseObject->model_catalog_product->getProductsAllInfo(array($product_id));
            }

            if ('1' == $this->baseObject->config->get('facebook_meta_tags_price_status')) {
                //$product_info_all = $this->baseObject->model_catalog_product->getProductsAllInfo(array($product_id));
                if ($product_info_all[$product_id]['special']) {
                    //$special_price = $this->baseObject->currency->format($this->baseObject->tax->calculate($product_info_all[$product_id]['special'], $result['tax_class_id'], $this->baseObject->config->get('config_tax')));
                    $special_price = $this->baseObject->currency->format($product_info_all[$product_id]['special']);
                    $fb_price = $special_price;
                    $fb_sale_text = $this->baseObject->config->get('facebook_meta_tags_price_sale');
                    $this->baseObject->view->assign('fb_sale_text', htmlentities($fb_sale_text));
                } else {
                    $fb_price = $this->baseObject->currency->format($product_info['price']); //$21.00
          //$fb_price = $this->baseObject->currency->format_number($product_info['price']); //21.00
                }
            }

            if ('1' == $this->baseObject->config->get('facebook_meta_tags_pricecode')) {
                $fb_price_amount = $this->baseObject->currency->format_number($product_info['price']); //21.00
                $fb_price_currency = $this->baseObject->currency->getCurrency();
                $this->baseObject->view->assign('fb_price_amount', strip_tags($fb_price_amount));
                $this->baseObject->view->assign('fb_price_currency', strip_tags($fb_price_currency['code']));

                if ('1' == $this->baseObject->config->get('facebook_meta_tags_pricecodesale')) {
                    $fb_sale_price_amount = $product_info_all[$product_id]['special'];
                    $this->baseObject->view->assign('fb_sale_price_amount', strip_tags($fb_sale_price_amount));
                }
            }

            //$this->loadModel('tool/seo_url');
            //$fb_url = $this-> baseObject->html-> getSecureURL('product/product', '&product_id=' . $product_id, '&encode');

            if ('1' == $this->baseObject->config->get('facebook_meta_tags_og_url')) {
                $fb_url = $this->rewriteseo($this->baseObject->html->getURL('product/product', '&product_id='.$product_id, '&encode'));
            }

            // if product
            $this->baseObject->view->assign('fb_og_type_products', 'product');

            $this->baseObject->view->assign('fb_image', $fb_image);
            $this->baseObject->view->assign('fb_image_width', $fb_image_width);
            $this->baseObject->view->assign('fb_image_height', $fb_image_height);
            // strip_html_tags   replaceWhitespace  and try htmlentities() to convert "<" to "&lt" and > to "&gt"
            $strip1 = $this->strip_html_tags($fb_desc);

            $strip2 = strip_tags($strip1);
            $strip3 = htmlentities($strip2);

            $this->baseObject->view->assign('fb_desc', $strip3);
            $this->baseObject->view->assign('fb_price', strip_tags($fb_price));
            $this->baseObject->view->assign('fb_image_alt', strip_tags($fb_image_alt));

            //$this->baseObject->view->assign('fb_price_sp',($fb_price_sp));
            $this->baseObject->view->assign('fb_title', strip_tags($fb_title));
            $this->baseObject->view->assign('fb_url', $fb_url);

            if ('1' == $this->baseObject->config->get('facebook_meta_tags_brand')) {
                //$this->baseObject->log->write(print_r($product_info, true).' $product_info');
                $this->baseObject->load->model('catalog/manufacturer');
                $manufacturer_info = $this->baseObject->model_catalog_manufacturer->getManufacturer($product_info['manufacturer_id']);
                $fb_brand = $manufacturer_info['name'];
                $this->baseObject->view->assign('fb_brand', $fb_brand);
            }
        }

        //TWITTER
        //PART OF CODE USE FB

        if (0 == $this->baseObject->config->get('twitter_meta_tags_card_type')) {
            $twitter_meta_tags_card_type = 'summary';
            /*$twitter_image_width_cat = $this->baseObject->config->get('config_image_category_width');
            $twitter_image_height_cat = $this->baseObject->config->get('config_image_category_height');
            $twitter_image_width = $this->baseObject->config->get('config_image_category_width');
            $twitter_image_height = $this->baseObject->config->get('config_image_category_height');*/
            $twitter_image_width_cat = 250;
            $twitter_image_height_cat = 250;
            $twitter_image_width = 250;
            $twitter_image_height = 250;
        } else {
            $twitter_meta_tags_card_type = 'summary_large_image';

            /*$twitter_image_width_cat = $this->baseObject->config->get('config_image_thumb_width');
            $twitter_image_height_cat = $this->baseObject->config->get('config_image_thumb_height');
            $twitter_image_width = $this->baseObject->config->get('config_image_thumb_width');
            $twitter_image_height = $this->baseObject->config->get('config_image_thumb_height');*/
            $twitter_image_width_cat = 504;
            $twitter_image_height_cat = 252;
            $twitter_image_width = 504;
            $twitter_image_height = 252;
        }
        $this->baseObject->view->assign('twitter_meta_tags_card_type', $twitter_meta_tags_card_type);

        if ('@' === substr($this->baseObject->config->get('twitter_meta_tags_username'), 0, 1)) {
            $twitter_meta_tags_username = $this->baseObject->config->get('twitter_meta_tags_username');
        } elseif (strlen($this->baseObject->config->get('twitter_meta_tags_username')) > 3) {
            $twitter_meta_tags_username = '@'.$this->baseObject->config->get('twitter_meta_tags_username');
        }
        $this->baseObject->view->assign('twitter_meta_tags_username', $twitter_meta_tags_username);

        if (empty($category_id)) {
            $category_id = $this->baseObject->request->get['category_id'];
        }
        if (($category_id > 0) and $this->baseObject->config->get('twitter_meta_tags_cat_image')) {
            $this->baseObject->load->model('catalog/category');
            $resource = new AResource('image');
            $cat_image = $resource->getMainThumb(
                'categories',
                $category_id,
                $this->baseObject->config->get('config_image_thumb_width'),
                $this->baseObject->config->get('config_image_thumb_height'),
                true
            );
            // echo $root_image['thumb_url'];
            if (false !== strpos($cat_image['thumb_url'], 'http://')) {
                $cat_image_url = $cat_image['thumb_url'];
            } else {
                $cat_image_url = $protocol.$cat_image['thumb_url'];
            }
            $twitter_image_cat = $cat_image_url;

            $this->baseObject->view->assign('twitter_image_cat', $twitter_image_cat);
            $this->baseObject->view->assign('twitter_image_width_cat', $twitter_image_width_cat);
            $this->baseObject->view->assign('twitter_image_height_cat', $twitter_image_height_cat);

            $category_info = $this->baseObject->model_catalog_category->getCategory($category_id);
            $twitter_meta_tags_desc = html_entity_decode($category_info['description'], ENT_QUOTES, 'UTF-8');
            $strip1 = $this->strip_html_tagstwit($twitter_meta_tags_desc);
            $strip2 = strip_tags($strip1);
            $strip3 = htmlentities($strip2);
            //  $strip3 = substr(htmlentities($strip2), 0, 210);

            $this->baseObject->view->assign('twitter_meta_tags_desc', $strip3);
            $this->baseObject->view->assign('twitter_title', strip_tags($category_info['name']));
        }

        if ($product_id > 0) {
            $this->baseObject->load->model('catalog/product');
            $resource = new AResource('image');
            $root_image = $resource->getMainThumb(
                'products',
                $product_id,
                $twitter_image_width,
                $twitter_image_height,
                true
            );
            // echo $root_image['thumb_url'];
            if (false !== strpos($root_image['thumb_url'], 'http://')) {
                $root_image_url = $root_image['thumb_url'];
            } else {
                $root_image_url = $protocol.$root_image['thumb_url'];
            }
            $twitter_image = $root_image_url;

            $product_info = $this->baseObject->model_catalog_product->getProduct($product_id);
            $twitter_meta_tags_desc = html_entity_decode($product_info['description'], ENT_QUOTES, 'UTF-8'); //Description of content (maximum 200 characters)  https://dev.twitter.com/cards/markup
            $twitter_title = html_entity_decode($product_info['name'], ENT_QUOTES, 'UTF-8');
            $twitter_price = $product_info['price'];

            if ('1' == $this->baseObject->config->get('twitter_meta_tags_price_status')) {
                $product_info_all = $this->baseObject->model_catalog_product->getProductsAllInfo(array($product_id));
                if ($product_info_all[$product_id]['special']) {
                    //$special_price = $this->baseObject->currency->format($this->baseObject->tax->calculate($product_info_all[$product_id]['special'], $result['tax_class_id'], $this->baseObject->config->get('config_tax')));
                    $special_price = $this->baseObject->currency->format($product_info_all[$product_id]['special']);
                    $twitter_price = $special_price;
                    $twitter_sale_text = $this->baseObject->config->get('twitter_meta_tags_price_sale');
                    $this->baseObject->view->assign('twitter_sale_text', htmlentities($twitter_sale_text));
                } else {
                    $twitter_price = $this->baseObject->currency->format($product_info['price']);
                }
            }

            //$this->loadModel('tool/seo_url');
            //$twitter_url = $this-> baseObject->html-> getSecureURL('product/product', '&product_id=' . $product_id, '&encode');

            $this->baseObject->view->assign('twitter_image', $twitter_image);
            //$this->baseObject->view->assign('twitter_image_width',$twitter_image_width);
            //$this->baseObject->view->assign('twitter_image_height',$twitter_image_height);
            // strip_html_tagstwit   replaceWhitespaceTwit  and try htmlentities() to convert "<" to "&lt" and > to "&gt"
            $strip1 = $this->strip_html_tagstwit($twitter_meta_tags_desc);
            $strip2 = strip_tags($strip1);
            $strip3 = htmlentities($strip2);
            //  $strip3 = substr(htmlentities($strip2), 0, 210);
            $this->baseObject->view->assign('twitter_meta_tags_desc', $strip3);
            $this->baseObject->view->assign('twitter_price', strip_tags($twitter_price));

            //$this->baseObject->view->assign('twitter_price_sp',($twitter_price_sp));
            $this->baseObject->view->assign('twitter_title', strip_tags($twitter_title));
        }
        if (empty($category_id) and empty($product_id)) {
            if ('1' == $this->baseObject->config->get('twitter_meta_tags_site_name')) {
                $this->baseObject->view->assign('twitter_title', strip_tags($this->baseObject->config->get('config_title')));

                $strip1 = $this->strip_html_tagstwit($this->baseObject->config->get('config_meta_description'));
                $strip2 = strip_tags($strip1);
                $strip3 = htmlentities($strip2);
                //  $strip3 = substr(htmlentities($strip2), 0, 210);
                $this->baseObject->view->assign('twitter_meta_tags_desc', $strip3);
            }
        }

        //TWITTER END
    }

    //breadcrumb start

    //build path
    public function getPath($category_id, $language_id = 0)
    {
        $category_id = (int) $category_id;
        $language_id = (int) $language_id;
        if (!$language_id) {
            $language_id = (int) $this->baseObject->language->getLanguageID();
        }
        $query = $this->baseObject->db->query('SELECT name, parent_id
      		                            FROM '.$this->baseObject->db->table('categories').' c
      		                            LEFT JOIN '.$this->baseObject->db->table('category_descriptions')." cd
      		                                ON (c.category_id = cd.category_id)
      		                            WHERE c.category_id = '".(int) $category_id."' AND cd.language_id = '".$language_id."'
      		                            ORDER BY c.sort_order, cd.name ASC");

        $category_info = $query->row;
        if ($category_info['parent_id']) {
            return $this->getPath($category_info['parent_id'], $language_id).$this->baseObject->language->get('text_separator').$category_info['name'];
        } else {
            return $category_info['name'];
        }
    }

    //build path with id
    public function getPathids($category_id, $language_id = 0)
    {
        $category_id = (int) $category_id;
        $language_id = (int) $language_id;
        if (!$language_id) {
            $language_id = (int) $this->baseObject->language->getLanguageID();
        }
        $query = $this->baseObject->db->query('SELECT name, parent_id
      		                            FROM '.$this->baseObject->db->table('categories').' c
      		                            LEFT JOIN '.$this->baseObject->db->table('category_descriptions')." cd
      		                                ON (c.category_id = cd.category_id)
      		                            WHERE c.category_id = '".(int) $category_id."' AND cd.language_id = '".$language_id."'
      		                            ORDER BY c.sort_order, cd.name ASC");

        $category_info = $query->row;
        //$this->baseObject->log->write(print_r($category_info,true).'====$category_info IDS');
        if ($category_info['parent_id'] > 0) {
            return $this->getPathids($category_info['parent_id'], $language_id).'>'.$category_id;
        } else {
            return $category_id;
        }
    }

    //get all trails in the store. Slow but cached
    //TODO: store id
    public function getCategories($parent_id, $store_id = null)
    {
        $language_id = $this->baseObject->language->getLanguageID();
        $cache_key = 'all_category.'.$parent_id.'.store_'.$store_id.'_lang_'.$language_id;
        $category_data = $this->baseObject->cache->pull($cache_key);

        if (false === $category_data) {
            $category_data = array();
            $sql = 'SELECT *
      					FROM '.$this->baseObject->db->table('categories').' c
      					LEFT JOIN '.$this->baseObject->db->table('category_descriptions').' cd
      					ON (c.category_id = cd.category_id) ';
            if (!is_null($store_id)) {
                $sql .= 'RIGHT JOIN '.$this->baseObject->db->table('categories_to_stores')." cs ON (c.category_id = cs.category_id AND cs.store_id = '".(int) $store_id."')";
            }

            $sql .= "WHERE c.parent_id = '".(int) $parent_id."'
      						AND cd.language_id = '".(int) $language_id."'
      					ORDER BY c.sort_order, cd.name ASC";
            $query = $this->baseObject->db->query($sql);

            foreach ($query->rows as $result) {
                $category_data[] = array(
                              'category_id' => $result['category_id'],
                              'parent_id' => $result['parent_id'],
                              'name' => $this->getPath($result['category_id'], $language_id),
                  'fulltrail' => $this->getPathids($result['category_id'], $language_id),
                              'status' => $result['status'],
                              'sort_order' => $result['sort_order'],
                      );

                $category_data = array_merge($category_data, $this->getCategories($result['category_id'], $store_id));
            }

            $this->baseObject->cache->push($cache_key, $category_data);
        }

        return $category_data;
    }

    public function getclass($product_id)
    {
        $language_id = $this->baseObject->language->getLanguageID();
        $query = $this->baseObject->db->query('SELECT *
                        FROM '.$this->baseObject->db->table('products_to_categories')."
                        WHERE product_id = '".(int) $product_id."'");

        foreach ($query->rows as $result) {
            $product_category_data[] = $result['category_id'];
        }

        // this will get all possible store categories CACHED
        $categories = array();
        $results = $this->getCategories(0);
        foreach ($results as $r) {
            //$categories[$r['category_id']] = $r['name'];
            $categories[$r['category_id']]['id'] = $r['category_id'];
            $categories[$r['category_id']]['name'] = $r['name'];
            $categories[$r['category_id']]['fulltrail'] = $r['fulltrail'];
        }

        //$this->baseObject->log->write(print_r($categories,true).'====$categories');
        if (is_array($product_category_data)) {
            foreach ($product_category_data as $result) {
                $category_data[$result]['id'] = $result;
                $category_data[$result]['name'] = $categories[$result]['name'];
                $category_data[$result]['fulltrail'] = $categories[$result]['fulltrail'];
            }
        }
        //$this->baseObject->log->write(print_r($category_data,true).'====$category_data');
        return $category_data;
    }

    public function onControllerBlocksBreadcrumbs_UpdateData()
    {
        //$this->baseObject->log->write('product catched');
        $product_id = $this->baseObject->request->get['product_id'];
        if (empty($product_id)) {
            $product_id = $this->baseObject->request->get['key'];
        }
        if ('1' == $this->baseObject->config->get('product_breadcrumb_status') and ('3' == $this->baseObject->config->get('product_breadcrumb_mode')) and (int) $product_id > 0) {
            $this->baseObject->loadLanguage('product_breadcrumb/product_breadcrumb');
            $view = new AView($this->registry, 0);
            // get all data from the Controller
            $data = $this->baseObject->view->getData();
            //$data = $this->superclass($data);
            //$product_id = (int)$data['product_id'];

            $newdata['product_id'] = $product_id;
            $this->loadModel('catalog/product');
            $data['product_info'] = $this->baseObject->model_catalog_product->getProduct($product_id);
            //$this->getproductinfo();
            //reset breadcrumb and add initial
            $depth = 0;
            //$this->baseObject->document->resetBreadcrumbs();
            //'separator' => $this->baseObject->language->get('text_separator')
            if ('1' == $this->baseObject->config->get('product_breadcrumb_home')) {
                if ('1' == $this->baseObject->config->get('product_breadcrumb_sitename')) {
                    $newdata['home'] = array(
                                'href' => $this->baseObject->html->getHomeURL(),
                                'text' => $this->baseObject->config->get('store_name'),
                                'separator' => false,
                        );
                } else {
                    $newdata['home'] = array(
                                'href' => $this->baseObject->html->getHomeURL(),
                                'text' => $this->baseObject->language->get('text_home'),
                                'separator' => false,
                        );

                    ++$depth;
                }
            }
            //get brand
            if ('1' == $this->baseObject->config->get('product_breadcrumb_brand') and (int) $data['product_info']['manufacturer_id'] > 0) {
                //if brand exist and enabled
                //$this->loadModel('catalog/manufacturer');
                $newdata['brand'] = array(
                                'href' => $this->baseObject->html->getSEOURL('product/manufacturer', '&manufacturer_id='.(int) $data['product_info']['manufacturer_id'], '&encode'),
                                'text' => $data['product_info']['manufacturer'],
                                'separator' => $this->baseObject->language->get('text_separator'),
                        );
                ++$depth;
            }

            //get all category trails for product
            $cats = $this->getclass((int) $product_id);
            //$this->baseObject->log->write(print_r($cats, true).' get all category trails');

            //if product_breadcrumb_mode 1 find one largest path
            if (count($cats)) {
                //if(count($cats)>1) {

                foreach ($cats as $result) {
                    $cats_ids_list[$result['id']] = explode('>', $result['fulltrail']);
                }
                //$this->baseObject->log->write(print_r($cats_ids_list, true).' $cats_ids_list arrays');

                if ('3' == $this->baseObject->config->get('product_breadcrumb_mode')) {
                    //$this->baseObject->log->write(print_r(count($cats_ids_list), true).' count($cats_ids_list) ');

                    foreach ($cats_ids_list as $breadcrumbkey => $arrayvalue) { //separate one by one
                        //$this->baseObject->log->write(print_r($breadcrumbkey, true).' $breadcrumb arrays');
                        $depthlimit = 0;
                        foreach ($arrayvalue as $breadcrumbsitem => $value) {
                            //$idsdone = array('0' => 0); //conslidation to one breadcrumb and remove duplicate
                            //if(!array_key_exists((int)$breadcrumbsitem, $idsdone)) {
                            //if(!array_key_exists((int)$breadcrumbsitem, $cats_ids_list)) {
                            $category_info = $this->baseObject->model_catalog_category->getCategory((int) $value);
                            $newdata['newbreadcrumb'][(int) $breadcrumbkey][(int) $breadcrumbsitem][] = array(
                                        'href' => $this->baseObject->html->getSEOURL('product/category', '&path='.(int) $value, '&encode'),
                                        'text' => $category_info['name'],
                                        'separator' => $this->baseObject->language->get('text_separator'),
                                    );

                            //$idsdone[(int)$breadcrumbsitem] = (int)$breadcrumbsitem;

                            //}

                            //}
                            ++$depthlimit;
                            if ($depthlimit == (int) $this->baseObject->config->get('product_breadcrumb_depth')) {
                                break;
                            }
                        }
                    }
                    //look for longest trail
                    $needlecount = 0;
                    foreach ($newdata['newbreadcrumb'] as $resultkey => $result) {
                        //$product_category_data[] = $result['category_id'];
                        $newneedle = count($result);
                        $newdata['newbreadcrumb'][$resultkey]['count'] = count($result);
                        if ($newneedle > $needlecount) {
                            $needlecount = $newneedle;
                            $searched_id = $resultkey;
                        }
                    }
                    if ((int) $searched_id > 0) {
                        //sort array
                        $usernames = array();
                        foreach ($newdata['newbreadcrumb'] as $user) {
                            $usernames[] = $user['count'];
                        }
                        array_multisort($newdata['newbreadcrumb'], SORT_DESC, $usernames);
                    }
                }
            }
            // add last breadcrumb item
            if ('1' == $this->baseObject->config->get('product_breadcrumb_product')) {
                $newdata['product'] = array(
                  'href' => $this->baseObject->html->getSEOURL('product/product', $url.'&product_id='.$product_id, '&encode'),
                  'text' => $data['product_info']['name'],
                  //'separator' => $this->baseObject->language->get('text_separator')
                          );
            }
            $this->baseObject->view->assign('product_id', $product_id);
            $this->baseObject->view->assign('newbreadcrumb', $newdata);
        }
    }
}
