<?php
if (!defined('DIR_CORE') || !IS_ADMIN) {
    header('Location: static_pages/');
}

class ModelSeoPackCategory extends Model
{
    public function getCategory($category_id)
    {
        $query = $this->db->query("SELECT DISTINCT *,
			(SELECT keyword
			FROM " . $this->db->table("url_aliases") . "
			WHERE query = 'category_id=" . (int)$category_id . "'
				AND language_id='".(int)$this->language->getContentLanguageID()."' ) AS keyword
		FROM " . $this->db->table("categories") . "
		WHERE category_id = '" . (int)$category_id . "'");
        return $query->row;
    }


    public function getUniKeywordDu($seo_key, $object_key_name='', $object_id=0)
    {
        // SELECT `keyword` FROM ac_url_aliases WHERE query like '%' AND `keyword` like 'face%'
        // SELECT * FROM ac_url_aliases WHERE query like '%' AND `keyword` like 'face%' AND query<>'product_id=71'
        $object_id=(int)$object_id;

        $registry = Registry::getInstance();
        $db = $registry->get('db');
        $sql = "SELECT `keyword`
				FROM ".$db->table('url_aliases')."
				WHERE query like '%'
						AND `keyword` like '".$db->escape($seo_key)."%'";
        if ($object_id) {
            // exclude keyword of given object (product, category, content etc)
            $sql .= " AND query<>'".$db->escape($object_key_name)."=".$object_id."'";
        }

        $result = $db->query($sql);
        if ($result->num_rows) {
            foreach ($result->rows as $row) {
                $keywords[] = $row['keyword'];
            }

            $i=0;
            while (in_array($seo_key, $keywords) && $i<20) {
                $seo_key = $seo_key.'_'.($object_id?$object_id:$i);
                $i++;
            }
        }
        return $seo_key;
    }


    /////////////////////////////////////////////////////////////////////////
    public function getCategorySeo($category_id, $option_id = 0)
    {
        $language_id = $this->language->getContentLanguageID();
        $category_seo = $this->db->query(
            "SELECT *
			FROM `" . DB_PREFIX . "product_extra_seo_category`
			WHERE `category_id` = '" . (int)$category_id . "'
				 AND `language_id` = '" . (int)$language_id . "'
											 ");

        if ($category_seo->num_rows) {
            $row = $category_seo->row;
            $row['language'] = $category_seo;
            return $row;
        } else {
            return null;
        }
    }




    public function updateСategorySeo($category_id, $data)
    {
        if (!(int)$category_id || !$data) {
            return false;
        }
        $language_id = $this->language->getContentLanguageID();

        if (isset($data['category_seo']) ||  isset($data['category_seo_h1'])) {
            $seo_title = $data['category_seo'][0];
            $seo_h1 = $data['category_seo_h1'][0];
            if ($this->getCategorySeo($category_id) > 0) {
                $queryt = "UPDATE " . $this->db->table("product_extra_seo_category") . " SET ";
                if (isset($data['category_seo'])) {
                    $queryt .= " seo_title = '" . $this->db->escape($seo_title) . "'";
                }
                if (isset($data['category_seo_h1'][0]) and isset($data['category_seo'])) {
                    $queryt .=    " , ";
                }
                if (isset($data['category_seo_h1'][0])) {
                    $queryt .=    " seo_h1 = '" . $this->db->escape($seo_h1) . "'";
                }
                $queryt .=  " WHERE category_id = '" . $category_id . "' AND language_id = '" . $language_id . "' ";

                $this->db->query($queryt);
                //$this->log->write('exist');
            } else {
                $this->db->query("INSERT INTO " . $this->db->table("product_extra_seo_category") . " SET category_id = '" . (int)$category_id . "', seo_title = '" . $this->db->escape($seo_title) . "', seo_h1 = '" . $this->db->escape($seo_h1) . "', language_id = '" . $language_id . "'");
                //$this->log->write('notexist');
            }
        }




        if (isset($data['category_seo_meta_keywords']) ||  isset($data['category_seo_meta_description'])) {
            $seo_meta_keywords = $data['category_seo_meta_keywords'][0];
            $seo_meta_description = $data['category_seo_meta_description'][0];

            $queryupdate = "UPDATE " . $this->db->table("category_descriptions") . " SET ";
            if (isset($data['category_seo_meta_keywords'])) {
                $queryupdate .= " meta_keywords = '" . $this->db->escape($seo_meta_keywords) . "'";
            }
            if (isset($data['category_seo_meta_description'][0]) and isset($data['category_seo_meta_keywords'])) {
                $queryupdate .=    " , ";
            }
            if (isset($data['category_seo_meta_description'][0])) {
                $queryupdate .=    " meta_description = '" . $this->db->escape($seo_meta_description) . "'";
            }
            $queryupdate .=  " WHERE category_id = '" . $category_id . "' AND language_id = '" . $language_id . "' ";

            $this->db->query($queryupdate);
                //$this->log->write('exist');
        }

        if (isset($data['keyword'])) {
            $this->loadModel('extension/seo_generator');
            $seo = SEOEncode($data['keyword']); //getUniqueSeoKeyword( $data['keyword'], 'category_id', $category_id);
                    $seo = $this->getUniKeywordDu($seo, 'category_id', $category_id);
            $this->language->replaceDescriptions('url_aliases',
                array('query' => "category_id=" . (int)$category_id),
                array((int)$this->language->getContentLanguageID() => array('keyword' => $seo )));
                /*$data['keyword'] =  SEOEncode($data['keyword']);
                if($data['keyword']){
                $this->language->replaceDescriptions('url_aliases',
                                                    array('query' => "category_id=" . (int)$category_id),
                                                    array((int)$this->language->getContentLanguageID() => array('keyword' => $data['keyword'])));
                }else{
                    $this->db->query("DELETE
                                    FROM " . $this->db->table("url_aliases") . "
                                    WHERE query = 'category_id=" . (int)$category_id . "'
                                        AND language_id = '".(int)$this->language->getContentLanguageID()."'");
                }*/
        }



        $this->cache->delete('category');
        //127 $this->cache->remove('category');


        return true;
    }
}
