<?php

if (!IS_ADMIN || !defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ControllerResponsesExtensionSeoGenerator extends AController
{
    private $acm;
    public $data = array();

    public function generate_seo_link($input, $replace = '-', $remove_words = true, $words_array = array())
    {
        // _

        $input = str_replace('_', ' ', $input);
        $input = str_replace('-', ' ', $input);
        $input = str_replace('"', '', $input);
        $input = str_replace(',', ' ', $input); // tags list
        //make it lowercase, remove punctuation, remove multiple/leading/ending spaces
        $return = trim(preg_replace('/ +/', ' ', preg_replace('/[^\pL\p{Zs}0-9\s\-_]+/u', '', mb_strtolower($input, 'UTF-8'))));

        //remove words, if not helpful to seo
        //i like my defaults list in remove_words(), so I wont pass that array
        if ($remove_words) {
            $return = $this->remove_words($return, $replace, $words_array);
        }

        //convert the spaces to whatever the user wants
        //usually a dash or underscore..
        //...then return the value.
        return str_replace(' ', $replace, $return);
    }

    /* takes an input, scrubs unnecessary words */
    public function remove_words($input, $replace, $words_array = array(), $unique_words = true)
    {
        //separate all words based on spaces
        $input_array = explode(' ', $input);

        //create the return array
        $return = array();

        //loops through words, remove bad words, keep good ones
        foreach ($input_array as $word) {
            //if it's a word we should add...
            if (!in_array($word, $words_array) && ($unique_words ? !in_array($word, $return) : true)) {
                $return[] = $word;
            }
        }

        //return good words separated by dashes
        return implode($replace, $return);
    }

    public function unaccent($string) //umlauts
    {
        if (false !== strpos($string = htmlentities($string, ENT_QUOTES, 'UTF-8'), '&')) {
            $string = html_entity_decode(preg_replace('~&([a-z]{1,2})(?:acute|cedil|caron|circ|grave|lig|orn|ring|slash|th|tilde|uml);~i', '$1', $string), ENT_QUOTES, 'UTF-8');
        }
        $unwanted_array = array('Š' => 'S', 'š' => 's', 'Ž' => 'Z', 'ž' => 'z', 'À' => 'A', 'Á' => 'A', 'Â' => 'A', 'Ã' => 'A', 'Ä' => 'A', 'Å' => 'A', 'Æ' => 'A', 'Ç' => 'C', 'È' => 'E', 'É' => 'E',
                            'Ê' => 'E', 'Ë' => 'E', 'Ì' => 'I', 'Í' => 'I', 'Î' => 'I', 'Ï' => 'I', 'Ñ' => 'N', 'Ò' => 'O', 'Ó' => 'O', 'Ô' => 'O', 'Õ' => 'O', 'Ö' => 'O', 'Ø' => 'O', 'Ù' => 'U',
                            'Ú' => 'U', 'Û' => 'U', 'Ü' => 'U', 'Ý' => 'Y', 'Þ' => 'B', 'ß' => 'Ss', 'à' => 'a', 'á' => 'a', 'â' => 'a', 'ã' => 'a', 'ä' => 'a', 'å' => 'a', 'æ' => 'a', 'ç' => 'c',
                            'è' => 'e', 'é' => 'e', 'ê' => 'e', 'ë' => 'e', 'ì' => 'i', 'í' => 'i', 'î' => 'i', 'ï' => 'i', 'ð' => 'o', 'ñ' => 'n', 'ò' => 'o', 'ó' => 'o', 'ô' => 'o', 'õ' => 'o',
                            'ö' => 'o', 'ø' => 'o', 'ù' => 'u', 'ú' => 'u', 'û' => 'u', 'ý' => 'y', 'þ' => 'b', 'ÿ' => 'y',
                                                            'Ğ' => 'G', 'İ' => 'I', 'Ş' => 'S', 'ğ' => 'g', 'ı' => 'i', 'ş' => 's', 'ü' => 'u',
                                                            'ă' => 'a', 'Ă' => 'A', 'ș' => 's', 'Ș' => 'S', 'ț' => 't', 'Ț' => 'T',
                                                            'ą' => 'a', 'ż' => 'z', 'č' => 'c', 'ř' => 'r', 'ů' => 'u', 'ł' => 'l', 'ň' => 'n', 'ě' => 'e', 'ť' => 't', 'ď' => 'd', 'ʼ' => '', 'ę' => 'e',
                                                        );
        $string = strtr($string, $unwanted_array);

        return $string;
    }

    public function cleanUTF($name)
    { //translit
        $name = str_replace(array('š', 'č', 'đ', 'č', 'ć', 'ž', 'ñ'), array('s', 'c', 'd', 'c', 'c', 'z', 'n'), $name);
        $name = str_replace(array('Š', 'Č', 'Đ', 'Č', 'Ć', 'Ž', 'Ñ'), array('S', 'C', 'D', 'C', 'C', 'Z', 'N'), $name);
        $name = str_replace(array('а', 'б', 'в', 'ґ', 'г', 'д', 'е', 'ё', 'ж', 'з', 'ї', 'и', 'і', 'й', 'к', 'л', 'љ', 'м', 'н', 'њ', 'о', 'п', 'р', 'с', 'т', 'у', 'ф', 'х', 'ц', 'ч', 'џ', 'ш', 'щ', 'ъ', 'ы', 'ь', 'э', 'є',   'ю', 'я', 'А', 'Б', 'В', 'Г', 'Ґ', 'Д', 'Е', 'Ё', 'Ж', 'З', 'Ї', 'І', 'И', 'Й', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'),
                            array('a', 'b', 'v', 'g', 'g', 'd', 'e', 'e', 'z', 'z', 'i', 'i', 'i', 'j', 'k', 'l', 'lj', 'm', 'n', 'nj', 'o', 'p', 'r', 's', 't', 'u', 'f', 'h', 'c', 'c', 'dz', 's', 's', 'i', 'j', 'j', 'e', 'e', 'ju', 'ja', 'A', 'B', 'V', 'G', 'G', 'D', 'E', 'E', 'Z', 'Z', 'I', 'I', 'I', 'J', 'K', 'L', 'Lj', 'M', 'N', 'Nj', 'O', 'P', 'R', 'S', 'T', 'U', 'F', 'H', 'C', 'C', 'Dz', 'S', 'S', 'I', 'J', 'J', 'E', 'Ju', 'Ja'), $name);

        return $name;
    }

    public function limit_words($string, $word_limit)
    {
        $words = explode(' ', $string);

        return implode(' ', array_splice($words, 0, $word_limit));
    }

    public function in_array_r($needle, $haystack, $strict = false)
    {
        foreach ($haystack as $item) {
            if (($strict ? $item === $needle : $item == $needle) || (is_array($item) && $this->in_array_r($needle, $item, $strict))) {
                return true;
            }
        }

        return false;
    }

    public function get_seo_generator2()
    {
        $this->loadModel('extension/seo_generator');
        $this->loadModel('catalog/product');
        $this->loadModel('catalog/category');
        $this->loadModel('catalog/manufacturer');
        $this->loadModel('catalog/content');
        if (0 == $_SESSION['sucsess_part_generator']) {
            $newArray = $this->model_extension_seo_generator->getproductsall('products', 'product_id');
            if ($this->config->get('seo_generator_cbc')) {
                $newArrayC = $this->model_extension_seo_generator->getproductsall('categories', 'category_id');

                $newArray = array_merge($newArray, $newArrayC);
                $newArrayM = $this->model_extension_seo_generator->getproductsall('manufacturers', 'manufacturer_id');
                $newArray = array_merge($newArray, $newArrayM);
                $newArrayA = $this->model_extension_seo_generator->getproductsall('contents', 'content_id');
                $newArray = array_merge($newArray, $newArrayA);
            }
            //	print_r($newArray);

            foreach ($newArray as $index => $row) {
                //get product id    $row['product_id']

                $product_id = $row['product_id'];
                $category_id = $row['category_id'];
                $manufacturer_id = $row['manufacturer_id'];
                $content_id = $row['content_id'];

                if (has_value($product_id)) {
                    $newArrayUpdate[$index]['product_id'] = $product_id;
                    $product_info = $this->model_catalog_product->getProduct($product_id);
                    $manufacturer_id = $product_info['manufacturer_id'];
                    $oldkeyword = $product_info['keyword'];

                    $typearray = unserialize($this->config->get('seo_generator_type'));
                    if (in_array('model', $typearray)) {
                        $model = $product_info['model'];
                    }
                    if (in_array('product_name', $typearray)) {
                        $name = $product_info['name'];
                    }
                    if (in_array('meta_keys', $typearray)) {
                        $meta_keywords = $product_info['meta_keywords'];
                    }
                    //$blurb = $product_info['blurb'];

                    if (in_array('tags', $typearray)) {
                        $tags = $this->model_catalog_product->getProductTags($product_id);
                        $tag_seo = $tags[(int) $this->config->get('storefront_language_id')];
                        //echo $tag_seo;
                                                //break;
                    }

                    if (in_array('category', $typearray)) {
                        $cats = $this->model_extension_seo_generator->getCategories($product_id);
                        $cats_names_list = implode(', ', array_map(function ($entry) {
                            return $entry['name'];
                        }, $cats));
                    }

                    if (in_array('brand', $typearray)) {
                        $this->loadModel('catalog/manufacturer');
                        $manufacturer_name = $this->model_catalog_manufacturer->getManufacturer($manufacturer_id);
                        $brand = $manufacturer_name['name'];
                    }
                } elseif (has_value($category_id)) {
                    $newArrayUpdate[$index]['category_id'] = $category_id;
                    $category_info = $this->model_catalog_category->getCategoryDescriptions($category_id);
                    $name = $category_info[(int) $this->language->getContentLanguageID()]['name'];
                    //	['language_id']['name'] //(int)$this->language->getContentLanguageID()
                    $category_keyword = $this->model_catalog_category->getCategory($category_id);
                    $oldkeyword = $category_keyword['keyword'];
                } elseif (has_value($manufacturer_id)) {
                    $newArrayUpdate[$index]['manufacturer_id'] = $manufacturer_id;
                    $manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($manufacturer_id);
                    $name = $manufacturer_info['name'];
                    $oldkeyword = $manufacturer_info['keyword'];
                } elseif (has_value($content_id)) {
                    $newArrayUpdate[$index]['content_id'] = $content_id;
                    //	$content_info = $this->model_catalog_manufacturer->getManufacturer($content_id);
                    $l_id = $this->language->getContentLanguageID();
                    $this->acm = new AContentManager();
                    $content_info = $this->acm->getContent($content_id, $l_id);
                    //	print_r($content_info);
                    $name = $content_info['name'];
                    $oldkeyword = $content_info['keyword'];
                }

                //	$seokey = $product_info['keyword'];
                $bad_word_config = explode(',', str_replace(', ', ',', $this->config->get('seo_generator_badwords')));

                $bad_words_in = array("'", '.'); //"'"
                $bad_words = array_merge($bad_word_config, $bad_words_in);

                //print_r ($bad_words);
                if ('underscore' == $this->config->get('seo_generator_delim')) {
                    $replace = '_';
                } else {
                    $replace = '-';
                }

                /*	if ($this->config->get('seo_generator_new_only')) {
                    $seokey = $this->generate_seo_link($product_info['keyword'], $replace, true, $bad_words);
                }*/

                $time = microtime(true);
                if ($oldkeyword && $this->config->get('seo_generator_new_only')) {
                } else {
                    if (has_value($product_id)) {
                        $seo = $this->generate_seo_link(
                                $this->limit_words("$brand.' '.$name.' '.$model.' '.$cats_names_list.' '.$tag_seo.' '.$meta_keywords", $this->config->get('seo_generator_wordslimit')), $replace, true, $bad_words);
                    } else {
                        $seo = $this->generate_seo_link(
                                    $this->limit_words("$name", $this->config->get('seo_generator_wordslimit')), $replace, true, $bad_words);
                    }

                    if ($this->config->get('seo_generator_rlname_status')) {
                        $seo = $this->unaccent($seo);
                    }
                    if ($this->config->get('seo_generator_rltranslit_status')) {
                        $seo = $this->cleanUTF($seo);
                    }

                    //print_r ($resourcesobj); //$warning->toLog()->toDebug()->toMessages();

                    //if $object_key_name given - check is seo-key unique and return unique
                    //return getUniqueSeoKeywordInt($seo_key, $object_key_name, $object_id, $language_id);
                    if (has_value($product_id)) {
                        //	$uniq_seo_p = $this->model_extension_seo_generator->getUniKeyword( $seo, 'product_id', (int)$product_id);
                        //(int)$this->language->getContentLanguageID()
                        //$uniq_seo = $this->model_extension_seo_generator->getUniKeyword( $uniq_seo);
                        /*	echo "product $-seo= ".$seo.' <br>';
                            echo "product $-product_id= ".$product_id.' <br>';
                            echo "product $-content lang_id= ".(int)$this->language->getContentLanguageID().' <br>';
                            echo "uniq_seo----".$uniq_seo_p."  for product ".$product_id." -------------<br><br>";*/
                        $newArrayUpdate[$index]['seo'] = $seo;
                    } elseif (has_value($category_id)) {
                        //	$uniq_seo = $this->model_extension_seo_generator->getUniKeyword( $seo, 'category_id', (int)$category_id, (int)$this->language->getContentLanguageID() );
                        //	$uniq_seo = $this->model_extension_seo_generator->getUniKeyword( $uniq_seo);
                        $newArrayUpdate[$index]['seo'] = $seo;
                    } elseif (has_value($manufacturer_id)) {
                        //	$uniq_seo = $this->model_extension_seo_generator->getUniKeyword( $seo, 'manufacturer_id', (int)$manufacturer_id, (int)$this->language->getContentLanguageID() );
                        //	$uniq_seo = $this->model_extension_seo_generator->getUniKeyword( $uniq_seo);
                        $newArrayUpdate[$index]['seo'] = $seo;
                    } elseif (has_value($content_id)) {
                        //	$uniq_seo = $this->model_extension_seo_generator->getUniKeyword( $seo, 'content_id', (int)$content_id, (int)$this->language->getContentLanguageID() );
                        //$uniq_seo = $this->model_extension_seo_generator->getUniKeyword( $uniq_seo);
                        $newArrayUpdate[$index]['seo'] = $seo;
                    }
                    //	$this->cache->clear;
                    if ($oldkeyword) {
                        $newArrayUpdate[$index]['oldkeyword'] = $oldkeyword;
                    }

                    //	$newArrayUpdate[$index]['seo'] = $uniq_seo;
                }
            }
            //	print_r($newArrayUpdate);

            $_SESSION['myarray_generator'] = $newArrayUpdate;
            $part = $_SESSION['parts_generator'] = sizeof($_SESSION['myarray_generator']);
        }
        $part = sizeof($_SESSION['myarray_generator']);

        $value = $_SESSION['myarray_generator'][($_SESSION['sucsess_part_generator'])];
        ++$_SESSION['sucsess_part_generator'];

        //print_r($value);
        //	if ( $oldkeyword && $this->config->get('seo_generator_new_only')  )

        //$value['seo']
        //echo $this->config->get('seo_generator_new_only').'vv';
        if ($value['seo'] and (
                                    (!$value['oldkeyword'] and !$this->config->get('seo_generator_new_only'))
                                    or
                                    ($value['oldkeyword'] and !$this->config->get('seo_generator_new_only'))
                                    or
                                    (!$value['oldkeyword'] and $this->config->get('seo_generator_new_only'))
                                    )
                                     ) {
            //echo $this->language->getContentLanguageID().'zzz-';
            if ($value['product_id']) {
                $seo = getUniqueSeoKeyword($value['seo'], 'product_id', $value['product_id']);
                $seo = $this->model_extension_seo_generator->getUniKeyword($seo, 'product_id', $value['product_id']);
                $this->language->replaceDescriptions('url_aliases',
                                                array('query' => 'product_id='.(int) $value['product_id']),
                                                array((int) $this->language->getContentLanguageID() => array('keyword' => $seo)));
            }

            if ($value['category_id']) {
                $seo = getUniqueSeoKeyword($value['seo'], 'category_id', $value['category_id']);
                $seo = $this->model_extension_seo_generator->getUniKeyword($seo, 'category_id', $value['category_id']);
                $this->language->replaceDescriptions('url_aliases',
                                                array('query' => 'category_id='.(int) $value['category_id']),
                                                array((int) $this->language->getContentLanguageID() => array('keyword' => $seo)));
            }

            if ($value['manufacturer_id']) {
                $seo = getUniqueSeoKeyword($value['seo'], 'manufacturer_id', $value['manufacturer_id']);
                $seo = $this->model_extension_seo_generator->getUniKeyword($seo, 'manufacturer_id', $value['manufacturer_id']);
                $this->language->replaceDescriptions('url_aliases',
                                                array('query' => 'manufacturer_id='.(int) $value['manufacturer_id']),
                                                array((int) $this->language->getContentLanguageID() => array('keyword' => $seo)));
            }
            if ($value['content_id']) {
                $seo = getUniqueSeoKeyword($value['seo'], 'content_id', $value['content_id']);
                $seo = $this->model_extension_seo_generator->getUniKeyword($seo, 'content_id', $value['content_id']);
                $this->language->replaceDescriptions('url_aliases',
                                                array('query' => 'content_id='.(int) $value['content_id']),
                                                array((int) $this->language->getContentLanguageID() => array('keyword' => $seo)));
            }
        }

        //$this->cache->delete('*');
        $total = count((array)$newArray);
        $_SESSION['process_generator'] = (($_SESSION['sucsess_part_generator'] * 100) / $part);
        echo $_SESSION['process_generator'];
    }

    public function get_seo_generator3()   //restart
    {
        $_SESSION['sucsess_part_generator'] = 0;
        $_SESSION['parts_generator'] = 0;
        $_SESSION['myarray_generator'] = 0;
        $_SESSION['process_generator'] = 0;
    }
}
