<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
class ControllerPagesCatalogCollectionSeoPack extends AController
{
    private $error = array();
    private $attribute_manager;
    public $data = array();

    public function main()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('catalog/collections');
        $this->loadLanguage('seo_pack/seo_pack');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->loadModel('catalog/collection');
        $this->loadModel('seo_pack/collection');

        $content_language_id = $this->language->getContentLanguageID();

        if (isset($this->request->get['id']) && ($this->request->is_GET())) {
            $collection_info = $this->model_catalog_collection->getById($this->request->get['id']);
            //$this->log->write(print_r($collection_info, true).' $collection_info');
            $this->data['collection_description'] = $this->model_seo_pack_collection->getCollectionDescriptions($this->request->get['id']);

            //$this->log->write(print_r($this->data['collection_description'], true).' collection_description');
            //print_r($this->data['collection_description']);
            if (!$collection_info) {
                $this->session->data['warning'] = $this->language->get('error_collection_not_found');
                $this->redirect($this->html->getSecureURL('catalog/collections'));
            }
        }

        if ($this->request->is_POST()) {
            $this->model_seo_pack_collection->updateCollectionSeo($this->request->get['id'], $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->redirect($this->html->getSecureURL('catalog/collection_seo_pack', '&id='.$this->request->get['id']));
        }

        $this->view->assign('error_warning', $this->error['warning']);
        $this->view->assign('success', $this->session->data['success']);
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb(array(
            'href' => $this->html->getSecureURL('index/home'),
            'text' => $this->language->get('text_home'),
            'separator' => false,
        ));
        $this->document->addBreadcrumb(array(
            'href' => $this->html->getSecureURL('catalog/collections'),
            'text' => $this->language->get('heading_title'),
            'separator' => ' :: ',
        ));
        $this->document->addBreadcrumb(array(
            'href' => $this->html->getSecureURL('catalog/collections/update', '&id='.$this->request->get['id']),
            'text' => $this->language->get('text_edit').'&nbsp;'.$this->language->get('text_collection').' - '.$this->data['collection_description'][$this->session->data['content_language_id']]['name'],
            'separator' => ' :: ',
        ));
        $this->document->addBreadcrumb(array(
            'href' => $this->html->getSecureURL('catalog/collection_seo_pack', '&id='.$this->request->get['id']),
            'text' => $this->language->get('entry_admin_seo_tab_name'),
            'separator' => ' :: ',
            'current' => true,
        ));

        $this->data['collection_seo'] = $this->model_seo_pack_collection->getCollectionSeo($this->request->get['id']);
        //$this->log->write(print_r($this->data['collection_seo'], true).' collection_seo');
        //	$this->data['collection_description'] = $this->model_catalog_collection->getCollectionDescriptions($this->request->get['id'],$this->session->data['content_language_id']);


        //load tabs controller
        $tabs_obj_seo = $this->dispatch('pages/catalog/collection_tabs', array($this->data));
        $this->data['collection_tabs'] = $tabs_obj_seo->dispatchGetOutput();
        unset($tabs_obj_seo);

        $this->data['action'] = $this->html->getSecureURL('catalog/collection_seo_pack', '&id='.$this->request->get['id']);
        $this->data['form_title'] = $this->language->get('text_edit').'&nbsp;'.$this->language->get('text_collection');
        $this->data['update'] = $this->html->getSecureURL('seo_pack/collection/update_seo_pack', '&id='.$this->request->get['id']);
        $form = new AForm('HS');

        $form->setForm(array(
            'form_name' => 'productFrm',
            'update' => $this->data['update'],
        ));

        $this->data['form']['id'] = 'productFrm';

        $this->data['form']['form_open'] = $form->getFieldHtml(array(
            'type' => 'form',
            'name' => 'productFrm',
            'action' => $this->data['action'],
            'attr' => 'data-confirm-exit="true" class="aform form-horizontal"',
        ));

        $this->data['form']['submit'] = $form->getFieldHtml(array(
            'type' => 'button',
            'name' => 'submit',
            'text' => $this->language->get('button_save'),
            'style' => 'button1',
        ));
        $this->data['form']['cancel'] = $form->getFieldHtml(array(
            'type' => 'button',
            'href' => $this->html->getSecureURL('catalog/collections/update', '&id='.$this->request->get['id']),
            'name' => 'cancel',
            'text' => $this->language->get('button_cancel'),
            'style' => 'button2',
        ));
        $this->data['cancel'] = $this->html->getSecureURL('catalog/collections');

        $this->data['form']['fields']['seo'] = $form->getFieldHtml(array(
                'type' => 'textarea',
                'name' => 'collection_seo[]',
                'value' => $this->data['collection_seo']['seo_title'],
                'multilingual' => true,
        ));

        $this->data['form']['fields']['seo_h1'] = $form->getFieldHtml(array(
                'type' => 'textarea',
                'name' => 'collection_seo_h1[]',
                'value' => $this->data['collection_seo']['seo_h1'],
                'multilingual' => true,
        ));

        $this->data['form']['fields']['seo_meta_keywords'] = $form->getFieldHtml(array(
                            'type' => 'textarea',
                            'name' => 'collection_seo_meta_keywords[]',
                            'value' => $this->data['collection_description'][$content_language_id]['meta_keywords'],
                            'multilingual' => true,
                ));

        $this->data['form']['fields']['seo_meta_description'] = $form->getFieldHtml(array(
                            'type' => 'textarea',
                            'name' => 'collection_seo_meta_description[]',
                            'value' => $this->data['collection_description'][$content_language_id]['meta_description'],
                            'multilingual' => true,
                ));

        $this->data['keyword_button'] = $form->getFieldHtml(array(
                        'type' => 'button',
                        'name' => 'generate_seo_keyword',
                        'text' => $this->language->get('button_generate'),
                    //set button not to submit a form
                        'attr' => 'type="button"',
                        'style' => 'btn btn-info',
                ));
        $this->data['form']['collection_name'] = $this->data['collection_description'][$this->session->data['content_language_id']]['name'];
        $this->data['form']['generate_seo_url'] = $this->html->getSecureURL('common/common/getseokeyword', '&object_key_name=collection_id&id='.$this->request->get["id"]);

        $this->data['form']['fields']['keyword'] = $form->getFieldHtml(array(
                        'type' => 'input',
                        'name' => 'keyword',
                        'value' => $collection_info['keyword'],
                        'help_url' => $this->gen_help_url('seo_keyword'),
                        'multilingual' => true,
                        'attr' => ' gen-value="'.SEOEncode($this->data['collection_description']['name']).'" ',
                ));

        $this->view->assign('form_language_switch', $this->html->getContentLanguageSwitcher());
        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/extension/collection_seo_pack.tpl');

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }
}
