<script type="text/javascript">
    document.addEventListener('DOMContentLoaded', function load() {
        //waiting for jquery loaded!
        $('#review_submit').unbind("click");
        function review() {
            var dismiss = '<button type="button" class="close" data-dismiss="alert">&times;</button>';

            <?php if ($review_recaptcha) { ?>
                var captcha = '&h-captcha-response=' + encodeURIComponent($('[name=\'h-captcha-response\']').val());
            <?php } ?>

            $.ajax({
                type: 'POST',
                url: '<?php echo $product_review_write_url;?>',
                dataType: 'json',
                data: 'name='
                    + encodeURIComponent($('input[name=\'name\']').val())
                    + '&text='
                    + encodeURIComponent($('textarea[name=\'text\']').val())
                    + '&rating=' + encodeURIComponent($('input[name=\'rating\']:checked').val() ? $('input[name=\'rating\']:checked').val() : '') + captcha,
                beforeSend: function () {
                    $('.success, .warning').remove();
                    $('#review_button').attr('disabled', 'disabled');
                    $('#review_title').after('<div class="wait"><i class="fa fa-spinner fa-spin"></i> <?php echo $text_wait; ?></div>');
                },
                complete: function () {
                    $('#review_button').attr('disabled', '');
                    $('.wait').remove();
                    try {
                        resetLockBtn();
                    } catch (e) {
                    }
                },
                error: function (jqXHR, exception) {
                    var text = jqXHR.statusText + ": " + jqXHR.responseText;
                    $('#review .alert').remove();
                    $('#review_title').after('<div class="alert alert-error alert-danger">' + dismiss + text + '</div>');
                },
                success: function (data) {
                    if (data.error) {
                        $('#review .alert').remove();
                        $('#review_title').after('<div class="alert alert-error alert-danger">' + dismiss + data.error + '</div>');
                    } else {
                        $('#review .alert').remove();
                        $('#review_title').after('<div class="alert alert-success">' + dismiss + data.success + '</div>');

                        $('input[name=\'name\']').val('');
                        $('textarea[name=\'text\']').val('');
                        $('input[name=\'rating\']:checked').attr('checked', '');
                    }
                }
            });
        }

        $('#review_submit').click(function () {
            review();
        });

    });
</script>