<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' ) || !IS_ADMIN) {
    header ( 'Location: static_pages/' );
}

/**
 * ControllerResponsesExtensionFedexTest
 * @property ModelExtensionFedexOrder $model_extension_fedex_order
 */
class ControllerResponsesExtensionFedexTest extends AController {
    private $cfg = [];

    public function test() {
        $this->loadLanguage('fedex_integration/fedex_integration');
        $this->loadModel('setting/setting');
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        $this->cfg = $this->model_setting_setting->getSetting('fedex_integration',(int)$store_id);
        $json = [];
        $required_fields = [
            'client_id'        	 => 'fedex_integration_client_id',
            'account'   	 => 'fedex_integration_account',
            'client_secret'       	 => 'fedex_integration_client_secret',
            'city'       	 => 'fedex_integration_city',
            'postcode'   	 => 'fedex_integration_postcode',
            'packaging'   	 => 'fedex_integration_packaging',
            'pickupType'	 => 'fedex_integration_pickupType',
            'country'	     => 'fedex_integration_country',
        ];
        $address = [];
        foreach ($required_fields as $k => $fld){
            if (!$this->cfg[$fld] && $k!=='postcode'){
                $json['error'] = true;
                $json['message'] = 'Error: Please fill and save all required fields and try again.';
                break;
            }
            $address[$k] = $this->cfg[$fld];
        }
        if ($json['error'] != true){
            $test_result = $this->_processRequest($address);
            $test_mode = $this->cfg['fedex_integration_test'] ? 'ON' : 'OFF';
            if (!$test_result){
                $json['error'] = true;
                $json['message'] = 'fedex Error: Wrong data was given. Please check your API Credentials and try again.' . "\n" . 'Also please note that Test mode is ' . $test_mode . '!';
            } else if ($test_result['error']){
                $json['error'] = true;
                $json['message'] = 'fedex Error: ' . $test_result['error'] . "\n" . 'Please check your API Credentials and try again.' . "\n" . 'Also please note that Test mode is ' . $test_mode . '!';

            } else{
                $json['message'] = $this->language->get('text_connection_success');
                $json['error'] = false;
            }
        }
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($json));
    }

    private function _processRequest($address){
        $endpoint_url = $this->cfg['fedex_integration_test'] ? 'https://apis-sandbox.fedex.com/' : 'https://apis.fedex.com/' ;
        
        //fedex Account
        $fedex_account = $this->cfg['fedex_integration_account'];
        $fedex_packaging = $this->cfg['fedex_integration_packaging'];
        $fedex_pickup = $this->cfg['fedex_integration_pickupType'];
        $fedex_city = $this->cfg['fedex_integration_city'];
        $fedex_state = $this->cfg['fedex_integration_state'];
        $fedex_postcode = $this->cfg['fedex_integration_postcode'];
        $fedex_origin = $this->cfg['fedex_integration_country'];

        $token = $this->getAccessToken();

        if ($token['response']['errors']) {
            $error_msg = $token['response']['errors']['message'];
            return ['error' => $error_msg];
        }

        $access_token = $token['access_token'];

        $this->load->model('extension/fedex_order');

        //Recepient Info

        $request = [
            "accountNumber" => [
                "value" => $fedex_account
            ],
            "requestedShipment" => [
                "shipper" => [
                    "address" => [
                        "city" => $fedex_city,
                        "stateOrProvinceCode" => $fedex_state,
                        "postalCode" => $fedex_postcode,
                        "countryCode" => $fedex_origin
                    ]
                ],
                "recipient" => [
                    "address" => [
                        "city" => $fedex_city,
                        "stateOrProvinceCode" => $fedex_state,
                        "postalCode" => $fedex_postcode,
                        "countryCode" => $fedex_origin
                    ]
                ],
                "pickupType" => $fedex_pickup,
                "packagingType" => $fedex_packaging,
                "rateRequestType" => [
                        "ACCOUNT"
                ],
                "requestedPackageLineItems" => [
                    [
                        "weight" => [
                            "units" => strtoupper($this->config->get('config_weight_class')),
                            "value" => 1
                        ],
                        "dimensions" => [
                            "length" => 5,
                            "width" => 5,
                            "height" => 5,
                            "units" => strtoupper($this->config->get('config_length_class'))
                        ]
                    ]
                ]
            ]
        ];

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url.'rate/v1/rates/quotes',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($request),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Authorization: Bearer '.$access_token
            ),
        ));

        $response = json_decode(curl_exec($curl),true);

        curl_close($curl);
        if ($response['errors']) {
            $error_msg = $response['errors']['message'];
        }

        if ($this->config->get('fedex_integration_debug')) {
            $this->log->write('FedEx Integration Testing Result: '.var_export($response,true));
        }

        return ['error' => $error_msg];
    }

    public function getAccessToken() {
        $endpoint_url = $this->cfg['fedex_integration_test'] ? 'https://apis-sandbox.fedex.com/' : 'https://apis.fedex.com/' ;
        $client_id = $this->cfg['fedex_integration_client_id'];
        $client_secret = $this->cfg['fedex_integration_client_secret'];

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url.'oauth/token',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_id='.$client_id.'&client_secret='.$client_secret,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded',
            ),
        ));
        
        $response = json_decode(curl_exec($curl),true);
        $curl_error = curl_error($curl);

        curl_close($curl);

        if ($this->config->get('fedex_integration_debug')) {
            if ($curl_error) {
                $this->log->write('FedEx Integration Obtain Access Token Error: ' . var_export($response, true));
            } else {
                $this->log->write('FedEx Integration Obtain Access Token Response: ' . var_export($response, true));
            }
        }

        return $response;
    }
    
}