<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if ( !defined ( 'DIR_CORE' ) || !IS_ADMIN) {
    header ( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ControllerPagesExtensionFedexIntegration
 * @property ModelExtensionFedexIntegrationLicenseInfo $model_extension_fedex_integration_license_info
 */

class ControllerPagesExtensionFedexIntegration extends AController {
    private $error = [];
    public $data = [];
    private $errors = ['client_id', 'account', 'client_secret','country','city'];
    private $fields = [
        'fedex_integration_debug',
        'fedex_integration_client_id',
        'fedex_integration_account',
        'fedex_integration_client_secret',
        'fedex_integration_meter',
        'fedex_integration_city',
        'fedex_integration_postcode',
        'fedex_integration_state',
        'fedex_integration_country',
        'fedex_integration_test_connection' ,
        'fedex_integration_quote_type',
        'fedex_integration_pickupType',
        'fedex_integration_smart_post_hub_id',
        'fedex_integration_discount_rates',
        'fedex_integration_domestic_FIRST_OVERNIGHT',
        'fedex_integration_domestic_PRIORITY_OVERNIGHT',
        'fedex_integration_domestic_STANDARD_OVERNIGHT',
        'fedex_integration_domestic_FEDEX_2_DAY',
        'fedex_integration_domestic_FEDEX_EXPRESS_SAVER',
        'fedex_integration_domestic_FEDEX_GROUND',
        'fedex_integration_domestic_GROUND_HOME_DELIVERY',
        'fedex_integration_domestic_SMART_POST',
        'fedex_integration_intl_INTERNATIONAL_ECONOMY',
        'fedex_integration_intl_INTERNATIONAL_ECONOMY_FREIGHT',
        'fedex_integration_intl_INTERNATIONAL_FIRST',
        'fedex_integration_intl_INTERNATIONAL_PRIORITY',
        'fedex_integration_intl_INTERNATIONAL_PRIORITY_FREIGHT',
        'fedex_integration_intl_FEDEX_INTERNATIONAL_PRIORITY_PLUS',
        'fedex_integration_intl_FEDEX_INTERNATIONAL_PRIORITY_EXPRESS',
        'fedex_integration_intl_FEDEX_INTERNATIONAL_PRIORITY',
        'fedex_integration_intl_FEDEX_GROUND',
        'fedex_integration_local_zipcodes',
        'fedex_integration_local_delivery_fee',
        'fedex_integration_local_delivery_only',
        'fedex_integration_local_delivery_message',
        'fedex_integration_free_domestic_method',
        'fedex_integration_free_domestic_method',
        'fedex_integration_free_international_method',
        'fedex_integration_test',
        'fedex_integration_packaging',
        'fedex_integration_residential',
        'fedex_integration_display_weight',
        'fedex_integration_length',
        'fedex_integration_height',
        'fedex_integration_weight',
        'fedex_integration_width',
        'fedex_integration_tax_class_id',
        'fedex_integration_location_id',
        'fedex_integration_type',
        'fedex_integration_additional_fee',
        'fedex_integration_additional_weight',
        'fedex_integration_declared_value',
        'fedex_integration_declared_value_nominal',
        'fedex_integration_estimate_message',
    ];

    public function verify() {
        $store_id = $this->getStoreId();
        $settings = $this->model_setting_setting->getSetting('fedex_integration',$store_id);
        if ($settings['fedex_integration_status'] === '1') {
            $this->load->model('extension/fedex_integration_license_info');
            $license_key = $settings['fedex_integration_license_code'];
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('fedex_integration_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_fedex_integration_license_info->getStoreId();
                    $license_key = $this->model_extension_fedex_integration_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_fedex_integration_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'fedex_integration');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_fedex_integration_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

	public function verifyEditor() {
		if ( $this->config->get( 'editor_status' ) === '1' ) {
            $this->load->model('extension/editor_license_info');
            $license_key = $this->config->get('editor_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('editor_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_editor_license_info->getStoreId();
                    $license_key = $this->model_extension_editor_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_editor_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'editor');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_editor_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
		} else {
			return false;
		}
	}

    public function main() {
        $this->request->get['extension'] = 'fedex_integration';
        $this->loadLanguage('fedex_integration/fedex_integration');
        $this->loadLanguage('fedex_integration/fedex_integration');
        $this->document->setTitle( $this->language->get('text_additional_settings') );
        $this->load->model('setting/setting');

        if ( $this->request->is_POST() && $this->_validate() ) {
            $store_id = $this->getStoreId();
            $this->model_setting_setting->editSetting('fedex_integration', $this->request->post,$store_id);
            $this->session->data['success'] = $this->language->get('text_success');
            redirect($this->html->getSecureURL('extension/fedex_integration'));
        }

        if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }
        $this->data['success'] = $this->session->data['success'];
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        if (isset($this->error['key'])) {
            $this->data['error_key'] = $this->error['key'];
        } else {
            $this->data['error_key'] = '';
        }

        $this->data['error'] = [];
        foreach ( $this->errors as $f ) {
            if (isset ( $this->error[$f] )) {
                $this->data['error'][$f] = $this->error[$f];
            }
        }

        $this->document->initBreadcrumb( [
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ]);
        $this->document->addBreadcrumb( [
            'href'      => $this->html->getSecureURL('extension/extensions/shipping'),
            'text'      => $this->language->get('text_shipping'),
            'separator' => ' :: '
        ]);
        $this->document->addBreadcrumb( [
            'href'      => $this->html->getSecureURL('shipping/fedex_integration'),
            'text'      => $this->language->get('fedex_integration_name'),
            'separator' => ' :: ',
            'current' => true
        ]);

        $packages = [
            'FEDEX_BOX' => $this->language->get('text_packaging_box'),
            'FEDEX_PAK' => $this->language->get('text_packaging_pak'),
            'FEDEX_TUBE' => $this->language->get('text_packaging_tube'),
            'YOUR_PACKAGING' => $this->language->get('text_packaging_your_packaging'),
        ];

        $this->view->assign('addition_note',$this->language->get('fedex_integration_addition_note'));
        $this->view->assign('ext_text',$this->language->get('fedex_integration_ext_man'));
        $this->view->assign('ext_man','https://why2central.net/v1/fedex');

        $this->load->model('localisation/tax_class');
        $results = $this->model_localisation_tax_class->getTaxClasses();
        $tax_classes = [0 => $this->language->get ( 'text_none' )];
        foreach ( $results as $k => $v ) {
            $tax_classes[ $v['tax_class_id'] ] = $v['title'];
        }

        $this->load->model('localisation/location');
        $results = $this->model_localisation_location->getLocations();
        $locations = [0 => $this->language->get ( 'text_all_zones' )];
        foreach ( $results as $k => $v ) {
            $locations[ $v['location_id'] ] = $v['name'];
        }

        $store_id = $this->getStoreId();

        $settings = $this->model_setting_setting->getSetting('fedex_integration',$store_id);
        foreach ( $this->fields as $f ) {
            if (isset ( $this->request->post [$f] )) {
                $this->data [$f] = $this->request->post [$f];
            } else {
				$this->data [$f] = $settings[$f];
            }
        }

        $this->data ['action'] = $this->html->getSecureURL ( 'extension/fedex_integration', '&extension=fedex_integration' );
        $this->data['cancel'] = $this->html->getSecureURL('extension/extensions/shipping');
        $this->data ['heading_title'] = $this->language->get ( 'text_edit' ) . $this->language->get ( 'text_shipping' );
        $this->data ['form_title'] = $this->language->get ( 'heading_title' );
        $this->data ['update'] = $this->html->getSecureURL ( 'r/extension/fedex_integration_save/update' );

        $form = new AForm ( 'HS' );
        $form->setForm ( [
            'form_name' => 'editFrm',
            'update' => $this->data ['update'] ] );

        $this->data['form']['form_open'] = $form->getFieldHtml ( [
            'type' => 'form',
            'name' => 'editFrm',
            'action' => $this->data ['action'],
            'attr' => 'data-confirm-exit="true" class="aform form-horizontal"'
        ] );
        $this->data['form']['submit'] = $form->getFieldHtml ( [
            'type' => 'button',
            'name' => 'submit',
            'text' => $this->language->get ( 'button_save' )
        ] );
        $this->data['form']['cancel'] = $form->getFieldHtml ( [
            'type' => 'button',
            'name' => 'cancel',
            'text' => $this->language->get ( 'button_cancel' )
        ] );
        $this->data['form']['fields']['debug'] = $form->getFieldHtml([
            'type' => 'checkbox',
            'name' => 'fedex_integration_debug',
            'value' => $this->data['fedex_integration_debug'],
            'style'  => 'btn_switch',
        ]);
        $this->data['form']['fields']['test'] = $form->getFieldHtml([
            'type' => 'checkbox',
            'name' => 'fedex_integration_test',
            'value' => $this->data['fedex_integration_test'],
            'style'  => 'btn_switch',
        ]);
        $this->data['form']['fields']['client_id'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_client_id',
            'value' => $this->data['fedex_integration_client_id'],
            'required' => true,
            'style' => 'small-field',
        ]);
        $this->data['form']['fields']['client_secret'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_client_secret',
            'value' => $this->data['fedex_integration_client_secret'],
            'required' => true,
            'style' => 'small-field',
        ]);
        $this->data['form']['fields']['account'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_account',
            'value' => $this->data['fedex_integration_account'],
            'required' => true,
            'style' => 'small-field',
        ]);
        $pickupType=['CONTACT_FEDEX_TO_SCHEDULE','DROPOFF_AT_FEDEX_LOCATION','USE_SCHEDULED_PICKUP','ON_CALL','REGULAR_STOP'];
        $pickup =[];
        foreach ($pickupType as $k)
        {
            $pickup[$k]=$this->language->get('text_'.$k);
        }
        $this->data['form']['fields']['pickupType'] = $form->getFieldHtml([
            'type'    => 'selectbox',
            'name'    => 'fedex_integration_pickupType',
            'options' => $pickup,
            'value'   => $this->data['fedex_integration_pickupType'],
            'style' => 'medium-field',
        ]);
        $this->data['form']['fields']['packaging'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'fedex_integration_packaging',
            'options' => $packages,
            'value' => $this->data['fedex_integration_packaging'],
            'style' => 'small-field',
        ]);
        $this->data['form']['fields']['residential'] = $form->getFieldHtml([
            'type' => 'checkbox',
            'name' => 'fedex_integration_residential',
            'value' => $this->data['fedex_integration_residential'],
            'style'  => 'btn_switch',
        ]);
        $this->data['form']['fields']['city'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_city',
            'value' => $this->data['fedex_integration_city'],
            'required' => true,
            'style' => 'small-field',
        ]);
        $this->data['form']['fields']['postcode'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_postcode',
            'value' => $this->data['fedex_integration_postcode'],
            'required' => false,
            'style' => 'small-field',
        ]);
        $this->data['form']['fields']['state'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_state',
            'value' => $this->data['fedex_integration_state'],
            'required' => false,
            'style' => 'small-field',
        ]);
        $this->data['form']['fields']['country'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_country',
            'value' => $this->data['fedex_integration_country'],
            'required' => true,
            'style' => 'small-field',
        ]);

        $hub_id=[
            'NONE' => 'NONE',
            '5185' => '5185 ALPA Allentown',
            '5303' => '5303 ATGA Atlanta',
            '5281' => '5281 CHNC Charlotte',
            '5602' => '5602 CIIL Chicago',
            '5929' => '5929 COCA Chino',
            '5751' => '5751 DLTX Dallas',
            '5802' => '5802 DNCO Denver',
            '5481' => '5481 DTMI Detroit',
            '5087' => '5087 EDNJ Edison',
            '5431' => '5431 GCOH Grove City',
            '5771' => '5771 HOTX Houston',
            '5465' => '5465 ININ Indianapolis',
            '5648' => '5648 KCKS Kansas City',
            '5902' => '5902 LACA Los Angeles',
            '5254' => '5254 MAWV Martinsburg',
            '5379' => '5379 METN Memphis',
            '5552' => '5552 MPMN Minneapolis',
            '5531' => '5531 NBWI New Berlin',
            '5110' => '5110 NENY Newburgh',
            '5015' => '5015 NOMA Northborough',
            '5327' => '5327 ORFL Orlando',
            '5194' => '5194 PHPA Philadelphia',
            '5854' => '5854 PHAZ Phoenix',
            '5150' => '5150 PTPA Pittsburgh',
            '5958' => '5958 SACA Sacramento',
            '5843' => '5843 SCUT Salt Lake City',
            '5983' => '5983 SEWA Seattle',
            '5631' => '5631 STMO St. Louis'
        ];
        $this->data['form']['fields']['smart_post_hub_id'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'fedex_integration_smart_post_hub_id',
            'value' => $this->data['fedex_integration_smart_post_hub_id'],
            'options' => $hub_id,
            'style' => 'small-field',
        ]);

        $this->data['form']['fields']['discount_rates'] = $form->getFieldHtml([
            'type' => 'checkbox',
            'name' => 'fedex_integration_discount_rates',
            'value' => $this->data['fedex_integration_discount_rates'],
            'style'  => 'btn_switch',
        ]);
        $this->data['form']['fields']['test_connection'] = $form->getFieldHtml([
            'type' => 'button',
            'name' => 'test_connection',
            'title' => $this->language->get('entry_test_connect'),
            'text' => $this->language->get('entry_test_connect'),
            'required' => true,
            'style' => 'btn btn-info lock-on-click',
        ]);
        $this->data['test']=$this->language->get(('entry_test'));
        $this->data['test_url']=$this->html->getSecureURL('r/extension/fedex_test/test');
        //US
        $domestic = ['FIRST_OVERNIGHT','PRIORITY_OVERNIGHT','STANDARD_OVERNIGHT','FEDEX_2_DAY','FEDEX_EXPRESS_SAVER','FEDEX_GROUND','GROUND_HOME_DELIVERY','SMART_POST'];
        $this->data['form']['fields']['domestic'] = [];
        $options = [];
        foreach ( $domestic as $i ) {
            $title = 'domestic_'.$i;
            $name = 'fedex_integration_domestic_'.$i;
            $this->data['form']['fields']['domestic'][$title] = $form->getFieldHtml([
                'type' => 'checkbox',
                'name' => $name,
                'style' => 'btn_switch',
                'value' => $this->data[$name],
            ]);
            $options['NONE']="NONE";
            $options[$title] = $this->language->get('text_' . $title);
        }

        $this->data['form']['fields']['local_zipcodes'] = $form->getFieldHtml([
            'type'    => 'textarea',
            'name'    => 'fedex_integration_local_zipcodes',
            'value'   => $this->data['fedex_integration_local_zipcodes'],
        ]);

        $this->data['form']['fields']['local_delivery_fee'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_local_delivery_fee',
            'value' => $this->data['fedex_integration_local_delivery_fee'],
            'required' => true,
            'style' => 'small-field',
        ]);

        $this->data['form']['fields']['local_delivery_only'] = $form->getFieldHtml([
            'type' => 'checkbox',
            'name' => 'fedex_integration_local_delivery_only',
            'value' => $this->data['fedex_integration_local_delivery_only'],
            'style'  => 'btn_switch',
        ]);

        $this->data['form']['fields']['local_delivery_message'] = $form->getFieldHtml([
                'type' => 'texteditor',
                'name' => 'fedex_integration_local_delivery_message',
                'value' => $this->data['fedex_integration_local_delivery_message'],
                'style' => 'xl-field',
        ]);

        $this->data['form']['fields']['free_domestic_method'] = $form->getFieldHtml([
            'type'    => 'selectbox',
            'name'    => 'fedex_integration_free_domestic_method',
            'options' => $options,
            'value'   => $this->data['fedex_integration_free_domestic_method'],
            'style' => 'small-field',
        ]);

        $international = ['INTERNATIONAL_ECONOMY',
            'INTERNATIONAL_ECONOMY_FREIGHT',
            'INTERNATIONAL_FIRST',
            'INTERNATIONAL_PRIORITY',
            'INTERNATIONAL_PRIORITY_FREIGHT',
            'FEDEX_INTERNATIONAL_PRIORITY_PLUS',
            'FEDEX_INTERNATIONAL_PRIORITY_EXPRESS',
            'FEDEX_INTERNATIONAL_PRIORITY',
            'FEDEX_GROUND'];

        $this->data['form']['fields']['international'] = [];
        $options = [];
        foreach ( $international as $i ) {
            $title = 'intl_'.$i;
            $name = 'fedex_integration_intl_'.$i;
            $this->data['form']['fields']['international'][$title] = $form->getFieldHtml([
                'type' => 'checkbox',
                'name' => $name,
                'style' => 'btn_switch',
                'value' => $this->data[$name],
            ]);
            $options['NONE']="NONE";
            $options[$title] = $this->language->get('text_' . $title);
        }

        $this->data['form']['fields']['free_international_method'] = $form->getFieldHtml([
            'type'    => 'selectbox',
            'name'    => 'fedex_integration_free_international_method',
            'options' => $options,
            'value'   => $this->data['fedex_integration_free_international_method'],
            'style' => 'small-field',
        ]);

        $this->data['form']['fields']['display_weight'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'fedex_integration_display_weight',
            'value' => $this->data['fedex_integration_display_weight'],
            'options' => [
                1 => $this->language->get ( 'text_yes' ),
                0 => $this->language->get ( 'text_no' ),
            ],
            'style' => 'small-field',
        ]);

        $this->data['form']['fields']['length'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_length',
            'value' => $this->data['fedex_integration_length'],
            'style' => 'small-field',
        ]);
        $this->data['form']['fields']['width'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_width',
            'value' => $this->data['fedex_integration_width'],
            'style' => 'small-field',
        ]);

        $this->data['form']['fields']['height'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_height',
            'value' => $this->data['fedex_integration_height'],
            'style' => 'small-field',
        ]);
        $this->data['form']['fields']['weight'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_weight',
            'value' => $this->data['fedex_integration_weight'],
            'style' => 'small-field',
        ]);
        $this->data['form']['fields']['tax'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'fedex_integration_tax_class_id',
            'options' => $tax_classes,
            'value' => $this->data['fedex_integration_tax_class_id'],
            'style' => 'small-field',
        ]);
        $this->data['form']['fields']['location'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'fedex_integration_location_id',
            'options' => $locations,
            'value' => $this->data['fedex_integration_location_id'],
            'style' => 'small-field',
        ]);
        $optType=[];
        $opt=['fixed','percent'];
        foreach ($opt as $ot)
        {
            $title=$ot;
            $optType[$title]=$this->language->get('text_' . $ot);
        }
        $this->data['form']['fields']['type'] = $form->getFieldHtml([
            'type'    => 'selectbox',
            'name'    => 'fedex_integration_type',
            'options' => $optType,
            'value'   => $this->data['fedex_integration_type'],
            'style' => 'small-field',
        ]);
        $this->data['form']['fields']['additional_fee'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_additional_fee',
            'value' => moneyDisplayFormat($this->data['fedex_integration_additional_fee']),
            'style' => 'small-field',
        ]);

        $this->data['form']['fields']['additional_weight'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_additional_weight',
            'value' => $this->data['fedex_integration_additional_weight'],
            'style' => 'small-field',
        ]);

        $this->data['form']['fields']['declared_value'] = $form->getFieldHtml([
            'type' => 'checkbox',
            'name' => 'fedex_integration_declared_value',
            'value' => $this->data['fedex_integration_declared_value'],
            'style'  => 'btn_switch',
        ]);
        $this->data['form']['fields']['declared_value_nominal'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'fedex_integration_declared_value_nominal',
            'value' => $this->data['fedex_integration_declared_value_nominal'],
            'style' => 'small-field',
        ]);
        $this->data['form']['fields']['estimate_message'] = $form->getFieldHtml([
                'type' => 'texteditor',
                'name' => 'fedex_integration_estimate_message',
                'value' => $this->data['fedex_integration_estimate_message'],
                'style' => 'xl-field',
        ]);

        $this->view->batchAssign (  $this->language->getASet () );

        $this->addChild('responses/common/resource_library/get_resources_html', 'resources_html', 'responses/common/resource_library_scripts.tpl');
        $resources_scripts = $this->dispatch(
            'responses/common/resource_library/get_resources_scripts',
            [
                'object_name' => '',
                'object_id' => '',
                'types' => ['image'],
            ]
        );
        $this->data['resources_scripts'] =  $resources_scripts->dispatchGetOutput();

        //load tabs controller
	    $this->data['editorLicense'] = $this->verifyEditor();
        $this->data['editor']=$this->config->get('editor_status');
	    $this->data['license_status']  = $this->verify();
	    $this->data['text_unauthorized'] = $this->language->get( 'text_fedex_integration_unauthorized' );
	    $this->data['groups'][] = 'additional_settings';
        $this->data['link_additional_settings'] = $this->data['add_sett']->href;
        $this->data['active_group'] = 'additional_settings';

        $tabs_obj = $this->dispatch('pages/extension/extension_tabs', [ $this->data ] );
        $this->data['tabs'] = $tabs_obj->dispatchGetOutput();
        unset($tabs_obj);

        $obj = $this->dispatch('pages/extension/extension_summary', [ $this->data ] );
        $this->data['extension_summary'] = $obj->dispatchGetOutput();
        unset($obj);
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());

        $this->view->batchAssign( $this->data );
        $this->processTemplate('pages/extension/fedex_integration.tpl' );
    }

    private function _validate() {
        $this->load->language('fedex_integration/fedex_integration');
        if (!$this->user->canModify('shipping/fedex')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->request->post['fedex_integration_account']) {
            $this->error['account'] = $this->language->get('error_account');
        }

        if (!$this->request->post['fedex_integration_client_id']) {
            $this->error['client_id'] = $this->language->get('error_client_id');
        }

        if (!$this->request->post['fedex_integration_client_secret']) {
            $this->error['client_secret'] = $this->language->get('error_client_secret');
        }

        if (!$this->request->post['fedex_integration_country']) {
            $this->error['country'] = $this->language->get('error_country');
        }

        if (!$this->request->post['fedex_integration_city']) {
            $this->error['city'] = $this->language->get('error_city');
        }

        if (!$this->error) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}