
<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

$check1= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_values')." where field='store_id'";
$q1=$this->db->query($check1);
$exist1=count($q1->rows);
if ($exist1==0) {
    $sql12 = "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_values')." ADD `store_id` INT(11) COLLATE utf8_general_ci AFTER `custom_email`";
    $this->db->query($sql12);
}

$check2= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_info')." where field='store_id'";
$q2=$this->db->query($check2);
$exist2=count($q2->rows);
if ($exist2==0) {
    $sql13 = "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_info')." ADD `store_id` INT(11) COLLATE utf8_general_ci AFTER `expire_date`";
    $this->db->query($sql13);
}

$check3= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_values')." where field='upload_later'";
$q3=$this->db->query($check3);
$exist3=count($q3->rows);
if ($exist3==0) {
    $sql13 = "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_values')." ADD `upload_later` CHAR(1) COLLATE utf8_general_ci AFTER `custom_email`";
    $this->db->query($sql13);
}

$check4= "SHOW columns from ".$this->db->table('customer_group_auto_assigned_info')." where field='upload_later'";
$q4=$this->db->query($check4);
$exist4=count($q4->rows);
if ($exist4==0) {
    $sql14 = "ALTER TABLE ".$this->db->table('customer_group_auto_assigned_info')." ADD `upload_later` CHAR(1) COLLATE utf8_general_ci AFTER `expire_date`";
    $this->db->query($sql14);
}

$sql5 = "SELECT `store_id` FROM " . $this->db->table("stores");
$query5 = $this->db->query($sql5);
$results5 = $query5->rows;

if (file_exists(DIR_EXT.'email_editor') && $this->config->get('email_editor_status')) {

    $sql2='CREATE TABLE IF NOT EXISTS ' . $this->db->table('email_editor_customer_group') . ' (
`email_editor_customer_group_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
`email_template_id` int(11),
`customer_group_id` int(11),
`section_name` VARCHAR(256)
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci';

    $this->db->query($sql2);

    foreach ($results5 as $result) {
        $store_id = $result["store_id"];

        $query_customer_groups = $this->db->query("SELECT * FROM " . $this->db->table("customer_groups"));
        $customer_groups = $query_customer_groups->rows;
        foreach ($customer_groups as $cust_group) {
            $search = [" ", "'",];
            $replace = "_";
            $section = str_replace($search, $replace, strtolower($cust_group['name']));

            $account_activated_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_create' AND `store_id`=".$store_id);
            if ($account_activated_exist->row['total'] === '0') {
                $account_activated = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_create'");
                $account_activated_info = $account_activated->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                          SET `section` = '" . $section . "_account_create', 
                          `sender_name`='" . $account_activated_info['sender_name'] . "',`sender_email`='" . $account_activated_info['sender_email'] . "',`subject`='" . $account_activated_info['subject'] . "', 
                          `default_subject`='" . $account_activated_info['default_subject'] . "',
                          `content` = '" . $account_activated_info['content'] . "', 
                          `default_content` = '" . $account_activated_info['default_content'] . "',`email_signature_id` = '" . $account_activated_info['email_signature_id'] . "',
                          `notify_admin`='" . $account_activated_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_create_email_id = $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_create_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            }

            $account_approval_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_approval' AND `store_id`=".$store_id);
            if ($account_approval_exist->row['total'] === '0') {
                $account_approval = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_approval'");
                $account_approval_info = $account_approval->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                          SET `section` = '" . $section . "_account_approval', 
                          `sender_name`='" . $account_approval_info['sender_name'] . "',`sender_email`='" . $account_approval_info['sender_email'] . "',`subject`='" . $account_approval_info['subject'] . "', 
                          `default_subject`='" . $account_approval_info['default_subject'] . "',
                          `content` = '" . $account_approval_info['content'] . "', 
                          `default_content` = '" . $account_approval_info['default_content'] . "',`email_signature_id` = '" . $account_approval_info['email_signature_id'] . "',
                          `notify_admin`='" . $account_approval_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_approval_email_id =  $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_approval_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            }
            $account_activation_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_activation' AND `store_id`=".$store_id);
            if ($account_activation_exist->row['total'] === '0') {
                $account_activation = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_activation'");
                $account_activation_info = $account_activation->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                          SET `section` = '" . $section . "_account_activation', 
                          `sender_name`='" . $account_activation_info['sender_name'] . "',`sender_email`='" . $account_activation_info['sender_email'] . "',`subject`='" . $account_activation_info['subject'] . "', 
                          `default_subject`='" . $account_activation_info['default_subject'] . "',
                          `content` = '" . $account_activation_info['content'] . "', 
                          `default_content` = '" . $account_activation_info['default_content'] . "',`email_signature_id` = '" . $account_activation_info['email_signature_id'] . "',
                          `notify_admin`='" . $account_activation_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_activation_email_id =  $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_activation_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            }

        }
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_create_info'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_create_subject'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_create_content'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_activation_info'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_activation_subject'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_activation_content'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_approval_info'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_approval_subject'");
        $this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_".$section."_account_approval_content'");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_create_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_create_subject','Account Create Email Subject:',now(),now())");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_create_content','Account Create Email Content:',now(),now())");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_activation_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {activate_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_activation_subject','Account Activation Email Subject:',now(),now())");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_activation_content','Account Activation Email Content:',now(),now())");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_approval_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_approval_subject','Account Needs Approval Email Subject:',now(),now())");

        $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_".$section."_account_approval_content','Account Needs Approval Email Content:',now(),now())");

    }
}

$sql = "UPDATE ".$this->db->table('language_definitions')." set language_value='
       This is a WHY2 extension.  All support and updates are managed from WHY2. <br>
        Read about WHY2\'s 12 months support <a href=\"https://why2central.net/knowledgebase/why2-support-and-updates-policy/\" target=\"_blank\" style=\"font-weight:bold;\">here</a> and how WHY2 updates are delivered <a href=\"https://why2central.net/knowledgebase/extension-updater/\" target=\"_blank\" style=\"font-weight:bold;\">here</a>.<br>
        You can safely ignore Support expired notification within the Admin Dashboard.<br><br>
       This extension helps you to auto assign a customer to the desired customer group when they register their account.
     This can be beneficial if you have wholesalers or non-profits  who will need tax exemption documents on file,  or a group of customers that you want to offer specials too, perhaps students or crafters or something else that will benefit your business model.  Using Customer Group Auto Assign gives you the ability to have unique registration page for each customer group that will assign those at  registration to the preferred group.
     <ul>
     <li>Each  customer group has fields for Exempt from all Taxes,  Approve New Customers, Email Activation for New Customers, Upload Tax Exemption Certificate, and the ability to use a separate email template with specific message for that group.</li>
     <li>You can allow customers to upload their tax exemption certificate and set the expiration date,  if there is one.   Admins (store owners) can manage them easily via the built-in tax exemption list.</li>
     <li>Customer can update their tax exemption certificate via customer information. They will see their latest uploaded certificate while the old ones are not removed from your server.</li>
     <li>You can use custom email template that was copied from the default email template so you can send different message if needed.</li>
     <li>There is no limit to the number of customer groups you can add to your store.</li>
     </ul><br>
<strong>Notes: There are two ways to obtain the license key. <br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;a. Use this <a href=\"https://wehearyou2.com/clientarea/reg/register.php\" target=\"_blank\" style=\"font-weight:bold;\">form</a> to register to our Support system and generate your license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;b. Already registered -  click <a href=\"https://wehearyou2.com/clientarea/reg/index.php\" target=\"_blank\" style=\"font-weight:bold;\">here</a> to log into your account to obtain license key.<br>
        Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to obtain the license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;c. If you already have an account in our support system and you are using multiple extensions from WHY2,  you do NOT need to create another account in the support system.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;d. Updating extension in same location does NOT require a new key.<br> Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to Update extension in same location.</strong><br><br>
	Enter your WHY2 license key here.' WHERE language_key='customer_group_auto_assigned_note';";
$this->db->query($sql);

$sql1 = "UPDATE ".$this->db->table('language_definitions')." set language_value='Enter your WHY2 license key:' WHERE language_key='customer_group_auto_assigned_license_code';";
$this->db->query($sql1);


$sql3 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("customer_group_auto_assigned_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql3);

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_additional_fields'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_allow_upload_later'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='column_upload_later'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_no'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_yes'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='button_diy_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='button_mc_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_update_customer_group_auto_assigned_available'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='customer_group_auto_assigned_license_expired'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='error_upload_type'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='error_upload_certificate'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_date_format'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_upload_tax_exemption'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='entry_customer_group_name'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_additional_fields','If you are Tax Exempt',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','entry_allow_upload_later','Allow tax exempt certificate to be uploaded later: <span class=\"help\">Turn ON if you want to allow customer upload the tax exempt certificate later.</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','column_upload_later','Upload after account created',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_no','No',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_yes','Yes',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','entry_upload_later','Will upload after account created',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_support_by_why2','Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','button_diy_support_by_why2','If you are self-managed users click here for support. Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','button_mc_support_by_why2','If you are a WHY2 Managed Client click here for support. Updates are part of the Managed Services.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','text_update_customer_group_auto_assigned_available','New version (%s) is available. <a href=\"%s\" target=\"_BLANK\"><strong>Click to update now.</strong></a>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','customer_group_auto_assigned_license_expired','Your license key is expired. Possibly due to inactive with the extension for more than 14 days. Please click on the SAVE button at the bottom of this page.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','error_upload_type','Use formats:  png, jpg, gif or PDF.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','error_upload_certificate','You need to upload tax exempt certificate!',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','entry_date_format','Use the following date format: ',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','entry_upload_tax_exemption','Upload your tax exemption certificate: (PNG, JPG, GIF or PDF)',now(),now())");

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='breadcrumb_customer_groups'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='breadcrumb_edit_group'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_customer_group_auto_assigned_settings'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='tab_general'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='customer_group_auto_assigned_customer_group_auto_assigned' AND `language_key`='text_checkout_settings_note'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','customer_group_auto_assigned_customer_group_auto_assigned','breadcrumb_customer_groups','Customer Groups',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','breadcrumb_edit_group','Edit Customer Group',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_customer_group_auto_assigned_settings','Customer Group Auto Assigned Settings',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','tab_general','General',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','text_checkout_settings_note','<strong>Notes: Check your Settings > Checkout [here] to make sure that you set the correct settings if you want to restrict customers from being able to login until they are approved or they have confirm their account.</strong>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','customer_group_auto_assigned_customer_group_auto_assigned','entry_customer_group_name','Customer Group Name: ',now(),now())");

$exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('customer_group_auto_assigned_license') . "'");
if ($exist->num_rows === 1) {
    $this->db->query("DROP TABLE ".$this->db->table("customer_group_auto_assigned_license"));
}

if (file_exists(DIR_EXT.'customer_group_auto_assigned/admin/view/default/template/pages/extension/extensions_edit.tpl')) {
    unlink(DIR_EXT.'customer_group_auto_assigned/admin/view/default/template/pages/extension/extensions_edit.tpl');
}


$mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
$diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
$shared_secret = "customer_group_auto_assigned";

$public_key = "";
$path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

if ($this->config->get('customer_group_auto_assigned_license_code')) {
    $license_key = $this->config->get('customer_group_auto_assigned_license_code');
    $license = new License($path_to_phpseclib);
    $license_manager = $license->getManager();
    if (stripos($license_key, 'mc-') !== false) {
        $server_url = $mc_server_url;
    } else {
        $server_url = $diy_server_url;
    }
    $license_manager->setLicenseServerUrl($server_url);
    $license_manager->setKeys($license_key, "", $shared_secret);
    $public_key = $license_manager->requestKey();
    $this->load->model('extension/customer_group_auto_assigned_license_info');

    $store_id = (int)$this->config->get('config_store_id');

    $license_manager->setKeys($license_key, $public_key, $shared_secret);
    $custom_data = ['version' => '1.3.3.2'];
    $license_data = $license_manager->requestData($custom_data);
    if (!is_null($license_data)) {
        $ttl = 1209600;
        $validate = $license_manager->validate($license_data, $ttl);

        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
            $data['public_key'] = $public_key;
            $data['license_data'] = $license_data;
            $data['license_key'] = $license_key;
            $data['store_id'] = $store_id;
            $data['last_check'] = time();
            $this->load->model('extension/customer_group_auto_assigned_license_info');
            $this->model_extension_customer_group_auto_assigned_license_info->saveLicenseData($data);
        }
    }
}

if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = [];
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'customer_group_auto_assigned' . DIR_EXT_CORE . 'lib', DIR_SYSTEM.'lib');
}