<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

class ModelExtensionCustomerGroupAutoAssigned extends Model {


    /**
     * @param $customer_group_id
     * @return mixed
     * @throws AException
     */
    public function getValues($customer_group_id) {
        $store_id = $this->getStoreId();
        $query = $this->db->query("SELECT cgaa.*,cg.name as customer_group_name FROM ". $this->db->table("customer_group_auto_assigned_values") . " cgaa
                                   LEFT JOIN ". $this->db->table("customer_groups") . " cg ON cg.customer_group_id=cgaa.customer_group_id
                                   WHERE cgaa.customer_group_id=".(int)$customer_group_id. " AND cgaa.store_id=".$store_id);
        return $query->row;
    }

    /**
     * @param $data
     * @throws AException
     */
    public function addInfo($data) {
        $expire_date = '';
        $store_id = $this->getStoreId();
        if ($data['expiration_date'] && $data['expire']==='1') {
            $expire_date = date_create($data['expiration_date'])->format('Y-m-d');
        } else {
            $expire_date = '0000-00-00';
        }
        $this->db->query("INSERT INTO ".$this->db->table('customer_group_auto_assigned_info') ." SET `customer_group_id`=".(int)$data['customer_group_id']."
                         ,`customer_id`=".$data['customer_id'].",`image_url`='".$data['image_url']."',`upload_later`='".$data['upload_later']."',`uploaded_at`=NOW(),`expire`='".$data['expire']."',`expire_date`='".$expire_date."',`store_id`=".$store_id);
    }

    /**
     * @param $customer_id
     * @return mixed
     * @throws AException
     */
    public function getImage($customer_id) {
        $query = $this->db->query("SELECT * FROM ".$this->db->table('customer_group_auto_assigned_info') ." WHERE `customer_id`=".(int)$customer_id. " ORDER BY uploaded_at DESC LIMIT 1");
        return $query->row;
    }

    /**
     * @param $email
     * @param $activated
     * @param $custom_email
     * @return bool|null
     * @throws AException
     */
    public function sendWelcomeEmail($email, $activated,$custom_email) {
        if (!$email) {
            return null;
        }
        //build welcome email in text format
        $login_url = $this->html->getSecureURL('account/login');
        $this->language->load('mail/account_create');
        $languageId = $this->language->getLanguageID();

        if ($activated) {
            if ($custom_email) {
                $template = 'custgroup_storefront_welcome_email_activated';
            } else {
                $template = 'storefront_welcome_email_activated';
            }
        } else {
            if ($custom_email) {
                $template = 'custgroup_storefront_welcome_email_approval';
            } else {
                $template = 'storefront_welcome_email_approval';
            }
        }

        $this->data['mail_template_data']['login_url'] = $login_url;

        $mailLogo = $this->config->get('config_mail_logo_'.$languageId)
            ? : $this->config->get('config_mail_logo');
        $mailLogo = $mailLogo ? : $this->config->get('config_logo_'.$languageId);
        $mailLogo = $mailLogo ? : $this->config->get('config_logo');

        if ($mailLogo) {
            $result = getMailLogoDetails($mailLogo);
            $this->data['mail_template_data']['logo_uri'] = $result['uri'];
            $this->data['mail_template_data']['logo_html'] = $result['html'];
        }

        $this->data['mail_template_data']['config_mail_logo'] = $mailLogo;

        $this->data['mail_template_data']['store_name'] = $this->config->get('store_name');
        $this->data['mail_template_data']['store_url'] =
            $this->config->get('config_url').$this->config->get('seo_prefix');
        $this->data['mail_template_data']['text_project_label'] = project_base();

        //allow to change email data from extensions
        $this->extensions->hk_ProcessData($this, 'sf_account_welcome_mail');

        $this->_send_email($email, $template, $this->data['mail_template_data']);

        return true;
    }

    /**
     * @param $customer_id
     * @param $custom_email
     * @return bool|null
     * @throws AException
     */
    public function emailActivateLink($customer_id,$custom_email) {
        if (!$customer_id) {
            return null;
        }
        $languageId = $this->language->getLanguageID();
        $customer_data = $this->getCustomer($customer_id);

        //encrypt token and data
        $enc = new AEncryption($this->config->get('encryption_key'));
        $code = genToken();
        //store activation code
        $customer_data['data']['email_activation'] = $code;
        $this->updateOtherData($customer_id, $customer_data['data']);

        $ac = $enc->encrypt($customer_id.'::'.$code);
        $activate_url = $this->html->getSecureURL('account/login', '&ac='.$ac);

        //build welcome email
        $this->language->load('mail/account_create');

        $this->data['mail_template_data']['activate_url'] = '<a href="'.$activate_url.'">'.$activate_url.'</a>';

        $mailLogo = $this->config->get('config_mail_logo_'.$languageId)
            ? : $this->config->get('config_mail_logo');
        $mailLogo = $mailLogo ? : $this->config->get('config_logo_'.$languageId);
        $mailLogo = $mailLogo ? : $this->config->get('config_logo');

        if ($mailLogo) {
            $result = getMailLogoDetails($mailLogo);
            $this->data['mail_template_data']['logo_uri'] = $result['uri'];
            $this->data['mail_template_data']['logo_html'] = $result['html'];
        }

        $this->data['mail_template_data']['config_mail_logo'] = $mailLogo;

        $this->data['mail_template_data']['store_name'] = $this->config->get('store_name');
        $this->data['mail_template_data']['store_url'] =
            $this->config->get('config_url').$this->config->get('seo_prefix');
        $this->data['mail_template_data']['text_project_label'] = project_base();

        if ($custom_email) {
          $template = 'custgroup_storefront_send_activate_link';
        } else {
          $template = 'storefront_send_activate_link';
        }

        //allow to change email data from extensions
        $this->extensions->hk_ProcessData($this, 'sf_account_activation_mail');

        $this->_send_email($customer_data['email'], $template, $this->data['mail_template_data']);

        return true;
    }

    /**
     * @param $customer_id
     * @param $data
     *
     * @return bool
     * @throws AException
     */
    public function updateOtherData($customer_id, $data) {
        $customer_id = (int) $customer_id;
        if (!$customer_id) {
            return false;
        }
        $this->db->query(
            "UPDATE ".$this->db->table("customers")."
           SET data = '".$this->db->escape(serialize($data))."'
           WHERE customer_id = '".$customer_id."'"
        );
        return true;
    }

    /**
     * @param int $customer_id
     *
     * @return array
     * @throws AException
     */
    public function getCustomer($customer_id) {
        $query = $this->db->query(
            "SELECT *
            FROM ".$this->db->table("customers")."
            WHERE customer_id = '".(int) $customer_id."'"
        );
        $result_row = $this->dcrypt->decrypt_data($query->row, 'customers');
        $result_row['data'] = unserialize($result_row['data']);
        return $result_row;
    }

    /**
     * @param string $email
     * @param string $template
     * @param array $data
     *
     * @throws AException
     */
    protected function _send_email($email, $template, $data) {
        $mail = new AMail($this->config);
        $mail->setTo($email);
        $mail->setFrom($this->config->get('store_main_email'));
        $mail->setSender($this->config->get('store_name'));

        $mail->setTemplate($template, $data);

        if (is_file(DIR_RESOURCE.$data['config_mail_logo'])) {
            $mail->addAttachment(
                DIR_RESOURCE.$data['config_mail_logo'],
                md5(pathinfo($data['config_mail_logo'], PATHINFO_FILENAME))
                .'.'.pathinfo($data['config_mail_logo'], PATHINFO_EXTENSION)
            );
        }
        $mail->send();
    }

    public function getStoreId() {
        $store_id = (int)$this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int)$this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int)$this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}