<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * ModelExtensionCustomerGroupAutoAssigned
 */
class ModelExtensionCustomerGroupAutoAssigned extends Model {

    /**
     * @param $customer_group_id
     * @param $data
     * @throws AException
     */
	public function addValues($customer_group_id,$data) {
        $store_id = $this->getStoreId();
	    $this->removeValue($customer_group_id);
		$this->db->query("INSERT INTO ".$this->db->table('customer_group_auto_assigned_values')." SET `customer_group_id`=".(int)$customer_group_id.",`activated`='".$data['activated']."',`admin_approval`='".$data['admin_approval']."',
		                 `email_activation`='".$data['email_activation']."',`upload_tax_exemption`='".$data['upload_tax_exemption']."',`custom_email`='".$data['custom_email']."',`upload_later`='".$data['upload_later']."',`store_id`=".$store_id);
	}

    /**
     * @param $customer_group_id
     * @param $data
     * @throws AException
     */
    public function updateValues($customer_group_id,$data) {
        $store_id = $this->getStoreId();
        $exist = $this->getValues($customer_group_id);

        $fields = ['activated','admin_approval', 'email_activation', 'upload_tax_exemption', 'custom_email','upload_later'];
        $update = [];
        foreach ($fields as $f) {
            if (isset($data[$f])) {
                $update[] = $f . " = '" . $data[$f] . "'";
            }
        }

        if (!empty($update)) {
            if ($exist) {
                $this->db->query(
                    "UPDATE " . $this->db->table("customer_group_auto_assigned_values") . " 
                        SET " . implode(',', $update) . " 
                        WHERE customer_group_id = '" . (int)$customer_group_id . "' AND store_id=".$store_id
                );
            } else {
                $update['store_id'] = 'store_id='.$this->getStoreId();
                $this->db->query(
                    "INSERT INTO " . $this->db->table("customer_group_auto_assigned_values") . " 
                        SET " . implode(',', $update) . " 
                         ,customer_group_id = '" . (int)$customer_group_id . "'"
                );
            }
        }
    }

    /**
     * @param $customer_group_id
     * @return mixed
     * @throws AException
     */
    public function getValues($customer_group_id) {
        $store_id = $this->getStoreId();
        $query = $this->db->query("SELECT * FROM ". $this->db->table("customer_group_auto_assigned_values") . " WHERE `customer_group_id`=".(int)$customer_group_id." AND `store_id`=".$store_id);
        return $query->row;
    }

    /**
     * @param $customer_group_id
     * @throws AException
     */
    public function removeValue($customer_group_id) {
        $store_id = $this->getStoreId();
        $this->db->query("DELETE FROM ". $this->db->table("customer_group_auto_assigned_values") . " WHERE `customer_group_id`=".(int)$customer_group_id." AND `store_id`=".$store_id);
    }

    /**
     * @param $customer_id
     * @return mixed
     * @throws AException
     */
    public function getInfo($customer_id) {
	    $query = $this->db->query("SELECT * FROM ".$this->db->table('customer_group_auto_assigned_info') ." WHERE `customer_id`=".(int)$customer_id);
	    return $query->row;
    }

    /**
     * @param array $data
     *
     * @return array|null
     */
    public function getTotalTaxExemptList($data = [])  {
        return $this->getTaxExemptList($data, 'total_only');
    }

    public function getTaxExemptList($data = [], $mode = 'default') {
        if (!empty($data['content_language_id'])) {
            $language_id = ( int )$data['content_language_id'];
        } else {
            $language_id = (int)$this->config->get('storefront_language_id');
        }

        $store_id = $this->getStoreId();

        if ($data || $mode == 'total_only') {
            $filter = (isset($data['filter']) ? $data['filter'] : []);

            if ($mode == 'total_only') {
                $sql = "SELECT COUNT(*) as total
						FROM ".$this->db->table("customer_group_auto_assigned_info")." info 
                       LEFT JOIN ".$this->db->table("customers")." c ON c.customer_id=info.customer_id
                       LEFT JOIN ".$this->db->table("addresses")." addr ON c.customer_id=addr.customer_id AND addr.address_id = c.address_id";
            } else {
                $sql = "SELECT info.*,CONCAT(c.firstname,' ',c.lastname) as customer_name,addr.company FROM ".$this->db->table("customer_group_auto_assigned_info")." info 
                       LEFT JOIN ".$this->db->table("customers")." c ON c.customer_id=info.customer_id
                       LEFT JOIN ".$this->db->table("addresses")." addr ON c.customer_id=addr.customer_id AND addr.address_id = c.address_id
                       ";
            }

            $sql .= " WHERE 1 AND info.store_id=".$store_id;

            if (isset($filter['customer_id']) && $filter['customer_id']!=='none') {
                $sql .= " AND c.customer_id = ".$filter['customer_id'];
            }

            if (isset($filter['company']) && $filter['company']!=='none') {
                if ($filter['company']==='empty') {
                    $sql .= ' AND addr.company = ""';
                } else {
                    $sql .= ' AND addr.company = "'.$filter['company'].'"';
                }
            }

            if (!empty($filter['filter_date_start'])) {
                $deliver_start = date_create($filter['filter_date_start'])->format('Y-m-d');
                $sql .= " AND DATE(info.uploaded_at) >= DATE('" . $deliver_start . "')";
            }
            if (!empty($filter['filter_date_end'])) {
                $deliver_end = date_create($filter['filter_date_end'])->format('Y-m-d');
                $sql .= " AND DATE(info.uploaded_at) <= DATE('" . $deliver_end . "')";
            }

            //If for total, we done building the query
            if ($mode == 'total_only') {
                $query = $this->db->query($sql);
                return $query->row['total'];
            }

            $sort_data = [
                'name'          => 'customer_name',
                'company'       => 'company',
                'uploaded_at'   => 'info.uploaded_at',
                'expire'        => 'info.expire',
                'expire_date'   => 'info.expire_date',
                'upload_later'  => 'info.upload_later'
            ];

            if (isset($data['sort']) && in_array($data['sort'], array_keys($sort_data))) {
                $sql .= " ORDER BY ".$sort_data[$data['sort']];
            } else {
                $sql .= " ORDER BY customer_name";
            }

            if (isset($data['order']) && ($data['order'] == 'DESC')) {
                $sql .= " DESC";
            } else {
                $sql .= " ASC";
            }

            if (isset($data['start']) || isset($data['limit'])) {
                if ($data['start'] < 0) {
                    $data['start'] = 0;
                }

                if ($data['limit'] < 1) {
                    $data['limit'] = 20;
                }

                $sql .= " LIMIT ".(int)$data['start'].",".(int)$data['limit'];
            }
            $query = $this->db->query($sql);

            return $query->rows;
        } else {
            $cache_key = 'tax_exempt_certificate_list.lang_'.$language_id;
            $product_data = $this->cache->pull($cache_key);

            if ($product_data === false) {
                $sql = "SELECT info.*,CONCAT(c.first_name,' ',c.last_name) as customer_name FROM ".$this->db->table("customer_group_auto_assigned_info")." info 
                       LEFT JOIN ".$this->db->table("customers")." c ON c.customer_id=info.customer_id WHERE info.store_id=".$store_id;
                $query = $this->db->query($sql);
                $product_data = $query->rows;
                $this->cache->push($cache_key, $product_data);
            }

            return $product_data;
        }
    }

    public function getCompanies() {
        $sql = "SELECT addr.company FROM ".$this->db->table("customers")." c 
                       LEFT JOIN ".$this->db->table("addresses")." addr ON c.customer_id=addr.customer_id AND addr.address_id = c.address_id";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function removeData($customer_group_auto_assigned_info_id) {
        $query = $this->db->query("SELECT image_url FROM ".$this->db->table("customer_group_auto_assigned_info")." WHERE `customer_group_auto_assigned_info_id`=".$customer_group_auto_assigned_info_id);
        $image_url = $query->row['image_url'];
        if (file_exists(DIR_EXT.'customer_group_auto_assigned/'.$image_url)) {
            unlink(DIR_EXT.'customer_group_auto_assigned/'.$image_url);
        }

        $this->db->query("DELETE FROM ".$this->db->table("customer_group_auto_assigned_info")." WHERE `customer_group_auto_assigned_info_id`=".$customer_group_auto_assigned_info_id);
    }

    public function removeDataByCustomerId($customer_id) {
        $this->deleteAll(DIR_EXT . 'customer_group_auto_assigned/files/'.$customer_id);
        $this->db->query("DELETE FROM ".$this->db->table("customer_group_auto_assigned_info")." WHERE `customer_id`=".$customer_id);
    }

    public function deleteAll($dir) {
        if(is_dir($dir)){
            $files = glob( $dir . '*', GLOB_MARK );
            foreach( $files as $file )
            {
                $this->deleteAll( $file );
            }
            rmdir( $dir );
        } elseif(is_file($dir)) {
            unlink( $dir );
        }
    }

    public function getStoreId() {
        $store_id = (int)$this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int)$this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int)$this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }

}
