<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerPagesSaleCustomerGroupAutoAssignedSettings
 * @property ModelExtensionCustomerGroupAutoAssignedLicenseInfo $model_extension_customer_group_auto_assigned_license_info
 * @property ModelExtensionCustomerGroupAutoAssigned $model_extension_customer_group_auto_assigned
 * @property ModelExtensionEmailEditorLicenseInfo $model_extension_email_editor_license_info
 */

class ControllerPagesSaleCustomerGroupAutoAssignedSettings extends AController {
    public $data = [];
    public $datas = [];
    private $error = [];
    private $errors = [];

    public function verify() {
        $this->load->model('extension/customer_group_auto_assigned_license_info');
        $license_key = $this->config->get('customer_group_auto_assigned_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('customer_group_auto_assigned_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_customer_group_auto_assigned_license_info->getStoreId();
                $license_key = $this->model_extension_customer_group_auto_assigned_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_customer_group_auto_assigned_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], 'customer_group_auto_assigned');
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_customer_group_auto_assigned_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyEmailEditor() {
        if ($this->config->get('email_editor_status')) {
            $this->load->model('extension/email_editor_license_info');
            $license_key = $this->config->get('email_editor_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('email_editor_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_email_editor_license_info->getStoreId();
                    $license_key = $this->model_extension_email_editor_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_email_editor_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'email_editor');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_email_editor_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }
    }

    public function main() {

    }
    
    public function update() {
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('customer_group_auto_assigned/customer_group_auto_assigned');
        $this->document->setTitle($this->language->get('text_customer_group_auto_assigned_settings'));
        $this->document->initBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('index/home', '', true),
                'text'      => $this->language->get('text_home'),
                'separator' => false,
            ]
        );

        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('sale/customer_group', '', true),
                'text'      => $this->language->get('breadcrumb_customer_groups'),
                'separator' => ' :: ',
            ]
        );

        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL(
                    'sale/customer_group/update',
                    '&customer_group_id='.$this->request->get['customer_group_id'],
                    true
                ),
                'text'      => $this->language->get('breadcrumb_edit_group'),
                'separator' => ' :: ',
            ]
        );

        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL(
                    'sale/customer_group_auto_assign/update',
                    '&customer_group_id='.$this->request->get['customer_group_id'],
                    true
                ),
                'text'      => $this->language->get('text_customer_group_auto_assigned_settings'),
                'separator' => ' :: ',
                'current'   => true,
            ]
        );

        $this->data['heading_title'] = $this->language->get('text_customer_group_auto_assigned_settings');

        $tabs['general'] = [
            'name'       => 'customer_group_edit',
            'text'       => $this->language->get('tab_general'),
            'href'       => $this->html->getSecureURL(
                'sale/customer_group/update',
                '&customer_group_id='.$this->request->get['customer_group_id'],
                true
            ),
            'sort_order' => 0,
        ];

        $obj = $this->dispatch(
            'responses/common/tabs',
            [
                'sale/customer_group',
                //parent controller. Use customer group to use for other extensions this will add tabs via their hooks
                ['tabs' => $tabs],
            ]
        );
        $this->data['tabs'] = $obj->dispatchGetOutput();

        $this->load->model('sale/customer_group');
        $customer_group_id = $this->request->get['customer_group_id'];

        $this->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
        $this->data['account_create_url'] = '';

        if ($this->request->is_POST()) {
            $this->load->model('extension/customer_group_auto_assigned');
            $this->load->model('sale/customer_group');
            $customer_group_id = $this->request->get['customer_group_id'];
            $customer_group_info = $this->model_sale_customer_group->getCustomerGroup($customer_group_id);
            $post = $this->request->post;
            $post['customer_group_id'] = $customer_group_id;
            if ($this->verifyEmailEditor()) {
                $this->load->model('extension/email_templates');
                $search= [" ","'"];
                $replace = "_";
                $section = str_replace($search,$replace,strtolower($customer_group_info['name']));
                $post['section_name'] = $section;
                $this->model_extension_email_templates->updateEmailTemplateSection($post);
            }
            $this->model_extension_customer_group_auto_assigned->addValues($customer_group_id,$post);
        }

        $store_id = $this->getStoreId();
        $this->load->model('setting/setting');
        $this->load->model('extension/customer_group_auto_assigned');
        $settings = $this->model_setting_setting->getSetting('details', $store_id);
        $store_url = $settings['config_ssl_url'] ?: $settings['config_url'];
        $customer_group_auto_assigned_settings = $this->model_extension_customer_group_auto_assigned->getValues($customer_group_id);
        $this->datas['account_create_url'] = $store_url . 'index.php?rt=account/create&group_id=' . $customer_group_id;

        $customer_group_info = $this->model_sale_customer_group->getCustomerGroup($customer_group_id);

        if (isset($this->request->post['name'])) {
            $this->datas['activated'] = $this->request->post['activated'];
            $this->datas['admin_approval'] = $this->request->post['admin_approval'];
            $this->datas['email_activation'] = $this->request->post['email_activation'];
            $this->datas['upload_tax_exemption'] = $this->request->post['upload_tax_exemption'];
            $this->datas['upload_later'] = $this->request->post['upload_later'];
            $this->datas['custom_email'] = $this->request->post['custom_email'];
        } elseif (isset($customer_group_auto_assigned_settings)) {
            $this->datas['activated'] = $customer_group_auto_assigned_settings['activated'];
            $this->datas['admin_approval'] = $customer_group_auto_assigned_settings['admin_approval'];
            $this->datas['email_activation'] = $customer_group_auto_assigned_settings['email_activation'];
            $this->datas['upload_tax_exemption'] = $customer_group_auto_assigned_settings['upload_tax_exemption'];
            $this->datas['upload_later'] = $customer_group_auto_assigned_settings['upload_later'];
            $this->datas['custom_email'] = $customer_group_auto_assigned_settings['custom_email'];
        } else {
            $this->datas['activated'] = '';
            $this->datas['admin_approval'] = '';
            $this->datas['email_activation'] = '';
            $this->datas['upload_tax_exemption'] = '';
            $this->datas['upload_later'] = '';
            $this->datas['custom_email'] = '';
        }
        

        $this->data['action'] = $this->html->getSecureURL(
            'sale/customer_group_auto_assigned_settings/update',
            '&customer_group_id='.$this->request->get['customer_group_id']
        );

        $this->data ['update'] = $this->html->getSecureURL ( 'r/sale/customer_group_auto_assigned_settings/update','&customer_group_id='.$this->request->get['customer_group_id'] );

        $form = new AForm('HS');
        $form->setForm ( array ('form_name' => 'editFrm', 'update' => $this->data ['update'] ) );

        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'editFrm',
                'action' => $this->data['action'],
                'attr'   => 'data-confirm-exit="true"  class="form-horizontal"',
            ]
        );

        $this->data['form']['fields']['customer_group_name'] = $this->html->buildInput([
            'name'     => 'customer_group_name',
            'value'    => $customer_group_info['name'],
            'required' => false,
            'attr'     => 'readonly'
        ]);
        $this->view->assign('entry_customer_group_name',$this->language->get('entry_customer_group_name'));

        $this->data['form']['fields']['activated'] = $this->html->buildCheckbox([
            'name'     => 'activated',
            'value'    => $this->datas['activated'],
            'style'    => 'btn_switch',
            'required' => false,
        ]);
        $this->view->assign('entry_activated',$this->language->get('entry_customer_group_auto_assigned_activated'));

        $this->data['form']['fields']['admin_approval'] = $this->html->buildCheckbox([
            'name'     => 'admin_approval',
            'value'    => $this->datas['admin_approval'],
            'style'    => 'btn_switch',
            'required' => false,
        ]);
        $this->view->assign('entry_admin_approval',$this->language->get('entry_customer_group_auto_assigned_admin_approval'));

        $this->data['form']['fields']['email_activation'] = $this->html->buildCheckbox([
            'name'     => 'email_activation',
            'value'    => $this->datas['email_activation'],
            'style'    => 'btn_switch',
            'required' => false,
        ]);
        $this->view->assign('entry_email_activation',$this->language->get('entry_customer_group_auto_assigned_email_activation'));

        $this->data['form']['fields']['upload_tax_exemption'] = $this->html->buildCheckbox([
            'name'     => 'upload_tax_exemption',
            'value'    => $this->datas['upload_tax_exemption'],
            'style'    => 'btn_switch',
            'required' => false,
        ]);
        $this->view->assign('entry_upload_tax_exemption',$this->language->get('entry_customer_group_auto_assigned_upload_tax_exemption'));

        $this->data['form']['fields']['upload_later'] = $this->html->buildCheckbox([
            'name'     => 'upload_later',
            'value'    => $this->datas['upload_later'],
            'style'    => 'btn_switch',
            'required' => false,
        ]);
        $this->view->assign('entry_upload_later',$this->language->get('entry_allow_upload_later'));

        $this->data['form']['fields']['custom_email'] = $this->html->buildCheckbox([
            'name'     => 'custom_email',
            'value'    => $this->datas['custom_email'],
            'style'    => 'btn_switch',
            'required' => false,
        ]);
        $this->view->assign('entry_custom_email',$this->language->get('entry_customer_group_auto_assigned_custom_email'));

        if ($this->verifyEmailEditor()) {
            $this->data['form']['fields']['previewEmailTemplate'] = $this->html->buildButton([
                'name'     => 'previewEmailTemplate',
                'text'     => $this->language->get('button_preview_email_template'),
                'style'    => 'btn btn-primary',
            ]);

            $this->data['form']['fields']['editEmailTemplate'] = $this->html->buildButton([
                'name'     => 'editEmailTemplate',
                'text'     => $this->language->get('button_edit_email_template'),
                'style'    => 'btn btn-primary',
            ]);
            $this->view->assign("edit_email_url",$this->html->getSecureURL("extension/email_templates/edit"));

            $search= [" ","'"];
            $replace = "_";
            $section = str_replace($search,$replace,strtolower($customer_group_info['name']));
            $this->view->assign('section',$section);

            $this->view->assign('getContent',$this->html->getSecureURL( 'r/extension/email_editor/getEmailContentBySection' ));
            $this->view->assign('getTemplateId',$this->html->getSecureURL( 'r/extension/email_editor/getEmailTemplateIdBySection' ));
            $this->view->assign('getSignature',$this->html->getSecureURL( 'r/extension/email_editor/getSignatureBySection' ));

            $logo = $this->dispatch('pages/extension/preview_email_logo', []);
            $this->view->assign('logo', html_entity_decode($logo->dispatchGetOutput()));
        }

        $this->data['form']['fields']['account_create_url'] = $this->html->buildInput([
            'name'     => 'account_create_url',
            'value'    => $this->datas['account_create_url'],
            'style'    => 'medium-field',
            'attr'     => 'readonly'
        ]);

        $this->view->assign('entry_account_create_url',$this->language->get('entry_customer_group_auto_assigned_account_create_url'));
        $text_checkout_settings_note = str_replace('[here]','<a href="'.$this->html->getSecureURL('setting/setting/checkout').'" target="_BLANK">here</a>',$this->language->get('text_checkout_settings_note'));
        $this->view->assign('text_checkout_settings_note',$text_checkout_settings_note);

        $this->view->assign['email_editor_status'] = $this->verifyEmailEditor();

        $this->view->assign('button_save',$this->language->get('button_save'));
        $this->view->assign('button_cancel',$this->language->get('button_cancel'));
        $this->view->assign('cancel_url',$this->html->getSecureURL('sale/customer_group/update','&customer_group_id='.$this->request->get['customer_group_id'],true));

        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());
        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/sale/customer_group_auto_assigned_settings.tpl');
    }

    public function getStoreId() {
       $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}