<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
header ( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";
require_once DIR_EXT. "customer_group_auto_assigned" . DIR_EXT_CORE ."updater.php";

class ExtensionCustomerGroupAutoAssigned extends Extension {

    public $data = [];
    public $error = [];
    public $errors=[];

    private $mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
    private $diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
    private $shared_secret = "customer_group_auto_assigned";	

    public function __construct() {
        $this->registry = Registry::getInstance();
    }

    private function _is_enabled() {
        return $this->baseObject->config->get('customer_group_auto_assigned_status') && $this->verify();
    }

	public function verify() {
		$that =& $this->baseObject;
        $that->load->model('extension/customer_group_auto_assigned_license_info');
        $license_key = $that->config->get('customer_group_auto_assigned_license_code');
        if ($license_key) {
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('customer_group_auto_assigned_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $that->model_extension_customer_group_auto_assigned_license_info->getStoreId();
                $license_key = $that->model_extension_customer_group_auto_assigned_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_customer_group_auto_assigned_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600; 
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $that->model_extension_customer_group_auto_assigned_license_info->getLicensedStoreStatus();
                if ($validate['status']==='expired') {
                    $public_key = "";
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }

                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $current_version = $that->model_extension_customer_group_auto_assigned_license_info->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/customer_group_auto_assigned_license_info');
                            $that->model_extension_customer_group_auto_assigned_license_info->saveLicenseData($data);
                        } elseif ($validate['status'] === 'valid' && $store_status == 1) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                } else {
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
	}

    public function verifyCustPref() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'customer_preferences_status' ) ) {
            $that->load->model('extension/customer_preferences_license_info');
            $license_key = $that->config->get('customer_preferences_license_code');
            $shared_secret = 'customer_preferences';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('customer_preferences_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_customer_preferences_license_info->getStoreId();
                    $license_key = $that->model_extension_customer_preferences_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_customer_preferences_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_customer_preferences_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyTaxId() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'taxid_option_status' ) ) {
            $that->load->model('extension/taxid_option_license_info');
            $license_key = $that->config->get('taxid_option_license_code');
            $shared_secret = 'taxid_option';
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('taxid_option_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_taxid_option_license_info->getStoreId();
                    $license_key = $that->model_extension_taxid_option_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_taxid_option_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_taxid_option_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyEmailEditor() {
        $that =& $this->baseObject;
        if ($that->config->get('email_editor_status')) {
            $that->load->model('extension/email_editor_license_info');
            $license_key = $that->config->get('email_editor_license_code');
            if ($license_key) {
                $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('email_editor_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $that->model_extension_email_editor_license_info->getStoreId();
                    $license_key = $that->model_extension_email_editor_license_info->getLicenseCode($store_id);
                    $license_info = $that->model_extension_email_editor_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'email_editor');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $that->model_extension_email_editor_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }
    }

    public function onControllerPagesIndexLogin_InitData() {
        $that =& $this->baseObject;
        if ($that->request->is_POST()) {
            $logged_in = $that->session->data['LAST_ACTIVITY'];
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('customer_group_auto_assigned_license_info') . "'");
            if ($exist->num_rows === 1) {
                if (isset($logged_in)) {
                    $that->load->model('extension/customer_group_auto_assigned_license_info');
                    $store_id = $that->model_extension_customer_group_auto_assigned_license_info->getStoreId();

                    $license_info = $that->model_extension_customer_group_auto_assigned_license_info->getLicenseData($store_id);
                    $last_check = $license_info['last_check'];
                    $daily_check = 86400;
                    if (time() > $daily_check + $last_check) {
                        $public_key = "";
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license_key = $that->model_extension_customer_group_auto_assigned_license_info->getLicenseCode($store_id);
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        if (stripos($license_key,'mc-')!==false) {
                            $server_url = $this->mc_server_url;
                        } else {
                            $server_url = $this->diy_server_url;
                        }

                        $license_manager->setLicenseServerUrl($server_url);
                        $license_manager->setKeys($license_key, "", $this->shared_secret);
                        $public_key = $license_manager->requestKey();
                        $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                        $that->load->model('extension/customer_group_auto_assigned_updater');
                        $current_version = $that->model_extension_customer_group_auto_assigned_updater->getCurrentVersion();
                        $custom_data = ['version' => $current_version];
                        $license_data = $license_manager->requestData($custom_data);
                        if (!is_null($license_data)) {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $ttl = 1209600;
                            $validate = $license_manager->validate($license_data, $ttl);
                            if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                                $data['public_key'] = $public_key;
                                $data['license_data'] = $license_data;
                                $data['store_id'] = $store_id;
                                $data['last_check'] = time();
                                $that->load->model('extension/customer_group_auto_assigned_license_info');
                                $that->model_extension_customer_group_auto_assigned_license_info->saveLicenseData($data);
                            }
                        }
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_InitData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            if ( $extension === 'customer_group_auto_assigned' ) {
                if ( $that->request->is_POST()) {
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = trim($that->request->post['customer_group_auto_assigned_license_code']);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }
                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $that->load->model('extension/customer_group_auto_assigned_license_info');

                    $store_id = (int) $that->config->get('config_store_id');
                    if (has_value($that->request->get_or_post('store_id'))) {
                        $store_id = (int) $that->request->get_or_post('store_id');
                    } else {
                        if ($that->session->data['current_store_id']) {
                            $store_id = (int) $that->session->data['current_store_id'];
                        }
                    }

                    $installed_store_id = $that->model_extension_customer_group_auto_assigned_license_info->getInstalledLicense($license_key);

                    if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                        $that->model_extension_customer_group_auto_assigned_license_info->deleteLicenseInfo($installed_store_id);
                    }
                    $existing_license_key = $that->model_extension_customer_group_auto_assigned_license_info->getLicenseCode($store_id);
                    $data['multi']=false;
                    $split_existing_license_key = explode('-',$existing_license_key);
                    $split_license_key = explode('-',$license_key);
                    if ($existing_license_key && $split_existing_license_key[0] !== $split_license_key[0]) {
                        $data['multi']=true;
                    }

                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/customer_group_auto_assigned_updater');
                    $current_version = $that->model_extension_customer_group_auto_assigned_updater->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);

                        $that->load->model('setting/setting');
                        $that->load->model('extension/customer_group_auto_assigned_license_info');
                        $data['customer_group_auto_assigned_licensed_store_id_'.$store_id] = 1;

                        $that->model_setting_setting->editSetting('customer_group_auto_assigned', $data);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            if (file_exists(DIR_EXT.'customer_group_auto_assigned/core/helpers.php')) {
                                unlink(DIR_EXT.'customer_group_auto_assigned/core/helpers.php');
                            }
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['license_key'] = $license_key;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/customer_group_auto_assigned_license_info');
                            $that->model_extension_customer_group_auto_assigned_license_info->saveLicenseData($data);
                        }
                    } else {
                        $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_UpdateData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
            if ( $extension === 'customer_group_auto_assigned' ) {
                $latestVersion = $this->getVersion();
                $that->loadLanguage('extension/extensions');
                if (!is_null($latestVersion) && $latestVersion!=='') {
                    $info = sprintf(
                        $that->language->get('text_update_customer_group_auto_assigned_available'),
                        $latestVersion,
                        $that->html->getSecureURL('extension/customer_group_auto_assigned_updater','&version='.str_replace('.', '-', $latestVersion))
                    );
                    $that->view->assign('info',$info);
                } else {
                    $that->view->assign('info','');
                }
                $view = new AView($this->registry, 0);
                $data['manual_url'] = 'https://why2central.net/v1/customer-group-auto-assigned';
                $data['manual_title'] = $that->language->get('customer_group_auto_assigned_name').' Manual';
                $view->batchAssign($data);
                $that->view->addHookVar('extension_toolbar_buttons', $view->fetch('pages/extension/customer_group_auto_assigned_manual.tpl'));
                $that->load->model('extension/customer_group_auto_assigned_license_info');
                $license_key = $that->config->get('customer_group_auto_assigned_license_code');
                if ($license_key) {
                    $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('customer_group_auto_assigned_license_info') . "'");
                    if ($exist->num_rows === 1) {
                        $store_id = $that->model_extension_customer_group_auto_assigned_license_info->getStoreId();
                        $license_key = $that->model_extension_customer_group_auto_assigned_license_info->getLicenseCode($store_id);
                        $license_info = $that->model_extension_customer_group_auto_assigned_license_info->getLicenseData($store_id);
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_info['license_data'], $ttl);
                        $message = '';
                        if ($validate['status']==='expired') {
                            $message = $that->language->get('customer_group_auto_assigned_license_expired');
                        }
                        $that->view->assign('message',$message);
                    }
                }
                $that->processTemplate();
            }
        }
    }

    public function onControllerResponsesListingGridExtension_InitData() {
        if ($this->baseObject_method != 'update') {
            return false;
        }
        $that =& $this->baseObject;
        if ($that->request->get['id'] != 'customer_group_auto_assigned') {
            return false;
        }
        if (isset($that->request->post['customer_group_auto_assigned_license_code'])) {
            $that->request->post['customer_group_auto_assigned_license_code'] = trim($that->request->post['customer_group_auto_assigned_license_code']);
        }
    }

    public function onControllerResponsesListingGridExtension_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $store_id = (int)$that->config->get('current_store_id');
            if ($that->request->get_or_post('store_id')) {
                $store_id = $that->request->get_or_post('store_id');
            }
            $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
            $response = json_decode(json_encode($that->data['response']), true);
            $extension_rows = $response['rows'];
            $ext_name = $that->language->get('customer_group_auto_assigned_name');
            foreach ($extension_rows as $k => $extensions) {
                if ($extensions['id'] === 'customer_group_auto_assigned_' . $store_id) {
                    $cells = $extensions['cell'];
                    foreach ($cells as $key => $cell) {
                        if ($cell===$ext_name || strpos($cell,'<p class="alert-info">'.$ext_name)!==false) {
                            $latestVersion = $this->getVersion();
                            if (!is_null($latestVersion) && $latestVersion !== '') {
                                $update_now_url = $that->html->getSecureURL('extension/customer_group_auto_assigned_updater', '&version=' . str_replace('.', '-', $latestVersion));
                                $cells[$key] = '<p class="alert-info">'
                                    .$ext_name.' (WHY2)'
                                    . '<br>'
                                    . sprintf(
                                        $that->language->get('text_update_customer_group_auto_assigned_available'),
                                        $latestVersion,
                                        $update_now_url
                                    )
                                    . '</p>';
                                $that->data['response']->rows[$k]['cell'][$key] = $cells[$key];
                            } else {
                                $that->data['response']->rows[$k]['cell'][$key] = $ext_name;
                            }
                        }
                    }
                }
            }
        } elseif ($this->baseObject_method==='update') {
            if ($that->request->post['customer_group_auto_assigned_license_code']) {
                $public_key = "";
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

                $license_key = trim($that->request->post['customer_group_auto_assigned_license_code']);
                if (stripos($license_key,'mc-')!==false) {
                    $server_url = $this->mc_server_url;
                } else {
                    $server_url = $this->diy_server_url;
                }
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setLicenseServerUrl($server_url);
                $license_manager->setKeys($license_key, "", $this->shared_secret);
                $public_key = $license_manager->requestKey();

                $store_id = (int) $that->config->get('config_store_id');
                if ($that->request->get_or_post('store_id')) {
                    $store_id = $that->request->get_or_post('store_id');
                }

                $that->load->model('extension/customer_group_auto_assigned_license_info');

                $installed_store_id = $that->model_extension_customer_group_auto_assigned_license_info->getInstalledLicense($license_key);

                if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                    $that->model_extension_customer_group_auto_assigned_license_info->deleteLicenseInfo($installed_store_id);
                }

                $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                $that->load->model('extension/customer_group_auto_assigned_updater');
                $current_version = $that->model_extension_customer_group_auto_assigned_updater->getCurrentVersion();
                $custom_data = ['version' => $current_version];
                $license_data = $license_manager->requestData($custom_data);
                if (!is_null($license_data)) {
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_data, $ttl);

                    $that->load->model('setting/setting');
                    $that->load->model('extension/customer_group_auto_assigned_license_info');

                    if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $data['license_key'] = $license_key;
                        $data['store_id'] = $store_id;
                        $data['last_check'] = time();
                        $that->load->model('extension/customer_group_auto_assigned_license_info');
                        $that->model_extension_customer_group_auto_assigned_license_info->saveLicenseData($data);
                    }
                } else {
                    $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensionSummary_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $extension = $that->request->get['extension'];
            if ($extension==='customer_group_auto_assigned') {
                $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
                $extension_info = $that->extensions->getExtensionInfo($extension);
                $support_expiration_int =  strtotime($extension_info['support_expiration']);
                if ($extension_info['support_expiration'] && $support_expiration_int !== 0) {
                    if ($support_expiration_int < time()) {
                        if ($that->data['text_support_expiration']) {
                            $that->view->assign('text_support_expired', $that->language->get('text_support_by_why2'));
                        } else {
                            $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                        }
                    } else {
                        $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                    }
                } else {
                    $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                }
                $that->view->assign('get_support_button', '');
                $data['get_diy_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'diy_support',
                        'target' => "_new",
                        'href'   => 'https://wehearyou2.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_diy_support_by_why2'),
                    ]
                );
                $data['get_mc_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'mc_support',
                        'target' => "_new",
                        'href'   => 'https://abantecartplus.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_mc_support_by_why2'),
                    ]
                );
                $view = new AView(Registry::getInstance(), 0);
                $view->batchAssign($data);
                $that->view->addHookVar('extension_summary_item', $view->fetch('pages/extension/extension_summary_buttons.tpl'));
                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        }
    }

    //-- Admin > Customer Group

    public function onControllerPagesSaleCustomerGroup_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'insert') {
            $that->load->model('extension/customer_group_auto_assigned');
            $customer_group_id = $that->data['customer_group_id'];
            $post = $that->request->post;
            $post['customer_group_id'] = $customer_group_id;
            if ($this->verifyEmailEditor()) {
                $that->load->model('extension/email_templates');
                $that->model_extension_email_templates->createEmailTemplate($post);
            }
         } elseif ($this->baseObject_method === 'update') {
            $that->load->model('extension/customer_group_auto_assigned');
            $customer_group_id = $that->request->get['customer_group_id'];
            $post = $that->request->post;
            $post['customer_group_id'] = $customer_group_id;
            if ($this->verifyEmailEditor()) {
                $that->load->model('extension/email_templates');
                $search= [" ","'"];
                $replace = "_";
                $section = str_replace($search,$replace,strtolower($post['name']));
                $post['section_name'] = $section;
                $that->model_extension_email_templates->updateEmailTemplateSection($post);
            }
         }
    }

    public function onControllerResponsesListingGridCustomer_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'update') {
            $that->load->model('extension/customer_group_auto_assigned');
            switch ($that->request->post['oper']) {
                case 'del':
                    $ids = explode(',', $that->request->post['id']);
                    if (!empty($ids)) {
                        foreach ($ids as $id) {
                            $that->model_extension_customer_group_auto_assigned->removeDataByCustomerId($id);
                        }
                    }
                    break;
            }
        }
    }

    public function onControllerResponsesListingGridCustomerGroup_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='update_field') {
            if (isset($that->request->get['id'])) {
                $post = $that->request->post;
                $that->load->model('extension/customer_group_auto_assigned');
                if ($this->verifyEmailEditor() && isset($post['name'])) {
                    $that->load->model('extension/email_templates');
                    $search= [" ","'"];
                    $replace = "_";
                    $section = str_replace($search,$replace,strtolower($post['name']));
                    $post['customer_group_id'] = $that->request->get['id'];
                    $post['section_name'] = $section;
                    $that->model_extension_email_templates->updateEmailTemplateSection($post);
                }
                $that->model_extension_customer_group_auto_assigned->updateValues($that->request->get['id'],$post );
            }
        }
    }

    public function getStoreId() {
        $that =& $this->baseObject;
        $store_id = (int) $that->config->get('config_store_id');
        if (has_value($that->request->get_or_post('store_id'))) {
            $store_id = (int) $that->request->get_or_post('store_id');
        } else {
            if ($that->session->data['current_store_id']) {
                $store_id = (int) $that->session->data['current_store_id'];
            }
        }
        return $store_id;
    }

    public function onControllerResponsesCommonTabs_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject->parent_controller != 'sale/customer_group') {
            return null;
        }

        $that =& $this->baseObject;
        $that->loadLanguage('customer_group_auto_assigned/customer_group_auto_assigned');

        $that->data['tabs']['customer_group_auto_assigned_settings'] = [
            'name'       => 'customer_group_auto_assigned',
            'text'       => $that->language->get('text_customer_group_auto_assigned_settings'),
            'href'       => $that->html->getSecureURL(
                'sale/customer_group_auto_assigned_settings/update',
                '&customer_group_id='.$that->request->get['customer_group_id']
            ),
            'active'     => $that->request->get['rt'] == 'sale/customer_group_auto_assigned_settings/update',
            'sort_order' => 1,
        ];
    }

    public function onControllerResponsesListingGridCustomer_InitData() {
        if (!$this->isEnabled()) {
            return;
        }
        $that =& $this->baseObject;
        if (isset($that->request->get['id']) && isset($that->request->post['attributes'])) {
            /** @var ModelSaleCustomerAttributes $mdl */
            $mdl = $that->load->model('customer_group_auto_assigned/customer_group_auto_assigned');
            $mdl->updateCustomerAttributeValues(
                $that->request->get['id'],
                $that->request->post['attributes']
            );
        }
    }

    public function onControllerCommonListingGrid_InitData() {
        /** @var ControllerPagesSaleCustomerGroup $that */
        $that =& $this->baseObject;
        if (!in_array($that->data['table_id'], ['cg_grid'])) {
            return;
        }

        $editUrl = $that->html->getSecureURL('sale/customer_group/update', '&customer_group_id=%ID%');
        $attrUrl = $that->html->getSecureURL('sale/customer_group_auto_assigned_settings/update', '&customer_group_id=%ID%');
        $that->loadLanguage('customer_group_auto_assigned/customer_group_auto_assigned');

        if (!$that->data['actions']['dropdown']) {
            $that->data['actions']['dropdown'] = [
                'text'     => $that->language->get('text_choose_action'),
                'href'     => $editUrl,
                'children' => [
                    'general' => [
                        'text' => $that->language->get('tab_general'),
                        'href' => $editUrl,
                    ],
                ],
            ];
        }
        $that->data['actions']['dropdown']['children']['customer_group_auto_assigned_settings'] =
            [
                'text' => $that->language->get('text_customer_group_auto_assigned_settings'),
                'href' => $attrUrl,
            ];
    }
    
    // -- End Of Admin > Customer Group

    // -- Admin Order Detail And Sale Invoice

    public function onControllerPagesSaleOrder_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='details') {
            $that->load->model('sale/order');
            $that->load->model('extension/customer_group_auto_assigned');
            $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
            $order_id = $that->request->get['order_id'];
            $order_info = $that->model_sale_order->getOrder($order_id);
            $customer_id = $order_info['customer_id'];
            $exemption_info = $that->model_extension_customer_group_auto_assigned->getExemptionInfo($customer_id);
            if ($exemption_info) {
                $data['exemption_info'] = $exemption_info;
                $data['company_name'] = $order_info['payment_company'];
                $data['text_tax_exempt_company_name'] = $that->language->get('text_tax_exempt_company_name','customer_group_auto_assigned/customer_group_auto_assigned');
                $data['text_tax_exempt_upload_date'] = $that->language->get('text_tax_exempt_upload_date','customer_group_auto_assigned/customer_group_auto_assigned');
                $data['text_tax_exempt_have_expiration_date'] = $that->language->get('text_tax_exempt_have_expiration_date','customer_group_auto_assigned/customer_group_auto_assigned');
                $data['text_tax_exempt_expiration_date'] = $that->language->get('text_tax_exempt_expiration_date','customer_group_auto_assigned/customer_group_auto_assigned');
                if ($exemption_info['uploaded_at']!=='0000-00-00' && !is_null($exemption_info['uploaded_at'])) {
                    $uploaded_at = date_create($exemption_info['uploaded_at']);
                    $data['uploaded_at'] = $uploaded_at->format($that->language->get('date_format_short'));
                }
                $data['expire'] = $exemption_info['expire'] ==='0' ? $that->language->get('text_no'): $that->language->get('text_yes');
                if ($exemption_info['expire_date'] !== '0000-00-00 00:00:00' && !is_null($exemption_info['expire_date'])) {
                    $expire_date = date_create($exemption_info['expire_date']);
                    $data['expire_date'] = $expire_date->format($that->language->get('date_format_short'));
                }
            } else {
                $data['no_tax_exemption_message'] = $that->language->get('text_no_exempt_certificate','customer_group_auto_assigned/customer_group_auto_assigned');
            }
            $data['text_tax_exempt_title'] = $that->language->get('text_tax_exempt_title','customer_group_auto_assigned/customer_group_auto_assigned');
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('order_pre_details', $view->fetch('pages/sale/order_details_auto_assigned_fields.tpl'));
        }
    }

    public function onControllerResponsesSaleInvoice_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->load->model('sale/order');
            $that->load->model('extension/customer_group_auto_assigned');
            $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
            $order_id = $that->request->get['order_id'];
            $order_info = $that->model_sale_order->getOrder($order_id);
            $customer_id = $order_info['customer_id'];
            $exemption_info = $that->model_extension_customer_group_auto_assigned->getExemptionInfo($customer_id);
            if ($exemption_info) {
                $data['exemption_info'] = $exemption_info;
                $data['company_name'] = $order_info['payment_company'];
                $data['text_tax_exempt_company_name'] = $that->language->get('text_tax_exempt_company_name','customer_group_auto_assigned/customer_group_auto_assigned');
                $data['text_tax_exempt_upload_date'] = $that->language->get('text_tax_exempt_upload_date','customer_group_auto_assigned/customer_group_auto_assigned');
                $data['text_tax_exempt_have_expiration_date'] = $that->language->get('text_tax_exempt_have_expiration_date','customer_group_auto_assigned/customer_group_auto_assigned');
                $data['text_tax_exempt_expiration_date'] = $that->language->get('text_tax_exempt_expiration_date','customer_group_auto_assigned/customer_group_auto_assigned');
                if ($exemption_info['uploaded_at']!=='0000-00-00' && !is_null($exemption_info['uploaded_at'])) {
                    $uploaded_at = date_create($exemption_info['uploaded_at']);
                    $data['uploaded_at'] = $uploaded_at->format($that->language->get('date_format_short'));
                }
                $data['expire'] = $exemption_info['expire'] ==='0' ? $that->language->get('text_no'): $that->language->get('text_yes');
                if ($exemption_info['expire_date'] !== '0000-00-00 00:00:00' && !is_null($exemption_info['expire_date'])) {
                    $expire_date = date_create($exemption_info['expire_date']);
                    $data['expire_date'] = $expire_date->format($that->language->get('date_format_short'));
                }
            } else {
                $data['no_tax_exemption_message'] = $that->language->get('text_no_exempt_certificate','customer_group_auto_assigned/customer_group_auto_assigned');
            }
            $data['text_tax_exempt_title'] = $that->language->get('text_tax_exempt_title','customer_group_auto_assigned/customer_group_auto_assigned');
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('order_invoice_'.$order_id.'_top_info', $view->fetch('responses/sale/sale_invoice_auto_assigned_fields.tpl'));
        }
    }

    // -- End Of Admin Order Detail And Sale Invoice

    //-- Customer registration
    public function onControllerPagesAccountCreate_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $request_data = $that->request->post;

            if (isset($that->request->get['group_id'])) {
                $customer_group_id = (int)$that->request->get['group_id'];
                $that->data['action'] = $that->html->getSecureURL('account/create','&group_id='.$customer_group_id);
                $request_data['customer_group_id'] = $customer_group_id;
            } else {
                $customer_group_id = (int)$that->config->get('config_customer_group_id');
                $request_data['customer_group_id'] = $customer_group_id;
            }
            if ($that->request->is_POST()) {
                $that->load->model('account/customer');
                $that->load->model('extension/customer_group_auto_assigned');
                if ($this->verifyEmailEditor()) {
                    $that->load->model('extension/email_editor', 'storefront');
                }
                $taxid_errors = [];
                if ($that->csrftoken->isTokenValid()) {
                    $that->session->data['base_post']    = $that->request->post;
                    $errors = $that->model_account_customer->validateRegistrationData($request_data);
                } else {
                    $errors['warning'] = $that->language->get('error_unknown');
                }
                if ( ! empty( $errors ) ) {
                    $that->session->data['field_errors'] = $errors;
                    if ($that->request->get['group_id']) {
                        redirect($that->html->getSecureURL('account/create','&group_id='.$that->request->get['group_id']));
                    } else {
                        redirect($that->html->getSecureURL('account/create'));
                    }
                } else {
                    $customer_group_info = $that->model_extension_customer_group_auto_assigned->getValues($customer_group_id);
                    $search = [" ", "'"];
                    $replace = "_";
                    $section = str_replace($search, $replace, strtolower($customer_group_info['customer_group_name']));
                    $custom_email = $customer_group_info['custom_email'] === '1' ? true : false;
                    //if allow login as email, need to set loginname = email
                    if (!$that->config->get('prevent_email_as_login')) {
                        $request_data['loginname'] = $request_data['email'];
                    }

                    if ($customer_group_info) {
                        if ($customer_group_info['admin_approval'] === '0') {
                            $request_data['approved'] = 1;
                        } else {
                            $request_data['approved'] = 0;
                        }
                    }
                    if ($this->verifyTaxId()) {
                        $that->load->model('account/taxid_option');
                        $that->data['customer_id'] = $that->model_account_taxid_option->addCustomer( $request_data );
                        $that->model_account_taxid_option->addCustomerAdditionalValues($that->data['customer_id'], $request_data);
                    } else {
                        $that->data['customer_id'] = $that->model_account_customer->addCustomer($request_data);
                    }

                    $customer_id = $that->data['customer_id'];
                    if ($customer_group_info['upload_tax_exemption'] === '1') {
                        $data['image_url'] = '';
                        $accept = ["image/jpeg", "image/png", "image/gif", "application/pdf"];
                        $upmime = strtolower($_FILES["upload_tax_exemption"]["type"]);
                        if (in_array($upmime, $accept)) {
                            $filename = $_FILES['upload_tax_exemption']['name'];
                            $temp_name = $_FILES['upload_tax_exemption']['tmp_name'];

                            $current_year = date('Y');
                            $current_month = date('m');
                            if ($filename) {
                                if (!file_exists(DIR_EXT . 'customer_group_auto_assigned/files/')) {
                                    mkdir(DIR_EXT . 'customer_group_auto_assigned/files/');
                                }
                                if (!file_exists(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id)) {
                                    mkdir(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id, 0755);
                                }

                                if (!file_exists(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year)) {
                                    mkdir(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year, 0755);
                                }
                                if (!file_exists(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month)) {
                                    mkdir(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month, 0755);
                                }

                                $upload_dir = DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month . '/';

                                // move file
                                $uploaded = move_uploaded_file($temp_name, $upload_dir . $filename);

                                if ($uploaded) {
                                    $data['image_url'] = 'files/' . $customer_id . '/' . $current_year . '/' . $current_month . '/' . $filename;
                                } else {
                                    $that->log->write('unable to upload file');
                                }
                            }
                        }
                        $data['customer_id'] = $customer_id;
                        $data['customer_group_id'] = $customer_group_id;
                        $data['expire'] = $request_data['expire'];
                        $data['upload_later'] = $request_data['upload_later'];
                        $data['expiration_date'] = $request_data['expiration_date'];
                        $that->model_extension_customer_group_auto_assigned->addInfo($data);
                    }
                    $that->model_account_customer->editCustomerNotifications($request_data, $that->data['customer_id']);
                    unset($that->session->data['guest']);
                    if ($customer_group_info) {
                        if ($customer_group_info['admin_approval'] === '0') {
                            //add and send account activation link if required
                            if ($customer_group_info['email_activation'] === '1') {
                                //send activation email request and wait for confirmation
                                if ($this->verifyEmailEditor()) {
                                    $that->model_extension_email_editor->emailActivateLink($customer_id, $section, $custom_email);
                                } else {
                                    $that->model_extension_customer_group_auto_assigned->emailActivateLink($customer_id, $custom_email);
                                }
                            } else {
                                //send welcome email
                                if ($this->verifyEmailEditor()) {
                                    $that->model_extension_email_editor->sendWelcomeEmail($that->request->post['email'], true, $section, $custom_email);
                                } else {
                                    $that->model_extension_customer_group_auto_assigned->sendWelcomeEmail($that->request->post['email'], true, $custom_email);
                                }
                                //login customer after create account is approving and email activation are disabled in settings
                                $that->customer->login($request_data['loginname'], $request_data['password']);
                            }
                        } else {
                            //send welcome email, but need manual approval
                            if ($this->verifyEmailEditor()) {
                                $that->model_extension_email_editor->sendWelcomeEmail($that->request->post['email'], false, $section, $custom_email);
                            } else {
                                $that->model_extension_customer_group_auto_assigned->sendWelcomeEmail($that->request->post['email'], false, $custom_email);
                            }
                        }
                        //set success text for non-approved customers on login page after redirect
                        if ($customer_group_info['admin_approval'] === '1') {
                            $that->loadLanguage('account/success');
                            $that->session->data['success'] = sprintf(
                                $that->language->get('text_approval', 'account/success'),
                                $that->config->get('store_name'),
                                $that->html->getSecureURL('content/contact')
                            );
                        }

                        if ($this->verifyCustPref()) {
                            /** @var ModelSaleCustomerPreferences $mdl */
                            $mdl = $that->load->model('sale/customer_preferences');
                            $preferences = $mdl->getPreferencesForGroup(
                                $that->config->get('config_customer_group_id'),
                                $that->language->getLanguageID()
                            );

                            foreach ($preferences as $pref) {
                                $exist = '-';
                                $values_number = sizeof($pref['values']);
                                foreach ($pref['values'] as $k => $v) {
                                    if ($v['default']==='1') {
                                        $exist = $k;
                                    }
                                }
                                foreach ($pref['values'] as $key => $val) {
                                    if ($values_number === 1) {
                                        $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                                        $data['value'] = $val['value'];
                                        $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id,$data);
                                    } elseif ($values_number > 1) {
                                        if ((string)$exist === (string)$key || $exist ==='-' && (string)$key==='0') {
                                            $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                                            $data['value'] = $val['value'];
                                            $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id,$data);
                                        }
                                    }
                                }
                            }
                        }

                        if ($customer_group_info['email_activation'] === '1' || !$that->session->data['redirect']) {
                            redirect($that->html->getSecureURL('account/success'));
                        } else {
                            redirect($that->session->data['redirect']);
                        }

                        if (isset($that->session->data['base_post'])) {
                            unset($that->session->data['base_post']);
                        }
                        $that->session->data['customer_group_auto_assigned_settings'] = $customer_group_info;
                    } else {
                        if (!$that->config->get('config_customer_approval')) {
                            //add and send account activation link if required
                            if (!$that->config->get('config_customer_email_activation')) {
                                //send welcome email
                                if ($this->verifyEmailEditor()) {
                                    $that->model_extension_email_editor->sendWelcomeEmail($that->request->post['email'], true);
                                } else {
                                    $that->model_account_customer->sendWelcomeEmail($that->request->post['email'], true);
                                }
                                //login customer after create account is approving and email activation are disabled in settings
                                $that->customer->login($request_data['loginname'], $request_data['password']);
                            } else {
                                if ($this->verifyEmailEditor()) {
                                    $that->model_extension_email_editor->emailActivateLink($customer_id);
                                } else {
                                    //send activation email request and wait for confirmation
                                    $that->model_account_customer->emailActivateLink($customer_id);
                                }
                            }
                        } else {
                            //send welcome email, but need manual approval
                            if ($this->verifyEmailEditor()) {
                                $that->model_extension_email_editor->sendWelcomeEmail($that->request->post['email'], false);
                            } else {
                                $that->model_account_customer->sendWelcomeEmail($that->request->post['email'], false);
                            }
                        }
                        //set success text for non-approved customers on login page after redirect
                        if ($that->config->get('config_customer_approval')) {
                            $that->loadLanguage('account/success');
                            $that->session->data['success'] = sprintf(
                                $that->language->get('text_approval', 'account/success'),
                                $that->config->get('store_name'),
                                $that->html->getSecureURL('content/contact')
                            );
                        }

                        if ($this->verifyCustPref()) {
                            $mdl = $that->load->model('sale/customer_preferences');
                            $preferences = $mdl->getPreferencesForGroup(
                                $that->config->get('config_customer_group_id'),
                                $that->language->getLanguageID()
                            );

                            foreach ($preferences as $pref) {
                                $exist = '-';
                                $values_number = sizeof($pref['values']);
                                foreach ($pref['values'] as $k => $v) {
                                    if ($v['default']==='1') {
                                        $exist = $k;
                                    }
                                }
                                foreach ($pref['values'] as $key => $val) {
                                    if ($values_number === 1) {
                                        $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                                        $data['value'] = $val['value'];
                                        $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id,$data);
                                    } elseif ($values_number > 1) {
                                        if ((string)$exist === (string)$key || $exist ==='-' && (string)$key==='0') {
                                            $data['customer_preferences_id'] = $pref['customer_preferences_id'];
                                            $data['value'] = $val['value'];
                                            $that->model_sale_customer_preferences->addPreferencesToCustomer($customer_id,$data);
                                        }
                                    }
                                }
                            }
                        }

                        if ($that->config->get('config_customer_email_activation') || !$that->session->data['redirect']) {
                            redirect($that->html->getSecureURL('account/success'));
                        } else {
                            redirect($that->session->data['redirect']);
                        }
                    }

                    if (isset($that->session->data['base_post'])) {
                        unset($that->session->data['base_post']);
                    }
                }
            }

           if ( isset( $that->session->data['base_post'] ) ) {
               $that->request->post = $that->session->data['base_post'];
               unset( $that->session->data['base_post'] );
           }
        }
    }

    public function onControllerPagesAccountCreate_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;

        if ($this->baseObject_method==='main') {
            $field_errors = $that->session->data['field_errors'];
            $data['errors'] = $field_errors;
            if ($field_errors) {
                foreach ($field_errors as $key => $field_error) {
                    $that->view->assign('error_' . $key, $field_error);
                    $data['errors'][$key] = $field_error;
                }
                unset($that->session->data['field_errors']);
            }

            $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
            $that->load->model('extension/customer_group_auto_assigned');
            if (isset($that->request->get['group_id'])) {
                $that->document->addScript($that->view->templateResource('/javascript/moment-with-locales.js'));
                $that->document->addScript($that->view->templateResource('/javascript/bootstrap-datetimepicker.min.js'));
                $that->document->addStyle(
                    [
                        'href' => $that->view->templateResource('/stylesheet/bootstrap-datetimepicker.min.css'),
                        'rel' => 'stylesheet',
                    ]
                );
                $customer_group_id = (int)$that->request->get['group_id'];
                $form=$that->view->getData('form');
                $form['form_open'] = $that->html->buildForm(
                [
                    'type'   => 'form',
                    'name'   => 'AccountFrm',
                    'action' => $that->html->getSecureURL('account/create','&group_id='.$customer_group_id),
                    'csrf'   => true,
                ]);
                $that->view->assign('form',$form);
            } else {
                $customer_group_id = (int)$that->config->get('config_customer_group_id');
            }
            $that->load->model('extension/customer_group_auto_assigned');
            $customer_group_info = $that->model_extension_customer_group_auto_assigned->getValues($customer_group_id);
            if ($customer_group_info['upload_tax_exemption']) {
                if ($customer_group_info['upload_later']==='1') {
                    $fields = ['upload_later','upload_tax_exemption', 'expire', 'expiration_date'];
                } else {
                    $fields = ['upload_tax_exemption', 'expire', 'expiration_date'];
                }
                foreach ($fields as $v) {
                    if (isset($that->session->data['error_'.$v])) {
                        $data['errors'][$v] = $that->session->data['error_'.$v];
                        unset($that->session->data['error_'.$v]);
                    }
                    if ($v==='upload_tax_exemption') {
                        $option_data = [
                            'type' => 'file',
                            'name' => $v,
                            'attr' => 'accept="image/png, image/gif, image/jpeg,application/pdf"'
                        ];
                    } elseif ($v==='expire') {
                        $options = [
                          '1' => $that->language->get('text_yes'),
                          '0' => $that->language->get('text_no')
                        ];
                        $option_data = [
                            'type' => 'selectbox',
                            'name' => $v,
                            'options' => $options
                        ];
                    } elseif ($v==='upload_later') {
                        $option_data = [
                            'type' => 'checkbox',
                            'name' => $v,
                            'value' => $that->request->post[$v] ?: '1',
                            'checked' => $that->request->post[$v]
                        ];
                    } else {
                        $option_data = [
                            'type' => 'input',
                            'name' => $v,
                            'placeholder' => $that->language->get('entry_date_format').'mm/dd/yyyy',
                            'value' => $that->request->post[$v]
                        ];
                    }
                    $data['entry_' . $v] = $that->language->get('entry_' . $v);
                    $data['additional'][$v] = $that->html->buildElement($option_data);
                }
                $data['dateformat'] = $that->language->get('date_format_short');
                $data['text_additional_fields'] = $that->language->get('text_additional_fields','customer_group_auto_assigned/customer_group_auto_assigned');
                $data['text_allowed_filename'] = $that->language->get('text_allowed_filename','customer_group_auto_assigned/customer_group_auto_assigned');
                $view = new AView($this->registry, 0);
                $view->batchAssign($data);
                $that->view->addHookVar('customer_attributes', $view->fetch('pages/account/auto_assigned_fields_create.tpl'));
            }
            $that->processTemplate();
        }
    }

    public function onModelAccountCustomer_ValidateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method[0]==='validateRegistrationData') {
            if ($that->request->get['group_id']) {
                $customer_group_id = $that->request->get['group_id'];
            } elseif ($that->customer->isLogged()) {
                $customer_group_id = $that->customer->getCustomerGroupId();
            } else {
                $customer_group_id = (int)$that->config->get('config_customer_group_id');
            }
            $that->load->model('extension/customer_group_auto_assigned');
            $customer_group_info = $that->model_extension_customer_group_auto_assigned->getValues($customer_group_id);
            $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
            $post = $that->session->data['base_post'];
            if ($customer_group_info['upload_tax_exemption'] === '1' && (($customer_group_info['upload_later']==='1' && !$post['upload_later'])|| $customer_group_info['upload_later']==='0') ) {
                $accept = ["image/jpeg", "image/png", "image/gif", "application/pdf"];
                $upmime = strtolower($_FILES["upload_tax_exemption"]["type"]);
                if (in_array($upmime, $accept) == false) {
                    $that->session->data['error_upload_tax_exemption'] = $that->language->get('error_upload_type');
                    $that->error['upload_tax_exemption'] = $that->language->get('error_upload_type');
                }
            }

            if ($this->verifyTaxId()) {
                $that->load->language('account/taxid_option');
                if ($that->config->get('telephone_option_mandatory_status') == '1') {
                    $phone = $post['telephone'] ?? '';
                    $pattern = $that->config->get('config_phone_validation_pattern') ?: '/^[0-9]{3,32}$/';
                    if (mb_strlen($phone) < 3
                        || mb_strlen($phone) > 32
                        || !preg_match($pattern, $phone)
                    ) {
                        $that->error['telephone'] = $that->language->get('telephone_error');
                        $this->error['telephone'] = '<br>'.$that->language->get('telephone_error');
                    }
                }

                if ($that->config->get('fax_option_mandatory_status') == '1') {
                    if (empty($post['fax']) || (mb_strlen($post['fax']) > 32)) {
                        $that->error['fax'] = $that->language->get('fax_error');
                        $this->errors['fax'] = '<br>'.$that->language->get('fax_error');
                    }
                }

                if ($that->config->get('company_option_mandatory_status') == '1') {
                    if (empty($post['company'])) {
                        $that->error['company'] = $that->language->get('company_error');
                        $this->errors['company'] = '<br>'.$that->language->get('company_error');
                    }
                }

                //$str=strtolower($v);
                if ($that->config->get('taxid_option_mandatory_status') == '1') {
                    if (empty($post['taxid']) && strtolower($post['taxid']) !== 'na' && strtolower($post['taxid']) !== 'none') {
                        $that->error['taxid'] = $that->language->get('taxid_error');
                        $this->errors['taxid'] = '<br>'.$that->language->get('taxid_error');
                    }
                }

                if ($that->config->get('registration_option_mandatory_status') == '1') {
                    if (empty($post['registration'])) {
                        $that->error['registration'] = $that->language->get('registration_error');
                        $this->errors['registration'] = '<br>'.$that->language->get('registration_error');
                    }
                }

                if ($that->config->get('bank_name_option_mandatory_status') == '1') {
                    if (empty($post['bank_name'])) {
                        $that->error['bank_name'] = $that->language->get('bank_name_error');
                        $this->errors['bank_name'] = '<br>'.$that->language->get('bank_name_error');
                    }
                }

                if ($that->config->get('bank_address_option_mandatory_status') == '1') {
                    if (empty($post['bank_address'])) {
                        $that->error['bank_address'] = $that->language->get('bank_address_error');
                        $this->errors['bank_address'] = '<br>'.$that->language->get('bank_address_error');
                    }
                }

                if ($that->config->get('iban_option_mandatory_status') == '1') {
                    if (empty($post['iban']) && strtolower($post['iban']) != 'na' && strtolower($post['iban']) != 'none') {
                        $that->error['iban'] = $that->language->get('iban_error');
                        $this->errors['iban'] = '<br>'.$that->language->get('iban_error');
                    }
                }

                if ($that->config->get('swift_option_mandatory_status') == '1') {
                    if (empty($post['swift']) && strtolower($post['swift']) != 'na' && strtolower($post['swift']) != 'none') {
                        $that->error['swift'] = $that->language->get('swift_error');
                        $this->errors['swift'] = '<br>'.$that->language->get('swift_error');
                    }
                }
            }

            if (count($that->error)) {
                if ($that->error['upload_tax_exemption']) {
                    if ($that->error['warning']) {
                        $that->error['warning'] = $that->error['warning'] . '<br>' . $that->language->get('error_upload_type');
                    } else {
                        $that->error['warning'] = $that->language->get('error_upload_type');
                    }
                } else {
                    //$that->error['warning'] = '';
                    foreach ($that->error as $key=> $error) {
                        if ($key==='warning') {
                            continue;
                        }
                        $that->error['warning'].='<br>'.$error;
                    }
                }
            }
        }
    }

    public function onControllerPagesAccountSuccess_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            if (isset( $that->session->data['base_post'] ) ) {
                unset( $that->session->data['base_post'] );
            }

            if ($that->session->data['customer_group_auto_assigned_settings']) {
                $customer_group_info = $that->session->data['customer_group_auto_assigned_settings'];
                $that->view->assign('heading_title', $that->language->get('heading_title'));

                if ($customer_group_info['email_activation'] === '1') {
                    $that->view->assign(
                        'text_message',
                        sprintf(
                            $that->language->get('text_activate'),
                            $that->config->get('store_name'),
                            $that->html->getURL('content/contact')
                        )
                    );
                    $that->view->assign('heading_title', $that->language->get('heading_title_activation'));
                } elseif ($customer_group_info['admin_approval'] === '1') {
                    $that->view->assign(
                        'text_message',
                        sprintf(
                            $that->language->get('text_approval'),
                            $that->config->get('store_name'),
                            $that->html->getURL('content/contact')
                        )
                    );
                } else {
                    $that->view->assign(
                        'text_message',
                        sprintf(
                            $that->language->get('text_message'),
                            $that->html->getURL('content/contact')
                        )
                    );
                }
                unset($that->session->data['customer_group_auto_assigned_settings']);
            }
        }
    }

    public function onModelAccountCustomer_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='sf_account_welcome_mail' || $this->baseObject_method==='sf_account_activation_mail' ) {
            $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
            $account_redirect_url = $that->html->getSecureURL('account/edit');
            $that->data['mail_template_data']['account_redirect_url'] = '<a href="'.$account_redirect_url.'">'.$that->language->get('text_here').'</a>';
        }
    }

    // -- End Of Customer Registration

   // -- Customer Edit Info

    public function onControllerPagesAccountEdit_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $request_data = $that->request->post;
        if ($this->baseObject_method === 'main') {
            if ($that->request->is_POST()) {
                $that->load->model('account/customer');
                if (!$that->error) {
                    $that->load->model('extension/customer_group_auto_assigned');
                    $customer_id = $that->customer->getId();
                    $customer_group_id = $that->customer->getCustomerGroupId();
                    $customer_group_info = $that->model_extension_customer_group_auto_assigned->getValues($customer_group_id);
                    if ($customer_group_info['upload_tax_exemption'] === '1') {
                        $accept = ["image/jpeg", "image/png", "image/gif", "application/pdf"];
                        $upmime = strtolower($_FILES["upload_tax_exemption"]["type"]);
                        if (in_array($upmime, $accept)) {
                            $filename = $_FILES['upload_tax_exemption']['name'];
                            $temp_name = $_FILES['upload_tax_exemption']['tmp_name'];
                            $current_year = date('Y');
                            $current_month = date('m');
                            if ($filename) {
                                if (!file_exists(DIR_EXT . 'customer_group_auto_assigned/files/')) {
                                    mkdir(DIR_EXT . 'customer_group_auto_assigned/files/');
                                }
                                if (!file_exists(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id)) {
                                    mkdir(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id, 0755);
                                }

                                if (!file_exists(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year)) {
                                    mkdir(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year, 0755);
                                }
                                if (!file_exists(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month)) {
                                    mkdir(DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month, 0755);
                                }

                                $upload_dir = DIR_EXT . 'customer_group_auto_assigned/files/' . $customer_id . '/' . $current_year . '/' . $current_month . '/';

                                // move file
                                $uploaded = move_uploaded_file($temp_name, $upload_dir . $filename);

                                if ($uploaded && $filename) {
                                    $data['image_url'] = 'files/' . $customer_id . '/' . $current_year . '/' . $current_month . '/' . $filename;
                                } else {
                                    //$that->log->write('Unable to upload file');
                                }
                                $data['customer_id'] = $customer_id;
                                $data['customer_group_id'] = $customer_group_id;
                                $data['expire'] = $that->request->post['expire'];
                                $data['expiration_date'] = $that->request->post['expiration_date'];
                                $that->model_extension_customer_group_auto_assigned->addInfo($data);
                            }
                        } else {
                            $info_id = $that->model_extension_customer_group_auto_assigned->getImage($customer_id);
                            $data['customer_group_auto_assigned_info_id'] = $info_id['customer_group_auto_assigned_info_id'];
                            $data['customer_id'] = $customer_id;
                            $data['expire'] = $that->request->post['expire'];
                            $data['expiration_date'] = $that->request->post['expiration_date'];
                            $that->model_extension_customer_group_auto_assigned->editInfo($data);
                        }
                    }
                }
            }
        }
    }

    public function onControllerPagesAccountEdit_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
          if ($this->baseObject_method === 'main') {
              $that->document->addScript($that->view->templateResource('/javascript/moment-with-locales.js'));
              $that->document->addScript($that->view->templateResource('/javascript/bootstrap-datetimepicker.min.js'));
              $that->document->addStyle(
                  [
                      'href' => $that->view->templateResource('/stylesheet/bootstrap-datetimepicker.min.css'),
                      'rel' => 'stylesheet',
                  ]
              );
            $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
            $that->load->model('extension/customer_group_auto_assigned');
            $customer_group_id = $that->customer->getCustomerGroupId();
            $customer_id = $that->customer->getId();
            $customer_group_info = $that->model_extension_customer_group_auto_assigned->getValues($customer_group_id);
            if ($customer_group_info['upload_tax_exemption']) {
                $data['entry_your_tax_exempt_certificate'] = $that->language->get('entry_your_tax_exempt_certificate');
                $tax_certificate = $that->model_extension_customer_group_auto_assigned->getImage($customer_id);
                $base = HTTPS ? HTTPS_SERVER : HTTP_SERVER;
                if ($tax_certificate['image_url']) {
                    $ext = pathinfo($tax_certificate['image_url'], PATHINFO_EXTENSION);
                    if ($ext==='pdf') {
                        $data['tax_certificate'] = '<object width="400px" height="400px" data="' . $base . 'extensions/customer_group_auto_assigned/' . $tax_certificate['image_url'] . '"></object>';
                    } else {
                        $data['tax_certificate'] = '<img src="' . $base . 'extensions/customer_group_auto_assigned/' . $tax_certificate['image_url'] . '" style="max-width: 100%;height: auto;"/>';
                    }
                    $data['expire'] = $tax_certificate['expire'];
                    if ($tax_certificate['expire'] === '1') {
                        $data['entry_expires_on'] = $that->language->get('entry_expires_on');
                        $data['expire_at'] = dateISO2Display($tax_certificate['expire_date'], $that->language->get('date_format_short'));
                    }
                }

                $fields = ['upload_tax_exemption','expire','expiration_date'];
                foreach ($fields as $v) {
                    if (isset($that->session->data['error_'.$v])) {
                        $data['errors'][$v] = $that->session->data['error_'.$v];
                        unset($that->session->data['error_'.$v]);
                    }
                    if ($v==='upload_tax_exemption') {
                        $option_data = [
                            'type' => 'file',
                            'name' => $v,
                            'attr' => 'accept="image/png, image/gif, image/jpeg,application/pdf"'
                        ];
                    } elseif ($v==='expire') {
                        $options = [
                            '1' => $that->language->get('text_yes'),
                            '0' => $that->language->get('text_no')
                        ];
                        $option_data = [
                            'type' => 'selectbox',
                            'name' => $v,
                            'options' => $options,
                            'value' => $tax_certificate['expire']
                        ];
                    } else {
                        $option_data = [
                            'type' => 'input',
                            'name' => $v,
                            'placeholder' =>  $that->language->get('entry_date_format').'mm/dd/yyyy',
                        ];
                    }
                    $data['entry_' . $v] = $that->language->get('entry_' . $v);
                    $data['additional'][$v] = $that->html->buildElement($option_data);
                }

                $data['text_additional_fields'] =  $that->language->get('text_additional_fields','customer_group_auto_assigned/customer_group_auto_assigned');
                $data['text_allowed_filename'] = $that->language->get('text_allowed_filename','customer_group_auto_assigned/customer_group_auto_assigned');
                $view = new AView($this->registry, 0);
                $view->batchAssign($data);
                $that->view->addHookVar('customer_attributes', $view->fetch('pages/account/auto_assigned_fields_edit.tpl'));
            }

        }
    }

    public function onControllerPagesAccountEdit_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if (isset($that->session->data['account_redirect_url'])) {
            redirect($that->html->getSecureURL($that->session->data['account_redirect_url']));
            unset($that->session->data['account_redirect_url']);
        }
    }

    protected function processFileUpload($customer_id) {
        $that =& $this->baseObject;
        $fm = new AFile();
        /** @var ModelSaleCustomerAttributes $mdl */
        $mdl = $that->load->model('sale/customer_attributes');
        $customer_id = !$customer_id ? $that->customer->getId() : $customer_id;
        foreach ($that->request->files['attributes']['name'] as $id => $name) {
            $attribute_data = $mdl->getAttributeInfo($id);
            if ($attribute_data['required'] && !has_value($name)) {
                $this->errors[$id] = $that->language->get('error_required');
            } else {
                if (!has_value($name)) {
                    continue;
                }

                $name = $customer_id.'_'.$name; //adds customer_id to set filename unique per customer
                $file_path_info = $fm->getUploadFilePath($attribute_data['settings']['directory'], $name);
                $mdl->addAttributesToCustomer($customer_id, [$id => $name]);

                $file_data = [
                    'option_id' => $id,
                    'name'      => $file_path_info['name'],
                    'path'      => $file_path_info['path'],
                    'type'      => $that->request->files['attributes']['type'][$id],
                    'tmp_name'  => $that->request->files['attributes']['tmp_name'][$id],
                    'error'     => $that->request->files['attributes']['error'][$id],
                    'size'      => $that->request->files['attributes']['size'][$id],
                ];

                $file_errors = $fm->validateFileOption($attribute_data['settings'], $file_data);
                if (has_value($file_errors)) {
                    $this->errors[$id] = $file_errors[0];
                }

                if (!has_value($this->errors)) {
                    move_uploaded_file($file_data['tmp_name'], $file_path_info['path']);
                    $dataset = new ADataset('file_uploads', 'admin');
                    $dataset->addRows(
                        [
                            'date_added' => date("Y-m-d H:i:s", time()),
                            'name'       => $file_path_info['name'],
                            'type'       => $file_data['type'],
                            'section'    => 'customer_attribute',
                            'section_id' => $attribute_data['attribute_id'],
                            'path'       => $file_path_info['path'],
                        ]
                    );
                }
            }
        }
    }

   // -- End Of Customer Edit Info

    // -- Checkout Confirmation Page, Fast Checkout Page, Invoice Page And Order Confirmation Email

    public function onControllerPagesCheckoutConfirm_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            if ($that->customer->isLogged()) {
                unset($that->session->data['account_redirect_url']);
                $that->load->model('extension/customer_group_auto_assigned');
                $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
                $that->load->model('account/address');
                $customer_id = $that->customer->getId();
                $customer_group_id = $that->customer->getCustomerGroupId();
                $info = $that->model_extension_customer_group_auto_assigned->getCustGroupSettings($customer_group_id,'checkout_confirm');
                $tax_exemption_status = $info['upload_tax_exemption'];
                $address_id = $that->customer->getAddressId();
                $address_info = $that->model_account_address->getAddress($address_id);
                if ($tax_exemption_status) {
                    $exemption_info = $that->model_extension_customer_group_auto_assigned->getExemptionInfo($customer_id);
                    if ($exemption_info) {
                        $data['exemption_info'] = $exemption_info;
                        $data['company_name'] = $address_info['company'];
                        $data['text_tax_exempt_company_name'] = $that->language->get('text_tax_exempt_company_name','customer_group_auto_assigned/customer_group_auto_assigned');
                        $data['text_tax_exempt_upload_date'] = $that->language->get('text_tax_exempt_upload_date','customer_group_auto_assigned/customer_group_auto_assigned');
                        $data['text_tax_exempt_have_expiration_date'] = $that->language->get('text_tax_exempt_have_expiration_date','customer_group_auto_assigned/customer_group_auto_assigned');
                        $data['text_tax_exempt_expiration_date'] = $that->language->get('text_tax_exempt_expiration_date','customer_group_auto_assigned/customer_group_auto_assigned');
                        if ($exemption_info['uploaded_at']!=='0000-00-00' && !is_null($exemption_info['uploaded_at'])) {
                            $uploaded_at = date_create($exemption_info['uploaded_at']);
                            $data['uploaded_at'] = $uploaded_at->format($that->language->get('date_format_short'));
                        }
                        $data['expire'] = $exemption_info['expire'] ==='0' ? $that->language->get('text_no'): $that->language->get('text_yes');
                       if ($exemption_info['expire_date'] !== '0000-00-00 00:00:00' && !is_null($exemption_info['expire_date'])) {
                            $expire_date = date_create($exemption_info['expire_date']);
                            $data['expire_date'] = $expire_date->format($that->language->get('date_format_short'));
                        }
                    } else {
                        $url = "<a href='".$that->html->getSEOURL('account/edit')."' target='_blank'>here</a>";
                        $that->session->data['account_redirect_url'] = 'checkout/confirm';
                        $data['no_tax_exemption_message'] = str_replace('[account_edit_url]',$url,html_entity_decode($info['no_tax_exemption_message']));
                    }
                    $data['text_tax_exempt_title'] = $that->language->get('text_tax_exempt_title','customer_group_auto_assigned/customer_group_auto_assigned');
                    $view = new AView($this->registry, 0);
                    $view->batchAssign($data);
                    $that->view->addHookVar('order_pre_attributes', $view->fetch('pages/checkout/confirm_auto_assigned_fields.tpl'));
                }
            }
        }
    }

    public function onControllerResponsesCheckoutPay_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            if ($that->customer->isLogged()) {
                unset($that->session->data['account_redirect_url']);
                $that->load->model('extension/customer_group_auto_assigned');
                $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
                $that->load->model('account/address');
                $customer_id = $that->customer->getId();
                $customer_group_id = $that->customer->getCustomerGroupId();
                $address_id = $that->customer->getAddressId();
                $address_info = $that->model_account_address->getAddress($address_id);
                $info = $that->model_extension_customer_group_auto_assigned->getCustGroupSettings($customer_group_id,'invoice');
                $tax_exemption_status = $info['upload_tax_exemption'];
                if ($tax_exemption_status) {
                    $exemption_info = $that->model_extension_customer_group_auto_assigned->getExemptionInfo($customer_id);
                    if ($exemption_info) {
                        $data['exemption_info'] = $exemption_info;
                        $data['company_name'] = $address_info['company'];
                        $data['text_tax_exempt_company_name'] = $that->language->get('text_tax_exempt_company_name','customer_group_auto_assigned/customer_group_auto_assigned');
                        $data['text_tax_exempt_upload_date'] = $that->language->get('text_tax_exempt_upload_date','customer_group_auto_assigned/customer_group_auto_assigned');
                        $data['text_tax_exempt_have_expiration_date'] = $that->language->get('text_tax_exempt_have_expiration_date','customer_group_auto_assigned/customer_group_auto_assigned');
                        $data['text_tax_exempt_expiration_date'] = $that->language->get('text_tax_exempt_expiration_date','customer_group_auto_assigned/customer_group_auto_assigned');
                        if ($exemption_info['uploaded_at']!=='0000-00-00' && !is_null($exemption_info['uploaded_at'])) {
                            $uploaded_at = date_create($exemption_info['uploaded_at']);
                            $data['uploaded_at'] = $uploaded_at->format($that->language->get('date_format_short'));
                        }
                        $data['expire'] = $exemption_info['expire'] ==='0' ? $that->language->get('text_no'): $that->language->get('text_yes');
                        if ($exemption_info['expire_date'] !== '0000-00-00 00:00:00' && !is_null($exemption_info['expire_date'])) {
                            $expire_date = date_create($exemption_info['expire_date']);
                            $data['expire_date'] = $expire_date->format($that->language->get('date_format_short'));
                        }
                    } else {
                        $url = "<a href='".$that->html->getSEOURL('account/edit')."' target='_blank'>here</a>";
                        $that->session->data['account_redirect_url'] = 'checkout/fast_checkout';
                        $data['no_tax_exemption_message'] = str_replace('[account_edit_url]',$url,html_entity_decode($info['no_tax_exemption_message']));
                    }
                    $data['text_tax_exempt_title'] = $that->language->get('text_tax_exempt_title','customer_group_auto_assigned/customer_group_auto_assigned');
                    $view = new AView($this->registry, 0);
                    $view->batchAssign($data);
                    $that->view->addHookVar('customer_additional_attributes', $view->fetch('pages/checkout/fc_auto_assigned_fields.tpl'));
                }
            }
        }
    }

    public function beforeModelCheckoutOrder_ProcessData()  {
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'sf_order_confirm_mail') {
            if ($that->customer->isLogged()) {
                $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
                $that->load->model('extension/customer_group_auto_assigned');
                $customer_id = $that->customer->getId();
                $customer_group_id = $that->customer->getCustomerGroupId();
                $info = $that->model_extension_customer_group_auto_assigned->getCustGroupSettings($customer_group_id,'confirmation_email');
                $tax_exemption_status = $info['upload_tax_exemption'];
                if ($tax_exemption_status) {
                    $exemption_info = $that->model_extension_customer_group_auto_assigned->getExemptionInfo($customer_id);
                    if ($exemption_info) {
                        $data['exemption_info'] = $exemption_info;
                        if (isset($that->data['mail_template_data']['payment_data']['payment_company'])) {
                            $data['company_name'] = $that->data['mail_template_data']['payment_data']['payment_company'];
                        } else {
                            $data['company_name'] = $that->data['mail_template_data']['payment_data']['company'];
                        }
                        $data['text_tax_exempt_company_name'] = $that->language->get('text_tax_exempt_company_name','customer_group_auto_assigned/customer_group_auto_assigned');
                        $data['text_tax_exempt_upload_date'] = $that->language->get('text_tax_exempt_upload_date','customer_group_auto_assigned/customer_group_auto_assigned');
                        $data['text_tax_exempt_have_expiration_date'] = $that->language->get('text_tax_exempt_have_expiration_date','customer_group_auto_assigned/customer_group_auto_assigned');
                        $data['text_tax_exempt_expiration_date'] = $that->language->get('text_tax_exempt_expiration_date','customer_group_auto_assigned/customer_group_auto_assigned');
                        if ($exemption_info['uploaded_at']!=='0000-00-00' && !is_null($exemption_info['uploaded_at'])) {
                            $uploaded_at = date_create($exemption_info['uploaded_at']);
                            $data['uploaded_at'] = $uploaded_at->format($that->language->get('date_format_short'));
                        }
                        $data['expire'] = $exemption_info['expire'] ==='0' ? $that->language->get('text_no'): $that->language->get('text_yes');
                       if ($exemption_info['expire_date'] !== '0000-00-00 00:00:00' && !is_null($exemption_info['expire_date'])) {
                            $expire_date = date_create($exemption_info['expire_date']);
                            $data['expire_date'] = $expire_date->format($that->language->get('date_format_short'));
                        }
                    } else {
                        $url = "<a href='".$that->html->getSEOURL('account/edit')."' target='_blank'>here</a>";
                        $data['no_tax_exemption_message'] = str_replace('[account_edit_url]',$url,$that->language->get('text_order_confirmation_no_exempt_file'));
                    }
                    $data['text_tax_exempt_title'] = $that->language->get('text_tax_exempt_title','customer_group_auto_assigned/customer_group_auto_assigned');
                    $view = new AView($this->registry, 0);
                    $view->batchAssign($data);
                    $that->data['mail_template_data']['tax_exemption_info'] = $view->fetch('pages/checkout/order_auto_assigned_fields.tpl');
                }
            }
        }
    }

    public function onModelCheckoutOrder_confirm($order_id, $order_status_id, $comment = '') {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;

        if ($that->customer->isLogged()) {
            $that->load->model('extension/customer_group_auto_assigned');
            $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
            $that->load->model('extension/customer_group_auto_assigned');
            $customer_id = $that->customer->getId();
            $customer_group_id = $that->customer->getCustomerGroupId();
            $info = $that->model_extension_customer_group_auto_assigned->getCustGroupSettings($customer_group_id,'confirmation_email');
            $tax_exemption_status = $info['upload_tax_exemption'];
            if ($tax_exemption_status) {
                $exemption_info = $that->model_extension_customer_group_auto_assigned->getExemptionInfo($customer_id);
                if (!$exemption_info) {
                   $that->model_extension_customer_group_auto_assigned->updateOrderOnHoldStatus($order_id);
                }
            }
        }
    }

    public function onControllerPagesAccountOrderDetails_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->loadModel('account/order');
            $that->loadModel('extension/fast_checkout');
            $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
            $that->load->model('extension/customer_group_auto_assigned');
            $order_id = 0;
            if ($that->customer->isLogged()) {
                //logged in customer, missing order ID?
                $order_id = (int) $that->request->get['order_id'];
                if (!$order_id) {
                    redirect($that->html->getSecureURL('account/history'));
                    return;
                }
                $order_info = $that->model_account_order->getOrder($order_id);
                if ($order_info) {
                    $customer_id = $that->customer->getId();
                    $customer_group_id = $that->customer->getCustomerGroupId();
                    $info = $that->model_extension_customer_group_auto_assigned->getCustGroupSettings($customer_group_id,'invoice');
                    $tax_exemption_status = $info['upload_tax_exemption'];
                    if ($tax_exemption_status) {
                        $exemption_info = $that->model_extension_customer_group_auto_assigned->getExemptionInfo($customer_id);
                        if ($exemption_info) {
                            $data['exemption_info'] = $exemption_info;
                            $data['company_name'] = $order_info['payment_company'];
                            $data['text_tax_exempt_company_name'] = $that->language->get('text_tax_exempt_company_name','customer_group_auto_assigned/customer_group_auto_assigned');
                            $data['text_tax_exempt_upload_date'] = $that->language->get('text_tax_exempt_upload_date','customer_group_auto_assigned/customer_group_auto_assigned');
                            $data['text_tax_exempt_have_expiration_date'] = $that->language->get('text_tax_exempt_have_expiration_date','customer_group_auto_assigned/customer_group_auto_assigned');
                            $data['text_tax_exempt_expiration_date'] = $that->language->get('text_tax_exempt_expiration_date','customer_group_auto_assigned/customer_group_auto_assigned');
                            if ($exemption_info['uploaded_at']!=='0000-00-00' && !is_null($exemption_info['uploaded_at'])) {
                                $uploaded_at = date_create($exemption_info['uploaded_at']);
                                $data['uploaded_at'] = $uploaded_at->format($that->language->get('date_format_short'));
                            }
                            $data['expire'] = $exemption_info['expire'] ==='0' ? $that->language->get('text_no'): $that->language->get('text_yes');
                           if ($exemption_info['expire_date'] !== '0000-00-00 00:00:00' && !is_null($exemption_info['expire_date'])) {
                                $expire_date = date_create($exemption_info['expire_date']);
                                $data['expire_date'] = $expire_date->format($that->language->get('date_format_short'));
                            }
                        } else {
                            $url = "<a href='".$that->html->getSEOURL('account/edit')."' target='_blank'>here</a>";
                            $data['no_tax_exemption_message'] = str_replace('[account_edit_url]',$url,html_entity_decode($info['no_tax_exemption_message']));
                        }
                        $data['text_tax_exempt_title'] = $that->language->get('text_tax_exempt_title','customer_group_auto_assigned/customer_group_auto_assigned');

                        $view = new AView($this->registry, 0);
                        $view->batchAssign($data);
                        $that->view->addHookVar('order_pre_attributes', $view->fetch('pages/account/fc_invoice_auto_assigned_fields.tpl'));
                    }
                }
            }
        }
    }

    public function onControllerPagesAccountInvoice_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->loadModel('account/customer');
            $that->load->model('account/order');
            $that->load->model('extension/customer_group_auto_assigned');
            $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');

            $order_id = (int) $that->request->get['order_id'];
            $guest = false;

            $enc = new AEncryption($that->config->get('encryption_key'));
            if (isset($that->request->get['ot']) && $that->config->get('config_guest_checkout')) {
                //try to decrypt order token
                $order_token = $that->request->get['ot'];
                if ($order_token) {
                    list($order_id, $email) = $that->model_account_customer->parseOrderToken($order_token);
                    if ($order_id && $email) {
                        $guest = true;
                        $order_info = $that->model_account_order->getOrder($order_id, '', 'view');
                    }
                }
            }

            if ($that->request->is_POST() && $this->_validate()) {
                $guest = true;
                $order_id = $that->request->post['order_id'];
                $email = $that->request->post['email'];
                $order_info = $that->model_account_order->getOrder($order_id);

                //compare emails
                if ($order_info['email'] != $email) {
                    unset($order_info, $order_id, $email);
                }
            }

            if (!$that->customer->isLogged() && !$guest) {
                $that->session->data['redirect'] = $that->html->getSecureURL('account/invoice', '&order_id=' . $order_id);
                $this->getInvoiceForm();
                return null;
            }

            if (!$order_id && $that->customer->isLogged()) {
                redirect($that->html->getSecureURL('account/history'));
            }

            //get info for registered customers
            if (!$order_info) {
                $order_info = $that->model_account_order->getOrder($order_id);
            }

            if ($order_info) {
                $customer_id = $that->customer->getId();
                $customer_group_id = $that->customer->getCustomerGroupId();
                $info = $that->model_extension_customer_group_auto_assigned->getCustGroupSettings($customer_group_id,'invoice');
                $tax_exemption_status = $info['upload_tax_exemption'];
                if ($tax_exemption_status) {
                    $exemption_info = $that->model_extension_customer_group_auto_assigned->getExemptionInfo($customer_id);
                    if ($exemption_info) {
                        $data['exemption_info'] = $exemption_info;
                        $data['company_name'] = $order_info['payment_company'];
                        $data['text_tax_exempt_company_name'] = $that->language->get('text_tax_exempt_company_name','customer_group_auto_assigned/customer_group_auto_assigned');
                        $data['text_tax_exempt_upload_date'] = $that->language->get('text_tax_exempt_upload_date','customer_group_auto_assigned/customer_group_auto_assigned');
                        $data['text_tax_exempt_have_expiration_date'] = $that->language->get('text_tax_exempt_have_expiration_date','customer_group_auto_assigned/customer_group_auto_assigned');
                        $data['text_tax_exempt_expiration_date'] = $that->language->get('text_tax_exempt_expiration_date','customer_group_auto_assigned/customer_group_auto_assigned');
                        if ($exemption_info['uploaded_at']!=='0000-00-00' && !is_null($exemption_info['uploaded_at'])) {
                            $uploaded_at = date_create($exemption_info['uploaded_at']);
                            $data['uploaded_at'] = $uploaded_at->format($that->language->get('date_format_short'));
                        }
                        $data['expire'] = $exemption_info['expire'] ==='0' ? $that->language->get('text_no'): $that->language->get('text_yes');
                       if ($exemption_info['expire_date'] !== '0000-00-00 00:00:00' && !is_null($exemption_info['expire_date'])) {
                            $expire_date = date_create($exemption_info['expire_date']);
                            $data['expire_date'] = $expire_date->format($that->language->get('date_format_short'));
                        }
                    } else {
                        $url = "<a href='".$that->html->getSEOURL('account/edit')."' target='_blank'>here</a>";
                        $data['no_tax_exemption_message'] = str_replace('[account_edit_url]',$url,html_entity_decode($info['no_tax_exemption_message']));
                    }
                    $data['text_tax_exempt_title'] = $that->language->get('text_tax_exempt_title','customer_group_auto_assigned/customer_group_auto_assigned');
                    $view = new AView($this->registry, 0);
                    $view->batchAssign($data);
                    $that->view->addHookVar('order_pre_attributes', $view->fetch('pages/account/invoice_auto_assigned_fields.tpl'));
                }
            }
        }
    }

    private function getInvoiceForm() {
        $that =& $this->baseObject;
        $that->document->resetBreadcrumbs();

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('index/home'),
            'text' => $that->language->get('text_home'),
            'separator' => false
        ]);

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('account/account'),
            'text' => $that->language->get('text_account'),
            'separator' => $that->language->get('text_separator')
        ]);

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('account/invoice'),
            'text' => $that->language->get('heading_title'),
            'separator' => $that->language->get('text_separator')
        ]);

        $this->data['back'] = $that->html->getHomeURL();

        $form = new AForm();
        $form->setForm(['form_name' => 'CheckOrderFrm']);

        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type' => 'form',
                'name' => 'CheckOrderFrm',
                'action' => $that->html->getSecureURL('account/invoice'),
                'csrf' => true
            ]);

        $order_id = (int)$that->request->post['order_id'] ? (int)$that->request->post['order_id'] : '';
        $this->data['form']['order_id'] = $form->getFieldHtml(
            [
                'type' => 'input',
                'name' => 'order_id',
                'value' => $order_id,
                'required' => true]);

        $this->data['entry_order_id'] = $that->language->get('text_order_id');

        $this->data['form']['email'] = $form->getFieldHtml(
            [
                'type' => 'input',
                'name' => 'email',
                'value' => $that->request->post['email'],
                'required' => true]);

        $this->data['entry_email'] = $that->language->get('text_email');

        $this->data['form']['back'] = $form->getFieldHtml(
            [
                'type' => 'button',
                'name' => 'back',
                'text' => $that->language->get('button_back'),
                'icon' => 'fa fa-arrow-left',
                'style' => 'button']);

        $this->data['form']['submit'] = $form->getFieldHtml(
            [
                'type' => 'submit',
                'icon' => 'fa fa-check',
                'name' => $that->language->get('button_continue')
            ]);

        $that->view->batchAssign($this->data);
        $that->processTemplate('pages/account/order.tpl');
    }

    private function _validate() {
        $that =& $this->baseObject;
        if (!(int)$that->request->post['order_id']){
            $this->error['order_id'] = $that->language->get('error_order_id');
        }

        if (mb_strlen($that->request->post['email']) > 96 || !preg_match(EMAIL_REGEX_PATTERN, $that->request->post['email'])){
            $this->error['email'] = $that->language->get('error_email');
        }

        $that->extensions->hk_ValidateData($this);

        return !$this->error ? true : false;
    }

    // -- End Of Checkout Confirmation Page, Fast Checkout Page, Invoice Page And Order Confirmation Email

    /**
     * @param $dispatch_rt
     * @param array $args
     * @return ADispatcher
     */
    protected function dispatch($dispatch_rt, $args = array ('')){
        return new ADispatcher($dispatch_rt, $args);
    }

    public function onControllerCommonHead_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $latestVersion = $this->getVersion();
                if ($latestVersion) {
                    $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
                    $that->load->model('extension/customer_group_auto_assigned_updater');
                    $total = $that->model_extension_customer_group_auto_assigned_updater->getTotalMsgIds();
                    if ($total > '0') {
                        $msg_ids = $that->model_extension_customer_group_auto_assigned_updater->getMsgIdsByCartVersions();
                        foreach ($msg_ids as $msg_id) {
                            $that->messages->deleteMessage($msg_id['msg_id']);
                            $that->model_extension_customer_group_auto_assigned_updater->deleteMsgID($msg_id['msg_id']);
                        }
                    }
                    $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_customer_group_auto_assigned_version_title'));
                    $msg = str_replace('[version_number]', str_replace('.', '-', $latestVersion), $that->language->get('text_new_customer_group_auto_assigned_version_description'));
                    $that->messages->saveNotice($msg_title, $msg);
                    $msg_info = $that->messages->getLikeMessage($msg_title);
                    $that->model_extension_customer_group_auto_assigned_updater->saveMessageId($msg_info['msg_id'], $latestVersion);
                }
            } else {
                $that->view->assign('search_url', $that->html->getNonSecureURL('search/search'));
            }
        }
    }

    private function getVersion() {
        $that =& $this->baseObject;
        $latestVersion = '';
        $license_key = $that->config->get('customer_group_auto_assigned_license_code');
        if ($license_key) {
            $valid = false;
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('customer_group_auto_assigned_license_info') . "'");
            if ($exist->num_rows === 1) {
                $that->load->model('extension/customer_group_auto_assigned_license_info');
                $store_id = $that->model_extension_customer_group_auto_assigned_license_info->getStoreId();

                $license_key = $that->model_extension_customer_group_auto_assigned_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_customer_group_auto_assigned_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);

                if ($validate['status'] === 'valid') {
                    if (stripos($license_key, 'rent-') !== false || stripos($license_key, 'mc-') !== false) {
                        $valid = true;
                    } elseif (stripos($license_key, 'own-') !== false) {
                        $today = date("Y-m-d H:i:s");
                        $support_date = date('Y-m-d H:i:s', strtotime($validate['updates']));
                        if ($today <= $support_date) {
                            $valid = true;
                        }
                    }
                }
            }
            if ($valid) {
                $that->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
                $getVersions = custGroupAutoAssignedUpdaterGetAllVersions();
                $that->load->model('extension/customer_group_auto_assigned_updater');
                $current_version = $that->model_extension_customer_group_auto_assigned_updater->getCurrentVersion();
                if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                    $versions = $getVersions['notification_data']['product_versions'];
                    if ($versions) {
                        $latestVersions = [];
                        foreach ($versions as $version) {
                            if (strpos($version['version_number'], VERSION) !== false) {
                                $latestVersions[] = $version['version_number'];
                            }
                        }
                        usort($latestVersions, 'version_compare');
                        $latestVersion = end($latestVersions);
                        if (version_compare($current_version, $latestVersion, '<') === true) {
                            $msg_ids = $that->model_extension_customer_group_auto_assigned_updater->getMsgIdsByCurrentCartVersion();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_customer_group_auto_assigned_updater->deleteMsgID($msg_id['msg_id']);
                            }
                            return $latestVersion;
                        }
                    }
                } else {
                    return '';
                }
            } else {
                return '';
            }
        }
    }
 }