<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

if (!class_exists('ExtensionCustomerGroupAutoAssigned')) {
    include_once('core/customer_group_auto_assigned_hook.php');
}

$controllers = [
    'storefront' => [],
    'admin' => [
        'pages/extension/tax_exempt_certificate_list',
        'pages/extension/customer_group_auto_assigned_updater',
        'pages/sale/customer_group_auto_assigned_settings',
        'responses/listing_grid/tax_exempt_certificate_list',
        'responses/sale/customer_group_auto_assigned_settings']
];

$models = [
    'storefront' => [
        'extension/customer_group_auto_assigned',
        'extension/customer_group_auto_assigned_license_info'
    ],
    'admin' => [
        'extension/customer_group_auto_assigned',
        'extension/customer_group_auto_assigned_updater',
        'extension/customer_group_auto_assigned_verify',
        'extension/customer_group_auto_assigned_license_info']
];

$templates = [
    'storefront' => [
        'pages/account/auto_assigned_fields_create.tpl',
        'pages/account/auto_assigned_fields_edit.tpl',
        'pages/account/fc_invoice_preferences_fields.tpl',
        'pages/checkout/fc_auto_assigned_fields.tpl',
        'pages/account/invoice_preferences_fields.tpl',
        'pages/checkout/confirm_auto_assigned_fields.tpl',
        'pages/checkout/order_auto_assigned_fields.tpl',
    ],
    'admin' => [
        'pages/extension/extensions_edit.tpl',
        'pages/extension/customer_group_auto_assigned_updater.tpl',
        'pages/extension/tax_exempt_certificate_list.tpl',
        'pages/sale/customer_group_auto_assigned_settings.tpl',
        'pages/sale/order_details_auto_assigned_fields.tpl',
        'responses/sale/sale_invoice_auto_assigned_fields.tpl',
        'pages/extension/customer_group_auto_assigned_manual.tpl',
        'pages/extension/extension_summary_button.tpl',
        'pages/extension/extensions.post.tpl',
        'pages/extension/customer_group_manufacturer_access_list.tpl',
		'pages/extension/extensions_edit.post.tpl',]
];

$languages = [
    'storefront' => [
        'customer_group_auto_assigned/customer_group_auto_assigned'],
    'admin' => [
        'customer_group_auto_assigned/customer_group_auto_assigned']
];