<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}


require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

$mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
$diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
$shared_secret = "email_editor";

$public_key = "";
$path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

if ($this->config->get('email_editor_license_code')) {
    $license_key = $this->config->get('email_editor_license_code');
    $license = new License($path_to_phpseclib);
    $license_manager = $license->getManager();
    if (stripos($license_key, 'mc-') !== false) {
        $server_url = $mc_server_url;
    } else {
        $server_url = $diy_server_url;
    }
    $license_manager->setLicenseServerUrl($server_url);
    $license_manager->setKeys($license_key, "", $shared_secret);
    $public_key = $license_manager->requestKey();
    $this->load->model('extension/email_editor_license_info');

    $store_id = (int)$this->config->get('config_store_id');

    $license_manager->setKeys($license_key, $public_key, $shared_secret);
    $custom_data = ['version' => '1.3.3.1'];
    $license_data = $license_manager->requestData($custom_data);
    if (!is_null($license_data)) {
        $ttl = 1209600;
        $validate = $license_manager->validate($license_data, $ttl);

        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
            $data['public_key'] = $public_key;
            $data['license_data'] = $license_data;
            $data['license_key'] = $license_key;
            $data['store_id'] = $store_id;
            $data['last_check'] = time();
            $this->load->model('extension/email_editor_license_info');
            $this->model_extension_email_editor_license_info->saveLicenseData($data);
        }
    }
}

$describe="DESCRIBE ".$this->db->table('email_editor_templates')." section";
$results=$this->db->query($describe);
if (strtolower($results->row['Type'])==='varchar(32)') {
    $alter = "ALTER table " . $this->db->table( 'email_editor_templates' ) . " MODIFY COLUMN `section` VARCHAR(256) NOT NULL";
    $this->db->query( $alter );
}

$account_approved_subject='Welcome, {{store_name}} ';
$account_approved_content='Welcome and thank you for registering at {{store_name}}<br><br>';
$account_approved_content.='Your account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:<br/>
            <a href="{{login_url}}">{{login_url}}</a><br/><br/>
            Once you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.';
$account_approved_content.='Thank you.<br/>{{store_name}}';

$check1= "SHOW columns from ".$this->db->table('email_editor_templates')." where field='store_id'";
$q1=$this->db->query($check1);
$exist1=count($q1->rows);
if ($exist1==0) {
    $sql12 = "ALTER TABLE ".$this->db->table('email_editor_templates')." ADD `store_id` INT(11) COLLATE utf8_general_ci AFTER `notify_admin`";
    $this->db->query($sql12);
}

$check2= "SHOW columns from ".$this->db->table('email_editor_signatures')." where field='store_id'";
$q2=$this->db->query($check2);
$exist2=count($q2->rows);
if ($exist2==0) {
    $sql13 = "ALTER TABLE ".$this->db->table('email_editor_signatures')." ADD `store_id` INT(11) COLLATE utf8_general_ci AFTER `content`";
    $this->db->query($sql13);
}

$check20= "SHOW columns from ".$this->db->table('email_editor_templates')." where field='allowed_placeholders'";
$q20=$this->db->query($check20);
$exist20=count($q20->rows);
if ($exist20==0) {
    $sql20 = "ALTER TABLE ".$this->db->table('email_editor_templates')." ADD `allowed_placeholders` text COLLATE utf8_unicode_ci NOT NULL AFTER `default_content`";
    $this->db->query($sql20);
}

$sql4 = "SELECT * FROM " . $this->db->table("email_editor_templates");
$query4 = $this->db->query($sql4);
$results4 = $query4->rows;

foreach ($results4 as $res4) {
    $query6 = $this->db->query("SELECT * FROM ". $this->db->table("email_editor_templates"). " WHERE `content` LIKE '%{{%' AND `section`='".$res4['section']."'");
    if ($query6->row) {
        continue;
    }
    $this->db->query("UPDATE ". $this->db->table("language_definitions")." SET `language_value` = REPLACE(`language_value`,'{','{{') WHERE `language_key`='text_".$res4['section']."_info'");
    $this->db->query("UPDATE ". $this->db->table("language_definitions")." SET `language_value` = REPLACE(`language_value`,'}','}}') WHERE `language_key`='text_".$res4['section']."_info'");
    $this->db->query("UPDATE ". $this->db->table("email_editor_templates")." SET `subject` = REPLACE(`subject`,'{','{{') WHERE `section`='".$res4['section']."'");
    $this->db->query("UPDATE ". $this->db->table("email_editor_templates")." SET `subject` = REPLACE(`subject`,'}','}}') WHERE `section`='".$res4['section']."'");
    $this->db->query("UPDATE ". $this->db->table("email_editor_templates")." SET `content` = REPLACE(`content`,'{','{{') WHERE `section`='".$res4['section']."'");
    $this->db->query("UPDATE ". $this->db->table("email_editor_templates")." SET `content` = REPLACE(`content`,'}','}}') WHERE `section`='".$res4['section']."'");
    $this->db->query("UPDATE ". $this->db->table("email_editor_templates")." SET `default_content` = REPLACE(`content`,'{','{{') WHERE `section`='".$res4['section']."'");
    $this->db->query("UPDATE ". $this->db->table("email_editor_templates")." SET `default_content` = REPLACE(`content`,'}','}}') WHERE `section`='".$res4['section']."'");
}

$sql5 = "SELECT `store_id` FROM " . $this->db->table("stores");
$query5 = $this->db->query($sql5);
$results5 = $query5->rows;

foreach ($results5 as $result) {
    $store_id = $result["store_id"];
    $exist = $this->db->query("SELECT COUNT(*) as exist FROM " . $this->db->table("email_editor_templates") . " WHERE `store_id`=" . $store_id);
    $exist_result = $exist->row['exist'];
    if ($store_id === '0') {
        $this->db->query("UPDATE " . $this->db->table("email_editor_templates") . " SET `store_id`=0");
        $account_approved = $this->db->query("SELECT COUNT(*) as exist FROM " . $this->db->table('email_editor_templates') . " WHERE `section` = 'account_approved' AND `store_id`=".$store_id);
        $exist = $account_approved->row['exist'];

        if ($exist === '0') {
            $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
                              `sender_name`='',`sender_email`='',`section` = 'account_approved', 
                              `subject`='" . $this->db->escape($account_approved_subject) . "', 
                              `default_subject`='" . $this->db->escape($account_approved_subject) . "' , 
                              `content` = '" . $this->db->escape($account_approved_content) . "', 
                              `default_content` = '" . $this->db->escape($account_approved_content) . "',
                              `allowed_placeholders`='store_name, login_url',
                              `email_signature_id` = 0,
                              `notify_admin`=0',`store_id`=0
                              ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
                             VALUES ('1','1','email_editor_email_editor','text_account_approved_info','Important Notes: <br>
                             1.&nbsp;This template has several defined tags such as {{store_name}}, {{login_url}}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
                             2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
                              VALUES ('1','1','email_editor_email_editor','text_account_approved_subject','Account Approved Email Subject:',now(),now())");

            $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
                              VALUES ('1','1','email_editor_email_editor','text_account_approved_content','Account Approved Email Content:',now(),now())");
        }

        if (file_exists(DIR_EXT . 'customer_group_auto_assigned') && $this->config->get('customer_group_auto_assigned_status')) {
            $sql2 = 'CREATE TABLE IF NOT EXISTS ' . $this->db->table('email_editor_customer_group') . ' (
                `email_editor_customer_group_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                `email_template_id` int(11),
                `customer_group_id` int(11),
                `section_name` VARCHAR(256)
                )ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci';

            $this->db->query($sql2);

            $query_customer_groups = $this->db->query("SELECT * FROM " . $this->db->table("customer_groups"));
            $customer_groups = $query_customer_groups->rows;
            foreach ($customer_groups as $cust_group) {
                $search = [" ", "'",];
                $replace = "_";
                $section = str_replace($search, $replace, strtolower($cust_group['name']));

            $account_activated_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_create' AND `store_id`='.$store_id'");
            if ($account_activated_exist->row['total'] === '0') {
                $account_activated = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_create'");
                $account_activated_info = $account_activated->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                          SET `section` = '" . $section . "_account_create', 
                          `sender_name`='" . $account_activated_info['sender_name'] . "',`sender_email`='" . $account_activated_info['sender_email'] . "',`subject`='" . $account_activated_info['subject'] . "', 
                          `default_subject`='" . $account_activated_info['default_subject'] . "',
                          `content` = '" . $account_activated_info['content'] . "', 
                          `default_content` = '" . $account_activated_info['default_content'] . "',
                          `allowed_placeholders`='store_name, login_url',
                          `email_signature_id` = '" . $account_activated_info['email_signature_id'] . "',
                          `notify_admin`='" . $account_activated_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_create_email_id = $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_create_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            }

            $account_approval_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_approval' AND `store_id`='.$store_id'");
            if ($account_approval_exist->row['total'] === '0') {
                $account_approval = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_approval'");
                $account_approval_info = $account_approval->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                          SET `section` = '" . $section . "_account_approval', 
                          `sender_name`='" . $account_approval_info['sender_name'] . "',`sender_email`='" . $account_approval_info['sender_email'] . "',`subject`='" . $account_approval_info['subject'] . "', 
                          `default_subject`='" . $account_approval_info['default_subject'] . "',
                          `content` = '" . $account_approval_info['content'] . "', 
                          `default_content` = '" . $account_approval_info['default_content'] . "',
                          `allowed_placeholders`='store_name, login_url',
                          `email_signature_id` = '" . $account_approval_info['email_signature_id'] . "',
                          `notify_admin`='" . $account_approval_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_approval_email_id =  $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_approval_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            }

            $account_activation_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='" . $section . "_account_activation' AND `store_id`='.$store_id'");
            if ($account_activation_exist->row['total'] === '0') {
                $account_activation = $this->db->query("SELECT * FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='account_activation'");
                $account_activation_info = $account_activation->row;
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  
                          SET `section` = '" . $section . "_account_activation', 
                          `sender_name`='" . $account_activation_info['sender_name'] . "',`sender_email`='" . $account_activation_info['sender_email'] . "',`subject`='" . $account_activation_info['subject'] . "', 
                          `default_subject`='" . $account_activation_info['default_subject'] . "',
                          `content` = '" . $account_activation_info['content'] . "', 
                          `default_content` = '" . $account_activation_info['default_content'] . "',
                          `allowed_placeholders`='store_name, activate_url',
                          `email_signature_id` = '" . $account_activation_info['email_signature_id'] . "',
                          `notify_admin`='" . $account_activation_info['notify_admin'] . "', `store_id`='" . $store_id . "'
                          ON DUPLICATE KEY UPDATE  
                          `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
                $account_activation_email_id =  $this->db->getLastId();
                $this->db->query("INSERT INTO " . $this->db->table('email_editor_customer_group') . "  
                          SET `email_template_id`=" . $account_activation_email_id . ",`customer_group_id`=" . $cust_group['customer_group_id'] . ",`section_name`='" . $section . "'");
            }

            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_info'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_subject'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_create_content'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_info'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_subject'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_activation_content'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_info'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_subject'");
            $this->db->query("DELETE FROM " . $this->db->table("language_definitions") . " WHERE `block`='email_editor_email_editor' AND `language_key`='text_" . $section . "_account_approval_content'");

                $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {{store_name}}, {{login_url}}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

                $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_subject','Account Create Email Subject:',now(),now())");

                $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_create_content','Account Create Email Content:',now(),now())");

                $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {{store_name}}, {{activate_url}}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

                $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_subject','Account Activation Email Subject:',now(),now())");

                $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_activation_content','Account Activation Email Content:',now(),now())");

                $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {{store_name}}, {{login_url}}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

                $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_subject','Account Needs Approval Email Subject:',now(),now())");

                $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_" . $section . "_account_approval_content','Account Needs Approval Email Content:',now(),now())");

                $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, login_url'"." WHERE `section` = '" . $section . "_account_approved'");
                $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, login_url'"." WHERE `section` = '" . $section . "_account_create'");
                $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, login_url'"." WHERE `section` =  '" . $section . "_account_approval'");
                $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, activate_url'"." WHERE `section` = '" . $section . "_account_activation'");

            }
        }

        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, login_url'"." WHERE `section` = 'account_create'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, login_url'"." WHERE `section` =  'account_approval'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, login_url'"." WHERE `section` = 'account_activated'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, activate_url'"." WHERE `section` = 'account_activation'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, amount, transaction_url, comment'"." WHERE `section` = 'customer_transaction'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, reset_password'"." WHERE `section` = 'account_reset_password' AND  `store_id`='" . $store_id . "'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, login_url'"." WHERE `section` = 'account_reset_password_success' AND  `store_id`='" . $store_id . "'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, login_url'"." WHERE `section` = 'account_approval' AND  `store_id`='" . $store_id . "'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, loginname'"." WHERE `section` = 'account_loginname_reminder' AND  `store_id`='" . $store_id . "'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, order_id, invoice_url, order_date, order_status, order_comment,company,firstname,lastname'"." WHERE `section` = 'order_status_update' AND  `store_id`='" . $store_id . "'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='store_name, order_id, invoice_url, order_details, order_comment'"." WHERE `section` = 'order_confirmation' AND  `store_id`='" . $store_id . "'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='company, firstname, lastname, shipper_name, tracking_number, tracking_url'"." WHERE `section` = 'shipping_info' AND  `store_id`='" . $store_id . "'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='company, firstname, lastname, delivery_date, shipper_name'"." WHERE `section` = 'local_shipping_info' AND  `store_id`='" . $store_id . "'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `allowed_placeholders`='company, firstname, lastname, available_date'"." WHERE `section` = 'store_pickup_info' AND  `store_id`='" . $store_id . "'");

        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `content` = CONCAT('Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>',`content`)"." WHERE `section` = 'shipping_info' AND  `store_id`='" . $store_id . "'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `content` = CONCAT('Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>',`content`)"." WHERE `section` = 'local_shipping_info' AND  `store_id`='" . $store_id . "'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `content` = CONCAT('Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>',`content`)"." WHERE `section` = 'store_pickup_info' AND  `store_id`='" . $store_id . "'");

        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `default_content` = CONCAT('Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>',`default_content`)"." WHERE `section` = 'shipping_info' AND  `store_id`='" . $store_id . "'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `default_content` = CONCAT('Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>',`default_content`)"." WHERE `section` = 'local_shipping_info' AND  `store_id`='" . $store_id . "'");
        $this->db->query("UPDATE " . $this->db->table('email_editor_templates') . "  SET `default_content` = CONCAT('Company: {{company}} <br>Name: {{firstname}} {{lastname}}<br>',`default_content`)"." WHERE `section` = 'store_pickup_info' AND  `store_id`='" . $store_id . "'");

    } elseif ($store_id !== '0') {
        $email_templates = $this->db->query("SELECT * FROM " . $this->db->table("email_editor_templates") . " WHERE `store_id`=0");
        $templates = $email_templates->rows;
        foreach ($templates as $template){
            $this->db->query("INSERT INTO " . $this->db->table('email_editor_templates') . "  (`sender_name`, `sender_email`, `section`, `subject`, `default_subject`, `content`, `default_content`,`allowed_placeholders`,`email_signature_id`,`notify_admin`,`store_id`)
                             VALUES ('".$template['sender_name']."','".$template['sender_email']."','".$template['section']."','".$template['subject']."','".$template['default_subject']."','".$template['content']."', 
                             '".$template['default_content']."','".$template['allowed_placeholders']."','".$template['email_signature_id']."','".$template['notify_admin']."','".$store_id."')");
        }
    }

    $signature_exist = $this->db->query("SELECT COUNT(*) as exist FROM " . $this->db->table("email_editor_signatures") . " WHERE `store_id`=" . $store_id);
    $signature_exist_result = $signature_exist->row['exist'];
    if ($store_id === '0' && $signature_exist_result === '0') {
        $this->db->query("UPDATE " . $this->db->table("email_editor_signatures") . " SET `store_id`=0");
    } else {
        $email_signatures = $this->db->query("SELECT * FROM " . $this->db->table("email_editor_signatures") . " WHERE `store_id`=0");
        $signatures = $email_signatures->rows;
        foreach ($signatures as $signature){
            $this->db->query("INSERT INTO " . $this->db->table('email_editor_signatures') . "  (`title`, `content`,`store_id`)
                             VALUES ('".$signature['title']."','".$signature['content']."','".$store_id."')");
        }
    }
}

$this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_allowed_placeholders','Allowed Placeholders:<br /><span class=\"help\">Coma separated list of allowed variable names.</span>',now(),now())");

//$this->db->query("UPDATE ")

$sql = "UPDATE ".$this->db->table('language_definitions')." set language_value='
        This is a WHY2 extension.  All support and updates are managed from WHY2. <br>
        Read about WHY2\'s 12 months support <a href=\"https://why2central.net/knowledgebase/why2-support-and-updates-policy/\" target=\"_blank\" style=\"font-weight:bold;\">here</a> and how WHY2 updates are delivered <a href=\"https://why2central.net/knowledgebase/extension-updater/\" target=\"_blank\" style=\"font-weight:bold;\">here</a>.<br>
        You can safely ignore Support expired notification within the Admin Dashboard.<br><br>
        This extension gives you :<br>
        1.&nbsp;The ability to modify email content without the need to edit the language definition or position. Allows you to use more than one email address for sending of different email notifications, eg  orders@mystore,  info@mystore. Also, you can select to receive an exact copy of the email that was sent to your customer.<br>
        2.&nbsp;Add package tracking information in <a href=\"#admin#rt=sale/order\">admin -> sales -> orders -> order details</a>.<br>
        <strong>Currently our extension automatically convert the following shipper company tracking URL into clickable link:<br>
        A.&nbsp;Australia Post.<br>
        B.&nbsp;Canada Post.<br>
        C.&nbsp;FedEx.<br>
        D.&nbsp;Purolator.<br>
        E.&nbsp;Parcel Force.<br>
        F.&nbsp;Royal Mail.<br>
        G.&nbsp;UPS.<br>
        H.&nbsp;USPS.<br>
        I.&nbsp;R+L Carriers.<br>
        Want us to support a new courier? <a href=\"https://wehearyou2.com/clientarea/client/login/\" target=\"_blank\" style=\"font-weight:bold;\">Contact us</a><br><br>
<strong>Notes: There are two ways to obtain the license key. <br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;a. Use this <a href=\"https://wehearyou2.com/clientarea/reg/register.php\" target=\"_blank\" style=\"font-weight:bold;\">form</a> to register to our Support system and generate your license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;b. Already registered -  click <a href=\"https://wehearyou2.com/clientarea/reg/index.php\" target=\"_blank\" style=\"font-weight:bold;\">here</a> to log into your account to obtain license key.<br>
        Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to obtain the license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;c. If you already have an account in our support system and you are using multiple extensions from WHY2,  you do NOT need to create another account in the support system.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;d. Updating extension in same location does NOT require a new key.<br> Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to Update extension in same location.</strong><br><br>
        1.&nbsp;Enter your WHY2 license key here.<br>
        2.&nbsp;Append Comments: Turn ON to append comments in order history.<br>
        3.&nbsp;Notify Customer: Turn ON if you want to notify your customer when you add tracking details.' WHERE language_key='email_editor_note';";
$this->db->query($sql);

$sql1 = "UPDATE ".$this->db->table('language_definitions')." set language_value='Enter your WHY2 license key:' WHERE language_key='email_editor_license_code';";
$this->db->query($sql1);

$sql2 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("email_editor_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql2);

$sql3 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("email_editor_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql3);

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_contact_customer_name'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_new_email_editor_version_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_new_email_editor_version_description'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_update_success'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_update_failed'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='button_start_update'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='button_cancel_update'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_update_email_editor_note'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_email_editor_updater_heading_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_changelog'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_no_updates'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='button_go_back'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='email_editor_license_expired'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_contact_customer_name',' Important Notes:<br>
        1.&nbsp;The message has two defined tags which are {{customer_firstname}} and {{customer_lastname}}. {{customer_firstname}} will be converted into customer first name and {{customer_lastname}} will be converted into customer last name. You can use one or both of them.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_new_email_editor_version_title','New version (v[new_version]) of Email Editor Extension',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_new_email_editor_version_description','There is a new version of Email Editor Extension. Please open -->#admin#rt=extension/email_editor_updater&version=[version_number] to update the extension. <br><br>
                        The update will replace existing files with the update files.<br><br>Make sure that you have made a backup of your store prior to updating. Use your normal backup method or Softaculous to make a backup prior to updating your site. Need help on how to backup an installation by using Softaculous click <a href=\"https://why2central.net/knowledgebase/how-to-backup-an-installation/\" target=\"_BLANK\"><b>here</b></a>.<br><br>
                        Do not delete this message until you have updated.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_update_success','The Email Editor extension has been successfully updated.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_update_failed','We are unable to update the Email Editor extension, please check <a target=\"_BLANK\" href=\"#admin#rt=tool/error_log\">error log</a> for more information.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','button_start_update','Start Update',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','button_cancel_update','Cancel Update',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_update_email_editor_note','Note:<br>We are going to update Email Editor extension. The update will replace existing files with the update files.<br><br>Make sure that you have made a backup of your store prior to updating. Use your normal backup method or Softaculous to make a backup prior to updating your site. Need help on how to backup an installation by using Softaculous click <a href=\"https://why2central.net/knowledgebase/how-to-backup-an-installation/\" target=\"_BLANK\"><b>here</b></a>.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_email_editor_updater_heading_title', 'Email Editor Updater',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_changelog','Changelog:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_no_updates','There are no new updates for this extension.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','button_go_back','Go Back',now(),now())");

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_quick_checkout_account_create_subject'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_quick_checkout_account_create_content'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='email_editor_email_editor' AND `language_key`='text_quick_checkout_account_create_info'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_quick_checkout_account_create_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {{store_name}}, {{login_url}}, {login} and {password}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_quick_checkout_account_create_subject','Quick Checkout Account Create Email Subject:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_quick_checkout_account_create_content','Quick Checkout Account Create Email Content:',now(),now())");

$this->db->query("UPDATE ".$this->db->table("language_definitions")." SET `language_value`='Cancel' WHERE `language_key`='button_cancel' AND `block`='email_editor_email_editor'");

if (file_exists(DIR_EXT.'delivery_scheduler') && $this->config->get('delivery_scheduler_status')==='1') {
    $order_status_update = $this->db->query("SELECT `content` FROM ". $this->db->table('email_editor_templates')." WHERE `section`='order_status_update'");
    $order_status_update_content = $order_status_update->row['content'];
    $new_order_status_update_content = str_replace('[The comments for your order are:]','[The comments or special delivery instructions for your order are:]',$order_status_update_content);
    $this->db->query("UPDATE ". $this->db->table('email_editor_templates')." SET `content` ='".$new_order_status_update_content."' WHERE `section`='order_status_update'");

    $order_confirmation_ = $this->db->query("SELECT `content` FROM ". $this->db->table('email_editor_templates')." WHERE `section`='order_confirmation'");
    $order_confirmation_content = $order_confirmation_->row['content'];
    $new_order_confirmation_content = str_replace('[The comments for your order are:]','[The comments or special delivery instructions for your order are:]',$order_confirmation_content);
    $this->db->query("UPDATE ". $this->db->table('email_editor_templates')." SET `content` ='".$new_order_confirmation_content."' WHERE `section`='order_confirmation'");
}

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='email_editor_email_editor' AND `language_key`='text_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='email_editor_email_editor' AND `language_key`='button_diy_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='email_editor_email_editor' AND `language_key`='button_mc_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='email_editor_email_editor' AND `language_key`='text_update_email_editor_available'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_support_by_why2','Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','button_diy_support_by_why2','If you are self-managed users click here for support. Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','button_mc_support_by_why2','If you are a WHY2 Managed Client click here for support. Updates are part of the Managed Services.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_update_email_editor_available','New version (%s) is available. <a href=\"%s\" target=\"_BLANK\"><strong>Click to update now.</strong></a>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','email_editor_license_expired','Your license key is expired. Possibly due to inactive with the extension for more than 14 days. Please click on the SAVE button at the bottom of this page.',now(),now())");

$this->db->query("UPDATE ".$this->db->table("language_definitions")." SET `language_value`='Cancel' WHERE `language_key`='button_cancel' AND `block`='email_editor_email_editor'");

$exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('email_editor_license') . "'");
if ($exist->num_rows === 1) {
    $this->db->query("DROP TABLE ".$this->db->table("email_editor_license"));
}

if (file_exists(DIR_EXT.'email_editor/admin/view/default/template/pages/extension/extensions_edit.tpl')) {
    unlink(DIR_EXT.'email_editor/admin/view/default/template/pages/extension/extensions_edit.tpl');
}

$rl = $this->db->query("SELECT COUNT(*) as exist FROM ".$this->db->table('shipper_tracking_url')." WHERE `shipper_name`='R+L Carriers'");
$exist = $rl->row['exist'];

if ($exist === '0') {
    $this->db->query("INSERT INTO " . $this->db->table('shipper_tracking_url') . " (`shipper_name`,`tracking_url`) VALUES ('R+L Carriers','https://m.rlcarriers.com/ShipmentTracing/?rstn={tracking_number}')");
}

if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = [];
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'email_editor' . DIR_EXT_CORE . 'lib/license', DIR_SYSTEM.'lib');
}