<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
class ModelExtensionEmailEditor extends Model {

    public $data=[];
    public $placeholders = [];

    /**
     * @param $email
     * @param $activated
     * @param string $section
     * @param string $custom_mail
     * @return bool|null
     * @throws AException
     * @throws ReflectionException
     */
    public function sendWelcomeEmail($email, $activated,$section='',$custom_mail='') {
        if (!$email) {
            return null;
        }
        //build welcome email in text format
        $login_url = $this->html->getSecureURL('account/login');
        $this->language->load('mail/account_create');

        if ($custom_mail) {
            if ($activated) {
                $details = $this->getDetails($section.'_account_create');
            } else {
                $details = $this->getDetails($section.'_account_approval');
            }
        } else {
            if ($activated) {
                $details = $this->getDetails('account_create');
            } else {
                $details = $this->getDetails('account_approval');
            }
        }

        $sender_name=$details['sender_name'] ? $details['sender_name']:$this->config->get('store_name');
        $sender_email=$details['sender_email'] ? $details['sender_email']:$this->config->get('store_main_email');

        $signature=html_entity_decode($details['signature']);
        $login_url='<a href="'.$login_url.'" target="_BLANK">'.$login_url.'</a>';

        $this->data['mail_template_data']['store_name'] = $this->config->get('store_name');
        $this->data['mail_template_data']['login_url'] = $login_url;

        $mustache = new Mustache_Engine(['escape' => function ($value) {
            return $value;
        }]);

        $arAllowedPlaceholders = explode(',', $details['allowed_placeholders']);

        foreach ($arAllowedPlaceholders as &$placeholder) {
            $placeholder = trim($placeholder);
        }

        foreach ( $this->data['mail_template_data'] as $key => $val) {
            if (in_array($key, $arAllowedPlaceholders, true)) {
                $this->placeholders[$key] = $val;
            }
        }

        $subject = $mustache->render($details['subject'], $this->placeholders);

        $content = $mustache->render($details['content'], $this->placeholders);
        $content = html_entity_decode($content);

        $notify_admin=$details['notify_admin'];
        $logos = $this->dispatch('pages/extension/email_logo',[]);
        $logo=$logos->dispatchGetOutput();

        $this->data['mail_plain_text'] = sprintf($this->language->get('text_welcome'), $this->config->get('store_name'))."\n\n";
        if ($activated) {
            $this->data['mail_plain_text'] .= $this->language->get('text_login')."\n";
            $this->data['mail_plain_text'] .= $login_url."\n\n";
        } else {
            $this->data['mail_plain_text'] .= $this->language->get('text_approval')."\n\n";
            $this->data['mail_plain_text'] .= $login_url."\n\n";
        }
        $this->data['mail_plain_text'] .= $this->language->get('text_services')."\n\n";
        $this->data['mail_plain_text'] .= $this->language->get('text_thanks')."\n";
        $this->data['mail_plain_text'] .= $this->config->get('store_name');

        $this->data['mail_template_data']['logo']=html_entity_decode($logo);
        $this->data['mail_template_data']['content']=$content;
        $this->data['mail_template_data']['signature']=$signature;
        //$this->data['mail_template_data']['text_project_label'] = project_base();

        $this->data['mail_template'] = DIR_EXT.'email_editor'.DIR_EXT_CORE.'lib/account_create.tpl';

        //allow to change email data from extensions
        $this->extensions->hk_ProcessData($this, 'sf_account_welcome_mail');

        $view = new AView($this->registry, 0);
        $view->batchAssign($this->data['mail_template_data']);
        $html_body = $view->fetch($this->data['mail_template']);
        $languageId = $this->language->getContentLanguageID() ?? $this->language->getLanguageID();
        $mailLogo = $this->config->get('config_mail_logo_'.$languageId)
            ? : $this->config->get('config_mail_logo');
        $mailLogo = $mailLogo ? : $this->config->get('config_logo_'.$languageId);
        $mailLogo = $mailLogo ? : $this->config->get('config_logo');
        $this->_send_email($email, [
                'subject'          => $subject,
                'sender_email'     => $sender_email,
                'sender_name'      => $sender_name,
                'txt_body'         => $this->data['mail_plain_text'],
                'html_body'        => $html_body,
                'config_mail_logo' => $mailLogo,
                'notify_admin'     => $notify_admin
            ]
        );

        return true;
    }

    /**
     * @param $customer_id
     * @param string $section
     * @param string $custom_mail
     * @return bool|null
     * @throws AException
     * @throws ReflectionException
     */
    public function emailActivateLink($customer_id,$section='',$custom_mail='') {
        if (!$customer_id) {
            return null;
        }
        $customer_data = $this->getCustomer($customer_id);

        //encrypt token and data
        $enc = new AEncryption($this->config->get('encryption_key'));
        $code = genToken();
        //store activation code
        $customer_data['data']['email_activation'] = $code;
        $this->updateOtherData($customer_id, $customer_data['data']);

        $ac = $enc->encrypt($customer_id.'::'.$code);
        $activate_url = $this->html->getSecureURL('account/login', '&ac='.$ac);

        $activate_url='<a href="'.$activate_url.'" target="_BLANK">'.$activate_url.'</a>';

        //build welcome email
        $this->language->load('mail/account_create');

        $this->data['mail_plain_text'] = sprintf($this->language->get('text_welcome'), $this->config->get('store_name'))."\n\n";
        $this->data['mail_plain_text'] .= sprintf(strip_tags($this->language->get('text_activate')), "\n".$activate_url."\n")."\n";
        $this->data['mail_plain_text'] .= $this->language->get('text_thanks')."\n";
        $this->data['mail_plain_text'] .= $this->config->get('store_name');

        if ($custom_mail) {
            $details = $this->getDetails($section.'_account_activation');
        } else {
            $details = $this->getDetails('account_activation');
        }

        $sender_name=$details['sender_name'] ? $details['sender_name']:$this->config->get('store_name');
        $sender_email=$details['sender_email'] ? $details['sender_email']:$this->config->get('store_main_email');
        $signature=html_entity_decode($details['signature']);
        $notify_admin=$details['notify_admin'];

        $this->data['mail_template_data']['store_name'] = $this->config->get('store_name');
        $this->data['mail_template_data']['activate_url'] = $activate_url;

        //allow to change email data from extensions
        $this->extensions->hk_ProcessData($this, 'sf_account_activation_mail');

        $mustache = new Mustache_Engine(['escape' => function ($value) {
            return $value;
        }]);

        $arAllowedPlaceholders = explode(',', $details['allowed_placeholders']);

        foreach ($arAllowedPlaceholders as &$placeholder) {
            $placeholder = trim($placeholder);
        }

        foreach ( $this->data['mail_template_data'] as $key => $val) {
            if (in_array($key, $arAllowedPlaceholders, true)) {
                $this->placeholders[$key] = $val;
            }
        }

        $subject = $mustache->render($details['subject'], $this->placeholders);
        $content = $mustache->render($details['content'], $this->placeholders);
        $content = html_entity_decode($content);

        $logos = $this->dispatch('pages/extension/email_logo',[]);
        $logo=$logos->dispatchGetOutput();

        //build HTML message with the template

        $this->data['mail_template_data']['logo']=html_entity_decode($logo);
        $this->data['mail_template_data']['content']=$content;
        $this->data['mail_template_data']['signature']=$signature;
        $this->data['mail_template'] = DIR_EXT.'email_editor'.DIR_EXT_CORE.'lib/account_create.tpl';

        $view = new AView($this->registry, 0);
        $view->batchAssign($this->data['mail_template_data']);
        $html_body = $view->fetch($this->data['mail_template']);
        $languageId = $this->language->getContentLanguageID() ?? $this->language->getLanguageID();
        $mailLogo = $this->config->get('config_mail_logo_'.$languageId)
            ? : $this->config->get('config_mail_logo');
        $mailLogo = $mailLogo ? : $this->config->get('config_logo_'.$languageId);
        $mailLogo = $mailLogo ? : $this->config->get('config_logo');
        $this->_send_email($customer_data['email'],
            [
                'subject'          => $subject,
                'sender_email'     => $sender_email,
                'sender_name'      => $sender_name,
                'txt_body'         => $this->data['mail_plain_text'],
                'html_body'        => $html_body,
                'config_mail_logo' => $mailLogo,
                'notify_admin'     => $notify_admin
            ]
        );

        return true;
    }

    protected function _send_email($email, $data) {
        $mail = new AMail($this->config);
        $mail->setTo($email);
        $mail->setFrom($data['sender_email']);
        $mail->setSender($data['sender_name']);
        $mail->setSubject($data['subject']);
        $mail->setText(html_entity_decode($data['txt_body'], ENT_QUOTES, 'UTF-8'));

        if (is_file(DIR_RESOURCE.$data['config_mail_logo'])) {
            $mail->addAttachment(DIR_RESOURCE.$data['config_mail_logo'],
                md5(pathinfo($data['config_mail_logo'], PATHINFO_FILENAME))
                .'.'.pathinfo($data['config_mail_logo'], PATHINFO_EXTENSION));
        }
        $mail->setHtml($data['html_body']);
        $mail->send();

        if ($data['notify_admin']==='1') {
            $mail = new AMail($this->config);
            $mail->setTo($this->config->get('store_main_email'));
            $mail->setFrom($data['sender_email']);
            $mail->setSender($data['sender_name']);
            $mail->setSubject('(Copy) '.$data['subject']);
            $mail->setText(html_entity_decode($data['txt_body'], ENT_QUOTES, 'UTF-8'));

            if (is_file(DIR_RESOURCE.$data['config_mail_logo'])) {
                $mail->addAttachment(DIR_RESOURCE.$data['config_mail_logo'],
                    md5(pathinfo($data['config_mail_logo'], PATHINFO_FILENAME))
                    .'.'.pathinfo($data['config_mail_logo'], PATHINFO_EXTENSION));
            }
            $mail->setHtml($data['html_body']);
            $mail->send();
        }
    }

    /**
     * @param int $customer_id
     *
     * @return array
     */
    public function getCustomer($customer_id) {
        $query = $this->db->query(
            "SELECT *
                FROM ".$this->db->table("customers")."
                WHERE customer_id = '".(int)$customer_id."'");
        $result_row = $this->dcrypt->decrypt_data($query->row, 'customers');
        $result_row['data'] = unserialize($result_row['data']);
        return $result_row;
    }

    /**
     * @param $customer_id
     * @param $data
     *
     * @return bool
     */
    public function updateOtherData($customer_id, $data) {
        $customer_id = (int)$customer_id;
        if (!$customer_id) {
            return false;
        }
        $this->db->query("UPDATE ".$this->db->table("customers")."
                           SET data = '".$this->db->escape(serialize($data))."'
                           WHERE customer_id = '".$customer_id."'");
        return true;
    }

    public function getDetails($section) {
        $store_id = $this->getStoreId();
        $sql="SELECT mail.sender_name,mail.sender_email,mail.subject,mail.content,mail.allowed_placeholders, sigs.content as signature, notify_admin
              FROM ". $this->db->table('email_editor_templates') . " mail 
              LEFT JOIN ". $this->db->table('email_editor_signatures') . " sigs on sigs.email_signature_id=mail.email_signature_id
              WHERE mail.section='".$section."' AND mail.store_id=".$store_id;
        $result=$this->db->query($sql);
        return $result->row;
    }

    public function getEmailSignature() {
        $store_id = $this->getStoreId();
        $sql = "SELECT `content` FROM ". $this->db->table('email_editor_templates') . " WHERE section='email_signature' AND `store_id`=.$store_id";
        $result=$this->db->query($sql);
        return $result->row;
    }

    protected function dispatch($dispatch_rt, $args =[]) {
        return new ADispatcher($dispatch_rt, $args);
    }

    public function getStoreId() {
            $store_id = (int) $this->config->get('config_store_id');
            if (has_value($this->request->get_or_post('store_id'))) {
                $store_id = (int) $this->request->get_or_post('store_id');
            } else {
                if ($this->session->data['current_store_id']) {
                    $store_id = (int) $this->session->data['current_store_id'];
                }
            }
            return $store_id;
        }
}