<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ModelAccountTaxidOption
 * @property ModelLocalisationCountry model_localisation_country
 * @property ModelAccountCustomer model_account_customer
 * @property ModelCatalogContent model_catalog_content
 */

use ReCaptcha\ReCaptcha;

/** @noinspection PhpUndefinedClassInspection */
class ModelAccountTaxidOption extends Model {

    /**
     * @param array $data
     * @return int
     */
    public function addCustomer($data) {
        $key_sql = '';
        if ( $this->dcrypt->active ) {
            $data = $this->dcrypt->encrypt_data($data, 'customers');
            $key_sql = ", key_id = '" . (int)$data['key_id'] . "'";
        }
        if(!(int)$data['customer_group_id']){
            $data['customer_group_id'] = (int)$this->config->get('config_customer_group_id');
        }
        if(!isset($data['status'])){
            // if need to activate via email  - disable status
            if($this->config->get('config_customer_email_activation')){
                $data['status'] = 0;
            }else{
                $data['status'] = 1;
            }
        }
        if(isset($data['approved'])){
            $data['approved'] = (int)$data['approved'];
        }else{
            if(!$this->config->get('config_customer_approval')){
                $data['approved'] = 1;
            }
        }

        // delete subscription accounts for given email
        $subscriber = $this->db->query("SELECT customer_id
										FROM " . $this->db->table("customers") . "
										WHERE LOWER(`email`) = LOWER('" . $this->db->escape($data['email']) . "')
											AND customer_group_id IN (SELECT customer_group_id
																	  FROM ".$this->db->table('customer_groups')."
																	  WHERE `name` = 'Newsletter Subscribers')");
        foreach($subscriber->rows as $row){
            $this->db->query("DELETE FROM " . $this->db->table("customers") . " WHERE customer_id = '" . (int)$row['customer_id'] . "'");
            $this->db->query("DELETE FROM " . $this->db->table("addresses") . " WHERE customer_id = '" . (int)$row['customer_id'] . "'");
        }

        $salt_key = genToken(8);
        $sql = "INSERT INTO " . $this->db->table("customers") . "
			  SET	store_id = '" . (int)$this->config->get('config_store_id') . "',
					loginname = '" . $this->db->escape($data['loginname']) . "',
					firstname = '" . $this->db->escape(trim($data['firstname'])) . "',
					lastname = '" . $this->db->escape(trim($data['lastname'])) . "',
					email = '" . $this->db->escape($data['email']) . "',
					telephone = '" . $this->db->escape($data['telephone']) . "',
					fax = '" . $this->db->escape($data['fax']) . "',
					salt = '" . $this->db->escape($salt_key) . "', 
					password = '" . $this->db->escape(sha1($salt_key.sha1($salt_key.sha1($data['password'])))) . "',
					newsletter = '" . (int)$data['newsletter'] . "',
					customer_group_id = '" .(int)$data['customer_group_id'] . "',
					approved = '".(int)$data['approved']."',
					status = '".(int)$data['status']."'". $key_sql . ",
					ip = '". $this->db->escape($data['ip']) ."',
					data = '". $this->db->escape(serialize($data['data'])) ."',
					date_added = NOW()";
        $this->db->query($sql);
        $customer_id = $this->db->getLastId();

        $key_sql = '';
        if ( $this->dcrypt->active ) {
            $data = $this->dcrypt->encrypt_data($data, 'addresses');
            $key_sql = ", key_id = '" . (int)$data['key_id'] . "'";
        }
        $this->db->query("INSERT INTO " . $this->db->table("addresses") . " 
      					  SET 	customer_id = '" . (int)$customer_id . "', 
      					  		firstname = '" . $this->db->escape($data['firstname']) . "', 
      					  		lastname = '" . $this->db->escape($data['lastname']) . "', 
      					  		company = '" . $this->db->escape($data['company']) . "',
      					  		taxid = '".  $this->db->escape($data['taxid']) ."', 
      					  		address_1 = '" . $this->db->escape($data['address_1']) . "', 
      					  		address_2 = '" . $this->db->escape($data['address_2']) . "', 
      					  		city = '" . $this->db->escape($data['city']) . "', 
      					  		postcode = '" . $this->db->escape($data['postcode']) . "', 
      					  		country_id = '" . (int)$data['country_id'] . "'" .
            $key_sql . ",
      					  		zone_id = '" . (int)$data['zone_id'] . "'");

        $address_id = $this->db->getLastId();
        $this->db->query("UPDATE " . $this->db->table("customers") . "
      	                    SET address_id = '" . (int)$address_id . "'
      	                    WHERE customer_id = '" . (int)$customer_id . "'");

        if(!$data['approved']){
            $language = new ALanguage($this->registry);
            $language->load( $language->language_details['directory'] );
            $language->load('account/create');

            if($data['subscriber']){
                //notify administrator of pending subscriber approval
                $msg_text = sprintf($language->get('text_pending_subscriber_approval'), $data['firstname'] . ' ' . $data['lastname'], $customer_id);
            }else{
                //notify administrator of pending customer approval
                $msg_text = sprintf($language->get('text_pending_customer_approval'), $data['firstname'] . ' ' . $data['lastname'], $customer_id);
            }
            $msg = new AMessage();
            $msg->saveNotice($language->get('text_new_customer'), $msg_text);
        }

        //enable notification setting for newsletter via email
        if($data['newsletter']){
            $sql = "INSERT INTO " . $this->db->table('customer_notifications') . "
					(customer_id, sendpoint, protocol, status, date_added)
				VALUES
				('" . $customer_id . "',
				'newsletter',
				'email',
				'1',
				NOW());";
            $this->db->query($sql);
        }

        //notify admin
        $language = new ALanguage($this->registry);
        $language->load( $language->language_details['directory'] );
        $language->load('common/im');
        if($data['subscriber']){
            $lang_key = 'im_new_subscriber_text_to_admin';
        } else {
            $lang_key = 'im_new_customer_text_to_admin';
        }
        $message_arr = [
            1 => [
                'message' => sprintf( $language->get( $lang_key ), $customer_id, $data['firstname'].' '.$data['lastname'] ),
            ],
        ];
        $this->im->send('new_customer', $message_arr);

        return $customer_id;
    }

    /**
     * @param int $customer_id
     * @param array $data
     * @return bool
     */
    public function addCustomerAdditionalValues($customer_id, $data = []) {

        //foreach ($data as $k => $val) {
            $this->db->query("INSERT INTO " . $this->db->table('customer_additional_values') . "
												(customer_id, email, telephone, fax, company, taxid, registration, bank_name, bank_address, iban, swift)
								  VALUES (" . (int)$customer_id . ", '" . $this->db->escape($data['email']) . "',
								   		  '" . $this->db->escape($data['telephone']) . "',
								          '" . $this->db->escape($data['fax']) . "',
								          '" . $this->db->escape($data['company']) . "',
								          '" . $this->db->escape($data['taxid']) . "',
								          '" . $this->db->escape($data['registration']) . "',
								          '" . $this->db->escape($data['bank_name']) . "',
								          '" . $this->db->escape($data['bank_address']) . "',
								          '" . $this->db->escape($data['iban']) . "',
								          '" . $this->db->escape($data['swift']) . "');");
        //}
        return true;
    }

    /**
     * @param $customer_id
     * @return mixed
     */
    public function getCustomerAdditionalValues($customer_id) {
        $sql = "SELECT *
				FROM " . $this->db->table('customer_additional_values') . "
				WHERE customer_id = " . (int)$customer_id;
        $query = $this->db->query($sql);
        return $query->row;
    }


    public function countCustomerAdditionalValuesByEmail($email,$id) {
        $sql = "SELECT *
				FROM " . $this->db->table('customer_additional_values') . "
				WHERE email = '" . $this->db->escape($email)."' AND customer_id='" .(int)$id . "'";
        $query = $this->db->query($sql);

        return $query->num_rows;
    }

    public function getValuesByEmail($email) {
        $sql = "SELECT *
				FROM " . $this->db->table('customer_additional_values') . "
				WHERE email = '" . $this->db->escape($email)."'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getValues($email,$customer_id) {
        $sql = "SELECT *
				FROM " . $this->db->table('customer_additional_values') . "
				WHERE email = '" . $this->db->escape($email)."' AND customer_id =". (int)$customer_id;
        $query = $this->db->query($sql);
        return $query->row;
    }

    /**
     * @param $data
     * @return array
     */
    public function validateAdditionalValuesForCreate($data) {
        $errors = [];
        //$this->load->model('localisation/country');
        $this->load->model('account/customer');
        $this->load->model('catalog/content');
        $this->load->language('account/taxid_option');
        //$country=$this->model_localisation_country->getCountry($data['country_id']);
        if ($this->config->get('config_account_create_captcha')) {
            if ($this->config->get('config_recaptcha_secret_key')) {
                $recaptcha = new ReCaptcha($this->config->get('config_recaptcha_secret_key'));
                $resp = $recaptcha->verify(
                    $data['g-recaptcha-response'],
                    $this->request->getRemoteIP()
                );
                if (!$resp->isSuccess() && $resp->getErrorCodes()) {
                    $errors['captcha'] = $this->language->get('error_captcha');
                }
            } else {
                if (!isset($this->session->data['captcha']) || ($this->session->data['captcha'] != $data['captcha'])) {
                    $errors['captcha'] = $this->language->get('error_captcha');
                }
            }
        }

        if ( $this->config->get('prevent_email_as_login')) {
            //validate only if email login is not allowed
            $login_name_pattern = '/^[\w._-]+$/i';
            if ( mb_strlen($data['loginname']) < 5
                || mb_strlen($data['loginname']) > 64
                || !preg_match($login_name_pattern, $data['loginname'])
            ) {
                $errors['loginname'] = $this->language->get('error_loginname');
                //validate uniqueness of login name
            } else if ( !$this->model_account_customer->is_unique_loginname($data['loginname']) ) {
                $errors['loginname'] = $this->language->get('error_loginname_notunique');
            }
        }

        if ((mb_strlen($data['firstname']) < 1) || (mb_strlen($data['firstname']) > 32)) {
            $errors['firstname'] = $this->language->get('error_firstname');
        }

        if ((mb_strlen($data['lastname']) < 1) || (mb_strlen($data['lastname']) > 32)) {
            $errors['lastname'] = $this->language->get('error_lastname');
        }

        if ((mb_strlen($data['email']) > 96) || (!preg_match(EMAIL_REGEX_PATTERN, $data['email']))) {
            $errors['email'] = $this->language->get('error_email');
        }

        if ($this->model_account_customer->getTotalCustomersByEmail($data['email'])) {
            $errors['email'] = $this->language->get('error_exists');
        }

        if ($this->config->get('telephone_option_mandatory_status') == '1') {
            $phone = $data['telephone'] ?? '';
            $pattern = $this->config->get('config_phone_validation_pattern') ?: '/^[0-9]{3,32}$/';
            if (mb_strlen($phone) < 3
                || mb_strlen($phone) > 32
                || !preg_match($pattern, $phone)
            ) {
                $errors['telephone'] = $this->language->get('telephone_error');
            }
        }

        if ($this->config->get('fax_option_mandatory_status') == '1') {
            if (empty($data['fax']) || (mb_strlen($data['fax']) > 32)) {
                $errors['fax'] = $this->language->get('fax_error');
            }
        }

        if ($this->config->get('company_option_mandatory_status') == '1') {
            if (empty($data['company'])) {
                $errors['company'] = $this->language->get('company_error');
            }
        }

        //$str=strtolower($v);
        if ($this->config->get('taxid_option_mandatory_status') == '1') {
            if (empty($data['taxid']) && strtolower($data['taxid']) !== 'na' && strtolower($data['taxid']) !== 'none') {
                $errors['taxid'] = $this->language->get('taxid_error');
            }
        }

        if ($this->config->get('registration_option_mandatory_status') == '1') {
            if (empty($data['registration'])) {
                $errors['registration'] = $this->language->get('registration_error');
            }
        }

        if ($this->config->get('bank_name_option_mandatory_status') == '1') {
            if (empty($data['bank_name'])) {
                $errors['bank_name'] = $this->language->get('bank_name_error');
            }
        }

        if ($this->config->get('bank_address_option_mandatory_status') == '1') {
            if (empty($data['bank_address'])) {
                $errors['bank_address'] = $this->language->get('bank_address_error');
            }
        }

        if ($this->config->get('iban_option_mandatory_status') == '1') {
            if (empty($data['iban']) && strtolower($data['iban']) != 'na' && strtolower($data['iban']) != 'none') {
                $errors['iban'] = $this->language->get('iban_error');
            }
        }

        if ($this->config->get('swift_option_mandatory_status') == '1') {
            if (empty($data['swift']) && strtolower($data['swift']) != 'na' && strtolower($data['swift']) != 'none') {
                $errors['swift'] = $this->language->get('swift_error');
            }
        }

        if ((mb_strlen($data['address_1']) < 3) || (mb_strlen($data['address_1']) > 128)) {
            $errors['address_1'] = $this->language->get('error_address_1');
        }

        if ((mb_strlen($data['city']) < 3) || (mb_strlen($data['city']) > 128)) {
            $errors['city'] = $this->language->get('error_city');
        }

        if ((mb_strlen($data['postcode']) < 3) || (mb_strlen($data['postcode']) > 128)) {
            $errors['postcode'] = $this->language->get('error_postcode');
        }

        if ($data['country_id'] == 'FALSE') {
            $errors['country'] = $this->language->get('error_country');
        }

        if ($data['zone_id'] == 'FALSE') {
            $errors['zone'] = $this->language->get('error_zone');
        }

        //check password length considering html entities (special case for characters " > < & )
        $pass_len = mb_strlen(htmlspecialchars_decode($data['password']));
        if ($pass_len < 4 || $pass_len > 20){
            $errors['password'] = $this->language->get('error_password');
        }

        if ($data['confirm'] != $data['password']) {
            $errors['confirm'] = $this->language->get('error_confirm');
        }

        if ($this->config->get('config_account_id')) {
            $this->load->model('catalog/content');

            $content_info = $this->model_catalog_content->getContent($this->config->get('config_account_id'));

            if ($content_info) {
                if (!isset($data['agree'])) {
                    $errors['warning'] = sprintf($this->language->get('error_agree'), $content_info['title']);
                }
            }
        }

        //validate IM URIs
        //get only active IM drivers
        $im_drivers = $this->im->getIMDriverObjects();
        if ($im_drivers){
            foreach ($im_drivers as $protocol => $driver_obj){
                /**
                 * @var AMailIM $driver_obj
                 */
                if (!is_object($driver_obj) || $protocol=='email'){
                    continue;
                }
                $result = $driver_obj->validateURI($data[$protocol]);
                if(!$result){
                    $errors[$protocol] = implode('<br>',$driver_obj->errors);
                }

            }
        }
        if (sizeof((array)$errors) && empty( $errors['warning'])) {
            $errors['warning'] = $this->language->get('gen_data_entry_error');
        }

        return $errors;
    }

    /**
     * @param array $data
     * @return array
     */
    public function validateAdditionalValuesForEdit($data) {
        $data = $data;
        $errors = [];
        //$this->load->model('localisation/country');
        $this->load->model('account/customer');
        $this->load->language('account/taxid_option');

        if ( $this->config->get('prevent_email_as_login') && isset($data['loginname']) ) {
            //validate only if email login is not allowed
            $login_name_pattern = '/^[\w._-]+$/i';
            if ((mb_strlen($data['loginname']) < 5) || (mb_strlen($data['loginname']) > 64)
                || (!preg_match($login_name_pattern, $data['loginname'])) ) {
                $errors['loginname'] = $this->language->get('error_loginname');
                //validate uniqueness of login name
            } else if ( !$this->model_account_customer->is_unique_loginname($data['loginname']) ) {
                $errors['loginname'] = $this->language->get('error_loginname_notunique');
            }
        }

        if ((mb_strlen($data['firstname']) < 1) || (mb_strlen($data['firstname']) > 32)) {
            $errors['firstname'] = $this->language->get('error_firstname');
        }

        if ((mb_strlen($data['lastname']) < 1) || (mb_strlen($data['lastname']) > 32)) {
            $errors['lastname'] = $this->language->get('error_lastname');
        }

        if ((mb_strlen($data['email']) > 96) || (!preg_match(EMAIL_REGEX_PATTERN, $data['email']))) {
            $errors['email'] = $this->language->get('error_email');
        }

        if (($this->customer->getEmail() != $data['email']) && $this->model_account_customer->getTotalCustomersByEmail($data['email'])) {
            $errors['email'] = $this->language->get('error_exists');
        }

        if ($this->config->get('telephone_option_mandatory_status') == '1') {
            $phone = $data['telephone'] ?? '';
            $pattern = $this->config->get('config_phone_validation_pattern') ?: '/^[0-9]{3,32}$/';
            if (mb_strlen($phone) < 3
                || mb_strlen($phone) > 32
                || !preg_match($pattern, $phone)
            ) {
                $errors['telephone'] = $this->language->get('telephone_error');
            }
        }

        if ($this->config->get('fax_option_mandatory_status') == '1') {
            if (empty($data['fax']) || (mb_strlen($data['fax']) > 32)) {
                $errors['fax'] = $this->language->get('fax_error');
            }
        }

        if ($this->config->get('registration_option_mandatory_status') == '1') {
            if (empty($data['registration'])) {
                $errors['registration'] = $this->language->get('registration_error');
            }
        }

        if ($this->config->get('bank_name_option_mandatory_status') == '1') {
            if (empty($data['bank_name'])) {
                $errors['bank_name'] = $this->language->get('bank_name_error');
            }
        }

        if ($this->config->get('bank_address_option_mandatory_status') == '1') {
            if (empty($data['bank_address'])) {
                $errors['bank_address'] = $this->language->get('bank_address_error');
            }
        }

        if ($this->config->get('iban_option_mandatory_status') == '1') {
            if (empty($data['iban']) && strtolower($data['iban']) != 'na' && strtolower($data['swift']) != 'iban') {
                $errors['iban'] = $this->language->get('iban_error');
            }
        }

        if ($this->config->get('swift_option_mandatory_status') == '1') {
            if (empty($data['swift']) && strtolower($data['swift']) != 'na' && strtolower($data['swift']) != 'none') {
                $errors['swift'] = $this->language->get('swift_error');
            }
        }

        if ( sizeof((array)$errors) && empty( $errors['warning'] ) ) {
            $errors['warning'] = $this->language->get('gen_data_entry_error');
        }

        //validate IM URIs
        //get only active IM drivers
        $im_drivers = $this->im->getIMDriverObjects();
        if ($im_drivers){
            foreach ($im_drivers as $protocol => $driver_obj){
                /**
                 * @var AMailIM $driver_obj
                 */
                if (!is_object($driver_obj) || $protocol=='email'){
                    continue;
                }
                $result = $driver_obj->validateURI($data[$protocol]);
                if(!$result){
                    $errors[$protocol] = implode('<br>',$driver_obj->errors);
                }

            }
        }

        if (sizeof((array)$errors) && empty( $errors['warning'])) {
            $errors['warning'] = $this->language->get('gen_data_entry_error');
        }

        return $errors;
    }

    public function getCountryId($custId) {
       $sql="SELECT c.iso_code_2 from ".$this->db->table('countries')." c LEFT JOIN "
           .$this->db->table('addresses')." a ON a.country_id=c.country_id LEFT JOIN "
           .$this->db->table('customers')." cu ON cu.address_id=a.address_id WHERE cu.customer_id=".$custId;
        $result=$this->db->query($sql);
        $code=$result->row;
        return $code['iso_code_2'];

    }

    /**
     * @param int $customer_id
     * @param array $data
     * @return null
     */
    public function updateCustomerAdditionalValues($customer_id, $data) {

        if (!has_value($data)) {
            return false;
        }

        foreach ($data as $key => $item) {
            $this->db->query("UPDATE  " . $this->db->table('customer_additional_values') . "
								  SET email='" .$this->db->escape($data['email']). "',
								      telephone='" . $this->db->escape($data['telephone']) . "',
								      fax='" . $this->db->escape($data['fax']) . "',
								      company='" . $this->db->escape($data['company']) . "',
								      taxid='" . $this->db->escape($data['taxid']) . "',
								      registration='" . $this->db->escape($data['registration']) . "',
								      bank_name='" . $this->db->escape($data['bank_name']) . "',
								      bank_address='" . $this->db->escape($data['bank_address']) . "',
								      iban='" . $this->db->escape($data['iban']) . "',
								      swift='" . $this->db->escape($data['swift']) . "' WHERE customer_id='".$customer_id."'");
        }
        return true;
    }

    /**
     * @param $email
     * @param $data
     * @return bool
     */
    public function updateCustomerAdditionalValuesByEmail($email, $customer_id, $data) {
        if (!has_value($data)) {
            return false;
        }

        foreach ($data as $key => $item) {
            $this->db->query("UPDATE  " . $this->db->table('customer_additional_values') . "
								  SET telephone='" . $this->db->escape($data['telephone']) . "',
								      fax='" . $this->db->escape($data['fax']) . "',
								      company='" . $this->db->escape($data['company']) . "',
								      taxid='" . $this->db->escape($data['taxid']) . "',
								      registration='" . $this->db->escape($data['registration']) . "',
								      bank_name='" . $this->db->escape($data['bank_name']) . "',
								      bank_address='" . $this->db->escape($data['bank_address']) . "',
								      iban='" . $this->db->escape($data['iban']) . "',
								      swift='" . $this->db->escape($data['swift']) . "' WHERE email='".$this->db->escape($email)."' AND customer_id='".$customer_id."'");

        }
        return true;
    }

    /**
     * @param $customer_id
     * @return bool|stdClass
     */
    public function deleteAdditionalValuesById($customer_id) {
        $sql="DELETE FROM " . $this->db->table('customer_additional_values') . "
              WHERE customer_id = '" . (int)$customer_id."'";
        $query = $this->db->query($sql);
        return $query;
    }

    /**
     * @param $data
     * @return int
     */
    public function addAddress($data = []){
        if (!$data){
            return false;
        }
        //encrypt customer data
        $key_sql = '';
        if ($this->dcrypt->active){
            $data = $this->dcrypt->encrypt_data($data, 'addresses');
            $key_sql = ", key_id = '" . (int)$data['key_id'] . "'";
        }

        $this->db->query("INSERT INTO `" . $this->db->table("addresses") . "`
						SET customer_id = '" . (int)$this->customer->getId() . "',
							company = '" . $this->db->escape($data['company']) . "',
							taxid = '" . $this->db->escape($data['taxid']) . "',
							firstname = '" . $this->db->escape($data['firstname']) . "',
							lastname = '" . $this->db->escape($data['lastname']) . "',
							address_1 = '" . $this->db->escape($data['address_1']) . "',
							address_2 = '" . $this->db->escape($data['address_2']) . "',
							postcode = '" . $this->db->escape($data['postcode']) . "',
							city = '" . $this->db->escape($data['city']) . "',
							zone_id = '" . (int)$data['zone_id'] . "',
							country_id = '" . (int)$data['country_id'] . "'" . $key_sql);

        $address_id = $this->db->getLastId();

        if (isset($data['default']) && $data['default'] == '1'){
            $this->db->query("UPDATE " . $this->db->table("customers") . "
							SET address_id = '" . (int)$address_id . "'
							WHERE customer_id = '" . (int)$this->customer->getId() . "'");
        }

        return $address_id;
    }

    /**
     * @param int $address_id
     * @param array $data
     * @return bool
     */
    public function editAddress($address_id, $data){
        $address_id = (int)$address_id;
        if (!$address_id || !$data){
            return false;
        }

        //encrypt customer data
        $key_sql = '';
        if ($this->dcrypt->active){
            $data = $this->dcrypt->encrypt_data($data, 'addresses');
            $key_sql = ", key_id = '" . (int)$data['key_id'] . "'";
        }

        $this->db->query(
            "UPDATE " . $this->db->table("addresses") . "
				SET company = '" . $this->db->escape($data['company']) . "',
				    taxid = '" . $this->db->escape($data['taxid']) . "',
					firstname = '" . $this->db->escape($data['firstname']) . "',
					lastname = '" . $this->db->escape($data['lastname']) . "',
					address_1 = '" . $this->db->escape($data['address_1']) . "',
					address_2 = '" . $this->db->escape($data['address_2']) . "',
					postcode = '" . $this->db->escape($data['postcode']) . "',
					city = '" . $this->db->escape($data['city']) . "',
					zone_id = '" . (int)$data['zone_id'] . "',
					country_id = '" . (int)$data['country_id'] . "'" . $key_sql . "
				WHERE address_id  = '" . (int)$address_id . "' AND customer_id = '" . (int)$this->customer->getId() . "'");

        if (isset($data['default'])){
            $this->db->query(
                "UPDATE " . $this->db->table("customers") . "
					SET address_id = '" . (int)$address_id . "'
					WHERE customer_id = '" . (int)$this->customer->getId() . "'");
        }

        return true;
    }

    /**
     * @param $address_id
     * @return array|bool
     */
    public function getAddress($address_id){
        $address_query = $this->db->query(
            "SELECT DISTINCT *
				 FROM " . $this->db->table("addresses") . "
				 WHERE address_id = '" . (int)$address_id . "' and customer_id = '" . (int)$this->customer->getId() . "'");

        if ($address_query->num_rows){
            return $this->_build_address_data($address_query->row);
        } else{
            return false;
        }
    }

    /**
     * @return array
     */
    public function getAddresses(){
        $address_data = array ();
        $query = $this->db->query(
            "SELECT *
				FROM " . $this->db->table("addresses") . "
				WHERE customer_id = '" . (int)$this->customer->getId() . "'");

        foreach ($query->rows as $result){
            $address_data[] = $this->_build_address_data($result);
        }
        return $address_data;
    }

    /**
     * @param $address_row
     * @return array
     */
    private function _build_address_data($address_row){
        $addr_row = $this->dcrypt->decrypt_data($address_row, 'addresses');

        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');
        $country_row = $this->model_localisation_country->getCountry($addr_row['country_id']);

        if ($country_row){
            $country = $country_row['name'];
            $iso_code_2 = $country_row['iso_code_2'];
            $iso_code_3 = $country_row['iso_code_3'];
        } else{
            $country = '';
            $iso_code_2 = '';
            $iso_code_3 = '';
        }
        if (strtolower($addr_row['taxid'])!=='na' && strtolower($addr_row['taxid'])!=='none') {
            $address_format = '{firstname} {lastname}'
                . "\n" . '{company}'
                . "\n" . '{taxid}'
                . "\n" . '{address_1}'
                . "\n" . '{address_2}'
                . "\n" . '{city} {postcode}'
                . "\n" . '{zone}'
                . "\n" . '{country}';
        } else {
            $address_format = '{firstname} {lastname}'
                . "\n" . '{company}'
                . "\n" . '{address_1}'
                . "\n" . '{address_2}'
                . "\n" . '{city} {postcode}'
                . "\n" . '{zone}'
                . "\n" . '{country}';
        }

        $zone_row = $this->model_localisation_zone->getZone($addr_row['zone_id']);

        if ($zone_row){
            $zone = $zone_row['name'];
            $code = $zone_row['code'];
        } else{
            $zone = '';
            $code = '';
        }

        $address_data = [
            'address_id'     => $addr_row['address_id'],
            'firstname'      => $addr_row['firstname'],
            'lastname'       => $addr_row['lastname'],
            'company'        => $addr_row['company'],
            'address_1'      => $addr_row['address_1'],
            'address_2'      => $addr_row['address_2'],
            'postcode'       => $addr_row['postcode'],
            'city'           => $addr_row['city'],
            'zone_id'        => $addr_row['zone_id'],
            'zone'           => $zone,
            'zone_code'      => $code,
            'country_id'     => $addr_row['country_id'],
            'country'        => $country,
            'iso_code_2'     => $iso_code_2,
            'iso_code_3'     => $iso_code_3,
            'address_format' => $address_format
        ];

        $address_data['taxid'] = $addr_row['taxid'];
        if (strtolower($address_data['company']) === 'none' || strtolower($address_data['company']) === 'na' || $address_data['company'] === '') {
            unset($address_data['company']);
            $address_data['address_format'] = str_replace('{company}','',$address_data['address_format']);
        }
        
        return $address_data;
    }
}