<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ExtensionQuickView
 * @property ModelQuickViewQuickView $model_quick_view_quick_view
 */
class ExtensionQuickView extends Extension {

    public $data = [];
    private $category;
    private $path;

    public function __construct(){
        $this->registry = Registry::getInstance();
    }

    private function _is_enabled() {
        return $this->baseObject->config->get('quick_view_status') ? true : false;
    }

    public function verifyProductPricingPlus() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'product_pricing_plus_status' ) === '1' ) {
            return true;
        } else {
            return false;
        }
    }

    public function onControllerCommonHead_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
	        if ( !IS_ADMIN ) {
		        $that     = $this->baseObject;
		        $style    = $that->config->get( 'quick_view_round_corner' );
		        $bg_color = $that->config->get( 'quick_view_bg_color' );
		        if ( $style === '1' ) {
			        if ( empty( $bg_color ) ) {
				        $bgColor = 'fff';
			        } else {
				        $bgColor = $bg_color;
			        }
			        $that->view->assign( 'color', $bgColor );
			        $that->document->addStyle(
				        [
					        'href' => $that->view->templateResource( '/stylesheet/styles2.css' ),
					        'rel'  => 'stylesheet',
				        ]
			        );
		        } else {
			        if ( empty( $bg_color ) ) {
				        $bgColor = 'fff';
			        } else {
				        $bgColor = $bg_color;
			        }
			        $that->view->assign( 'color', $bgColor );
			        $that->document->addStyle(
				        [
					        'href' => $that->view->templateResource( '/stylesheet/styles.css' ),
					        'rel'  => 'stylesheet',
				        ]
			        );
		        }

		        $pad = $that->config->get( 'quick_view_padding' );
		        if ( empty( $pad ) ) {
			        $padding = '25';
		        } else {
			        $padding = $pad;
		        }
		        $that->view->assign( 'padding', $padding );
		        $that->processTemplate( DIR_EXT . 'quick_view/storefront/view/default/template/common/head.post.tpl' );
	        }
        }
    }

    public function onControllerPagesExtensionExtensions_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method=='edit' ) {
            $that->view->assign('qv_status',$that->config->get('quick_view_status'));
            $that->view->assign('color',$that->config->get('quick_view_bg_color'));
            $that->document->addScript($that->view->templateResource('/javascript/jscolor.js'));
            if ($that->request->get['extension']==='quick_view') {
                $that->processTemplate('pages/extension/qv_extensions_edit.tpl');
            }
        }
    }

    protected function dispatch($dispatch_rt, $args = [ '' ]) {
        return new ADispatcher($dispatch_rt, $args);
    }

    public function onControllerBlocksBestSeller_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main' ) {
            if ( ! $that->config->get( 'embed_mode' ) ) {
                $that->load->language('quick_view/quick_view');
                $products = $that->data['products'];
                $this->data['best_seller_products'] = [];
                if ($products) {
                    foreach ($products as $product) {
                        $product_price = $product['price'];
                        if ($this->verifyProductPricingPlus()) {
                            $that->load->model('extension/product_pricing_plus');
                            $product_id = $product['product_id'];
                            $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                            if ($settings['show_product_listing']==='1') {
                                $product_price = html_entity_decode($settings['content']);
                                if ($product['special']) {
                                    $product['special'] = $product_price.' '.$product['special'];
                                    $product_price= $product['price'];
                                } else {
                                    if ($product['price']!=='$0.00') {
                                        $product_price .= ' ' . $product['price'];
                                    }
                                }
                            } else {
                                $product_price = $product['price'];
                            }
                        }
                        $quickView = "<a style=\"margin-left:-10px\" onclick=\"quickView('#quickview-modal', 
            '" . $that->html->getURL('r/quick_view/quick_view', '&product_id=' . $product['product_id']) . "')\" href=\"javascript:void(0);\"><i class='fa fa-search'></i> " . $that->language->get('text_quick_view') . "</a>";

                        $this->data['best_seller_products'][] = [
                            'product_id' => $product['product_id'],
                            'name' => $product['name'],
                            'blurb' => html_entity_decode($product['blurb']),
                            'model' => $product['model'],
                            'rating' => $product['rating'],
                            'stars' => $product['stars'],
                            'price' => $product_price,
                            'call_to_order' => $product['call_to_order'],
                            'options' => $product['options'],
                            'special' => $product['special'],
                            'thumb' => $product['thumb'],
                            'href' => $product['href'],
                            'add' => $product['add'],
                            'track_stock' => $product['track_stock'],
                            'in_stock' => $product['in_stock'],
                            'no_stock_text' => $product['no_stock_text'],
                            'total_quantity' => $product['total_quantity'],
                            'tax_class_id' => $product['tax_class_id'],
                            'date_added'     => $product['date_added'],
                            'buttons' => $quickView,
                        ];
                    }
                    $that->view->assign('products', $this->data['best_seller_products']);
                }
            }
        }
    }

    public function onControllerBlocksSpecial_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
	    if ($this->baseObject_method === 'main' ) {
		    if ( ! $that->config->get( 'embed_mode' ) ) {
                $that->load->language('quick_view/quick_view');
                $products = $that->data['products'];
                $this->data['block_special_products'] = [];
                foreach ($products as $product) {
                    $product_price = $product['price'];
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $product_price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $product['special'] = $product_price.' '.$product['special'];
                                $product_price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $product_price .= ' ' . $product['price'];
                                }
                            }
                        } else {
                            $product_price = $product['price'];
                        }
                    }
                    $quickView = "<a style=\"margin-left:-10px\" onclick=\"quickView('#quickview-modal', 
            '" . $that->html->getURL( 'r/quick_view/quick_view', '&product_id=' . $product['product_id'] ) . "')\" href=\"javascript:void(0);\"><i class='fa fa-search'></i> " . $that->language->get( 'text_quick_view' ) . "</a>";

                    $this->data['block_special_products'][] = [
                        'product_id' => $product['product_id'],
                        'name' => $product['name'],
                        'blurb' => html_entity_decode($product['blurb']),
                        'model' => $product['model'],
                        'rating' => $product['rating'],
                        'stars' => $product['stars'],
                        'price' => $product_price,
                        'call_to_order' => $product['call_to_order'],
                        'options' => $product['options'],
                        'special' => $product['special'],
                        'thumb' => $product['thumb'],
                        'href' => $product['href'],
                        'add' => $product['add'],
                        'track_stock' => $product['track_stock'],
                        'in_stock' => $product['in_stock'],
                        'no_stock_text' => $product['no_stock_text'],
                        'total_quantity' => $product['total_quantity'],
                        'tax_class_id' => $product['tax_class_id'],
                        'date_added'     => $product['date_added'],
                        'buttons' => $quickView,
                    ];
			    }
                $that->view->assign('products', $this->data['block_special_products']);
		    }
	    }
    }

    public function onControllerBlocksfeatured_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }

        $that =& $this->baseObject;
	    if ($this->baseObject_method === 'main' ) {
		    if ( ! $that->config->get( 'embed_mode' ) ) {
			    $that->load->language( 'quick_view/quick_view' );
                $products = $that->data['products'];
                $this->data['featured_products'] = [];
                if ($products) {
                    foreach ($products as $product) {
                        $product_price = $product['price'];
                        if ($this->verifyProductPricingPlus()) {
                            $that->load->model('extension/product_pricing_plus');
                            $product_id = $product['product_id'];
                            $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                            if ($settings['show_product_listing']==='1') {
                                $product_price = html_entity_decode($settings['content']);
                                if ($product['special']) {
                                    $product['special'] = $product_price.' '.$product['special'];
                                    $product_price= $product['price'];
                                } else {
                                    if ($product['price']!=='$0.00') {
                                        $product_price .= ' ' . $product['price'];
                                    }
                                }
                            } else {
                                $product_price = $product['price'];
                            }
                        }
                        $quickView = "<a style=\"margin-left:-10px\" onclick=\"quickView('#quickview-modal', 
            '" . $that->html->getURL('r/quick_view/quick_view', '&product_id=' . $product['product_id']) . "')\" href=\"javascript:void(0);\"><i class='fa fa-search'></i> " . $that->language->get('text_quick_view') . "</a>";
                        $this->data['featured_products'][] = [
                            'product_id' => $product['product_id'],
                            'name' => $product['name'],
                            'blurb' => html_entity_decode($product['blurb']),
                            'model' => $product['model'],
                            'rating' => $product['rating'],
                            'stars' => $product['stars'],
                            'price' => $product_price,
                            'call_to_order' => $product['call_to_order'],
                            'options' => $product['options'],
                            'special' => $product['special'],
                            'thumb' => $product['thumb'],
                            'href' => $product['href'],
                            'add' => $product['add'],
                            'track_stock' => $product['track_stock'],
                            'in_stock' => $product['in_stock'],
                            'no_stock_text' => $product['no_stock_text'],
                            'total_quantity' => $product['total_quantity'],
                            'tax_class_id' => $product['tax_class_id'],
                            'date_added'     => $product['date_added'],
                            'buttons' => $quickView,
                        ];
                    }
                    $that->view->assign('products', $this->data['featured_products']);
                }
		    }
	    }
    }

    public function onControllerBlocksLatest_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
	    if ($this->baseObject_method === 'main' ) {
		    if ( ! $that->config->get( 'embed_mode' ) ) {
                $that->load->language('quick_view/quick_view');
                $products = $that->data['products'];
                $this->data['latest_products'] = [];
                if ($products) {
                    foreach ($products as $product) {
                        $product_price = $product['price'];
                        if ($this->verifyProductPricingPlus()) {
                            $that->load->model('extension/product_pricing_plus');
                            $product_id = $product['product_id'];
                            $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                            if ($settings['show_product_listing']==='1') {
                                $product_price = html_entity_decode($settings['content']);
                                if ($product['special']) {
                                    $product['special'] = $product_price.' '.$product['special'];
                                    $product_price= $product['price'];
                                } else {
                                    if ($product['price']!=='$0.00') {
                                        $product_price .= ' ' . $product['price'];
                                    }
                                }
                            } else {
                                $product_price = $product['price'];
                            }
                        }
                        $quickView = "<a style=\"margin-left:-10px\" onclick=\"quickView('#quickview-modal', 
            '" . $that->html->getURL('r/quick_view/quick_view', '&product_id=' . $product['product_id']) . "')\" href=\"javascript:void(0);\"><i class='fa fa-search'></i> " . $that->language->get('text_quick_view') . "</a>";

                        $this->data['latest_products'][] = [
                            'product_id' => $product['product_id'],
                            'name' => $product['name'],
                            'blurb' => html_entity_decode($product['blurb']),
                            'model' => $product['model'],
                            'rating' => $product['rating'],
                            'stars' => $product['stars'],
                            'price' => $product_price,
                            'call_to_order' => $product['call_to_order'],
                            'options' => $product['options'],
                            'special' => $product['special'],
                            'thumb' => $product['thumb'],
                            'href' => $product['href'],
                            'add' => $product['add'],
                            'track_stock' => $product['track_stock'],
                            'in_stock' => $product['in_stock'],
                            'no_stock_text' => $product['no_stock_text'],
                            'total_quantity' => $product['total_quantity'],
                            'tax_class_id' => $product['tax_class_id'],
                            'date_added'     => $product['date_added'],
                            'buttons' => $quickView,
                        ];
                    }
                    $that->view->assign('products', $this->data['latest_products']);
                }
		    }
	    }
    }

    public function onControllerPagesProductSpecial_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
	    if ($this->baseObject_method === 'main' ) {
            if (!$that->config->get('embed_mode')) {
                $that->load->language('quick_view/quick_view');
                $products = $that->data['products'];
                $this->data['special_products'] = [];
                if ($products) {
                    foreach ($products as $product) {
                        $product_price = $product['price'];
                        if ($this->verifyProductPricingPlus()) {
                            $that->load->model('extension/product_pricing_plus');
                            $product_id = $product['product_id'];
                            $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                            if ($settings['show_product_listing']==='1') {
                                $product_price = html_entity_decode($settings['content']);
                                if ($product['special']) {
                                    $product['special'] = $product_price.' '.$product['special'];
                                    $product_price= $product['price'];
                                } else {
                                    if ($product['price']!=='$0.00') {
                                        $product_price .= ' ' . $product['price'];
                                    }
                                }
                            } else {
                                $product_price = $product['price'];
                            }
                        }
                        $quickView = "<a style=\"margin-left:-10px\" onclick=\"quickView('#quickview-modal', 
            '" . $that->html->getURL('r/quick_view/quick_view', '&product_id=' . $product['product_id']) . "')\" href=\"javascript:void(0);\"><i class='fa fa-search'></i> " . $that->language->get('text_quick_view') . "</a>";

                        $this->data['special_products'][] = [
                            'product_id' => $product['product_id'],
                            'name' => $product['name'],
                            'blurb' => html_entity_decode($product['blurb']),
                            'description' => html_entity_decode($product['description'], ENT_QUOTES, 'UTF-8'),
                            'model' => $product['model'],
                            'rating' => $product['rating'],
                            'stars' => $product['stars'],
                            'price' => $product_price,
                            'call_to_order' => $product['call_to_order'],
                            'options' => $product['options'],
                            'special' => $product['special'],
                            'thumb' => $product['thumb'],
                            'href' => $product['href'],
                            'add' => $product['add'],
                            'track_stock' => $product['track_stock'],
                            'in_stock' => $product['in_stock'],
                            'no_stock_text' => $product['no_stock_text'],
                            'total_quantity' => $product['total_quantity'],
                            'tax_class_id' => $product['tax_class_id'],
                            'date_added' => $product['date_added'],
                            'buttons' => $quickView,
                        ];
                    }
                    $that->view->assign('products', $this->data['special_products']);
                }
            }
        }
    }

    public function onControllerPagesProductCategory_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
	    if ($this->baseObject_method === 'main' ) {
            if(!$that->config->get('embed_mode')) {
                $that->load->language('quick_view/quick_view');
                $products = $that->data['products'];
                $this->data['category_products'] = [];
                if ($products) {
                    foreach ($products as $product) {
                        $product_price = $product['price'];
                        if ($this->verifyProductPricingPlus()) {
                            $that->load->model('extension/product_pricing_plus');
                            $product_id = $product['product_id'];
                            $settings = $that->model_extension_product_pricing_plus->getSettings($product_id);
                            if ($settings['show_product_listing'] === '1') {
                                $product_price = html_entity_decode($settings['content']);
                                if ($product['special']) {
                                    $product['special'] = $product_price . ' ' . $product['special'];
                                    $product_price = $product['price'];
                                } else {
                                    if ($product['price'] !== '$0.00') {
                                        $product_price .= ' ' . $product['price'];
                                    }
                                }
                            } else {
                                $product_price = $product['price'];
                            }
                        }
                        $quickView = "<a style=\"margin-left:-10px\" onclick=\"quickView('#quickview-modal', 
            '" . $that->html->getURL('r/quick_view/quick_view', '&product_id=' . $product['product_id']) . "')\" href=\"javascript:void(0);\"><i class='fa fa-search'></i> " . $that->language->get('text_quick_view') . "</a>";

                        $this->data['category_products'][] = [
                            'product_id' => $product['product_id'],
                            'name' => $product['name'],
                            'blurb' => html_entity_decode($product['blurb']),
                            'description' => html_entity_decode($product['description'], ENT_QUOTES, 'UTF-8'),
                            'model' => $product['model'],
                            'rating' => $product['rating'],
                            'stars' => $product['stars'],
                            'price' => $product_price,
                            'call_to_order' => $product['call_to_order'],
                            'options' => $product['options'],
                            'special' => $product['special'],
                            'thumb' => $product['thumb'],
                            'href' => $product['href'],
                            'add' => $product['add'],
                            'track_stock' => $product['track_stock'],
                            'in_stock' => $product['in_stock'],
                            'no_stock_text' => $product['no_stock_text'],
                            'total_quantity' => $product['total_quantity'],
                            'tax_class_id' => $product['tax_class_id'],
                            'date_added' => $product['date_added'],
                            'buttons' =>  $quickView,
                        ];
                    }
                    $that->view->assign('products', $this->data['category_products']);
                }
            }
        }
    }

    public function onControllerPagesProductManufacturer_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
	    if ($this->baseObject_method === 'main' ) {
            if (!$that->config->get('embed_mode')) {
                $that->load->language('quick_view/quick_view');
                $products = $that->data['products'];
                $this->data['manufacturer_products'] = [];
                if ($products) {
                    foreach ($products as $product) {
                        $product_price=$product['price'];
                        if ($this->verifyProductPricingPlus()) {
                            $that->load->model('extension/product_pricing_plus');
                            $product_id = $product['product_id'];
                            $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                            if ($settings['show_product_listing']==='1') {
                                $product_price = html_entity_decode($settings['content']);
                                if ($product['special']) {
                                    $product['special'] = $product_price.' '.$product['special'];
                                    $product_price= $product['price'];
                                } else {
                                    if ($product['price']!=='$0.00') {
                                        $product_price .= ' ' . $product['price'];
                                    }
                                }
                            } else {
                                $product_price = $product['price'];
                            }
                        }
                        $quickView = "<a style=\"margin-left:-10px\" onclick=\"quickView('#quickview-modal', 
            '" . $that->html->getURL('r/quick_view/quick_view', '&product_id=' . $product['product_id']) . "')\" href=\"javascript:void(0);\"><i class='fa fa-search'></i> " . $that->language->get('text_quick_view') . "</a>";

                        $this->data['manufacturer_products'][] = [
                            'product_id' => $product['product_id'],
                            'name' => $product['name'],
                            'blurb' => html_entity_decode($product['blurb']),
                            'description' => html_entity_decode($product['description'], ENT_QUOTES, 'UTF-8'),
                            'model' => $product['model'],
                            'rating' => $product['rating'],
                            'stars' => $product['stars'],
                            'price' => $product_price,
                            'call_to_order' => $product['call_to_order'],
                            'options' => $product['options'],
                            'special' => $product['special'],
                            'thumb' => $product['thumb'],
                            'href' => $product['href'],
                            'add' => $product['add'],
                            'track_stock' => $product['track_stock'],
                            'in_stock' => $product['in_stock'],
                            'no_stock_text' => $product['no_stock_text'],
                            'total_quantity' => $product['total_quantity'],
                            'tax_class_id' => $product['tax_class_id'],
                            'date_added' => $product['date_added'],
                            'buttons' => $quickView,
                        ];
                    }
                    $that->view->assign('products', $this->data['manufacturer_products']);
                }
            }
        }
    }

    public function onControllerPagesProductSearch_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
	        $that =& $this->baseObject;
	        if ( $this->baseObject_method === 'main' ) {
		        if ( ! $that->config->get( 'embed_mode' ) ) {
                    $that->load->language('quick_view/quick_view');
                    $products = $that->data['products'];
                    $this->data['products_search'] = [];
                    if ($products) {
                        foreach ($products as $product) {
                            $product_price = $product['price'];
                            if ($this->verifyProductPricingPlus()) {
                                $that->load->model('extension/product_pricing_plus');
                                $product_id = $product['product_id'];
                                $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                                if ($settings['show_product_listing']==='1') {
                                    $product_price = html_entity_decode($settings['content']);
                                    if ($product['special']) {
                                        $product['special'] = $product_price.' '.$product['special'];
                                        $product_price= $product['price'];
                                    } else {
                                        if ($product['price']!=='$0.00') {
                                            $product_price .= ' ' . $product['price'];
                                        }
                                    }
                                } else {
                                    $product_price = $product['price'];
                                }
                            }
                            $quickView = "<a style=\"margin-left:-10px\" onclick=\"quickView('#quickview-modal', 
            '" . $that->html->getURL('r/quick_view/quick_view', '&product_id=' . $product['product_id']) . "')\" href=\"javascript:void(0);\"><i class='fa fa-search'></i> " . $that->language->get('text_quick_view') . "</a>";

                            $this->data['products_search'][] = [
                                'product_id' => $product['product_id'],
                                'name' => $product['name'],
                                'blurb' => html_entity_decode($product['blurb']),
                                'description' => html_entity_decode($product['description'], ENT_QUOTES, 'UTF-8'),
                                'model' => $product['model'],
                                'rating' => $product['rating'],
                                'stars' => $product['stars'],
                                'price' => $product_price,
                                'call_to_order' => $product['call_to_order'],
                                'options' => $product['options'],
                                'special' => $product['special'],
                                'thumb' => $product['thumb'],
                                'href' => $product['href'],
                                'add' => $product['add'],
                                'track_stock' => $product['track_stock'],
                                'in_stock' => $product['in_stock'],
                                'no_stock_text' => $product['no_stock_text'],
                                'total_quantity' => $product['total_quantity'],
                                'tax_class_id' => $product['tax_class_id'],
                                'date_added' => $product['date_added'],
                                'buttons' => $quickView,
                            ];
                        }
                        $that->view->assign('products', $this->data['products_search']);
                    }
                }
	        }
        }
    }
}