<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_EXT."license_generator".DIR_EXT_CORE."lib/blesta_api.php";

/**
 * ModelExtensionLicenseGenerator
 * @property ModelCheckoutOrder $model_checkout_order
 * @property ModelLocalisationCountry $model_localisation_country
 * @property ModelLocalisationZone $model_localisation_zone
 * @property ModelAccountOrder $model_account_order
 * @property ModelExtensionEmailEditor $model_extension_email_editor
 * @property ModelCatalogProduct $model_catalog_product
 */
class ModelExtensionLicenseGenerator extends Model {

    public $blesta_user = "admin";
    public $blesta_key = "c67700f7c3e5312e8219b5bbf8281484";
    public $blesta_url = "https://wehearyou2.com/clientarea/api/";

    //public $blesta_user = "handoyo";
    //public $blesta_key = "e012096d9c135007ff4219863c1b048b";
    //public $blesta_url = "https://abdev7.com/blesta/api/";

    /**
     * Update Order Download Sort Order
     * @param $order_id
     * @return void
     * @throws AException
     */
    public function updateOrderDownloadSortOrder($order_id) {
        $query = $this->db->query("SELECT * FROM ".$this->db->table("order_downloads")." WHERE `order_id`=".(int)$order_id);
        $order_downloads = $query->rows;
        foreach ($order_downloads as $download) {
            $download_sort_order = $this->getSortOrderByDownloadId($download['download_id']);
            $this->db->query("UPDATE ".$this->db->table("order_downloads")." SET `sort_order`=".(int)$download_sort_order." WHERE `order_id`=".(int)$order_id." AND `download_id`=".(int)$download['download_id']);
        }
    }

    /**
     * Get Download Sort Order
     * @param $download_id
     * @return mixed
     * @throws AException
     */
    public function getSortOrderByDownloadId($download_id) {
        $query = $this->db->query("SELECT `sort_order` FROM ".$this->db->table("downloads")." WHERE `download_id`=".(int)$download_id);
        return $query->row['sort_order'];
    }

    /**
     * Validate Username
     * @param $username
     * @return string|null
     * @throws AException
     */
    public function validateUsername($username) {
        $this->load->language('license_generator/license_generator');

        $api = new BlestaApi($this->blesta_url, $this->blesta_user, $this->blesta_key);
        $post = $this->request->post;
        $exist = $api->post("users", "getByUsername", array(
            'username' => $username
        ));

        $existResult = json_decode(json_encode($exist->response()), true);
        $existErr = json_decode(json_encode($exist->errors()), true);
        if ($this->config->get('license_generator_debug_blesta')) {
            if ($existErr) {
                $this->log->write('Blesta validate username error: ' . var_export($existErr, true));
            } else {
                $this->log->write('Blesta validate username debug: ' . var_export($existResult, true));
            }
        }

        $error = "";

        if (!$existResult && $post['have_account'] === '1') {
            $error = $this->language->get('error_username');
        } elseif ($existResult && $post['have_account'] === '0') {
            $error = $this->language->get('error_username_taken');
        }

        return $error;
    }

    /**
     * Get Blesta ID By Customer ID
     * @param $customer_id
     * @return mixed
     * @throws AException
     */
    public function getSupportUserId($customer_id) {
        $sql = "SELECT * FROM " . $this->db->table("license_generator_account_info") . " WHERE `customer_id`=" . (int)$customer_id;
        $query = $this->db->query($sql);
        return $query->row;
    }

    /**
     * Get Blesta Client ID By Email
     * @param $email
     * @return mixed
     * @throws AException
     */
    public function getSupportUserIdByEmail($email) {
        $sql = "SELECT * FROM " . $this->db->table("license_generator_account_info") . " WHERE `email`='" . $email . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    /**
     * @param $order_id
     * @return mixed
     * @throws AException
     */
    public function getCustomerId($order_id) {
        $sql = "SELECT customer_id FROM " . $this->db->table("orders") . " WHERE `order_id`=" . (int)$order_id;
        $query = $this->db->query($sql);
        return $query->row['customer_id'];
    }

    /**
     * Get License Info By Order ID
     * @param $order_id
     * @return mixed
     * @throws AException
     */
    public function getLicenseKeysInfo($order_id) {
        $this->load->language('license_generator/license_generator');
        $sql = "SELECT * FROM " . $this->db->table("license_generator_info") . "
                WHERE order_id=" . (int)$order_id;
        $query = $this->db->query($sql);
        $results = $query->rows;
        $licenses = $packs_license = [];
        foreach ($results as $info) {
            $data['extension_name'] = $info['extension_name'];
            $data['store_url'] = $info['store_url'];
            $data['cart_version'] = $info['cart_version'];
            $data['license_code'] = $info['license_code'];
            $data['license_status'] = $info['blesta_license_status'];
            $data['order_product_id'] = $info['order_product_id'];
            if (stripos($info['license_code'],'own-')!==false && stripos($info['extension_name'],'Additional License')==false && $info['blesta_license_status']==='Active') {
                $text_order = $this->language->get('text_order_additional_license');
                $data['additional_license_link'] = '<button type="button" id="button_reorder" class="btn btn-primary" title="' . $text_order . '" onclick = "orderAdditionalLicense(' . $info['license_generator_info_id'] . ',' . $order_id . ');">' . $text_order . '</button>';
            } else {
                $data['additional_license_link'] = '';
            }
            $sql1 = "SELECT * FROM " . $this->db->table("license_generator_packs_info") . "
                WHERE order_id=" . (int)$order_id." AND `order_product_id`=".(int)$info['order_product_id'];
            $query_packs = $this->db->query($sql1);
            $packs = $query_packs->rows;
            if ($packs) {
                foreach ($packs as $pack_license) {
                    $packs_license['extension_name'] = $pack_license['extension_name'];
                    $packs_license['store_url'] = $pack_license['store_url'];
                    $packs_license['cart_version'] = $pack_license['cart_version'];
                    $packs_license['license_code'] = $pack_license['license_code'];
                    $packs_license['license_status'] = $pack_license['blesta_license_status'];
                    if (stripos($pack_license['license_code'],'own-')!==false && stripos($pack_license['extension_name'],'Additional License')==false && $pack_license['blesta_license_status']==='Active') {
                        $text_order = $this->language->get('text_order_additional_license');
                        $packs_license['additional_packs_license_link'] = '<button type="button" id="button_reorder" class="btn btn-primary" title="' . $text_order . '" onclick = "orderAdditionalPacksLicense(' . $pack_license['license_generator_pack_info_id'] . ',' . $order_id . ');">' . $text_order . '</button>';
                    } else {
                        $packs_license['additional_packs_license_link'] = '';
                    }
                    $data['packs_license'][$info['order_product_id']][] = $packs_license;
                }
            }

            $licenses[] = $data;
        }

        return $licenses;
    }

    /**
     * Check If Owned license exist
     * @param $order_id
     * @return mixed
     * @throws AException
     */
    public function isOwnLicenseExist($order_id) {
        $sql = "SELECT count(*) as total FROM " . $this->db->table("license_generator_info") . "
                WHERE order_id=" . (int)$order_id." AND `license_code` LIKE '%own-%'";
        $query = $this->db->query($sql);
        return $query->row['total'];
    }

    /**
     * @param $order_id
     * @return mixed
     * @throws AException
     */
    public function getLicenseKeysRelationInfo($order_id) {
        $sql = "SELECT * FROM " . $this->db->table("license_generator_info") . " lgi
                LEFT JOIN " . $this->db->table("stripe_order_relation") . " sor ON sor.old_order_id=lgi.order_id
                WHERE sor.order_id=" . (int)$order_id;
        $query = $this->db->query($sql);
        return $query->rows;
    }

    /**
     * @param $data
     * @throws AException
     */
    public function saveRelation($data) {
        $this->db->query("DELETE FROM " . $this->db->table("stripe_order_relation") . " WHERE `old_order_id`=" . (int)$data['old_order_id']);
        $this->db->query("INSERT INTO " . $this->db->table("stripe_order_relation") . " SET `old_order_id`=" . (int)$data['old_order_id'] . ",`order_id`=" . (int)$data['order_id']);
    }

    /**
     * Save License Info
     * @param $order_id
     * @param $data
     * @throws AException
     */
    public function saveInfo($order_id, $data) {
        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($order_id);
        $data['customer_id'] = $order_info['customer_id'];
        $customer_support_info = $this->getSupportUserId($order_info['customer_id']);
        if (!$customer_support_info) {
            if ($data['have_account'] === '0') {
                $register = $this->registerBlesta($data);
                $data['support_account_client_id'] = $register['id'];
                $data['support_client_id_code'] = $register['id_value'];
            } else {
                $info = $this->getUserId($data['existing_support_username']);
                $data['support_account_client_id'] = $info['id'];
                $data['support_client_id_code'] = $info['id_value'];
            }
            $this->saveAccountInfo($data);
        }
    }

    /**
     * Save Info By Customer ID
     * @param $order_id
     * @param $data
     * @throws AException
     */
    public function saveInfoByCustomerId($data) {
        $this->load->model('checkout/order');
        $customer_support_info = $this->getSupportUserId($data['customer_id']);
        if (!$customer_support_info) {
            if ($data['have_account'] === '0') {
                $register = $this->registerBlesta($data);
                $data['support_account_client_id'] = $register['id'];
                $data['support_client_id_code'] = $register['id_value'];
                $data['email'] = $data['email'];
            } else {
                $info = $this->getUserId($data['existing_support_username']);
                $data['support_account_client_id'] = $info['id'];
                $data['support_client_id_code'] = $info['id_value'];
                $data['email'] = $info['email'];
            }
            $this->saveAccountInfo($data);
        }
    }

    /**
     * Get Customer ID By Email
     * @param $email
     * @return mixed
     * @throws AException
     */
    public function getCustomerIdByEmail($email) {
        $query = $this->db->query("SELECT `customer_id` FROM " . $this->db->table("customers") . " WHERE `email`='" . $email . "'");
        return $query->row['customer_id'];
    }

    /**
     * Validate Main Store License Key
     * @param $license_key
     * @return array|bool|float|int|mixed|stdClass|string|null
     */
    public function validateMainStore($license_key) {
        $api = new BlestaApi($this->blesta_url, $this->blesta_user, $this->blesta_key);
        $getLicenseKeyInfo = $api->post("license_keys.license_keys_list", "getLicensesInfoByBlestaLicenseCode", [
            'blesta_license_code' => $license_key
        ]);
        $getLicenseKeyInfoResult = json_decode(json_encode($getLicenseKeyInfo->response()),true);
        $getLicenseKeyInfoErr = json_decode(json_encode($getLicenseKeyInfo->errors()),true);
        if ($this->config->get('license_generator_debug_blesta')) {
            if ($getLicenseKeyInfoErr) {
                $this->log->write('License generator validate main store error: ' . var_export($getLicenseKeyInfoErr, true));
            } else {
                $this->log->write('License generator validate main store debug: ' . var_export($getLicenseKeyInfoResult, true));
            }
        }
        return $getLicenseKeyInfoResult;
    }

    /**
     * Create Blesta Account
     * @param $data
     * @return mixed
     * @throws AException
     */
    public function registerBlesta($data) {
        if (isset($data['guest'])) {
            $info = $data['guest'];
        } else {
            $info = $data;
        }
        $api = new BlestaApi($this->blesta_url, $this->blesta_user, $this->blesta_key);
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');
        $country_info = $this->model_localisation_country->getCountry($info['country_id']);
        $zone_info = $this->model_localisation_zone->getZone($info['zone_id']);
        $response = $api->post("clients", "create", [
            'vars' => [
                'username' => $info['support_username'],
                'new_password' => $info['support_password'],
                'confirm_password' => $data['support_password'],
                //1 is general, 2 is extension customer
                'client_group_id' => '1',
                'status' => 'active',
                'first_name' => $info['firstname'],
                'last_name' => $info['lastname'],
                'email' => $info['cc_email'] ? $info['cc_email'] : $info['email'],
                'address1' => $info['address_1'],
                'address2' => $info['address_2'],
                'city' => $info['city'],
                'company' => $info['company'],
                'zip' => $info['postcode'],
                'state' => $zone_info['code'],
                'country' => $country_info['iso_code_2'],
                'settings' => [
                    'default_currency' => 'USD',
                    'language' => 'en_us',
                    'username_type' => 'username',
                    'tax_id' => '',
                    'tax_exempt' => '',
                ],
                'send_registration_email' => 'false'
            ]
        ]);
        $registerResult = json_decode(json_encode($response->response()), true);
        $existErr = json_decode(json_encode($response->errors()), true);
        if ($this->config->get('license_generator_debug_blesta')) {
            if ($existErr) {
                $this->log->write('License generator support system register customer error: ' . var_export($existErr, true));
            } else {
                $this->log->write('License generator support system register customer debug: ' . var_export($registerResult, true));
            }
        }
        return $registerResult;
    }

    /**
     * Get Blesta User ID
     * @param $username
     * @return mixed|void
     */
    public function getUserId($username)  {
        $api = new BlestaApi($this->blesta_url, $this->blesta_user, $this->blesta_key);
        $exist = $api->post("users", "getByUsername", [
            'username' => $username
        ]);

        $existResult = json_decode(json_encode($exist->response()), true);
        $existErr = json_decode(json_encode($exist->errors()), true);

        if ($existResult) {
            $user_id = $existResult['id'];
            $clientInfo = $api->post("clients", "getByUserId", [
                'user_id' => $user_id
            ]);

            $clientInfoResult = json_decode(json_encode($clientInfo->response()), true);
            $clientInfoErr = json_decode(json_encode($clientInfo->errors()), true);

            if ($this->config->get('license_generator_debug_blesta')) {
                if ($existErr) {
                    $this->log->write('License generator support system get user id error: ' . var_export($clientInfoErr, true));
                } else {
                    $this->log->write('License generator support system get user id debug: ' . var_export($clientInfoResult, true));
                }
            }

            return $clientInfoResult;
        }
    }

    /**
     * Save account info
     * @param $data
     * @throws AException
     */
    public function saveAccountInfo($data) {
        if ($data['have_account'] === '1' && $data['existing_support_username']) {
            $username = $data['existing_support_username'];
        } elseif ($data['support_username']) {
            $username = $data['support_username'];
        }

        $this->db->query("INSERT INTO " . $this->db->table("license_generator_account_info") . " SET `customer_id`=" . (int)$data['customer_id'] . ",`email`='" . $data['email'] . "',`support_username`='" . $username . "',
                         `support_client_id`='" . $data['support_account_client_id'] . "',`support_client_id_code`='" . $data['support_client_id_code'] . "'");
    }

    /**
     * Save license info
     * @param $data
     * @return int
     * @throws AException
     */
    public function saveLicenseInfo($data) {
        $this->db->query("INSERT INTO " . $this->db->table("license_generator_info") . " SET `order_id`=" . (int)$data['order_id'] . ",`order_product_id`=" . (int)$data['order_product_id'] . ",`extension_name`='" . $data['product_name'] . "',`extension_version`='" . $data['version'] . "',`store_url`='" . $data['url'] . "',
                         `cart_version`='" . $data['cart_version'] . "',`license_code`='" . $data['license_code'] . "',`support_client_id`='".$data['client_id']."',`blesta_license_id`='" . $data['blesta_license_id'] . "',
                         `blesta_note_id`='" . $data['blesta_note_id'] . "',`blesta_service_id`='" . $data['service_id'] . "',`blesta_license_status`='".$data['license_status']."'");
        return $this->db->getLastId();
    }

    /**
     * Save packs license info
     * @param $data
     * @return void
     * @throws AException
     */
    public function savePacksLicenseInfo($data) {
        $this->db->query("INSERT INTO " . $this->db->table("license_generator_packs_info") . " SET `license_generator_info_id`=" . (int)$data['license_generator_info_id'] . ",`order_id`=" . (int)$data['order_id'] . ",`order_product_id`=" . (int)$data['order_product_id'] . ",`extension_name`='" . $data['product_name'] . "',`extension_version`='" . $data['version'] . "',`store_url`='" . $data['url'] . "',
                         `cart_version`='" . $data['cart_version'] . "',`license_code`='" . $data['license_code'] . "',`support_client_id`='".$data['client_id']."',`blesta_license_id`='" . $data['blesta_license_id'] . "',
                         `blesta_note_id`='" . $data['blesta_note_id'] . "',`blesta_service_id`='" . $data['service_id'] . "',`blesta_license_status`='".$data['license_status']."'");
    }

    /**
     * Get License Info By Order Product ID
     * @param $order_product_id
     * @return mixed
     * @throws AException
     */
    public function getLicenseInfoByOrderProductId($order_product_id) {
        $query = $this->db->query("SELECT `license_code`,`blesta_license_status` FROM ".$this->db->table("license_generator_info")." WHERE `order_product_id`=".(int)$order_product_id);
        return $query->row;
    }

    /**
     * Get Packs License Info By Order Product ID
     * @param $order_product_id
     * @return mixed
     * @throws AException
     */
    public function getPacksLicenseInfoByOrderProductId($order_product_id) {
        $query = $this->db->query("SELECT `extension_name`,`license_code`,`blesta_license_status` FROM ".$this->db->table("license_generator_packs_info")." WHERE `order_product_id`=".(int)$order_product_id);
        return $query->rows;
    }

    /**
     * Save order relation to update store order status if blesta invoice is paid
     * @param $data
     * @throws AException
     */
    public function saveOrderRelation($data) {
        $this->db->query("INSERT INTO " . $this->db->table("license_generator_order_relation") . " SET `order_id`=" . (int)$data['order_id'] . ",`blesta_invoice_id`='".$data['invoice_id']."'");
    }

    /**
     * Update License Info
     * @param $data
     * @return void
     * @throws AException
     */
    public function updateLicenseInfo($data) {
        $this->db->query("UPDATE ".$this->db->table("license_generator_info") . " SET `license_code`='".$data['license_code']."' WHERE `blesta_service_id`='".$data['service_id']."'");
        $info =  $this->getBlestaLicenseInfoByServiceId($data['service_id']);
        $data['blesta_license_id'] = $info['blesta_license_id'];
        $data['blesta_note_id'] = $info['blesta_note_id'];
        $this->updateBlestaLicenseList($data);
        $this->updateBlestaNotes($data);
    }

    /**
     * Update Packs License Info
     * @param $data
     * @return void
     * @throws AException
     */
    public function updatePacksLicenseInfo($data) {
        $this->db->query("UPDATE ".$this->db->table("license_generator_packs_info") . " SET `license_code`='".$data['license_code']."' WHERE `blesta_service_id`='".$data['service_id']."'");
        $info =  $this->getBlestaPacksLicenseInfoByServiceId($data['service_id']);
        $data['blesta_license_id'] = $info['blesta_license_id'];
        $data['blesta_note_id'] = $info['blesta_note_id'];
        $this->updateBlestaLicenseList($data);
        $this->updateBlestaNotes($data);
    }

    /**
     * Update License Status
     * @param $data
     * @return void
     * @throws AException
     */
    public function updateLicenseStatus($data) {
        $this->db->query("UPDATE ".$this->db->table("license_generator_info") . " SET `blesta_license_status`='".$data['license_status']."' WHERE `blesta_service_id`='".$data['service_id']."'");
    }

    /**
     * Update Packs License Status
     * @param $data
     * @return void
     * @throws AException
     */
    public function updatePacksLicenseStatus($data) {
        $this->db->query("UPDATE ".$this->db->table("license_generator_packs_info") . " SET `blesta_license_status`='".$data['license_status']."' WHERE `blesta_service_id`='".$data['service_id']."'");
    }

    /**
     * Get Blesta license ID by Service Id
     * @param $service_id
     * @return mixed
     * @throws AException
     */
    public function getBlestaLicenseInfoByServiceId($service_id) {
        $query = $this->db->query("SELECT `blesta_license_id`,`blesta_note_id` FROM ".$this->db->table("license_generator_info")." WHERE `blesta_service_id`='".$service_id."'");
        return $query->row;
    }

    /**
     * Get Blesta Packs license ID by Service Id
     * @param $service_id
     * @return mixed
     * @throws AException
     */
    public function getBlestaPacksLicenseInfoByServiceId($service_id) {
        $query = $this->db->query("SELECT `blesta_license_id`,`blesta_note_id` FROM ".$this->db->table("license_generator_packs_info")." WHERE `blesta_service_id`='".$service_id."'");
        return $query->row;
    }

    /**
     * Get Order ID By Blesta Invoice ID
     * @param $invoice_id
     * @return mixed
     * @throws AException
     */
    public function getOrderIdByBlestaInvoice($invoice_id) {
        $query = $this->db->query("SELECT `order_id` FROM ".$this->db->table("license_generator_order_relation") . " WHERE `blesta_invoice_id`='".$invoice_id."'");
        return $query->row['order_id'];
    }

    /**
     * Generate License Key
     * @param $order_id
     * @throws AException
     */
    public function generateLicenseKey($order_id) {
        $this->load->model('checkout/order');
        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($order_id);
        $customer_id = $order_info['customer_id'];
        $support_info = $this->getSupportUserId($customer_id);
        $order_products = $this->model_account_order->getOrderProducts($order_id);
        $services = [];

        $data['email'] = $support_info['email'];
        $data['client_id'] = $support_info['support_client_id'];
        $data['client_id_code'] = $support_info['support_client_id_code'];
        foreach ($order_products as $product) {
            $data['product_name'] = $product['name'];
            $options = $this->model_account_order->getOrderOptions($order_id, $product['order_product_id']);
            //$this->log->write(var_export($options,true));
            $method = $buy = $rent = $store_url = $cart_version = $license = $expire = '';
            $data['order_id'] = $order_id;
            foreach ($options as $option) {
                if (stripos($option['name'], 'Buy ') !== false) {
                    $buy = '1';
                } else if (stripos($option['name'], 'Rent ') !== false) {
                    $rent = '1';
                    $period = str_replace('Months', 'Month', $option['value']);
                } else if (stripos($option['name'], 'The URL where you will install') !== false) {
                    $search = ['https://', 'http://', 'www.'];
                    $replace = [""];
                    $store_url = str_replace($search, $replace, $option['value']);
                    $store_url = rtrim($store_url, '/');
                } elseif (stripos($option['name'], 'AbanteCart version of the above URL') !== false) {
                    $cart_version = $option['value'];
                } elseif ($option['name'] === 'Extension Name') {
                    $data['product_name'] = $option['value'] . ' Additional License';
                }
            }

            $data['extension_name'] = html_entity_decode($product['name']);
            if (stripos($product['name'],' Pack') !== false && stripos($product['name'],' + ') == false) {
                $extension_name = str_replace(' Pack','',$product['name']);
                $extension_name =  html_entity_decode($extension_name);
                if (stripos($extension_name,'Pricing Calculator') !== false && stripos($extension_name,' & ') !== false) {
                    $extension_name = str_replace(['Pricing Calculator ',' Pack'],'',$product['name']);
                    $extension_name =  html_entity_decode($extension_name);
                    $extensions = explode(' & ', $extension_name);
                } elseif (stripos($extension_name,' & ') !== false) {
                    $extensions = explode(' & ', $extension_name);
                } elseif ($extension_name==='Pricing Calculator') {
                    $extensions = ['Area Calculator','Length Calculator','Liquids Calculator','Weight Calculator','Volume Calculator'];
                }
                $data['product_name'] = html_entity_decode($product['name']);
                $data['product_id'] = $product['product_id'];
                $data['packs_product_id'][] = $product['product_id'];
                $data['version'] = $this->getLatestExtensionVersion($data)['version'];
                $data['order_product_id'] = $product['order_product_id'];
                $data['url'] = $store_url;
                $data['cart_version'] = $cart_version;
                $data['service_id'] = 0;
                $data['invoice_id'] = 0;
                $data['support_service_id'] = 0;
                $data['support_service_status'] = '-';
                $data['blesta_license_id'] = 0;
                $data['blesta_note_id'] = 0;
                $data['license_status'] = '';
                $data['license_generator_info_id'] = $this->saveLicenseInfo($data);
                $calcs = ['Area','Length','Liquids','Weight','Volume'];
                foreach ($extensions as $product_name) {
                    if (in_array(html_entity_decode($product['name']),$calcs)) {
                        $product['name'] = html_entity_decode($product['name']) . ' Calculator';
                    }
                    $data['license_code'] = $license;
                    $data['ip'] = gethostbyname($store_url);
                    $data['period'] = $period;
                    $data['buy'] = $buy;
                    $data['rent'] = $rent;
                    $data['method'] = $method;
                    $data['quantity'] = $product['quantity'];
                    $data['product_name'] = html_entity_decode($product['name']);
                    $data['version'] = $this->getLatestExtensionVersion($data)['version'];
                    $data['product_name'] = $product_name;

                    $blestaServiceInfo = $this->getBlestaSeruice($data);
                    $services[] = $blestaServiceInfo['invoices'];
                    $data['created_at'] = $blestaServiceInfo['created_at'];
                    $data['created_date'] = $blestaServiceInfo['created_date'];
                    $data['renewal_at'] = $blestaServiceInfo['renewal_at'];
                    $data['renewal_on'] = $blestaServiceInfo['renewal_at'];
                    $data['renewal_date'] = $blestaServiceInfo['renewal_date'];
                    $data['service_id'] = $blestaServiceInfo['service_id'];
                    $data['invoice_id'] = $blestaServiceInfo['invoice_id'];
                    $data['support_service_id'] = $blestaServiceInfo['support_service_id'];
                    $data['support_service_status'] = $blestaServiceInfo['support_service_status'];
                    if ($buy !== '') {
                        $data['invoice'] = '#' . $order_id;
                    } elseif ($rent !== '') {
                        $data['invoice'] = '#Rent-' . $order_id;
                    }
                    $data['blesta_license_id'] = $this->addToLicenseList($data);
                    $data['blesta_note_id'] = $this->addNotes($data);
                    $data['license_status'] = 'Pending';
                    $this->savePacksLicenseInfo($data);
                }
            } elseif (stripos($product['name'],' + ') !== false) {
                $extension_name = str_replace(' Pack','',$product['name']);
                $extension_name =  html_entity_decode($extension_name);
                if (stripos($extension_name,' + ') !== false) {
                    $extensions = explode(' + ', $extension_name);
                }
                $data['product_name'] = html_entity_decode($product['name']);
                $data['product_id'] = $product['product_id'];
                $data['packs_product_id'][] = $product['product_id'];
                $data['version'] = $this->getLatestExtensionVersion($data)['version'];
                $data['order_product_id'] = $product['order_product_id'];
                $data['url'] = $store_url;
                $data['cart_version'] = $cart_version;
                $data['service_id'] = 0;
                $data['invoice_id'] = 0;
                $data['support_service_id'] = 0;
                $data['support_service_status'] = '-';
                $data['blesta_license_id'] = 0;
                $data['blesta_note_id'] = 0;
                $data['license_status'] = '';
                $data['license_generator_info_id'] = $this->saveLicenseInfo($data);
                $this->log->write('extensions: '.var_export($extensions,true));
                foreach ($extensions as $product_name) {
                    $data['license_code'] = $license;
                    $data['ip'] = gethostbyname($store_url);
                    $data['period'] = $period;
                    $data['buy'] = $buy;
                    $data['rent'] = $rent;
                    $data['method'] = $method;
                    $data['quantity'] = $product['quantity'];
                    $data['product_name'] = html_entity_decode($product['name']);
                    $data['version'] = $this->getLatestExtensionVersion($data)['version'];
                    $data['product_name'] = $product_name;
                    $blestaServiceInfo = $this->getBlestaSeruice($data);
                    $services[] = $blestaServiceInfo['invoices'];
                    $data['created_at'] = $blestaServiceInfo['created_at'];
                    $data['created_date'] = $blestaServiceInfo['created_date'];
                    $data['renewal_at'] = $blestaServiceInfo['renewal_at'];
                    $data['renewal_on'] = $blestaServiceInfo['renewal_at'];
                    $data['renewal_date'] = $blestaServiceInfo['renewal_date'];
                    $data['service_id'] = $blestaServiceInfo['service_id'];
                    $data['invoice_id'] = $blestaServiceInfo['invoice_id'];
                    $data['support_service_id'] = $blestaServiceInfo['support_service_id'];
                    $data['support_service_status'] = $blestaServiceInfo['support_service_status'];
                    if ($buy !== '') {
                        $data['invoice'] = '#' . $order_id;
                    } elseif ($rent !== '') {
                        $data['invoice'] = '#Rent-' . $order_id;
                    }
                    $data['blesta_license_id'] = $this->addToLicenseList($data);
                    $data['blesta_note_id'] = $this->addNotes($data);
                    $data['license_status'] = 'Pending';
                    $this->savePacksLicenseInfo($data);
                }
            }else {
                $data['product_id'] = $product['product_id'];
                $data['order_product_id'] = $product['order_product_id'];
                $data['license_code'] = $license;
                $data['url'] = $store_url;
                $data['cart_version'] = $cart_version;
                $data['ip'] = gethostbyname($store_url);
                $data['version'] = $this->getLatestExtensionVersion($data)['version'];
                $data['period'] = $period;
                $data['buy'] = $buy;
                $data['rent'] = $rent;
                $data['method'] = $method;
                $data['quantity'] = $product['quantity'];
                $blestaServiceInfo = $this->getBlestaSeruice($data);
                $services[] = $blestaServiceInfo['invoices'];
                $data['created_at'] = $blestaServiceInfo['created_at'];
                $data['created_date'] = $blestaServiceInfo['created_date'];
                $data['renewal_at'] = $blestaServiceInfo['renewal_at'];
                $data['renewal_on'] = $blestaServiceInfo['renewal_at'];
                $data['renewal_date'] = $blestaServiceInfo['renewal_date'];
                $data['service_id'] = $blestaServiceInfo['service_id'];
                $data['invoice_id'] = $blestaServiceInfo['invoice_id'];
                $data['support_service_id'] = $blestaServiceInfo['support_service_id'];
                $data['support_service_status'] = $blestaServiceInfo['support_service_status'];
                if ($buy !== '') {
                    $data['invoice'] = '#' . $order_id;
                } elseif ($rent !== '') {
                    $data['invoice'] = '#Rent-' . $order_id;
                }
                $data['blesta_license_id'] = $this->addToLicenseList($data);
                $data['blesta_note_id'] = $this->addNotes($data);
                $data['license_status'] = 'Pending';
                $this->saveLicenseInfo($data);
            }
        }
        $data['order_id'] = $order_id;
        $data['invoices'] = $this->array_flatten($services);
        $data['invoice_id'] = $this->createInvoices($data);
        $this->saveOrderRelation($data);
    }

    /**
     * Get Extension Latest Version
     * @param $data
     * @return array|string|string[]
     * @throws AException
     */
    public function getLatestExtensionVersion($data) {
        $sql = "SELECT d.mask as version FROM ".$this->db->table('products_to_downloads')." p2d 
                LEFT JOIN ".$this->db->table("downloads") ." d ON d.download_id = p2d.download_id
                WHERE p2d.product_id=".(int)$data['product_id'] ." AND d.mask like '%".$data['cart_version']."%'";
        $query = $this->db->query($sql);
        $results = $query->rows;
        usort($results, function ($a, $b) {
            list($al, $an) = explode('_', $a);
            list($bl, $bn) = explode('_', $b);
            if ($al == $bl) return version_compare($an, $bn);
            return strcmp($al, $bl);
        });
        $results = array_reverse($results);
        $product_name = str_replace([" & "," + "]," ",$data['product_name']);
        $search = [strtolower(str_replace(" ","_",$product_name)).'_',$product_name.'_','.tar.gz'];
        $replace = [''];
        return str_replace($search,$replace,$results[0]);
    }

    /**
     * Create Blesta Service
     * @param $data
     * @return array
     * @throws Exception
     */
    public function getBlestaSeruice($data) {
        $api = new BlestaApi($this->blesta_url, $this->blesta_user, $this->blesta_key);

        $timezoneInfo = $api->get("companies", "getSetting", [
            'company_id' => 1,
            'key' => 'timezone'
        ]);

        $getTimeZoneResult = json_decode(json_encode($timezoneInfo->response()), true);
        $getTimeZoneErr = json_decode(json_encode($timezoneInfo->errors()), true);

        if ($this->config->get('license_generator_debug_blesta')) {
            if ($getTimeZoneErr) {
                $this->log->write('Blesta get TimeZone error: ' . var_export($getTimeZoneErr, true));
            } else {
                $this->log->write('Blesta get TimeZone debug: ' . var_export($getTimeZoneResult, true));
            }
        }

        $response = [];
        $rent_pricing_id = $rent_service_id = $trial_pricing_id = $trial_service_id = $owned_pricing_id = $owned_service_id = $support_pricing_id = $support_service_id = $additional_license_pricing_id = $additional_license_service_id = '';
        if (!$getTimeZoneErr) {
            $timezone = $getTimeZoneResult['value'];

            $server_timezone = date_default_timezone_get();

            $data['server_timezone'] = $server_timezone;
            $data['blesta_timezone'] = $timezone;

            $query = $api->get("packages", "search", [
                'query' => $data['product_name']
            ]);

            $queryResult = json_decode(json_encode($query->response()), true);
            $queryErr = json_decode(json_encode($query->errors()), true);
            if ($this->config->get('license_generator_debug_blesta')) {
                if ($queryErr) {
                    $this->log->write('Blesta search package error: ' . var_export($queryErr, true));
                } else {
                    $this->log->write('Blesta search package debug: ' . var_export($queryResult, true));
                }
            }
            if (!$queryErr) {
                $rent_license_package_id = $additional_license_package_id = $support_package_id = $package_id = '';
                foreach ($queryResult as $packageResult) {
                    if (stripos($packageResult['name'], ' Development') !== false) {
                        continue;
                    }
                    if (stripos($packageResult['name'], 'Rent ') !== false) {
                        $rent_license_package_id = $packageResult['id'];
                    } elseif (stripos($packageResult['name'], ' Additional') !== false) {
                        $additional_license_package_id = $packageResult['id'];
                    } elseif (stripos($packageResult['name'], ' Support And Updates Service') !== false) {
                        $support_package_id = $packageResult['id'];
                    } else {
                        $package_id = $packageResult['id'];
                    }
                }

                if (stripos($data['product_name'],' Additional License')!==false) {
                    $additionalLicenseResponseInfo = $api->get("packages", "get", [
                        'package_id' => $additional_license_package_id
                    ]);
                    $additionalLicensePackageInfoResult = json_decode(json_encode($additionalLicenseResponseInfo->response()), true);
                    $additionalLicensePackageInfoErr = json_decode(json_encode($additionalLicenseResponseInfo->errors()), true);

                    if ($this->config->get('license_generator_debug_blesta')) {
                        if ($additionalLicensePackageInfoErr) {
                            $this->log->write('Blesta get additional license only package info error: ' . var_export($additionalLicensePackageInfoErr, true));
                        } else {
                            $this->log->write('Blesta get additional license only package info debug: ' . var_export($additionalLicensePackageInfoResult, true));
                        }
                    }

                    if (!$additionalLicensePackageInfoErr) {
                        $additional_license_package_pricing_id = $additionalLicensePackageInfoResult['pricing'][0]['id'];
                        $createAdditionalLicenseData = array(
                            'vars' => array(
                                'pricing_id' => $additional_license_package_pricing_id,
                                'client_id' => $data['client_id'],
                                'qty' => $data['quantity'],
                                'use_module' => 'false',
                                'status' => 'pending',
                            ),
                            'packages' => array($additional_license_package_id => $additional_license_package_pricing_id)
                        );

                        $responseAddAdditionalLicenseService = $api->post('services', 'add', $createAdditionalLicenseData);
                        $addAdditionalLicenseServiceResult = json_decode(json_encode($responseAddAdditionalLicenseService->response()), true);
                        $addAdditionalLicenseServiceErr = json_decode(json_encode($responseAddAdditionalLicenseService->errors()), true);
                        if ($this->config->get('license_generator_debug_blesta')) {
                            if ($addAdditionalLicenseServiceErr) {
                                $this->log->write('Blesta add additional license only service error: ' . var_export($addAdditionalLicenseServiceErr, true));
                            } else {
                                $this->log->write('Blesta add additional license only service debug: ' . var_export($addAdditionalLicenseServiceResult, true));
                            }
                        }
                        $additional_license_service_id = $addAdditionalLicenseServiceResult;

                        if ($addAdditionalLicenseServiceResult) {
                            $response['service_id'] = $additional_license_service_id;
                            $getAdditionalLicenseRenewalDate = $api->get("services", "get", [
                                'service_id' => $additional_license_service_id
                            ]);

                            $getAdditionalLicenseRenewalDateResult = json_decode(json_encode($getAdditionalLicenseRenewalDate->response()), true);
                            $getAdditionalLicenseRenewalDateErr = json_decode(json_encode($getAdditionalLicenseRenewalDate->errors()), true);

                            if ($this->config->get('license_generator_debug_blesta')) {
                                if ($getAdditionalLicenseRenewalDateErr) {
                                    $this->log->write('Blesta get additional license service info error: ' . var_export($getAdditionalLicenseRenewalDateErr, true));
                                } else {
                                    $this->log->write('Blesta get additional license info debug: ' . var_export($getAdditionalLicenseRenewalDateResult, true));
                                }
                            }

                            if (!$getAdditionalLicenseRenewalDateErr) {
                                $created_time = new DateTime($getAdditionalLicenseRenewalDateResult['date_added'], new DateTimeZone($server_timezone));
                                $created_time->setTimezone(new DateTimeZone($timezone));
                                $response['created_at'] = $created_time->format('Y-m-d H:i:s');
                                $response['created_date'] = $created_time->format('M d, Y');
                                //$data['created_date'] = $created_time->format('M d, Y');
                                //$support_expire_date = $created_time->modify('+365 day');
                                //$supportExpireDATE = $support_expire_date->format('Y-m-d');
                                //$response['license_support_date'] = $supportExpireDATE;
                                if (!is_null($getAdditionalLicenseRenewalDateResult['date_renews'])) {
                                    $renewal_time = new DateTime($getAdditionalLicenseRenewalDateResult['date_renews'], new DateTimeZone($server_timezone));
                                    $renewal_time->setTimezone(new DateTimeZone($timezone));
                                    $response['renewal_at'] = $renewal_time->format('Y-m-d H:i:s');
                                    $response['renewal_date'] = $renewal_time->format('M d, Y');
                                } else {
                                    $response['renewal_at'] = null;
                                    $response['renewal_date'] = null;
                                }
                                $response['service_id'] = $additional_license_service_id;
                                $response['support_service_id'] = 0;
                                $response['support_service_status'] = '-';
                                $response['invoices'] = $additional_license_service_id;
                                //$invoices = [$additional_license_service_id];
                                //$data['renewal_date'] = $renewal_time->format('M d, Y');
                                //$data['renewal_on'] = $renewal_time->format('M d, Y');
                            }
                            //$this->load->model('extension/email_editor');
                            //$this->model_extension_email_editor->sendServiceAddedEmail($data);
                        }
                    }
                } else {
                    if ($data['rent'] === '1') {
                        $rentLicensePackageResponseInfo = $api->get("packages", "get", [
                            'package_id' => $rent_license_package_id
                        ]);
                        $rentLicensePackageInfoResult = json_decode(json_encode($rentLicensePackageResponseInfo->response()), true);
                        $rentLicensePackageInfoErr = json_decode(json_encode($rentLicensePackageResponseInfo->errors()), true);

                        if ($this->config->get('license_generator_debug_blesta')) {
                            if ($rentLicensePackageInfoErr) {
                                $this->log->write('Blesta get rent package info error: ' . var_export($rentLicensePackageInfoErr, true));
                            } else {
                                $this->log->write('Blesta get rent package info debug: ' . var_export($rentLicensePackageInfoResult, true));
                            }
                        }

                        if (!$rentLicensePackageInfoErr) {
                            foreach ($rentLicensePackageInfoResult['pricing'] as $pricing) {
                                $term = $pricing['term'] . ' ' . $pricing['period'];
                                if (strtolower($data['period']) !== strtolower($term)) {
                                    continue;
                                }
                                $rent_pricing_id = $pricing['id'];
                            }
                            $createRentServiceData = [
                                'vars' => [
                                    'pricing_id' => $rent_pricing_id,
                                    'client_id' => $data['client_id'],
                                    'qty' => $data['quantity'],
                                    'use_module' => 'false',
                                    'status' => 'pending'
                                ],
                                'packages' => [$rent_license_package_id => $rent_pricing_id]
                            ];

                            $responseAddRentService = $api->post('services', 'add', $createRentServiceData);
                            $addRentServiceResult = json_decode(json_encode($responseAddRentService->response()), true);
                            $addRentServiceErr = json_decode(json_encode($responseAddRentService->errors()), true);
                            if ($this->config->get('license_generator_debug_blesta')) {
                                if ($addRentServiceErr) {
                                    $this->log->write('Blesta add rent service error: ' . var_export($addRentServiceErr, true));
                                } else {
                                    $this->log->write('Blesta add rent service debug: ' . var_export($addRentServiceResult, true));
                                }
                            }
                            $rent_service_id = $addRentServiceResult;

                            if ($addRentServiceResult) {
                                $response['service_id'] = $rent_service_id;
                                $getRenewalDate = $api->get("services", "get", [
                                    'service_id' => $rent_service_id
                                ]);

                                $getRentRenewalDateResult = json_decode(json_encode($getRenewalDate->response()), true);
                                $getRentRenewalDateErr = json_decode(json_encode($getRenewalDate->errors()), true);

                                if ($this->config->get('license_generator_debug_blesta')) {
                                    if ($getRentRenewalDateErr) {
                                        $this->log->write('Blesta get rent service info error: ' . var_export($getRentRenewalDateErr, true));
                                    } else {
                                        $this->log->write('Blesta get rent service info debug: ' . var_export($getRentRenewalDateResult, true));
                                    }
                                }

                                if (!$getRentRenewalDateErr) {
                                    $created_time = new DateTime($getRentRenewalDateResult['date_added'], new DateTimeZone($server_timezone));
                                    $created_time->setTimezone(new DateTimeZone($timezone));
                                    $response['created_at'] = $created_time->format('Y-m-d H:i:s');
                                    $response['created_date'] = $created_time->format('M d, Y');
                                    //$data['created_date'] = $created_time->format('M d, Y');
                                    //$support_expire_date = $created_time->modify('+365 day');
                                    //$supportExpireDATE = $support_expire_date->format('Y-m-d');
                                    //$response['license_support_date'] = $supportExpireDATE;
                                    $renewal_time = new DateTime($getRentRenewalDateResult['date_renews'], new DateTimeZone($server_timezone));
                                    $renewal_time->setTimezone(new DateTimeZone($timezone));
                                    $response['renewal_at'] = $renewal_time->format('Y-m-d H:i:s');
                                    $response['renewal_date'] = $renewal_time->format('M d, Y');
                                    $response['service_id'] = $rent_service_id;
                                    $response['invoices'] = $rent_service_id;
                                    $response['support_service_id'] = 0;
                                    $response['support_service_status'] = 'Pending';
                                    /**
                                    $invoices = [$rent_service_id];
                                    $createRentInvoice = $api->post('invoices', 'createFromServices', [
                                        'client_id' => $data['client_id'],
                                        'service_ids' => $invoices,
                                        'currency' => 'USD',
                                        'due_date' => date("Y/m/d"),
                                        'allow_pro_rata' => false
                                    ]);

                                    $addRentInvoiceResult = $createRentInvoice->response();
                                    $addRentInvoiceErr = $createRentInvoice->errors();
                                    if ($this->config->get('license_generator_debug_blesta')) {
                                        if ($addRentInvoiceErr) {
                                            $this->log->write('Blesta create rent service invoice error: ' . var_export($addRentInvoiceErr, true));
                                        } else {
                                            $this->log->write('Blesta create rent service invoice debug: ' . var_export($addRentInvoiceResult, true));
                                        }
                                    }
                                    $response['invoice_id'] = $addRentInvoiceResult;
                                     **/
                                    //$data['renewal_date'] = $renewal_time->format('M d, Y');
                                    //$data['renewal_on'] = $renewal_time->format('M d, Y');
                                }
                                //$this->load->model('extension/email_editor');
                                //$this->model_extension_email_editor->sendServiceAddedEmail($data);
                            }
                        }
                    } elseif ($data['buy'] === '1') {
                        $ownedLicensePackageResponseInfo = $api->get("packages", "get", [
                            'package_id' => $package_id
                        ]);
                        $ownedLicensePackageInfoResult = json_decode(json_encode($ownedLicensePackageResponseInfo->response()), true);
                        $ownedLicensePackageInfoErr = json_decode(json_encode($ownedLicensePackageResponseInfo->errors()), true);

                        if ($this->config->get('license_generator_debug_blesta')) {
                            if ($ownedLicensePackageInfoErr) {
                                $this->log->write('Blesta get owned package info error: ' . var_export($ownedLicensePackageInfoErr, true));
                            } else {
                                $this->log->write('Blesta get owned package info debug: ' . var_export($ownedLicensePackageInfoResult, true));
                            }
                        }

                        if (!$ownedLicensePackageInfoErr) {
                            $owned_pricing_id = $ownedLicensePackageInfoResult['pricing'][0]['id'];
                            $createOwnedServiceData = [
                                'vars' => [
                                    'pricing_id' => $owned_pricing_id,
                                    //'package_group_id' => 56,
                                    'client_id' => $data['client_id'],
                                    'qty' => $data['quantity'],
                                    'use_module' => 'false',
                                    'status' => 'pending'
                                ],
                                'packages' => [$package_id => $owned_pricing_id]
                            ];

                            $responseAddOwnedService = $api->post('services', 'add', $createOwnedServiceData);
                            $addOwnedServiceResult = json_decode(json_encode($responseAddOwnedService->response()), true);
                            $addOwnedServiceErr = json_decode(json_encode($responseAddOwnedService->errors()), true);
                            if ($this->config->get('license_generator_debug_blesta')) {
                                if ($addOwnedServiceErr) {
                                    $this->log->write('Blesta add owned service error: ' . var_export($addOwnedServiceErr, true));
                                } else {
                                    $this->log->write('Blesta add owned service debug: ' . var_export($addOwnedServiceResult, true));
                                }
                            }
                            $owned_service_id = $addOwnedServiceResult;

                            if ($addOwnedServiceResult) {
                                $getOwnedRenewalDate = $api->get("services", "get", [
                                    'service_id' => $owned_service_id
                                ]);

                                $getOwnedRenewalDateResult = json_decode(json_encode($getOwnedRenewalDate->response()), true);
                                $getOwnedRenewalDateErr = json_decode(json_encode($getOwnedRenewalDate->errors()), true);

                                if ($this->config->get('license_generator_debug_blesta')) {
                                    if ($getOwnedRenewalDateErr) {
                                        $this->log->write('Blesta get rent service info error: ' . var_export($getOwnedRenewalDateErr, true));
                                    } else {
                                        $this->log->write('Blesta get rent service info debug: ' . var_export($getOwnedRenewalDateResult, true));
                                    }
                                }

                                if (!$getOwnedRenewalDateErr) {
                                    $created_time = new DateTime($getOwnedRenewalDateResult['date_added'], new DateTimeZone($server_timezone));
                                    $created_time->setTimezone(new DateTimeZone($timezone));
                                    $response['created_at'] = $created_time->format('Y-m-d H:i:s');
                                    $response['created_date'] = $created_time->format('M d, Y');
                                    ////$data['created_date'] = $created_time->format('M d, Y');
                                    //$support_expire_date = $created_time->modify('+365 day');
                                    //$supportExpireDATE = $support_expire_date->format('Y-m-d');
                                    //$response['license_support_date'] = $supportExpireDATE;
                                    if (!is_null($getOwnedRenewalDateResult['date_renews'])) {
                                        $renewal_time = new DateTime($getOwnedRenewalDateResult['date_renews'], new DateTimeZone($server_timezone));
                                        $renewal_time->setTimezone(new DateTimeZone($timezone));
                                        $response['renewal_at'] = $renewal_time->format('Y-m-d H:i:s');
                                        $response['renewal_date'] = $renewal_time->format('M d, Y');
                                    } else {
                                        $response['renewal_at'] = null;
                                        $response['renewal_date'] = null;
                                    }

                                    //$response['service_id'] = $owned_service_id;
                                    //$data['renewal_date'] = $renewal_time->format('M d, Y');
                                    //$data['renewal_on'] = $renewal_time->format('M d, Y');
                                }

                                $response['service_id'] = $owned_service_id;

                                $supportResponseInfo = $api->get("packages", "get", [
                                    'package_id' => $support_package_id
                                ]);
                                $supportPackageInfoResult = json_decode(json_encode($supportResponseInfo->response()), true);
                                $supportPackageInfoErr = json_decode(json_encode($supportResponseInfo->errors()), true);

                                if ($this->config->get('license_generator_debug_blesta')) {
                                    if ($supportPackageInfoErr) {
                                        $this->log->write('Blesta get owned support package info error: ' . var_export($supportPackageInfoErr, true));
                                    } else {
                                        $this->log->write('Blesta get owned support package info debug: ' . var_export($supportPackageInfoResult, true));
                                    }
                                }

                                if (!$supportPackageInfoErr) {
                                    $support_package_pricing_id = $supportPackageInfoResult['pricing'][0]['id'];
                                    $createSupportData = array(
                                        'vars' => array(
                                            'parent_service_id' => $owned_service_id,
                                            'pricing_id' => $support_package_pricing_id,
                                            'client_id' => $data['client_id'],
                                            'override_price ' => 0,
                                            'use_module' => 'false',
                                            'status' => 'pending',
                                        ),
                                        'packages' => array($support_package_id => $support_package_pricing_id)
                                    );

                                    $responseAddSupportService = $api->post('services', 'add', $createSupportData);
                                    $addSupportServiceResult = json_decode(json_encode($responseAddSupportService->response()), true);
                                    $addSupportServiceErr = json_decode(json_encode($responseAddSupportService->errors()), true);

                                    $getSupportRenewalDate = $api->get("services", "get", [
                                        'service_id' => $addSupportServiceResult
                                    ]);

                                    $getSupportRenewalDateResult = json_decode(json_encode($getSupportRenewalDate->response()), true);
                                    $getSupportRenewalDateErr = json_decode(json_encode($getSupportRenewalDate->errors()), true);

                                    if (!$getSupportRenewalDateErr) {
                                        $created_time = new DateTime($getSupportRenewalDateResult['date_added'], new DateTimeZone($server_timezone));
                                        $created_time->setTimezone(new DateTimeZone($timezone));
                                        $response['created_at'] = $created_time->format('Y-m-d H:i:s');
                                        $response['created_date'] = $created_time->format('M d, Y');
                                        //$data['created_date'] = $created_time->format('M d, Y');
                                        //$support_expire_date = $created_time->modify('+365 day');
                                        //$supportExpireDATE = $support_expire_date->format('Y-m-d');
                                        //$response['license_support_date'] = $supportExpireDATE;
                                        if (!is_null($getSupportRenewalDateResult['date_renews'])) {
                                            $renewal_time = new DateTime($getSupportRenewalDateResult['date_renews'], new DateTimeZone($server_timezone));
                                            $renewal_time->setTimezone(new DateTimeZone($timezone));
                                            $response['renewal_at'] = $renewal_time->format('Y-m-d H:i:s');
                                            $response['renewal_date'] = $renewal_time->format('M d, Y');
                                        } else {
                                            $response['renewal_at'] = null;
                                            $response['renewal_date'] = null;
                                        }
                                    }

                                    if ($this->config->get('license_generator_debug_blesta')) {
                                        if ($addSupportServiceErr) {
                                            $this->log->write('Blesta add support service error: ' . var_export($addSupportServiceErr, true));
                                        } else {
                                            $this->log->write('Blesta add support service debug: ' . var_export($addSupportServiceResult, true));
                                        }
                                    }
                                    $support_service_id = $addSupportServiceResult;
                                    $response['support_service_id'] = $support_service_id;
                                    $response['support_service_status'] = 'Pending';
                                }
                                $invoices = [$owned_service_id, $support_service_id];
                                $response['invoices'] = $invoices;
                                /**
                                $createOwnedInvoice = $api->post('invoices', 'createFromServices', [
                                    'client_id' => $data['client_id'],
                                    'service_ids' => $invoices,
                                    'currency' => 'USD',
                                    'due_date' => date("Y/m/d"),
                                    'allow_pro_rata' => false
                                ]);

                                $addOwnedInvoiceResult = $createOwnedInvoice->response();
                                $addOwnedInvoiceErr = $createOwnedInvoice->errors();
                                if ($this->config->get('license_generator_debug_blesta')) {
                                    if ($addOwnedInvoiceResult) {
                                        $this->log->write('Blesta create owned service invoice error: ' . var_export($addOwnedInvoiceErr, true));
                                    } else {
                                        $this->log->write('Blesta create owned service invoice debug: ' . var_export($addOwnedInvoiceResult, true));
                                    }
                                } **/
                            }
                        }
                    }
                }
            }
            return $response;
        }
    }

    /**
     * @param $array
     * @return array|false
     */
    private function array_flatten($array) {
        if (!is_array($array)) {
            return FALSE;
        }
        $result = array();
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $result = array_merge($result, $this->array_flatten($value));
            }
            else {
                $result[$key] = $value;
            }
        }
        return $result;
    }

    /**
     * Create Blesta Invoices From Services
     * @param $data
     * @return mixed|void|null
     */
    public function createInvoices($data) {
        $api = new BlestaApi($this->blesta_url, $this->blesta_user, $this->blesta_key);

        $createInvoice = $api->post('invoices', 'createFromServices', [
            'client_id' => $data['client_id'],
            'service_ids' => $data['invoices'],
            'currency' => 'USD',
            'due_date' => date("Y/m/d"),
            'allow_pro_rata' => false
        ]);

        $createInvoiceResult = $createInvoice->response();
        $createInvoiceErr = $createInvoice->errors();
        if ($this->config->get('license_generator_debug_blesta')) {
            if ($createInvoiceErr) {
                $this->log->write('Blesta create invoice error: ' . var_export($createInvoiceErr, true));
            } else {
                $this->log->write('Blesta create invoice debug: ' . var_export($createInvoiceResult, true));
            }
        }

        if (!$createInvoiceErr) {
            $invoiceInfo = $api->get('invoices', 'get',
                ['invoice_id' => $createInvoiceResult]
            );

            $invoiceInfoResult = $invoiceInfo->response();
            $invoiceInfoErr = $invoiceInfo->errors();

            if ($this->config->get('license_generator_debug_blesta')) {
                if ($invoiceInfoErr) {
                    $this->log->write('Blesta get invoice error: ' . var_export($invoiceInfoErr, true));
                } else {
                    $this->log->write('Blesta get invoice debug: ' . var_export($invoiceInfoResult, true));
                }
            }

            if (!$invoiceInfoErr) {
                $invoiceInfoResults = json_decode(json_encode($invoiceInfoResult), true);
                $invoiceItems = $invoiceInfoResults['line_items'];
                $editInvoice = $items_id = [];

                foreach ($invoiceItems as $items) {
                    if (stripos($items['description'], ' Support And Updates Service') !== false) {
                        $support_info = explode(' -  (', $items['description']);
                        $description = $support_info[0] . ' 1st year included -  (' . $support_info[1];
                        $amount = 0;
                    } else {
                        $description = $items['description'];
                        $amount = $items['amount'];
                    }
                    $editInvoiceDatas['id'] = $items['id'];
                    $items_id[]= $items['id'];
                    $editInvoiceDatas['service_id'] = $items['service_id'];
                    $editInvoiceDatas['description'] = $description;
                    $editInvoiceDatas['qty'] = $items['qty'];
                    $editInvoiceDatas['amount'] = $amount;
                    $editInvoiceDatas['tax'] = false;
                    $editInvoice[] = $editInvoiceDatas;
                }

                if ($data['packs_product_id']) {
                    $this->load->model('catalog/product');
                    foreach ($data['packs_product_id'] as $packs_product_id) {
                        $product_description = $this->model_catalog_product->getProduct($packs_product_id);
                        $discount = $this->getPacksDiscount($packs_product_id);
                        $discountDatas['description'] = html_entity_decode($product_description['name']).' Bundle Discount';
                        $discountDatas['amount'] = -$discount;
                        $discountDatas['qty'] = '1';
                        $discountDatas['tax'] = false;
                        $editInvoice[] = $discountDatas;
                    }
                }

                //if (stripos($data['extension_name'],' Pack')) {
                //    $discount = $this->getPacksDiscountByProductName($data['extension_name']);
                //    //if ($data['extension_name'] === 'Delivery Scheduler & Quick Grid Export Pack') {
                //        $discountDatas['description'] = $data['extension_name'].' Bundle Discount';
                //        $discountDatas['amount'] = $discount;
                //    //}
                //    $diacountDatas['qty'] = '1';
                //    $diacountDatas['tax'] = false;
                //    $editInvoice[] = $diacountDatas;
                //}

                $editInvoiceData = [
                    'invoice_id' => $createInvoiceResult,
                    'vars' => [
                        'lines' => $editInvoice,
                        'delivery' => ['email']
                    ],
                ];

                $editInvoiceInfo = $api->post('invoices', 'edit', $editInvoiceData);
                $editInvoiceInfoResult = $editInvoiceInfo->response();
                $editInvoiceInfoErr = $editInvoiceInfo->errors();
                if ($this->config->get('license_generator_debug_blesta')) {
                    if ($editInvoiceInfoErr) {
                        $this->log->write('Blesta edit invoice error: ' . var_export($editInvoiceInfoErr, true));
                    } else {
                        $this->log->write('Blesta edit invoice debug: ' . var_export($editInvoiceInfoResult, true));
                    }
                }
                return $editInvoiceInfoResult;
            }
        }
    }

    /**
     * Get Cart Version By Order ID
     * @param $order_id
     * @return mixed
     * @throws AException
     */
    public function getCartVersion($order_id) {
        $query = $this->db->query("SELECT `cart_version` FROM ".$this->db->table("license_generator_info")." WHERE `order_id`=".(int)$order_id);
        return $query->row['cart_version'];
    }

    /**
     * Get Customer Order Downloads
     * @param int $order_id
     * @param int $customer_id
     *
     * @return array
     * @throws AException
     */
    public function getCustomerOrderDownloads($order_id, $customer_id) {
        $customer_id = (int)$customer_id;
        $order_id = (int)$order_id;
        if (!$order_id) {
            return [];
        }
        $sql = "SELECT o.order_id,
                      o.order_status_id,
                      od.download_id,
                      od.status,
                      od.date_added,
                      od.order_download_id,
                      d.activate,
                      od.activate_order_status_id,
                      od.name,
                      od.filename,
                      od.mask,
                      od.remaining_count,
                      od.expire_date,
                      op.product_id,
                      o.email
               FROM ".$this->db->table("order_downloads")." od
               INNER JOIN ".$this->db->table("orders")." o ON (od.order_id = o.order_id)
               LEFT JOIN ".$this->db->table("downloads")." d ON (d.download_id = od.download_id)
               LEFT JOIN ".$this->db->table("order_products")." op ON (op.order_product_id = od.order_product_id)
               LEFT JOIN ".$this->db->table("license_generator_info")." lgi ON (lgi.order_id = od.order_id)
               WHERE o.order_id = '".$order_id."' AND od.name LIKE CONCAT('%', lgi.extension_version, '%')
               ".($customer_id ? " AND o.customer_id = '".$customer_id."'" : "")."
               ORDER BY  o.date_added DESC,od.sort_order DESC,od.name DESC ";

        $query = $this->db->query($sql);
        $downloads = [];
        foreach ($query->rows as $download_info) {
            $downloads[$download_info['order_download_id']] = $download_info;
        }
        return $downloads;
    }

    /**
     * Get Service Id By Store URL
     * @param $url
     * @param $extension_name
     * @return mixed
     * @throws AException
     */
    public function getServiceIdByURL($url,$extension_name) {
        $query = $this->db->query("SELECT `blesta_service_id` WHERE `store_url`='".$url."' AND `extension_name`='".$extension_name."'");
        return $query->row['service_id'];
    }

    /**
     * @param $data
     */
    public function addToLicenseList($data) {
        $api  = new BlestaApi( $this->blesta_url, $this->blesta_user, $this->blesta_key );
        $response2 = $api->post("license_keys.license_keys_list", "create", [
            'vars' => [
                'client_id' => $data['client_id'],
                'client_id_code' => $data['client_id_code'],
                'extension_name' => $data['product_name'],
                'version' => $data['version'],
                'installation_url' => $data['url'],
                'ip_address' => $data['ip'],
                'license_code' => '',
                'blesta_license_code' => $data['license_code'],
                'subscribed' => 'Yes',
                'created_at' => $data['created_at'],
                'renewal_date' => $data['renewal_at'] !== '' ? $data['renewal_at'] : null,
                'license_id' => 0,
                'service_id' => $data['service_id'],
                'support_service_id' => $data['support_service_id'],
                'support_service_status' => $data['support_service_status'],
            ]
        ]);

        $result2 = json_decode(json_encode($response2->response()),true);
        $err2 = json_decode(json_encode($response2->errors()),true);
        if ($this->config->get('license_generator_debug_blesta')) {
            if ($err2) {
                $this->log->write('Blesta add to license list error: '.var_export($err2,true));
            } else {
                $this->log->write('Blesta add to license list debug: '.var_export($result2,true));
            }
        }
        return $result2;
    }

    /**
     * Update Blesta License List license code info
     * @param $data
     * @return mixed
     */
    public function updateBlestaLicenseList($data) {
        $api = new BlestaApi( $this->blesta_url, $this->blesta_user, $this->blesta_key );
        $getLicenseKeyInfo = $api->post("license_keys.license_keys_list", "getLicenseInfoByLicenseKeyId", [
            'license_keys_id' => $data['blesta_license_id']
        ]);
        $result2 = json_decode(json_encode($getLicenseKeyInfo->response()),true);
        $err2 = json_decode(json_encode($getLicenseKeyInfo->errors()),true);

        if ($this->config->get('license_generator_debug_blesta')) {
            if ($err2 || !is_null($err2)) {
                $this->log->write('Blesta get license list info error: '.var_export($err2,true));
            } else {
                $this->log->write('Blesta get license list info debug: '.var_export($result2,true));
            }
        }

        if ($result2) {
            $updateInfo = $api->post("license_keys.license_keys_list", "update", [
                'license_keys_id' => (int)$data['blesta_license_id'],
                'vars' => array(
                    'blesta_license_code' => $data['license_code']
                )
            ]);
            $updateResult2 = json_decode(json_encode($updateInfo->response()),true);
            $updateError2 = json_decode(json_encode($updateInfo->errors()),true);

            if ($this->config->get('license_generator_debug_blesta')) {
                if ($updateError2) {
                    $this->log->write('Blesta update license list error: '.var_export($updateError2,true));
                } else {
                    $this->log->write('Blesta update license list debug: '.var_export($updateResult2,true));
                }
            }
        }
        return $result2;
    }

    /**
     * Create Blesta Client Note
     * @param $data
     */
    public function addNotes($data) {
        $api  = new BlestaApi( $this->blesta_url, $this->blesta_user, $this->blesta_key );

        $createNote = $api->post("clients", "addNote", [
            "client_id" => $data['client_id'],
            "staff_id" => '',
            "vars" => [
                "title" => $data['product_name'] . ' license code is: {license_code} and the URL is: ' . $data['url'],
                "description" => "The license code is {license_code} \r\nURL is: " . $data['url'],
                "stickied" => '1'
            ]
        ]);

        $resultNote = json_decode(json_encode($createNote->response()),true);
        $errNote = json_decode(json_encode($createNote->errors()),true);
        if ($this->config->get('license_generator_debug_blesta')) {
            if ($errNote) {
                $this->log->write('Blesta add client note error: '.var_export($errNote,true));
            } else {
                $this->log->write('Blesta add client note debug: '.var_export($resultNote,true));
            }
        }
        if (!$errNote) {
            return $resultNote;
        }
    }

    /**
     * Update Blesta Client Note
     * @param $data
     * @return mixed
     */
    public function updateBlestaNotes($data) {
        $api = new BlestaApi( $this->blesta_url, $this->blesta_user, $this->blesta_key );

        $notes = $api->post("clients", "getNote",['note_id'=>$data['blesta_note_id']]);
        $notesResult = json_decode(json_encode($notes->response()), true);
        $notesError = json_decode(json_encode($notes->errors()), true);

        if ($this->config->get('license_generator_debug_blesta')) {
            if ($notesError || !is_null($notesError)) {
                $this->log->write('Blesta get client note error: ' . var_export($notesError, true));
            } else {
                $this->log->write('Blesta get client note debug: ' . var_export($notesResult, true));
            }
        }

        if (!$notesError) {
            $updateNotes = $api->post("clients", "editNote", [
                'note_id' => (int)$data['blesta_note_id'],
                'vars' => [
                    'title'=> str_replace('{license_code}', $data['license_code'], $notesResult['title']),
                    'description' => str_replace('{license_code}', $data['license_code'], $notesResult['description'])
                ]
            ]);
            $updateNotesResult = json_decode(json_encode($updateNotes->response()), true);
            $updateNotesError = json_decode(json_encode($updateNotes->errors()), true);

            if ($this->config->get('license_generator_debug_blesta')) {
                if ($updateNotesError) {
                    $this->log->write('Blesta update client note error: ' . var_export($updateNotesError, true));
                } else {
                    $this->log->write('Blesta update client note debug: ' . var_export($updateNotesResult, true));
                }
            }

        }
        return $updateNotesResult;
    }

    /**
     * Get Option Type
     * @param $option_id
     * @return mixed
     */
    public function getOptionType($option_id) {
        $sql="SELECT po.element_type,pod.name FROM ". $this->db->table('product_options')." po
              LEFT JOIN ". $this->db->table('product_option_descriptions')." pod ON pod.product_option_id = po.product_option_id  
              WHERE po.product_option_id=".(int)$option_id;
        $results=$this->db->query($sql);
        return $results->row;
    }

    /**
     * Get Product Option Value
     * @param $product_option_value_id
     * @return mixed
     * @throws AException
     */
    public function getProductOptionsValue($product_option_value_id) {
        $sql="SELECT povd.name FROM ". $this->db->table('product_option_values')." pov
              LEFT JOIN ". $this->db->table('product_option_value_descriptions')." povd ON povd.product_option_id = pov.product_option_id  
              WHERE pov.product_option_value_id=".(int)$product_option_value_id;
        $results=$this->db->query($sql);
        return $results->row['name'];
    }

    /**
     * Get Extension By License Code
     * @param $license_code
     * @return mixed
     * @throws AException
     */
    public function getExtensionNameByLicenseCode($license_code) {
        $sql="SELECT `extension_name` FROM ". $this->db->table('license_generator_info')." WHERE `license_code`='".$license_code."'";
        $results=$this->db->query($sql);
        return $results->row['name'];
    }

    /**
     * Get Packs Discount
     * @param $product_id
     * @return mixed
     * @throws AException
     */
    public function getPacksDiscountByProductName($product_name) {
        $sql = "SELECT `discount` FROM ".$this->db->table("license_generator_packs_discount")." lgpd 
                LEFT JOIN ".$this->db->table("product_descriptions")." pd ON pd.product_id = lgpd.product_id 
                WHERE pd.name='".$product_name."'";
        $query = $this->db->query($sql);
        return $query->row['discount'];
    }

    /**
     * @param $product_id
     * @return mixed
     * @throws AException
     */
    public function getPacksDiscount($product_id) {
        $sql = "SELECT `discount` FROM ".$this->db->table("license_generator_packs_discount")." 
                WHERE `product_id`=".(int)$product_id;
        $query = $this->db->query($sql);
        return $query->row['discount'];
    }

}