<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_EXT."license_generator".DIR_EXT_CORE."lib/blesta_api.php";

class ControllerResponsesExtensionLicenseGenerator extends AController {
    public $data = [];

    public $blesta_user = "admin";
    public $blesta_key = "c67700f7c3e5312e8219b5bbf8281484";
    public $blesta_url = "https://wehearyou2.com/clientarea/api/";

    //public $blesta_user = "handoyo";
    //public $blesta_key = "e012096d9c135007ff4219863c1b048b";
    //public $blesta_url = "https://abdev7.com/blesta/api/";

    public function getUserId() {
        $post = $this->request->post;
    }

    public function validateUsername() {
        $this->load->library('json');
        $this->load->language('license_generator/license_generator');

        $api  = new BlestaApi( $this->blesta_url, $this->blesta_user, $this->blesta_key );
        $post = $this->request->post;

        $exist = $api->post( "users", "getByUsername", array(
            'username' => $post['support_username']
        ) );

        $existResult = json_decode(json_encode($exist->response()),true);
        $existErr = json_decode(json_encode($exist->errors()),true);
        if ($this->config->get('license_generator_debug_blesta')) {
            if ($existErr) {
                $this->log->write('Blesta validate username error: ' . var_export($existErr, true));
            } else {
                $this->log->write('Blesta validate username debug: ' . var_export($existResult, true));
            }
        }

        if (!$existResult && $post['have_account'] === '1') {
            $this->data['error'] = $this->language->get('error_username');
        } elseif ($existResult && $post['have_account'] === '0') {
            $this->data['error'] = $this->language->get('error_username_taken');
        }
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($this->data));
    }
}