<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

include_once DIR_EXT.'license_generator'.DIR_EXT_CORE.'lib/download.php';

class ExtensionLicenseGenerator extends Extension {

	public $data = [];
	public $error = [];

    public function __construct() {
        $this->registry = Registry::getInstance();
    }

    private function _is_enabled() {
        return $this->baseObject->config->get( 'license_generator_status' ) ? true : false;
	}

    // Admin Catalog Product Page

    public function onControllerPagesCatalogProduct_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='insert' || $this->baseObject_method==='update') {
            if ($that->request->is_POST()) {
                $data['product_id'] = $that->request->get['product_id'];
                $data['discount'] = $that->request->post['packs_discount'];
                $that->load->model('extension/license_generator');
                $discount = $that->model_extension_license_generator->savePacksDiscount($data);
            }
        }
    }

    public function onControllerPagesCatalogProduct_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='insert') {
            $that->load->language('license_generator/license_generator');
            $form=$that->view->getData('form');
            $form['fields']['data']['packs_discount'] = $that->html->buildInput([
                'id' => 'packs_discount',
                'name' => 'packs_discount',
                'value' => $that->request->post['packs_discount'],
            ]);
            $that->view->assign('form',$form);
            $that->view->assign('entry_packs_discount',$that->language->get('entry_packs_discount'));

        } elseif ($this->baseObject_method==='update') {
            $that->load->language('license_generator/license_generator');

            $product_id = $that->request->get['product_id'];
            $that->load->model('extension/license_generator');
            $discount = $that->model_extension_license_generator->getPacksDiscount($product_id);
            $form=$that->view->getData('form');
            $form['fields']['data']['packs_discount'] = $that->html->buildInput([
                'id' => 'packs_discount',
                'name' => 'packs_discount',
                'value' => $discount,
            ]);
            $that->view->assign('form',$form);
            $that->view->assign('entry_packs_discount',$that->language->get('entry_packs_discount'));
        }
    }

    public function onControllerResponsesListingGridProduct_InitData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='update_field') {
            $that->load->language('license_generator/license_generator');
            $data['product_id'] = (int) $that->request->get['id'];
            $data['discount'] = $that->request->post['packs_discount'];
            $that->load->model('extension/license_generator');
            if ($data['discount']) {
                $that->model_extension_license_generator->savePacksDiscount($data);
            }
        }
    }

    // End Of Admin Catalog Product Page

    // Admin Download Form Section

    public function onControllerResponsesProductProduct_ValidateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $download_id = $that->request->get['download_id'];

        if ($download_id) {
            $that->load->model('catalog/download');
            $data = $that->model_catalog_download->getDownload($download_id);
        } else {
            $data = $that->request->post;
        }

        if (mb_strlen($data['name']) > 2) {
            unset($that->error['name']);
        }

        if (mb_strlen($data['name']) < 2 || mb_strlen($data['name']) > 128) {
            $that->error['name'] = $that->language->get('error_download_name');
        }
    }

    // End Of Admin Download Form Section

	// Admin Customer List Section
    public function onControllerResponsesListingGridCustomer_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'update') {
            $that->load->model('extension/license_generator');
            switch ($that->request->post['oper']) {
                case 'del':
                    $ids = explode(',', $that->request->post['id']);
                    if (!empty($ids)) {
                        foreach ($ids as $id) {
                            $that->model_extension_license_generator->deleteAccountInfo($id);
                        }
                    }
                    break;
            }
        }
    }
    // End Of Admin Customer List Section

    // Admin Order List Section
    public function onControllerResponsesListingGridOrder_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'update') {
            $that->load->model('extension/license_generator');
            switch ($that->request->post['oper']) {
                case 'del':
                    $ids = explode(',', $that->request->post['id']);
                    if (!empty($ids)) {
                        foreach ($ids as $id) {
                            $that->model_extension_license_generator->deleteOrderInfo($id);
                        }
                    }
                    break;
            }
        }
    }
    // End Of Admin Order List Section

    // Admin Order Details Section

    public function onControllerPagesSaleOrder_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'details') {
            $that->load->language('license_generator/license_generator');
            $that->load->model('extension/license_generator');
            $order_id = $that->request->get['order_id'];
            $licenses = $that->model_extension_license_generator->getLicenseKeysInfo($order_id);
            $data['text_license_key_list'] = $that->language->get('text_license_key_list');
            $data['column_extension_name'] = $that->language->get('column_extension_name');
            $data['column_store_url'] = $that->language->get('column_store_url');
            $data['column_cart_version'] = $that->language->get('column_cart_version');
            $data['column_license_key'] = $that->language->get('column_license_key');
            $data['licenses'] = $licenses;
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);

            $that->view->addHookVar('order_details', $view->fetch('pages/sale/license_keys_list.tpl'));
        }
    }

    // End Of Admin Order Details Section

    // Admin Sale Customer Section

    public function onControllerPagesSaleCustomer_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'update') {
            $customer_id = $that->request->get['customer_id'];
            $that->load->model('extension/license_generator');
            $that->load->language('license_generator/license_generator');
            $account_info = $that->model_extension_license_generator->getAccountInfo($customer_id);

            $form = $that->view->getData('form');

            $form['fields']['details']['support_client_id_code'] = $that->html->buildInput([
                    'name' => 'support_client_id_code',
                    'value' => '#'.$account_info['support_client_id_code'],
                'attr' => 'disabled'
            ]);

            $that->view->assign('entry_support_client_id_code', $that->language->get('entry_support_client_id_code'));

            $form['fields']['details']['support_username'] = $that->html->buildInput([
                'name' => 'support_username',
                'value' => $account_info['support_username'],
                'attr' => 'disabled'
            ]);
            $that->view->assign('entry_support_username', $that->language->get('entry_support_username'));

            $that->view->assign('form',$form);

        }
    }

    // End Of Admin Sale Customer Section

	// Storefront Account Create Section
    public function onControllerPagesAccountCreate_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if ($that->request->is_POST()) {
                $that->session->data['have_account'] = $that->request->post['have_account'] ?? '';
                $that->session->data['existing_support_username'] = $that->request->post['existing_support_username'] ?? '';
                $that->session->data['support_username'] = $that->request->post['support_username'] ?? '';
                $that->session->data['support_password'] = $that->request->post['support_password'] ?? '';
             }
        }
    }

    public function onControllerPagesAccountCreate_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            if ($that->request->is_POST() && $that->data['customer_id']) {
                $that->load->model('extension/license_generator');
                $post=$that->request->post;
                $post['customer_id'] = $that->data['customer_id'];
                $that->model_extension_license_generator->saveInfoByCustomerId($post);
            }

            $that->loadLanguage('license_generator/license_generator');
            $fields = ['have_account', 'existing_support_username', 'support_username', 'support_password'];

            $license_generator_info = $that->request->post;
            foreach ($fields as $v) {
                if ($v==='support_password') {
                    $data[$v . '_data'] = '';
                } else {
                    $data[$v . '_data'] = $license_generator_info[$v];
                }

                if (isset($that->session->data['error_'.$v])) {
                    $data['error_'.$v] = $that->session->data['error_'.$v];
                    unset($that->session->data['error_'.$v]);
                }
            }

            $data['session_have_support'] = $that->session->data['session_have_support'];

            $data['text_yes'] = $that->language->get('text_yes');
            $data['text_no'] = $that->language->get('text_no');
            $data['entry_existing_support_username'] = $that->language->get('entry_existing_support_username');
            $data['entry_has_support_account'] = $that->language->get('entry_has_support_account');
            $data['entry_support_account_username'] = $that->language->get('entry_support_account_username');
            $data['entry_support_username'] = $that->language->get('entry_support_username');
            $data['entry_support_password'] = $that->language->get('entry_support_password');
            $data['validate_username'] = $that->html->getSecureURL('r/extension/license_generator/validateUsername');
            $data['license_generator_support_note'] = $that->language->get('license_generator_support_note');
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('customer_attributes', $view->fetch('pages/account/account_create_fields.tpl'));
        } elseif ($this->baseObject_method==='onControllerPagesAccountCreate_InitData') {
            $post = $that->request->post;
            $post['customer_id'] = $that->data['customer_id'];
            $that->load->model('extension/license_generator');
            $that->model_extension_license_generator->saveInfoByCustomerId($post);
        }
    }

    public function onModelAccountCustomer_ValidateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->language->load('license_generator/license_generator');
        $that->load->model('extension/license_generator');
        $post = $that->request->post;
        if (!$that->customer->getId()) {
            if ($post['have_account'] === '1') {
                if ($post['existing_support_username'] === '') {
                    $this->error['existing_support_username'] = $that->language->get('error_username_empty');
                    $that->session->data['error_existing_support_username'] = $that->language->get('error_username_empty');
                } else {
                    $validate_username = $that->model_extension_license_generator->validateUsername($post['existing_support_username']);
                    if ($validate_username) {
                        $this->error['existing_support_username'] = $validate_username;
                        $that->session->data['error_existing_support_username'] = $validate_username;
                    }
                }
            } else {
                if ($post['support_username'] === '') {
                    $this->error['error_support_username'] = $that->language->get('error_username_empty');
                    $that->session->data['error_support_username'] = $that->language->get('error_username_empty');
                } else {
                    $validate_username = $that->model_extension_license_generator->validateUsername($post['support_username']);
                    if ($validate_username) {
                        $this->error['support_username'] = $validate_username;
                        $that->session->data['error_support_username'] = $validate_username;
                    }
                }
                $pass_len = mb_strlen(htmlspecialchars_decode($post['support_password']));
                if ($pass_len < 6 || $pass_len > 16) {
                    $this->error['support_password'] = $that->language->get('error_support_password');
                    $that->session->data['error_support_password'] = $that->language->get('error_support_password');
                }
            }
            //if ($that->csrftoken->isTokenValid()) {
            $that->error = array_merge(
                $that->error,
                $this->error
            );
        }

        //}
    }

    public function onControllerPagesAccountSuccess_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (!$that->session->data['redirect'] && $that->cart->hasProducts() && $that->config->get('fast_checkout_status')) {
                 $that->view->assign('continue', $that->html->getSecureURL('checkout/fast_checkout'));
            }
            unset(
                $that->session->data['have_account'],
                $that->session->data['existing_support_username'],
                $that->session->data['support_username'],
                $that->session->data['support_password']
            );
        }
    }
    // End Of Storefront Account Create Section

    //Fast Checkout Section
    public function onControllerResponsesCheckoutPay_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='address') {
            if (!$that->customer->isLogged() && $that->request->is_POST()) {
                $that->session->data['fc']['have_account'] = $that->request->post['have_account'] ?? '';
                $that->session->data['fc']['existing_support_username'] = $that->request->post['existing_support_username'] ?? '';
                $that->session->data['fc']['support_username'] = $that->request->post['support_username'] ?? '';
                $that->session->data['fc']['support_password'] = $that->request->post['support_password'] ?? '';
                $that->session->data['license_generator'] = $that->session->data['fc'];
                $that->session->data['license_generator']['guest'] = $that->request->post;
            }
        }
    }

    public function onControllerResponsesCheckoutPay_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->document->addStyle(
                [
                    'href' => $that->view->templateResource('/stylesheet/loading-indicator.css'),
                    'rel'  => 'stylesheet',
                ]
            );
            $that->load->model('extension/license_generator');
            $that->loadLanguage('license_generator/license_generator');
            $license_generator_info = $that->session->data['fc'];
            if ($that->customer->isLogged()) {
                $support_user_info = $that->model_extension_license_generator->getSupportUserId($that->customer->getId());
            } else {
                $support_user_info = $that->model_extension_license_generator->getSupportUserIdByEmail($license_generator_info['guest']['cc_email']);
            }
             $fields = ['have_account','existing_support_username','support_username','support_password'];

            if ($support_user_info) {
                $data['have_account_data'] = '1';
                $data['existing_support_username_data'] = $support_user_info['support_username'];
                $data['entry_existing_support_username'] = $that->language->get('entry_existing_support_username');
                $data['entry_has_support_account'] = $that->language->get('entry_has_support_account');
            } else {
                foreach ($fields as $v) {
                    $data[$v . '_data'] = $license_generator_info[$v];
                }
                $data['entry_existing_support_username'] = $that->language->get('entry_existing_support_username');
                $data['entry_has_support_account'] = $that->language->get('entry_has_support_account');
                $data['entry_support_username'] = $that->language->get('entry_support_username');
                $data['entry_support_password'] = $that->language->get('entry_support_password');
            }
            $data['is_logged'] = $that->customer->isLogged() ?: '';

            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('customer_additional_attributes', $view->fetch('pages/account/fc_license_generator_payment_fields.tpl'));
            $that->processTemplate('');
        } elseif ($this->baseObject_method === '_addressForm') {
            $that->load->model('extension/license_generator');
            if ($that->customer->isLogged()) {
                $support_user_info = $that->model_extension_license_generator->getSupportUserId($that->customer->getId());
            }
            if (!$support_user_info) {
                $that->loadLanguage('license_generator/license_generator');
                $fields = ['have_account', 'existing_support_username', 'support_username', 'support_password'];

                $license_generator_info = $that->session->data['fc'];
                foreach ($fields as $v) {
                    $data[$v . '_data'] = $license_generator_info[$v];
                }
                $data['text_yes'] = $that->language->get('text_yes');
                $data['text_no'] = $that->language->get('text_no');
                $data['entry_existing_support_username'] = $that->language->get('entry_existing_support_username');
                $data['entry_has_support_account'] = $that->language->get('entry_has_support_account');
                $data['entry_support_account_username'] = $that->language->get('entry_support_account_username');
                $data['entry_support_username'] = $that->language->get('entry_support_username');
                $data['entry_support_password'] = $that->language->get('entry_support_password');
                $data['validate_username'] = $that->html->getSecureURL('r/extension/license_generator/validateUsername');
                $data['license_generator_support_note'] = $that->language->get('license_generator_support_note');
                $view = new AView($this->registry, 0);
                $view->batchAssign($data);
                $that->view->addHookVar('address_attributes', $view->fetch('pages/account/fc_license_generator_guest_fields.tpl'));
            }
        } elseif ($this->baseObject_method === '_process_success') {
            unset(
                $that->session->data['license_generator'],
                $that->session->data['store_url'],
                $that->session->data['main_store_license_key'],
                $that->session->data['cart_version'],
            );
        }
    }

    public function onControllerResponsesCheckoutFastCheckoutSuccess_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $customer_id = $that->customer->getId();
            if (isset($that->session->data['additional_license_' . $customer_id])) {
                unset($that->session->data['additional_license_' . $customer_id]);
            }
            unset($that->session->data['fc']['have_account']);
            unset($that->session->data['fc']['existing_support_username']);
            unset($that->session->data['fc']['support_username']);
            unset($that->session->data['fc']['support_password']);
            unset($that->session->data['fc']['support_account_user_id']);
        }
    }

    public function onControllerPagesAccountOrderDetails_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $that->loadModel('account/order');
            $that->loadModel('extension/fast_checkout');
            $that->loadModel('extension/license_generator');
            $that->language->load('license_generator/license_generator');
            $order_id = 0;
            $order_token = '';
            $that->loadModel('extension/fast_checkout');

            //validate input and re-route
            if ($that->customer->isLogged()) {
                //logged in customer, missing order ID?
                $order_id = (int) $that->request->get['order_id'];
                if (!$order_id) {
                    redirect($that->html->getSecureURL('account/history'));
                    return;
                }
            } else {
                if (isset($that->request->get['ot']) && $that->config->get('config_guest_checkout')) {
                    //try to decrypt order token
                    $order_token = $that->request->get['ot'];
                    list($order_id, $email) = $that->model_extension_fast_checkout->parseOrderToken($order_token);
                    if ($order_id && $email) {
                        $that->data['order_token'] = $order_token;
                        $that->data['guest'] = $guest = true;
                    } else {
                        redirect($that->html->getSecureURL('account/history'));
                        return;
                    }
                }
            }

            $licenses = $that->model_extension_license_generator->getLicenseKeysInfo($order_id);
            $that->view->assign('licenses', $licenses);

            $download = new ALicenseGeneratorDownload();

            $that->load->model('extension/license_generator');
            $downloads = [];
            //get only enabled, not expired, which have remaining count > 0 and available
            if ($that->data['guest']) {
                $customer_downloads = $that->model_extension_license_generator->getCustomerOrderDownloads($order_id, 0);
            } else {
                $customer_downloads = $that->model_extension_license_generator->getCustomerOrderDownloads(
                    $order_id,
                    $that->customer->getId()
                );
            }

            if (!$customer_downloads) {
                return;
            }

            $suffix = [
                'B',
                'KB',
                'MB',
                'GB',
                'TB',
                'PB',
                'EB',
                'ZB',
                'YB',
            ];

            foreach ($customer_downloads as $download_info) {
                $text_status = $download->getTextStatusForOrderDownload($download_info);
                $size = 0;
                if (is_numeric($download_info['filename'])) {
                    $rl = new AResource('download');
                    $resource = $rl->getResource($download_info['filename']);
                    if ($resource && $resource['resource_path']) {
                        $size = filesize(DIR_RESOURCE.$rl->getTypeDir().$resource['resource_path']);
                    }
                }else{
                    $size = filesize(DIR_RESOURCE.$download_info['filename']);
                }
                $i = 0;

                while (($size / 1024) > 1) {
                    $size = $size / 1024;
                    $i++;
                }

                $download_text = $download_button = '';

                if (!$text_status) {
                    $download_button = $that->html->buildElement(
                        [
                            'type'  => 'button',
                            'name'  => 'download_button_'.$download_info['order_download_id'],
                            'title' => $that->language->get('text_download'),
                            'text'  => $that->language->get('text_download'),
                            'style' => 'button',
                            'href'  => $that->html->getSecureURL(
                                'account/order_details/startdownload',
                                '&order_download_id='.$download_info['order_download_id']
                                .($that->data['guest'] ? '&ot='.$that->data['order_token'] : '')
                            ),
                            'icon'  => 'fa fa-download-alt',
                        ]
                    );
                } else {
                    $download_text = $text_status;
                }

                $attributes = $download->getDownloadAttributesValuesForCustomer($download_info['download_id']);
                $downloads[] = [
                    'attributes'  => $attributes,
                    'order_id'    => $download_info['order_id'],
                    'date_added'  => dateISO2Display(
                        $download_info['date_added'],
                        $that->language->get('date_format_short')
                    ),
                    'name'        => $download_info['name'],
                    'remaining'   => $download_info['remaining_count'],
                    'size'        => round(substr($size, 0, strpos($size, '.') + 4), 2).$suffix[$i],
                    'button'      => $download_button,
                    'text'        => $download_text,
                    'expire_date' => dateISO2Display(
                        $download_info['expire_date'],
                        $that->language->get('date_format_short').' '.$that->language->get('time_format_short')
                    ),
                ];
            }
            usort($downloads, function ($a, $b) {
                list($al, $an) = explode('_', $a['name']);
                list($bl, $bn) = explode('_', $b['name']);
                if ($al == $bl) return version_compare($an, $bn);
                return strcmp($al, $bl);
            });
            $downloads = array_reverse($downloads);
            $that->view->assign('downloads', $downloads);
            $that->view->batchAssign($that->language->getASet());
            $that->processTemplate();
        }
    }
    // End Of Fast Checkout Section

    // Storefront Checkout Confirm Section

    public function afterModelCheckoutOrder_confirm($order_id) {
        $that =& $this->baseObject;
        $that->load->model('account/order');
        $that->load->model('extension/license_generator');
        $data = $that->session->data['license_generator'];
        $that->model_extension_license_generator->saveInfo($order_id, $data);
        $that->model_extension_license_generator->updateOrderDownloadSortOrder($order_id);
        $that->loadModel('account/order');
         $that->model_extension_license_generator->generateLicenseKey($order_id);
        if ($that->session->data['redirect'] === $that->html->getSecureUrl('checkout/fast_checkout')) {
            unset($that->session->data['redirect']);
        }
        $customer_id = $that->customer->getId();
        if (isset($that->session->data['additional_license_' . $customer_id])) {
            unset($that->session->data['additional_license_' . $customer_id]);
        }
        unset(
            $that->session->data['license_generator'],
            $that->session->data['store_url'],
            $that->session->data['main_store_license_key'],
            $that->session->data['cart_version'],
        );
    }

    // End Of Storefront Checkout Confirm Section

    // Order Invoice Section
    public function onControllerPagesAccountInvoice_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $that->loadModel('account/order');
            $that->loadModel('account/customer');
            $that->loadModel('extension/license_generator');
            $that->language->load('license_generator/license_generator');

            $that->view->assign('success_message','');
            $that->view->assign('error_message','');
            if ($that->session->data['order_additional_license_success']) {
                $that->view->assign('success_message', $that->session->data['order_additional_license_success']);
                unset($that->session->data['order_additional_license_success']);
            }
            if ($that->session->data['order_additional_license_error']) {
                $that->view->assign('error_message', $that->session->data['order_additional_license_error']);
                unset($that->session->data['order_additional_license_error']);
            }

            if (isset($that->request->get['order_id'])) {
                $order_id = (int)$that->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $order_token = '';
            $guest = false;
            $enc = new AEncryption($that->config->get('encryption_key'));
            if (isset($that->request->get['ot']) && $that->config->get('config_guest_checkout')) {
                //try to decrypt order token
                $order_token = $that->request->get['ot'];
                if ($order_token) {
                    list($order_id, $email) = $that->model_account_customer->parseOrderToken($order_token);
                    if ($order_id && $email) {
                        $guest = true;
                        $order_info = $that->model_account_order->getOrder($order_id, '', 'view');
                    }
                }
            }

            if ($that->request->is_POST()) {
                $guest = true;

                $order_id = $that->request->post['order_id'];
                $email = $that->request->post['email'];
                $order_token = $enc->encrypt($order_id.'::'.$email);
                $order_info = $that->model_account_order->getOrder($order_id, '', 'view');

                //compare emails
                if ($order_info['email'] != $email) {
                    unset($order_info, $order_id, $email);
                }
            }

            $licenses = $that->model_extension_license_generator->getLicenseKeysInfo($order_id);
            $data['exist'] = $that->model_extension_license_generator->isOwnLicenseExist($order_id);
            $data['text_license_key_list'] = $that->language->get('text_license_key_list');
            $data['column_extension_name'] = $that->language->get('column_extension_name');
            $data['column_store_url'] = $that->language->get('column_store_url');
            $data['column_cart_version'] = $that->language->get('column_cart_version');
            $data['column_license_key'] = $that->language->get('column_license_key');
            $data['column_license_status'] = $that->language->get('column_license_status');
            $data['licenses'] = $licenses;
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('order_attributes', $view->fetch('pages/account/license_keys_list.tpl'));
            if ($that->customer->isLogged()) {
                $that->view->assign('redirect', $that->html->getURL('account/invoice','&order_id='.$order_id));
            } else {
                $that->view->assign('redirect', $that->html->getURL( 'account/invoice', '&ot=' . $order_token ));
            }
            $that->view->assign('order_additional_license_url', $that->html->getURL('r/extension/additional_license/orderAdditionalLicense'));
            $that->view->assign('order_additional_packs_license_url', $that->html->getURL('r/extension/additional_license/orderPacksAdditionalLicense'));
        }
    }
    // End Of Order Invoice Section

    // Dowload Section
    public function onControllerPagesAccountDownload_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->load->language('license_generator/license_generator');
        if ($this->baseObject_method === 'main') {
            $order_id = null;
            $download = $that->data['download'];
            $guest = false;
            $order_token = $that->request->get['ot'];
            if ($order_token) {
                list($order_id, $email) = $that->model_account_customer->parseOrderToken($order_token);
                if ($order_id && $email) {
                    $guest = true;
                }
            }
            if (isset($that->request->get['limit'])) {
                $limit = (int)$that->request->get['limit'];
                $limit = $limit > 50 ? 50 : $limit;
            } else {
                $limit = $that->config->get('config_catalog_limit');
            }
            if (isset($that->request->get['page'])) {
                $page = $that->request->get['page'];
            } else {
                $page = 1;
            }
            $download = new ALicenseGeneratorDownload();

            $downloads = [];
            //get only enabled, not expired, which have remaining count > 0 and available
            if ($guest) {
                $customer_downloads = $download->getCustomerOrderDownloads($order_id, 0);
            } else {
                $customer_downloads = $download->getCustomerDownloads(($page - 1) * $limit, $limit);
            }

            $that->data['raw_downloads'] = $customer_downloads;
            $product_ids = array_column($customer_downloads, 'product_id');
            $product_ids = array_map('intval', $product_ids);

            $resource = new AResource('image');
            $thumbnails = $product_ids
                ? $resource->getMainThumbList(
                    'products',
                    $product_ids,
                    $that->config->get('config_image_cart_width'),
                    $that->config->get('config_image_cart_height'),
                    false
                )
                : [];
            $suffix = [
                'B',
                'KB',
                'MB',
                'GB',
                'TB',
                'PB',
                'EB',
                'ZB',
                'YB',
            ];

            $that->load->model('extension/license_generator');

            foreach ($customer_downloads as $download_info) {
                $text_status = $download->getTextStatusForOrderDownload($download_info);
                $size = 0;
                if (is_numeric($download_info['filename'])) {
                    $rl = new AResource('download');
                    $resource = $rl->getResource($download_info['filename']);
                    if ($resource && $resource['resource_path']) {
                        $size = filesize(DIR_RESOURCE.$rl->getTypeDir().$resource['resource_path']);
                    }
                }else{
                    $size = filesize(DIR_RESOURCE.$download_info['filename']);
                }
                $i = 0;
                while (($size / 1024) > 1) {
                    $size = $size / 1024;
                    $i++;
                }

                $download_text = $download_button = '';
                if (!$text_status) {
                    $download_button = $that->html->buildElement(
                        [
                            'type' => 'button',
                            'name' => 'download_button_' . $download_info['order_download_id'],
                            'title' => $that->language->get('text_download'),
                            'text' => $that->language->get('text_download'),
                            'style' => 'button',
                            'href' => $that->html->getSecureURL(
                                'account/download/startdownload',
                                '&order_download_id=' . $download_info['order_download_id']
                                . ($guest ? '&ot=' . $order_token : '')
                            ),
                            'icon' => 'fa fa-download-alt',
                        ]
                    );
                } else {
                    $download_text = $text_status;
                }

                $thumbnail = $thumbnails[$download_info['product_id']];
                $attributes = $download->getDownloadAttributesValuesForCustomer($download_info['download_id']);
                $license_info = $that->model_extension_license_generator->getLicenseInfoByOrderProductId($download_info['order_product_id']);

                $downloads[$download_info['order_id']][$download_info['order_download_id']] = [
                    'order_download_id' => $download_info['order_download_id'],
                    'thumbnail' => $thumbnail,
                    'attributes' => $attributes,
                    'order_id' => $download_info['order_id'],
                    'date_added' => dateISO2Display(
                        $download_info['date_added'],
                        $that->language->get('date_format_short')
                    ),
                    'name' => $download_info['name'],
                    'remaining' => $download_info['remaining_count'],
                    'size' => round((float)substr($size, 0, strpos($size, '.') + 4), 2).$suffix[$i],
                    'button' => $download_button,
                    'text' => $download_text,
                    'expire_date' => dateISO2Display(
                        $download_info['expire_date'],
                        $that->language->get('date_format_short') . ' ' . $that->language->get('time_format_short')
                    ),
                    'license_code' => $license_info['license_code'],
                    'license_status' => $license_info['blesta_license_status'],
                ];

                $packs_license_info = $that->model_extension_license_generator->getPacksLicenseInfoByOrderProductId($download_info['order_product_id']);
                if ($packs_license_info) {
                    $downloads[$download_info['order_id']][$download_info['order_download_id']]['packs_license'] = $packs_license_info;
                }
            }

            $that->view->assign('downloads', $downloads);

            $that->view->assign('pagination_bootstrap', $that->html->buildElement(
                [
                    'type' => 'Pagination',
                    'name' => 'pagination',
                    'text' => $that->language->get('text_pagination'),
                    'text_limit' => $that->language->get('text_per_page'),
                    'total' => $download->getTotalDownloads(),
                    'page' => $page,
                    'limit' => $limit,
                    'url' => $that->html->getURL('account/download&limit=' . $limit . '&page={page}', '&encode'),
                    'style' => 'pagination',
                ]
            ));
            $that->view->batchAssign($that->language->getASet());
            $that->processTemplate();
        }
    }
    // End Of Download Section

    // Storefront Checkout Cart Section
    public function onControllerPagesCheckoutCart_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (!$that->cart->hasProducts()) {
                if (isset($that->session->data['store_url'])) {
                    $customer_id = $that->customer->getId();
                    if (isset($that->session->data['additional_license_' . $customer_id])) {
                        unset($that->session->data['additional_license_' . $customer_id]);
                    }
                    unset(
                        $that->session->data['store_url'],
                        $that->session->data['main_store_license_key'],
                        $that->session->data['cart_version']
                    );
                }
            }
        }
    }
    // End Of Storefront Checkout Cart Section

    // Storefront Product Page Section
    public function onControllerPagesProductProduct_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $fast_checkout = $that->config->get('fast_checkout_status');
            if ($fast_checkout === '1') {
                $that->view->replaceHookVar('product_add_to_cart_html', '');
            }
            $key = [];
            $request = $that->request->get;

            if (has_value($request['key'])) {
                $key = explode(':', $request['key']);
                $product_id = (int) $key[0];
            } elseif (has_value($request['product_id'])) {
                $product_id = (int) $request['product_id'];
            } else {
                $product_id = 0;
            }
            $product_info = $that->model_catalog_product->getProduct($product_id);

            if ($product_info['name']==='Multi-Store Additional License' && !$request['key']) {
                $this->_product_not_found($product_id);
                return;
            }

            $this->data['product_info']['blurb'] = html_entity_decode($that->data['product_info']['blurb']);
            $that->view->batchAssign($this->data);
            $that->view->assign('main_store_license_key',$that->session->data['main_store_license_key']);
            $that->view->assign('store_url',$that->session->data['store_url']);
            $that->view->assign('extension_name',$that->session->data['extension_name']);
            $that->view->assign('cart_version',$that->session->data['cart_version']);

            $product_name = $that->data['product_info']['name'];

            if ($product_name==='Multi-Store Additional License' && has_value($request['additional_license'])) {
                $customer_id = $that->customer->getId();
                if (isset($that->session->data['additional_license_' . $customer_id][$product_id]['options'])) {
                    $options = $that->session->data['additional_license_' . $customer_id][$product_id]['options'];
                    $that->view->assign('main_store_license_key',$options['main_store_license_key']);
                    $that->view->assign('store_url',$options['store_url']);
                    $that->view->assign('cart_version',$options['cart_version']);
                    $that->view->assign('extension_name',$options['extension_name']);
                }
            }
            $that->processTemplate('');
        }
    }

    protected function _product_not_found($product_id) {
        $that =& $this->baseObject;
        $that->load->language('license_generator/license_generator');
        $url = $this->_build_url_params($that->request->get);
        $that->document->addBreadcrumb(
            [
                'href'      => $that->html->getSEOURL(
                    'product/product',
                    $url.'&product_id='.$product_id,
                    '&encode'
                ),
                'text'      => $that->language->get('heading_cannot_order'),
                'separator' => $that->language->get('text_separator'),
            ]
        );

        $that->document->setTitle($that->language->get('heading_cannot_order'));

        $this->data['heading_title'] = $that->language->get('heading_cannot_order');
        if ($that->customer && ($that->customer->isLogged() || $that->customer->isUnauthCustomer())) {
            $this->data['text_error'] = $that->language->get('text_logged_in_cannot_order');
        } else {
            $this->data['text_error'] = $that->language->get('text_cannot_order');
        }
        $continue = HtmlElementFactory::create(
            [
                'type'  => 'button',
                'name'  => 'continue_button',
                'text'  => $that->language->get('button_continue'),
                'style' => 'button',
            ]
        );
        $that->view->assign('button_continue', $continue);
        $this->data['continue'] = $that->html->getHomeURL();

        $that->view->setTemplate('pages/error/not_found.tpl');

        $that->view->batchAssign($this->data);
        $that->processTemplate();
    }


    /**
     * @param $request
     *
     * @return string
     */
    protected function _build_url_params($request) {
        $url = '';
        $params = [
            'path',
            'manufacturer_id',
            'keyword',
            'category_id',
            'description'
        ];
        foreach($params as $key){
            if (isset($request[$key])) {
                $url .= '&'.$key.'='.$request[$key];
            }
        }

        return $url;
    }
    // End Of Storefront Product Page Section

    // Storefront Account Edit Section
    public function onControllerPagesAccountEdit_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->load->language('license_generator/license_generator');
            $that->load->model('extension/license_generator');
            $form=$that->view->getData('form');

            $customer_id = $that->customer->getId();
            $customer_info = $that->model_extension_license_generator->getSupportUserId($customer_id);

            $that->view->assign('entry_existing_support_username',$that->language->get('entry_existing_support_username'));

            $form['fields']['existing_support_username'] = $that->html->buildInput([
                'name' => 'existing_support_username',
                'value' => $customer_info['support_username'],
                'attr' => $customer_info['support_username'] ? 'disabled' : ''
            ]);

            $that->view->assign('form',$form);
        }
    }
    // End Of Storefront Account Edit Section

    // Storefront Checkout Cart Section
    public function onControllerPagesCheckoutCart_InitData() {
        if ( ! $this->_is_enabled() ) {
            return null;
        }
        $that = $this->baseObject;
        if ( $this->baseObject_method === 'main' ) {
            $that->load->language('license_generator/license_generator');
            if ( $that->request->is_POST() ) {
                $that->load->model( 'extension/license_generator' );
                $that->load->model( 'extension/additional_license' );
                $that->load->model( 'catalog/product' );
                $product_rt = 'product/product';
                $post = $that->request->post;

                $product_info = $that->model_catalog_product->getProduct($post['product_id']);
                $main_store_license_key = $missing_buy = $missing_rent = '';
                $extension_name = '';
                $main_store_exist = false;

                if ( isset( $post['option'] ) ) {
                    $options = $post['option'];
                    $i=$j=0;

                    $rent = $license_key_status = $licensed_extension_name = $rent_license_key_status = false;
                    foreach ( $options as $option_id => $option ) {
                        $options_info = $that->model_extension_license_generator->getOptionType( $option_id );
                        $option_name  = $options_info['name'];
                        if (stripos($option_name,'Buy ')!==false) {
                            if ($option==='') {
                                $i++;
                                $missing_buy = true;
                            } else {
                                $j++;
                            }
                        } elseif ( stripos($option_name,'Rent ')!==false) {
                            if ($option==='') {
                                $i++;
                                $missing_rent = true;
                            } else {
                                $j++;
                            }
                        } elseif(stripos($option_name,'Main Store License Key')!==false) {
                            $main_store_license_key = $option;
                            $main_store_exist = true;
                            //if (stripos($option,'own-')) {
                                $licenseKeyInfo = $that->model_extension_license_generator->validateMainStore($option);
                                if ($option===$licenseKeyInfo['blesta_license_code']) {
                                    $license_key_status = true;
                                    $licensed_extension_name = $licenseKeyInfo['extension_name'];
                                    $that->session->data['extension_name'] = $licenseKeyInfo['extension_name'];
                                }
                            //}
                        } elseif(stripos($option_name,'Extension Name')!==false) {
                            $extension_name = $that->model_extension_additional_license->getOptionValueName($option);
                        }
                    }

                    if (!$license_key_status && $main_store_exist) {
                        $text_errors = $that->language->get('error_invalid_license_code');
                        $that->session->data['error'] = $text_errors;
                        //send options values back via _GET
                        //$url = '&' . http_build_query( [ 'option' => $post['option'] ] );
                        $url= '&key='.$post['product_id'].':'.md5(serialize($post['option'] ));
                        redirect( $that->html->getSecureURL( $product_rt, '&product_id=' . $post['product_id'] ) . $url );
                    } elseif ($license_key_status && $extension_name!==$licensed_extension_name && $main_store_exist) {
                        $text_errors = $that->language->get('error_extension_name_unmatch');
                        $that->session->data['error'] = $text_errors;
                        //send options values back via _GET
                        //$url = '&' . http_build_query( [ 'option' => $post['option'] ] );
                        $url= '&key='.$post['product_id'].':'.md5(serialize($post['option'] ));
                        redirect( $that->html->getSecureURL( $product_rt, '&product_id=' . $post['product_id'] ) . $url );
                    } elseif ( $i==1 && $missing_buy && (stripos($product_info['name'],' pack') !== false || stripos($product_info['name'],' + ') !== false)) {
                        $text_errors = $that->language->get('error_missing_buy');
                        $that->session->data['error'] = $text_errors;
                        //send options values back via _GET
                        $url = '&' . http_build_query( [ 'option' => $post['option'] ] );
                        redirect( $that->html->getSecureURL( $product_rt, '&product_id=' . $post['product_id'] . $url ) );
                    }  elseif ( $i==2 ) {
                        $text_errors = $that->language->get('error_rent_or_buy');
                        $that->session->data['error'] = $text_errors;
                        //send options values back via _GET
                        $url = '&' . http_build_query( [ 'option' => $post['option'] ] );
                        redirect( $that->html->getSecureURL( $product_rt, '&product_id=' . $post['product_id'] . $url ) );
                    } elseif ($j===2) {
                        $text_errors = $that->language->get('error_rent_and_buy');
                        $that->session->data['error'] = $text_errors;
                        $that->load->model('catalog/product');
                        foreach ($post['option'] as $product_option_id => $value) {
                            $option_info = $that->model_catalog_product->getProductOption($post['product_id'],$product_option_id);
                            if (stripos($option_info['name'],'The URL where you will install')!==false || stripos($option_info['name'],'AbanteCart version of the above URL') !== false ) {
                                unset($post['option'][$product_option_id]);
                            }
                        }
                        $url = '&' . http_build_query( [ 'option' => $post['option'] ] );
                        redirect( $that->html->getSecureURL( $product_rt, '&product_id=' . $post['product_id']) );
                    }
                }
            }
        }
    }
    // End of Storefront Checkout Cart Section

    // ACart Section
    public function onACart_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'ACart::buildProductDetails') {
            $options = $that->data['output']['option'];
             foreach ($options as $option) {
                if (stripos($option['name'],'The URL where you will install')!==false) {
                    //if (!isset($that->session->data['store_url'])) {
                        $that->session->data['store_url'] = $option['value'];
                    //}
                } elseif (stripos($option['name'],'AbanteCart version of the above URL')!==false) {
                    $that->session->data['cart_version'] = $option['value'];
                } elseif (stripos($option['name'],'Main Store License Key')!==false) {
                    $that->session->data['main_store_license_key'] = $option['value'];
                } elseif (stripos($option['name'],'Extension Name')!==false) {
                    $that->session->data['extension_name'] = $option['value'];
                }
            }
        }
    }
    // End Of ACart Section

    // Quick View Section
    public function onControllerResponsesQuickViewQuickView_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $that->view->assign('store_url',$that->session->data['store_url']);
            $that->view->assign('cart_version',$that->session->data['cart_version']);
            $that->processTemplate('');
        }
    }
    // End Of Quick View Section


    // Page Checkout Success Section
    public function onControllerPagesCheckoutSuccess_ProcessData() {
        if (!$this->_is_enabled()) {
            return;
        }
        $that =& $this->baseObject;
        $customer_id = $that->customer->getId();
        if (isset($that->session->data['additional_license_' . $customer_id])) {
            unset($that->session->data['additional_license_' . $customer_id]);
        }
        unset(
            $that->session->data['license_generator'],
            $that->session->data['store_url'],
            $that->session->data['main_store_license_key'],
            $that->session->data['cart_version'],
        );
    }
    // End Of Page Checkout Success Section
}