<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelExtensionLicenseGenerator extends Model {

    /**
     * @param $customer_id
     * @throws AException
     */
    public function deleteAccountInfo($customer_id) {
        $this->db->query("DELETE FROM ".$this->db->table("license_generator_account_info")." WHERE `customer_id`=".(int)$customer_id);
    }

    /**
     * @param $order_id
     * @throws AException
     */
    public function deleteOrderInfo($order_id) {
        $this->db->query("DELETE FROM ".$this->db->table("license_generator_info")." WHERE `order_id`=".(int)$order_id);
        $this->db->query("DELETE FROM ".$this->db->table("license_generator_packs_info")." WHERE `order_id`=".(int)$order_id);
        $this->db->query("DELETE FROM ".$this->db->table("license_generator_order_relation")." WHERE `order_id`=".(int)$order_id);
    }

    /**
     * @param $customer_id
     * @return void
     * @throws AException
     */
    public function getAccountInfo($customer_id) {
        $query = $this->db->query("SELECT * FROM ".$this->db->table("license_generator_account_info")." WHERE `customer_id`=".(int)$customer_id);
        return $query->row;
    }

    /**
     * @param $order_id
     * @return mixed
     * @throws AException
     */
    public function getLicenseKeysInfo($order_id) {
        $sql = "SELECT * FROM ".$this->db->table("license_generator_info")." WHERE `order_id`=".(int)$order_id;
        $query = $this->db->query($sql);
        return $query->rows;
    }

    /**
     * @param $data
     * @return void
     * @throws AException
     */
    public function savePacksDiscount($data) {
        $this->db->query("DELETE FROM ".$this->db->table("license_generator_packs_discount")." WHERE `product_id`=".(int)$data['product_id']);
        $this->db->query("INSERT INTO ".$this->db->table("license_generator_packs_discount")." SET `product_id`=".(int)$data['product_id'].",`discount`=".(float)$data['discount']);
    }

    /**
     * @param $product_id
     * @return mixed
     * @throws AException
     */
    public function getPacksDiscount($product_id) {
        $sql = "SELECT `discount` FROM ".$this->db->table("license_generator_packs_discount")." WHERE `product_id`=".(int)$product_id;
        $query = $this->db->query($sql);
        return $query->row['discount'];
    }

}