<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
class ModelExtensionEmailSignatures extends Model {

    public function addSignature($data) {
        $sql="INSERT INTO " .$this->db->table('email_editor_signatures') ." SET
        `title`='".$this->db->escape($data['title'])."',
        `content`='".$this->db->escape($data['content'])."'";
        $this->db->query($sql);
        return $this->db->getLastId();
    }

    public function getSignatures() {
        $sql = "SELECT * FROM " . $this->db->table('email_editor_signatures');
        $result = $this->db->query($sql);
        return $result->rows;
    }

    public function getAvailableSignatures() {
        $sql = "SELECT `email_signature_id`,`title` FROM " .$this->db->table('email_editor_signatures');
        $result = $this->db->query($sql);
        return $result->rows;
    }

    /**
     * @param $filter
     * @param string $mode
     * @return array
     */
    public function getAllSignatures($filter, $mode = '') {
        if ($mode == 'total_only') {
            $sql = "SELECT COUNT(*) as total FROM " .$this->db->table('email_editor_signatures');
        } else {
            $sql = "SELECT * FROM " .$this->db->table('email_editor_signatures');
        }

        if (isset($filter['start']) || isset($filter['limit'])) {
            if ($filter['start'] < 0) {
                $filter['start'] = 0;
            }
            if ($filter['limit'] < 1) {
                $filter['limit'] = 20;
            }
            $sql .= $mode != 'total_only' ? " LIMIT " . (int)$filter['start'] . "," . (int)$filter['limit'] : '';
        }
        $result = $this->db->query($sql);
        $output = [];
        if ($mode == 'total_only') {
            $output = $result->row['total'];
        } else {
            foreach ($result->rows as $row) {
                if ($row['section']) {
                    $output[] = $row;
                } else {
                    $output[] = $this->getsignature($row['email_signature_id']);
                }
            }
        }
        return $output;
    }

    /**
     * @param $signature_id
     * @return mixed
     */
    public function getSignature($signature_id) {
        $signature_id = (int)$signature_id;
        $sql = "SELECT * FROM " .$this->db->table('email_editor_signatures') ." WHERE `email_signature_id`=" . $signature_id;
        $result = $this->db->query($sql);
        return $result->row;
    }

    public function updateSignature($signature_id,$data) {
        $fields=[
            'title',
            'content',
        ];

        $update=[];
        foreach ($fields as $f) {
            if (isset($data[$f])) {
                $update[] = "$f = '" . $this->db->escape($data[$f]) . "'";
            }
        }

        if (!empty($update)) {
            return $this->db->query("UPDATE " .$this->db->table('email_editor_signatures') ." SET " . implode(',', $update) . " WHERE email_signature_id = '" . (int)$signature_id . "'");
        }
    }

    public function deleteSignature($signature_id) {
        $sql="DELETE FROM " .$this->db->table('email_editor_signatures') ." WHERE email_signature_id=".$signature_id;
        $this->db->query($sql);
    }


    public function getTitle($title) {
        $sql="SELECT COUNT(*) as total FROM " .$this->db->table('email_editor_signatures') ." WHERE `title`='".$title."'";
        $res=$this->db->query($sql);
        $result=$res->row;
        return $result['total'];
    }
}