<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

class ExtensionEditor extends Extension {
	private $error = [];
	public $data = [];

	public function __construct() {
		$this->registry = Registry::getInstance();
	}

	private function _is_enabled() {
		return $this->baseObject->config->get( 'editor_status' ) ? true : false;
	}

    public function verifyProductPricingPlus() {
        $that =& $this->baseObject;
        if ( $that->config->get( 'product_pricing_plus_status' ) === '1' ) {
            return true;
        } else {
            return false;
        }
    }

	public function onControllerCommonHead_InitData() {
		if ( ! $this->_is_enabled() ) {
			return null;
		}
		$that =& $this->baseObject;
		if ( IS_ADMIN || ( IS_ADMIN && $that->config->get( 'enhanced_admin_status' ) == '1' ) ) {
			$editor = $that->config->get( 'editor_status' );
			$rt=$that->request->get['rt'];
			$that->view->assign( 'rt', $rt );
			$that->view->assign( 'editor', $editor );
			$that->view->assign( 'url', $that->html->getSecureURL( 'r/extension/filemanager', '&type=Images' ) );
		}
	}

	public function onControllerPagesProductProduct_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ($this->baseObject_method==='main') {
			$this->data['product_info']['blurb'] = html_entity_decode($that->data['product_info']['blurb']);
			$that->view->batchAssign($this->data);
			$that->processTemplate();
		}
	}

	public function onControllerResponsesEmbedJS_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ($this->baseObject_method==='product') {
			$this->data['product']=$that->data['product'];
			$this->data['product']['blurb'] = html_entity_decode($that->data['product']['blurb']);
			$that->view->batchAssign($this->data);
			$that->processTemplate();
		}
	}

	public function onControllerBlocksBestSeller_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ($this->baseObject_method === 'main' ) {
			$this->data['products'] = [];
			$products = $that->data['products'];
			if ($products) {
				foreach ( $products as $product ) {
                    $price = $product['price'];
                    $special = $product['special'];
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $product['special'] = $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                            }
                        } else {
                            $price = $product['price'];
                        }
                    }
                    $this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => $product['stars'],
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
					];
				}
				$that->view->assign('products',$this->data['products']);
			}
		}
	}

	public function onControllerBlocksSpecial_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ( $this->baseObject_method === 'main' ) {
			$this->data['products'] = [];
			$products = $that->data['products'];
			if($products) {
				foreach ( $products as $product ) {
                   $price = $product['price'];
                   $special = $product['special'];
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $product['special'] = $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                            }
                        } else {
                            $price = $product['price'];
                        }
                    }
                    $this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => sprintf( $that->language->get( 'text_stars' ), $product['rating'] ),
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
					];
				}
				$that->view->assign('products',$this->data['products']);
			}
		}
	}

	public function onControllerBlocksfeatured_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}

		$that =& $this->baseObject;
		if ($this->baseObject_method === 'main' ) {
			$that->load->model( 'catalog/product' );
			$this->data['products'] = [];
			$products = $that->data['products'];
			if ($products) {
				foreach ( $products as $product ) {
                    $price = $product['price'];
                    $special = $product['special'];
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $product['special'] = $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                            }
                        } else {
                            $price = $product['price'];
                        }
                    }
                    $this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => $product['stars'],
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
						'date_added'     => $product['date_added'],
					];
				}
				$that->view->assign('products',$this->data['products']);
			}
		}
	}

	public function onControllerBlocksLatest_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ($this->baseObject_method === 'main' ) {
			$this->data['products'] = [];
			$products = $that->data['products'];
			if ($products) {
				foreach ( $products as $product ) {
				    $price = $product['price'];
                    $special = $product['special'];
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $product['special'] = $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                            }
                        } else {
                            $price = $product['price'];
                        }
                    }
                    $this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => $product['stars'],
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
						'date_added'     => $product['date_added'],
					];
				}
				$that->view->assign('products',$this->data['products']);
			}
		}
	}

	public function onControllerPagesProductSpecial_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ( $this->baseObject_method === 'main' ) {
			$this->data['products'] = [];
			$products = $that->data['products'];
			if ($products) {
				foreach ( $products as $product ) {
                    $price = $product['price'];
                    $special = $product['special'];
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $product['special'] = $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                            }
                        } else {
                            $price = $product['price'];
                        }
                    }
                    $this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'description'    => $product['description'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => $product['stars'],
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
					];
				}
				$that->view->assign( 'products', $this->data['products'] );
			}
		}
	}

	public function onControllerPagesProductCategory_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ( $this->baseObject_method === 'main' ) {
			$this->data['products'] = [];
			$products               = $that->data['products'];
			if ($products) {
				foreach ( $products as $product ) {
                    $price = $product['price'];
                    $special = $product['special'];
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $product['special'] = $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                            }
                        } else {
                            $price = $product['price'];
                        }
                    }
                    $this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'description'    => $product['description'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => $product['stars'],
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
					];
				}
				$that->view->assign( 'products', $this->data['products'] );
			}
		}
	}

	public function onControllerPagesProductManufacturer_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		$that =& $this->baseObject;
		if ($this->baseObject_method === 'main' ) {
			$this->data['products'] = [];
			$products               = $that->data['products'];
			if ($products) {
				foreach ( $products as $product ) {
                    $price = $product['price'];
                    $special = $product['special'];
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $product['special'] = $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                            }
                        } else {
                            $price = $product['price'];
                        }
                    }
                    $this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'description'    => $product['description'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => $product['stars'],
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
					];
				}
				$that->view->assign( 'products', $this->data['products'] );
			}
		}
	}

	public function onControllerPagesProductSearch_UpdateData() {
		if (!$this->_is_enabled()) {
			return null;
		}
		if ($this->baseObject_method == 'main') {
			$that =& $this->baseObject;

			$this->data['products'] = [];
			$products               = $that->data['products'];
			if ($products) {
				foreach ( $products as $product ) {
                    $price = $product['price'];
                    $special = $product['special'];
                    if ($this->verifyProductPricingPlus()) {
                        $that->load->model('extension/product_pricing_plus');
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $product['special'] = $price.' '.$product['special'];
                                $price= $product['price'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $price .= ' ' . $product['price'];
                                }
                            }
                        } else {
                            $price = $product['price'];
                        }
                    }
                    $this->data['products'][] = [
						'product_id'     => $product['product_id'],
						'name'           => $product['name'],
						'description'    => $product['description'],
						'blurb'          => html_entity_decode( $product['blurb'] ),
						'model'          => $product['model'],
						'rating'         => $product['rating'],
						'stars'          => $product['stars'],
						'price'          => $price,
						'call_to_order'  => $product['call_to_order'],
						'options'        => $product['options'],
						'special'        => $special,
						'thumb'          => $product['thumb'],
						'href'           => $product['href'],
						'add'            => $product['add'],
						'track_stock'    => $product['track_stock'],
						'in_stock'       => $product['in_stock'],
						'no_stock_text'  => $product['no_stock_text'],
						'total_quantity' => $product['total_quantity'],
						'tax_class_id'   => $product['tax_class_id'],
					];
				}
				$that->view->assign( 'products', $this->data['products'] );
			}
		}
	}
}