<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ControllerResponsesExtensionBillingByWhy2 extends AController {
    public function main() {

        $item = $this->html->buildElement(
            [
                'type'  => 'button',
                'name'  => 'back',
                'style' => 'button',
                'text'  => $this->language->get('button_back'),
            ]
        );
        $this->view->assign('button_back', $item);

        $item = $this->html->buildElement(
            [
                'type'  => 'button',
                'name'  => 'checkout',
                'style' => 'button btn-primary',
                'text'  => $this->language->get('button_confirm'),
            ]
        );
        $this->view->assign('button_confirm', $item);

        $this->loadLanguage('billing_by_why2/billing_by_why2');

        $this->view->assign('text_instructions', $this->language->get('text_instructions'));

        $this->view->assign('continue', $this->html->getSecureURL('checkout/success'));

        $this->view->assign('back', $this->html->getSecureURL(
            ($this->request->get['rt'] == 'checkout/guest_step_3'
                ? 'checkout/guest_step_2'
                : 'checkout/payment'),
            '&mode=edit', true));
        $this->processTemplate('responses/billing_by_why2.tpl');
    }

    public function api() {
        $data = [];

        $data['text_note'] = $this->language->get('text_note');
        $data['process_rt'] = 'billing_by_why2/api_confirm';

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($data));
    }

    public function api_confirm() {
        $data = [];

        $this->confirm();
        $data['success'] = 'completed';

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($data));
    }

    public function confirm() {
        $this->load->model('checkout/order');
        $this->load->language('billing_by_why2/billing_by_why2');
        $comment = $this->language->get('text_instructions');
        $comment = html_entity_decode($comment,ENT_QUOTES,'UTF-8');

        $this->model_checkout_order->confirm($this->session->data['order_id'], $this->config->get('billing_by_why2_order_status_id'),$comment);
        $this->response->addJSONHeader();
        $this->response->setOutput(json_encode(['result' => true]));
    }
}
